{ Illustrates the global discretization error                               }
{ Considers the deterministic ordinary differential equation                }
{  dX(t) = A(t,X(t)) dt   with  X(T0) = X0   on the time interval [T0,T]    }
{ Equidistant approximation of X(t) by the Euler and the midpoint method    }
{ with the time step sizes DELTA                                            }
{ Plots the linearly interpolated global discretization errors for the both }
{ approximations against the time t in the same graphic                     }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : For a correct printout of the paths one has to choose the scaling  }
{        parameter carefully.                                               }

PROGRAM PRX3X1X9; { PC-Exercise 8.2.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE;

CONST
 NUM=10;       { number of time steps for the comparison }
 T0=0.0;       { left end point                          }
 T=1.0;        { right end point                         }
 DELTA=1/NUM;  { time step size                          }
 X0=1.0;       { initial value                           }
 ABSCMIN=T0;   { left end point                          }
 ABSCMAX=T;    { right end point                         }
 ORDMIN=-0.2;  { minimum of the ordinate                 }
 ORDMAX=+0.2;  { maximum of the ordinate                 }
 ORDPOINT=0.0; { significant ordinate point              }

TYPE
 VECTOR=ARRAY[0..NUM] OF REAL;

VAR
 C1,C2,CR:STRING;     { help strings                           }
 AXISX,AXISY:INTEGER; { location of the axes                   }
 DISTX,DISTY:INTEGER; { scale parameters                       }
 I:INTEGER;           { time step                              }
 TI:REAL;             { subinterval point                      }
 XT:REAL;             { exact solution X(t) at time t = TI     }
 Y1T:VECTOR;          { Euler approximation                    }
 Y2T:VECTOR;          { Midpoint approximation                 }
 EPS1:VECTOR;         { global discretization errors(Euler)    }
 EPS2:VECTOR;         { global discretization errors(Midpoint) }
 ABSCISSA:VECTOR;     { subinterval points                     }

{ Generates the function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=-3.*XI+1.;
END;{ A }

{ Generates the functional form of the explicit solution }

FUNCTION EXPLSOL(TI:REAL):REAL;
BEGIN
 EXPLSOL:=X0*((2/3)*EXP(-3.*(TI-T0))+1/3);
END;{ EXPLSOL }

{ Prepares the screen for the printout of the data segment       }
{ X-axis is placed in the center; CY,CX ... strings for the axes }

PROCEDURE COORDSYS(CY,CX:STRING);
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+10;
 AXISX:=TRUNC(MAXY/2);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-2*IH-20;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,AXISX-DISTY-IH,'^');OUTTEXTXY(AXISY,AXISX-DISTY-2*IH,CY);
 LINE(AXISY,AXISX-DISTY-IH,AXISY,AXISX+DISTY+IH);
 LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-DISTY;
 LINE(AXISY-3,AXISX-DISTY,AXISY+3,AXISX-DISTY);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX+TRUNC((0.5-DY)*2.0*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX+DISTY,AXISY+3,AXISX+DISTY);
 OUTTEXTXY(AXISY-7,AXISX+DISTY,CHCR(ORDMIN));
 SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+10,CX);
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=1 TO FACTOR DO
  BEGIN
   I1:=AXISY+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+15;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Plots the trajectory of the given data segment on the screen assuming     }
{ COORDSYS has been called before and x-axis is placed in the screen center }
{ N0,NN = indices of the first and last data picked                         }
{ LTN = line thickness                                                      }

PROCEDURE PLOTGRAPH(LTN,N0,NN:INTEGER;ORDINATE,ABSCISSA:VECTOR);
VAR
 IL,IR,IHL,IHR:INTEGER; { screen coordinates                      }
 I:INTEGER;             { data index                              }
 HALFORD:REAL;          { corresponds to the height of the x-axis }
 FACTORX,FACTORY:REAL;  { scaling parameters                      }
BEGIN
 SETLINESTYLE(0,0,LTN);
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);HALFORD:=(ORDMAX+ORDMIN)/2;
 FACTORY:=DISTY/(ORDMAX-HALFORD);
 IR:=AXISY+TRUNC((ABSCISSA[N0]-ABSCMIN)*FACTORX);
 IHR:=AXISX-TRUNC((ORDINATE[N0]-HALFORD)*FACTORY);
 I:=N0;
 REPEAT
  I:=I+1;
  IL:=IR;IHL:=IHR;
  IR:=AXISY+TRUNC((ABSCISSA[I]-ABSCMIN)*FACTORX);
  IHR:=AXISX-TRUNC((ORDINATE[I]-HALFORD)*FACTORY);
  LINE(IL,IHL,IR,IHR);
 UNTIL I=NN;
 SETLINESTYLE(0,0,1);
END;{ PLOTGRAPH }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.1.9 (PC-Exercise 8.2.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Generation of the Euler and the Midpoint approximation : }

 I:=0;            { number of time steps                        }
 TI:=T0;          { initial time                                }
 Y1T[I]:=X0;      { initial value of the Euler approximation    }
 Y2T[I]:=X0;      { initial value of the Midpoint approximation }
 EPS1[0]:=0.0;    { initial error of the Euler approximation    }
 EPS2[0]:=0.0;    { initial error of the Midpoint approximation }
 ABSCISSA[0]:=T0; { initial value of the x-axis                 }

{ Initialization for the Midpoint approximation : }

 I:=I+1;                          { new time step                          }
 TI:=T0+DELTA;                    { new subinterval point                  }
 Y1T[I]:=X0+A(TI-DELTA,X0)*DELTA; { one Euler step for the Midpoint scheme }
 Y2T[I]:=Y1T[I];
 ABSCISSA[I]:=TI; { value of the x-axis }

{ Calculation of the global discretization errors at time t = TI : }

 XT:=EXPLSOL(TI);    { exact solution               }
 EPS1[I]:=XT-Y1T[I]; { error of the Euler method    }
 EPS2[I]:=XT-Y2T[I]; { error of the Midpoint method }

{ Iteration : }

 WHILE (TI < T) DO
  BEGIN
   I:=I+1; { time step }
   TI:=TI+DELTA; { right subinterval end point }

  { Euler scheme : }

   Y1T[I]:=Y1T[I-1]+A(TI-DELTA,Y1T[I-1])*DELTA;

  { Midpoint scheme : }

   Y2T[I]:=Y2T[I-2]+2.*A(TI-DELTA,Y2T[I-1])*DELTA;

  { Calculation of the global discretization errors at time t = TI : }

   XT:=EXPLSOL(TI);    { exact solution               }
   EPS1[I]:=XT-Y1T[I]; { error of the Euler method    }
   EPS2[I]:=XT-Y2T[I]; { error of the Midpoint method }

   ABSCISSA[I]:=TI; { value of the x-axis }
  END;

{ Printout : }

 CLEARDEVICE;
 COORDSYS('EPS','t');              { draws the coordinate system }
 PLOTGRAPH(1,0,NUM,EPS1,ABSCISSA); { plots the Euler error       }
 PLOTGRAPH(3,0,NUM,EPS2,ABSCISSA); { plots the Midpoint error    }
 CR:='Global discretization errors EPS1(Euler)(thin) and EPS2(Midpoint)';
 CR:=CR+'(thick)';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X1X9 }