{ Exact solution and Euler approximation                                   }
{ Considers the stochastic differential equation                           }
{               dX(t) = A(t,X(t)) dt + B(t,X(t)) dW(t)                     }
{           with  X(T0) = X0   on the time interval [T0,T]                 }
{ where W(t) is a Wiener process                                           }
{ Equidistant approximation of X(t) by the Euler scheme with the time step }
{ sizes DELTA                                                              }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers      }
{ Plots the linearly interpolated trajectories of X(t) and the Euler ap-   }
{ proximation w.r.t. the highest possible resolution in the same graphic   }
{ Written by Henri Schurz, 9.10. 1991                                      }
{ Note : Be careful if changing the time step sizes. The maximum of the    }
{        numbers of the time steps used can not be larger than NUMINV.     }
{        Otherwise the corresponding picking up of data has to be reorga-  }
{        nized in order to use AAGRAPHS-routines. The time step size DELTA }
{        can not be smaller than the DELTA_X used to evaluate the exact    }
{        solution.                                                         }
{        Range check errors may occur if the final time T is not an integer}
{        number due to truncation errors. In those cases one has to change }
{        the test form (TI<T)? in the WHILE statement (example T = 1.9) or }
{        one uses FOR ... TO ... DO loops.                                 }

PROGRAM PRX3X2X1; { PC-Exercise 9.2.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 T0=0.0;         { left end point                                         }
 T=1.0;          { right end point                                        }
 DELTA=(T-T0)/4; { time step size (>=1/NUMINV) of the Euler approximation }
 X0=1.0;         { initial value                                          }
 ALPHA=1.5;      { parameter in the function A(t,x)                       }
 BETA=1.0;       { parameter in the function B(t,x)                       }

VAR
 CR:STRING;          { help string                                   }
 I,J:INTEGER;        { time steps                                    }
 APPROXSTEP:INTEGER; { ratio of the time step sizes                  }
 TI:REAL;            { subinterval point                             }
 YTOLD:REAL;         { last value of the approximation               }
 DELTA_X:REAL;       { time step size to plot the exact solution     }
 SQDELTA_X:REAL;     { square root of the time step size DELTA_X     }
 G1,G2:REAL;         { Gaussian random numbers                       }
 WT:REAL;            { value of the Wiener process at time ti        }
 DWTI:REAL;          { Wiener process increment  W(t(i+1)) - W(ti)   }
 DWT:VECTOR;         { values of the Wiener process increments       }
 XT:VECTOR;          { values of the exact solution X(t)             }
 YT:VECTOR;          { values of the Euler approximation using DELTA }
 ABSCISSA:VECTOR;    { values of the subinterval points              }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=BETA*XI;
END;{ B }

{ Generates the functional form of the explicit solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP((ALPHA-0.5*BETA*BETA)*(TI-T0)+BETA*WT);
END;{ EXPLSOL }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.2.1 (PC-Exercise 9.2.1)');
 STATUSLINE('Be patient! This will take the computer some time!');
 APPROXSTEP:=TRUNC(NUMINV*DELTA/(T-T0)+0.0000001); { ratio of step sizes }

{ Generation of the Wiener process increments DWT[I]            }
{ Evaluation of the exact solution and initialization of data : }

 DELTA_X:=(T-T0)/NUMINV;   { time step size for the exact solution }
 SQDELTA_X:=SQRT(DELTA_X); { square root of DELTA_X                }
 TI:=T0;                   { initial time                          }
 XT[0]:=X0;                { initial value of the exact solution   }
 ABSCISSA[0]:=T0;          { value of the x-axis                   }
 WT:=0.0;                  { value of the Wiener process at t = T0 }
 FOR I:=1 TO NUMINV DO
  BEGIN
   TI:=TI+DELTA_X; { time }
   IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
    ELSE G1:=G2;
   DWT[I-1]:=G1*SQDELTA_X; { Wiener process increment  W(t(i+1)) - W(ti) }
   WT:=WT+DWT[I-1];        { value of the Wiener process W(t) at t = TI  }
   XT[I]:=EXPLSOL(TI,WT);  { exact value of the solution                 }
   ABSCISSA[I]:=TI;        { value of the x-axis                         }
  END;

{ Generation of the Euler approximation : }

 I:=0;
 TI:=T0;    { initial time                       }
 YT[0]:=X0; { initial value of the approximation }
 WHILE TI < T DO
  BEGIN
   I:=I+1;    { time step index }
   TI:=TI+DELTA; { current time }
   YTOLD:=YT[(I-1)*APPROXSTEP]; { saves the old value }
   DWTI:=0.0; { calculates Wiener process increment for Euler time step }
   FOR J:=1 TO APPROXSTEP DO DWTI:=DWTI+DWT[(I-1)*APPROXSTEP+J-1];

  { Euler scheme : }

   YT[I*APPROXSTEP]:=YTOLD+A(TI-DELTA,YTOLD)*DELTA+B(TI-DELTA,YTOLD)*DWTI;

  { Interpolation for the other values : }

   IF APPROXSTEP>1 THEN
    FOR J:=1 TO APPROXSTEP-1 DO
     YT[(I-1)*APPROXSTEP+J]:=YTOLD+J*(YT[I*APPROXSTEP]-YTOLD)/APPROXSTEP;

  END;{ WHILE }

{ Printout : }

 CLEARDEVICE;
 GRAPH321(XT,YT,ABSCISSA,'X(t), Y(t)','t','X(t)','Y(t)'); { plots the paths }
 CR:='Exact solution X(t) and Euler approximation Y(t) using ';
 CR:=CR+'DELTA = '+CHCR(DELTA);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X2X1 }