{ Illustrates the absolute error criterion                             }
{ Considers the stochastic differential equation                       }
{      dX(t) = A(t,X(t)) dt + B(t,X(t)) dW(t)   with  X(T0) = X0       }
{  on the time interval [T0,T]  where W(t) is a Wiener process         }
{ Equidistant approximation of X(t) by the Euler scheme with different }
{ time step sizes DELTA                                                }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers  }
{ Estimation of the absolute errors at the time T using N trajectories }
{ Printout of the estimates for different time step sizes              }
{ Written by Henri Schurz, 9.10. 1991                                  }

PROGRAM PRX3X3X1; { PC-Exercise 9.3.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 N=25;            { sample size                                        }
 NUM=4;           { number of different time step sizes                }
 T0=0.0;          { left end point                                     }
 T=1.0;           { right end point                                    }
 DELTA=(T-T0)/16; { largest time step size of the Euler approximations }
 X0=1.0;          { initial value                                      }
 ALPHA=1.5;       { parameter in the function A(t,x)                   }
 BETA=1.0;        { parameter in the function B(t,x)                   }

TYPE
 VECTOR=ARRAY[1..NUM] OF REAL;

VAR
 CR:STRING;      { help string                                   }
 G:INTEGER;      { index of the current time step size           }
 K:INTEGER;      { sample index                                  }
 I:INTEGER;      { time step index                               }
 TI:REAL;        { subinterval point                             }
 DELTA_Y:REAL;   { time step size of the Euler approximation     }
 SQDELTA_Y:REAL; { square root of the time step size DELTA_Y     }
 G1,G2:REAL;     { Gaussian random numbers                       }
 WT:REAL;        { value of the Wiener process at time ti        }
 DWTI:REAL;      { Wiener process increment  W(t(i+1)) - W(ti)   }
 XT:REAL;        { value of the exact solution X(t)              }
 YT:REAL;        { value of the Euler approximation using DELTA  }
 EPS:VECTOR;     { absolute errors for different time step sizes }
 DEL:VECTOR;     { time step sizes                               }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=BETA*XI;
END;{ B }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP((ALPHA-0.5*BETA*BETA)*(TI-T0)+BETA*WT);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Prepares the screen and plots a table of the results }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 IK,L:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IK:=TRUNC((MAXX-2)/4);
 FOR L:=0 TO NUM+1 DO LINE(0,80+L*20,4*IK,80+L*20);
 CR:='Estimated absolute errors arising in the Euler approximation at t = ';
 CR:=CR+CHCR(T)+' :';
 OUTTEXTXY(TRUNC(MAXX/2),25,CR);
 OUTTEXTXY(2*IK,60,'sample size N = '+CHCR(N));
 FOR L:=0 TO 4 DO
  CASE L OF
   0,2,4 : LINE(L*IK,80,L*IK,80+(NUM+1)*20);
    1 : BEGIN
         CR:='time step size';OUTTEXTXY(L*IK,90,CR);
         FOR I:=1 TO NUM DO
          BEGIN
           CR:=CHCR(DEL[I]);OUTTEXTXY(L*IK,90+I*20,CR);
          END;
        END;
    3 : BEGIN
         CR:='absolute error';OUTTEXTXY(L*IK,90,CR);
         FOR I:=1 TO NUM DO
          BEGIN
           CR:=CHCR(EPS[I]);OUTTEXTXY(L*IK,90+I*20,CR);
          END;
        END;
   END;
END;{ SETTABLETOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.3.1 (PC-Exercise 9.3.1)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the absolute errors for different time step sizes : }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used    }
  DELTA_Y:=DELTA_Y/2;       { time step size of the approximation }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y              }
  EPS[G]:=0.0;              { initial error                       }

 { Generation of different trajectories : }

  K:=0;
  REPEAT
   K:=K+1;  { index of the trajectory used          }
   WT:=0.0; { value of the Wiener process at t = T0 }

  { Generation of the Euler approximation and its absolute error : }

   I:=0;
   TI:=T0; { initial time                       }
   YT:=X0; { initial value of the approximation }
   WHILE TI<T DO
    BEGIN
     I:=I+1;         { time step index }
     TI:=TI+DELTA_Y; { current time    }
     IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
      ELSE G1:=G2;
     DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
     WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

    { Euler scheme : }

     YT:=YT+A(TI-DELTA_Y,YT)*DELTA_Y+B(TI-DELTA_Y,YT)*DWTI;

    END;{ WHILE }

  { Summation of the absolute errors : }

   XT:=EXPLSOL(TI,WT); { exact value of the solution }
   EPS[G]:=EPS[G]+ABSERR(XT,YT);

  UNTIL K=N;{ REPEAT for different samples }
  EPS[G]:=EPS[G]/N;DEL[G]:=DELTA_Y;
 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the results : }

 CLEARDEVICE;
 SETTABLETOSCR;
 CR:='Estimation of the absolute error for different time step sizes';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X3X1 }