{ Confidence intervals for the absolute errors arising in the Euler aproxi- }
{ mations at the time T                                                     }
{ Considers the stochastic differential equation                            }
{     dX(t) = A(t,X(t)) dt + B(t,X(t)) dW(t)        with X(T0) = X0         }
{  on the time interval [T0,T] where W(t) is a Wiener process               }
{ Equidistant approximation of X(t) by the Euler scheme with the time step  }
{ size DELTA                                                                }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=10,20,40,100) with the sample size N             }
{ Plots the confidence intervals for different batch numbers                }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch length remember that the corresponding per-  }
{        centage points should also be changed.                             }

PROGRAM PRX3X3X2; { PC-Exercise 9.3.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 MAXM=100;        { maximum of batch numbers                  }
 N=100;           { sample size of one batch                  }
 T0=0.0;          { left end point                            }
 T=1.0;           { right end point                           }
 DELTA=(T-T0)/16; { time step size of the Euler approximation }
 X0=1.0;          { initial value                             }
 ALPHA=1.5;       { parameter in the function A(t,x)          }
 BETA=0.1;        { parameter in the function B(t,x)          }

TYPE
 VECTOR0=ARRAY[1..MAXM] OF REAL;

VAR
 CR:STRING;             { help string                                  }
 I:INTEGER;             { time step index                              }
 J:INTEGER;             { index of the batch used                      }
 K:INTEGER;             { sample index within the current batch        }
 TI:REAL;               { subinterval point                            }
 SQDELTA:REAL;          { square root of the time step size DELTA      }
 G1,G2:REAL;            { Gaussian random numbers                      }
 WT:REAL;               { value of the Wiener process at time ti       }
 DWTI:REAL;             { Wiener process increment  W(ti+1) - W(ti)    }
 XT:REAL;               { value of the exact solution X(t)             }
 YT:REAL;               { value of the Euler approximation using DELTA }
 AVERAGE,VARIANCE:REAL; { statistical parameters                       }
 QUANTILE:REAL;         { percentage points of the t-distribution      }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch    }
 M:VECTOR1;             { numbers of batches                           }
 DIFFER:VECTOR1;        { half of the confidence interval lengths      }
 EPS:VECTOR1;           { absolute errors for different batch numbers  }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=BETA*XI;
END;{ B }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP((ALPHA-0.5*BETA*BETA)*(TI-T0)+BETA*WT);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.3.2 (PC-Exercise 9.3.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the absolute errors    }
{ for different batch numbers using the already generated batches : }

 EPS[1]:=0.0;EPS[2]:=0.0;EPS[3]:=0.0;EPS[4]:=0.0; { initial errors }
 SQDELTA:=SQRT(DELTA); { square root of DELTA }
 J:=0;
 REPEAT
  J:=J+1;          { index of the batch used                          }
  EPSYLON[J]:=0.0; { sum of the absolute errors within the batch used }

 { Generation of different trajectories : }

  K:=0;
  REPEAT
   K:=K+1;  { index of the trajectory used          }
   WT:=0.0; { value of the Wiener process at t = T0 }

  { Generation of the Euler approximation and its absolute error : }

   I:=0;
   TI:=T0; { initial time                       }
   YT:=X0; { initial value of the approximation }
   WHILE TI<T DO
    BEGIN
     I:=I+1;       { time step index }
     TI:=TI+DELTA; { current time    }
     IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
      ELSE G1:=G2;
     DWTI:=G1*SQDELTA; { Wiener process increment  W(t(i+1)) - W(ti) }
     WT:=WT+DWTI;      { value of the Wiener process W(t) at t = TI  }

    { Euler scheme : }

     YT:=YT+A(TI-DELTA,YT)*DELTA+B(TI-DELTA,YT)*DWTI;

    END;{ WHILE }

  { Summation of the absolute errors : }

   XT:=EXPLSOL(TI,WT); { exact value of the solution }
   EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

  UNTIL K=N;{ REPEAT for different samples }
  EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
 UNTIL J=MAXM;{ REPEAT for different batches }

{ Calculation of the confidence intervals and initialization of data : }

 FOR J:=1 TO 4 DO
  BEGIN
   CASE J OF { initializes batch numbers and percentage points }
     1 : BEGIN M[J]:=10;QUANTILE:=1.83 END;
     2 : BEGIN M[J]:=20;QUANTILE:=1.73 END;
     3 : BEGIN M[J]:=40;QUANTILE:=1.68 END;
     4 : BEGIN M[J]:=100;QUANTILE:=1.66 END;
    END;
   COMPSAMPLEPARA(TRUNC(M[J]),EPSYLON,AVERAGE,VARIANCE);
   EPS[J]:=AVERAGE;              { midpoint of the confidence interval }
   DIFFER[J]:=QUANTILE*SQRT(VARIANCE/M[J]); { half the interval length }
  END;

{ Printout of the results : }

 CLEARDEVICE;
 CONFINV(4,EPS,DIFFER,M,'EPS','number of batches');
 CR:='Confidence intervals for the absolute error EPS(Euler,DELTA=';
 CR:=CR+CHCR(DELTA)+') at t = '+CHCR(T);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X3X2 }