{ Confidence intervals for the absolute errors in the Euler approximation   }
{ at the time T and the (log2,log2) - graph                                 }
{ Considers the stochastic differential equation                            }
{      dX(t) = A(t,X(t)) dt + B1(t,X(t)) dW1(t) + B2(t,X(t)) dW2(t)         }
{ with  X(T0) = X0  on the time interval [T0,T]                             }
{ where (W1(t),W2(t)) is a two-dimensional Wiener process                   }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X1X1; { PC-Exercise 10.2.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                }
 T0=0.0;         { left end point                                     }
 T=1.0;          { right end point                                    }
 DELTA=(T-T0)/8; { largest time step size of the Euler approximations }
 X0=1.0;         { initial value                                      }
 ALPHA=-0.5;     { parameter in the function A(t,x)                   }
 BETA1=1.0;      { parameter in the function B1(t,x)                  }
 BETA2=1.0;      { parameter in the function B2(t,x)                  }
 M=20;           { number of batches                                  }
 N=100;          { sample size of one batch                           }
 QUANTILE=1.73;  { percentage point of the t-distribution             }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 TI:REAL;               { subinterval point                                 }
 DELTA_Y:REAL;          { time step size of the Euler approximation         }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 G1,G2:REAL;            { Gaussian random numbers                           }
 W1T,W2T:REAL;          { values of the Wiener process at time ti           }
 DW1TI,DW2TI:REAL;      { Wiener process increments W(.)(t(i+1)) - W(.)(ti) }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the Euler approximation using DELTA_Y    }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the diffusion function B1(t,x) }

FUNCTION B1(TI,XI:REAL):REAL;
BEGIN
 B1:=BETA1*XI;
END;{ B1 }

{ Generates the diffusion function B2(t,x) }

FUNCTION B2(TI,XI:REAL):REAL;
BEGIN
 B2:=BETA2*XI;
END;{ B2 }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,W1T,W2T:REAL):REAL;
VAR
 Q:REAL;
BEGIN
 Q:=ALPHA-0.5*(BETA1*BETA1+BETA2*BETA2);
 EXPLSOL:=X0*EXP(Q*(TI-T0)+BETA1*W1T+BETA2*W2T);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.1.1 (PC-Exercise 10.2.1)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the absolute errors }
{ for different time step sizes :                                }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;   { index of the trajectory used                                }
    W1T:=0.0; { value of the first component of the Wiener process at t=T0  }
    W2T:=0.0; { value of the second component of the Wiener process at t=T0 }

   { Generation of the Euler approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;              { time step index                               }
      TI:=TI+DELTA_Y;      { current time                                  }
      GENERATE(G1,G2);     { uses Polar Marsaglia method                   }
      DW1TI:=G1*SQDELTA_Y; { Wiener process increment  W1(t(i+1)) - W1(ti) }
      DW2TI:=G2*SQDELTA_Y; { Wiener process increment  W2(t(i+1)) - W2(ti) }
      W1T:=W1T+DW1TI;      { value of the Wiener process W1(t) at t = TI   }
      W2T:=W2T+DW2TI;      { value of the Wiener process W2(t) at t = TI   }

     { Euler scheme : }

      YT:=YT+A(TI-DELTA_Y,YT)*DELTA_Y                      { drift part     }
         +B1(TI-DELTA_Y,YT)*DW1TI+B2(TI-DELTA_Y,YT)*DW2TI; { diffusion part }

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,W1T,W2T); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(Euler,t=';
 CR:=CR+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph at t = ';
 CR:=CR+CHCR(T);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X1X1 }