{ Confidence intervals for the absolute errors in the Milstein approxima-   }
{ tion at the time T and the (log2,log2) - graph                            }
{ Considers the stochastic differential equation                            }
{       dX(t) = A(t,X(t)) dt + B1(t,X(t)) dW1(t) + B2(t,X(t)) dW2(t)        }
{               with X(T0) = X0 on the time interval [T0,T]                 }
{ where (W1(t),W2(t)) is a Wiener process                                   }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : Use the truncation parameters P = 2 and P = 10(takes time)         }
{        If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X1X3; { PC-Exercise 10.3.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                   }
 T0=0.0;         { left end point                                        }
 T=1.0;          { right end point                                       }
 DELTA=(T-T0)/8; { largest time step size of the Milstein approximations }
 X0=1.0;         { initial value                                         }
 ALPHA=-0.5;     { parameter in the function A(t,x)                      }
 BETA1=1.0;      { parameter in the function B1(t,x)                     }
 BETA2=1.0;      { parameter in the function B2(t,x)                     }
 P=2;            { truncation parameter for the multiple integrals       }
 M=20;           { number of batches                                     }
 N=100;          { sample size of one batch                              }
 QUANTILE=1.73;  { percentage point of the t-distribution                }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 TI:REAL;               { subinterval point                                 }
 DELTA_Y:REAL;          { time step size of the Milstein approximation      }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 G1,G2:REAL;            { Gaussian random numbers                           }
 W1T,W2T:REAL;          { values of the Wiener process at time ti           }
 DW1TI,DW2TI:REAL;      { Wiener process increments W(.)(t(i+1)) - W(.)(ti) }
 AA,BB1,BB2:REAL;       { function values for the Milstein scheme           }
 DB1DX,DB2DX:REAL;      { derivatives values for the Milstein scheme        }
 L1B11,L1B12:REAL;      { operator values for the Milstein scheme           }
 L2B11,L2B12:REAL;      { operator values for the Milstein scheme           }
 I1,I11,I2,I22,I12P,I21P:REAL; { multiple Ito integrals                     }
 J12P,J21P:REAL;        { multiple Stratonovich integrals                   }
 ROP:REAL;              { approximation parameter of the multiple integrals }
 MU1,MU2:REAL;          { Gaussian random numbers                           }
 SUMVAL:REAL;           { help variable                                     }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the Milstein approximation using DELTA_Y }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the diffusion function B1(t,x) }

FUNCTION B1(TI,XI:REAL):REAL;
BEGIN
 B1:=BETA1*XI;
END;{ B1 }

{ Generates the first x partial derivative of the diffusion function B1(t,x) }

FUNCTION DB1X(TI,XI:REAL):REAL;
BEGIN
 DB1X:=BETA1;
END;{ DB1X }

{ Generates the diffusion function B2(t,x) }

FUNCTION B2(TI,XI:REAL):REAL;
BEGIN
 B2:=BETA2*XI;
END;{ B2 }

{ Generates the first x partial derivative of the diffusion function B2(t,x) }

FUNCTION DB2X(TI,XI:REAL):REAL;
BEGIN
 DB2X:=BETA2;
END;{ DB2X }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,W1T,W2T:REAL):REAL;
VAR
 Q:REAL;
BEGIN
 Q:=ALPHA-0.5*(BETA1*BETA1+BETA2*BETA2);
 EXPLSOL:=X0*EXP(Q*(TI-T0)+BETA1*W1T+BETA2*W2T);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Sets the parameter ROP of the procedure MULTIINTJ12 }

PROCEDURE SETUPPARAMULTIINTJ12(P:INTEGER;VAR ROP:REAL);
VAR
 R:INTEGER;
BEGIN
 ROP:=0.0;
 FOR R:=1 TO P DO ROP:=ROP+1/(R*R);
 ROP:=PI*PI/6-ROP;ROP:=ROP/(2*PI*PI);
END;{ SETUPPARAMULTIINTJ12 }

{ Generates the multiple Stratonovich integral J12                          }
{ Uses the time step size DELTA; PL and PR(<=100) are accuracy parameters   }
{ Assumes the Gaussian random numbers GSI1,GSI2,MU1 and MU2 have already    }
{ been generated and ROP has been calculated by SETUPPARAMULTIINTJ12 before }
{ GSI1 and GSI2 are involved in the generation of the Wiener increments     }
{ SUMVAL is the help value to continue the summations                       }

PROCEDURE MULTIINTJ12(PL,PR:INTEGER;ROP,DELTA,GSI1,GSI2,MU1,MU2:REAL;
                                    VAR SUMVAL,J12:REAL);
VAR
 R:INTEGER;
 ETA,ZETA:ARRAY[1..2,1..100] OF REAL;
BEGIN
 FOR R:=PL TO PR DO
  BEGIN
   GENERATE(ZETA[1,R],ZETA[2,R]);GENERATE(ETA[1,R],ETA[2,R]);
   SUMVAL:=SUMVAL+(1/R)*(ZETA[1,R]*(SQRT(2)*GSI2+ETA[2,R])
                 -ZETA[2,R]*(SQRT(2)*GSI1+ETA[1,R]));
  END;
 J12:=SUMVAL*DELTA/PI;
 J12:=J12+DELTA*(GSI1*GSI2/2+SQRT(ROP)*(MU1*GSI2-MU2*GSI1));
END;{ MULTIINTJ12 }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.1.3 (PC-Exercise 10.3.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Calculation of the parameter ROP depending on P : }

 SETUPPARAMULTIINTJ12(P,ROP);

{ Estimation of the confidence intervals for the absolute errors }
{ for different time step sizes :                                }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;   { index of the trajectory used                                }
    W1T:=0.0; { value of the first component of the Wiener process at t=T0  }
    W2T:=0.0; { value of the second component of the Wiener process at t=T0 }

   { Generation of the Milstein approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;              { time step index                               }
      TI:=TI+DELTA_Y;      { current time                                  }
      GENERATE(G1,G2);     { uses Polar Marsaglia method                   }
      DW1TI:=G1*SQDELTA_Y; { Wiener process increment  W1(t(i+1)) - W1(ti) }
      DW2TI:=G2*SQDELTA_Y; { Wiener process increment  W2(t(i+1)) - W2(ti) }
      W1T:=W1T+DW1TI;      { value of the Wiener process W1(t) at t = TI   }
      W2T:=W2T+DW2TI;      { value of the Wiener process W2(t) at t = TI   }

     { Approximation of the multiple Stratonovich integral J12 : }

      SUMVAL:=0.0;
      GENERATE(MU1,MU2); { Gaussian random numbers MU1 and MU2 }
      MULTIINTJ12(1,P,ROP,DELTA_Y,G1,G2,MU1,MU2,SUMVAL,J12P);
      J21P:=DW1TI*DW2TI-J12P;

     { Milstein scheme(Ito version) : }

      I1:=DW1TI;I11:=0.5*(DW1TI*DW1TI-DELTA_Y);I12P:=J12P; { Ito integrals }
      I2:=DW2TI;I22:=0.5*(DW2TI*DW2TI-DELTA_Y);I21P:=J21P;
      AA:=A(TI-DELTA_Y,YT);
      BB1:=B1(TI-DELTA_Y,YT);DB1DX:=DB1X(TI-DELTA_Y,YT);
      BB2:=B2(TI-DELTA_Y,YT);DB2DX:=DB2X(TI-DELTA_Y,YT);
      L1B11:=BB1*DB1DX;L1B12:=BB1*DB2DX;
      L2B12:=BB2*DB2DX;L2B11:=BB2*DB1DX;
      YT:=YT+AA*DELTA_Y  { drift part }
      +BB1*I1+BB2*I2+L1B11*I11+L1B12*I12P+L2B11*I21P+L2B12*I22;{ diffusion }

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,W1T,W2T); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(t=';
 CR:=CR+CHCR(T)+')'+'  <Milstein>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph at t = ';
 CR:=CR+CHCR(T)+'  <Milstein>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X1X3 }