{ Confidence intervals for the absolute errors in the 1.5 order strong      }
{ Taylor approximation at t = T and the (log2,log2)-graph                   }
{ Considers the stochastic differential equation                            }
{       dX(t) = A(t,X(t)) dt + B(t,X(t)) dW(t)   with  X(T0) = X0           }
{ on the time interval [T0,T] where W(t) is a Wiener process                }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X1X5; { PC-Exercise 10.4.2 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                 }
 T0=0.0;         { left end point                                      }
 T=1.0;          { right end point                                     }
 DELTA=(T-T0)/8; { largest time step size of the Taylor approximations }
 X0=1.0;         { initial value                                       }
 ALPHA=1.5;      { parameter in the function A(t,x)                    }
 BETA=0.1;       { parameter in the function B(t,x)                    }
 M=20;           { number of batches                                   }
 N=100;          { sample size of one batch                            }
 QUANTILE=1.73;  { percentage point of the t-distribution              }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 SQRT3:REAL;            { square root of 3.0                                }
 TIOLD:REAL;            { left subinterval point                            }
 TI:REAL;               { right subinterval point                           }
 DELTA_Y:REAL;          { time step size of the Taylor approximation        }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 AA,DADX,BB,DBDX:REAL;  { function values for the 1.5 order Taylor scheme   }
 L0A11,L0B11,L1A11,L1B11,L1L1B11:REAL; { values of the functional operators }
 I1,I11,I10,I01,I00,I111:REAL; { multiple Ito integrals                     }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the Taylor approximation using DELTA_Y   }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the first x partial derivatives of the drift function A(t,x) }

FUNCTION DAX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DAX:=ALPHA;
END;{ DAX }

FUNCTION DAT(TI,XI:REAL):REAL; { t derivative }
BEGIN
 DAT:=0.0;
END;{ DAT }

{ Generates the second x partial derivative of the drift function A(t,x) }

FUNCTION DDAXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDAXX:=0.0;
END;{ DDAXX }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=BETA*XI;
END;{ B }

{ Generates the first partial derivatives of the diffusion function B(t,x) }

FUNCTION DBX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DBX:=BETA;
END;{ DBX }

FUNCTION DBT(TI,XI:REAL):REAL; { t derivative }
BEGIN
 DBT:=0.0;
END;{ DBT }

{ Generates the second x partial derivative of the diffusion function B(t,x) }

FUNCTION DDBXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDBXX:=0.0;
END;{ DDBXX }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP((ALPHA-0.5*BETA*BETA)*(TI-T0)+BETA*WT);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.1.5 (PC-Exercise 10.4.2)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the absolute errors }
{ for different time step sizes :                                }

 SQRT3:=SQRT(3);
 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the Taylor approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;             { time step index                             }
      TI:=TI+DELTA_Y;     { current time                                }
      GENERATE(G1,G2);    { uses the Polar Marsaglia method             }
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Generation of the multiple Ito integrals : }

      I1:=DWTI;I11:=0.5*(DWTI*DWTI-DELTA_Y);I00:=0.5*DELTA_Y*DELTA_Y;
      I10:=0.5*SQDELTA_Y*DELTA_Y*(G1+G2/SQRT3);I01:=DWTI*DELTA_Y-I10;
      I111:=0.5*(DWTI*DWTI/3-DELTA_Y)*DWTI;

     { 1.5 order strong Taylor scheme(Ito version) : }

      TIOLD:=TI-DELTA_Y;
      AA:=A(TIOLD,YT);DADX:=DAX(TIOLD,YT);
      BB:=B(TIOLD,YT);DBDX:=DBX(TIOLD,YT);
      L0A11:=DAT(TIOLD,YT)+AA*DADX+0.5*BB*BB*DDAXX(TIOLD,YT);
      L0B11:=DBT(TIOLD,YT)+AA*DBDX+0.5*BB*BB*DDBXX(TIOLD,YT);
      L1A11:=BB*DADX;L1B11:=BB*DBDX;
      L1L1B11:=BB*(DBDX*DBDX+BB*DDBXX(TIOLD,YT));
      YT:=YT+AA*DELTA_Y+BB*I1+L1B11*I11+L1A11*I10+L0B11*I01+L0A11*I00
            +L1L1B11*I111;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(t=';
 CR:=CR+CHCR(T)+')'+'  <1.5 Taylor>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph at t = ';
 CR:=CR+CHCR(T)+'  <1.5 Taylor>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X1X5 }