{ The general 2.0 order Taylor approximation in the one-dimensional case    }
{ Confidence intervals for the absolute errors in the 2.0 order strong      }
{ Taylor approximation at t = T and the (log2,log2) - graph                 }
{ Considers the stochastic differential equation                            }
{       dX(t) = A(t,X(t)) dt + B(t,X(t)) dW(t)   with  X(T0) = X0           }
{ on the time interval [T0,T] where W(t) is a Wiener process                }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X1X7; { PC-Exercise 10.5.2 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                 }
 T0=0.0;         { left end point                                      }
 T=1.0;          { right end point                                     }
 DELTA=(T-T0)/8; { largest time step size of the Taylor approximations }
 X0=1.0;         { initial value                                       }
 ALPHA=1.5;      { parameter in the function A(t,x)                    }
 BETA=0.1;       { parameter in the function B(t,x)                    }
 P=5;            { truncation parameter for the multiple integrals     }
 M=20;           { number of batches                                   }
 N=100;          { sample size of one batch                            }
 QUANTILE=1.73;  { percentage point of the t-distribution              }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 TIOLD:REAL;            { left subinterval point                            }
 TI:REAL;               { right subinterval point                           }
 DELTA_Y:REAL;          { time step size of the Taylor approximation        }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 AA,DADX,BB,DBDX:REAL;  { function values for the 2.0 order Taylor scheme   }
 DDADXX,DDBDXX:REAL;    { function values for the 2.0 order Taylor scheme   }
 DDBDXT,DDDBDXXX:REAL;  { function values for the 2.0 order Taylor scheme   }
 CORRDRIFT:REAL;        { value of the corresponding Stratonovich drift     }
 L0A11,L0B11,L1A11,L1B11,L1L1B11:REAL; { values of the functional operators }
 L1L1A11,L1L0B11,L0L1B11,L1L1L1B11:REAL;{ values of the functional operators}
 DL1B11DX:REAL;         { help variable(derivative of the operator L1B11)   }
 J1,J11,J00,J111,J1111:REAL; { multiple Stratonovich integrals              }
 J10,J01,J110,J101,J011:REAL;{ multiple Stratonovich integrals approximated }
 ALPHAP,ROP:REAL;       { approximation parameter of the multiple integrals }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the Taylor approximation using DELTA_Y   }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the first partial derivatives of the drift function A(t,x) }

FUNCTION DAX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DAX:=ALPHA;
END;{ DAX }

FUNCTION DAT(TI,XI:REAL):REAL; { t derivative }
BEGIN
 DAT:=0.0;
END;{ DAT }

{ Generates the second x partial derivative of the drift function A(t,x) }

FUNCTION DDAXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDAXX:=0.0;
END;{ DDAXX }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=BETA*XI;
END;{ B }

{ Generates the first partial derivatives of the diffusion function B(t,x) }

FUNCTION DBX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DBX:=BETA;
END;{ DBX }

FUNCTION DBT(TI,XI:REAL):REAL; { t derivative }
BEGIN
 DBT:=0.0;
END;{ DBT }

{ Generates the second partial derivatives of the diffusion function B(t,x) }

FUNCTION DDBXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDBXX:=0.0;
END;{ DDBXX }

FUNCTION DDBXT(TI,XI:REAL):REAL; { derivative w.r.t. x and t }
BEGIN
 DDBXT:=0.0;
END;{ DDBXT }

FUNCTION DDBTX(TI,XI:REAL):REAL; { derivative w.r.t. t and x }
BEGIN
 DDBTX:=0.0;
END;{ DDBTX }

{ Generates the third x partial derivative of the diffusion function B(t,x) }

FUNCTION DDDBXXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDDBXXX:=0.0;
END;{ DDDBXXX }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP((ALPHA-0.5*BETA*BETA)*(TI-T0)+BETA*WT);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Sets the parameters for the procedure MULTIINT }

PROCEDURE SETUPPARAMULTIINT(P:INTEGER;VAR ALPHAP,ROP:REAL);
VAR
 R:INTEGER;
 INCRE:REAL;
BEGIN
 ALPHAP:=0.0;ROP:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   INCRE:=1/(R*R);ROP:=ROP+INCRE;ALPHAP:=ALPHAP+INCRE*INCRE;
  END;
 ALPHAP:=(PI*PI*PI*PI/90-ALPHAP)/(2*PI*PI);
 ROP:=PI*PI/6-ROP;ROP:=ROP/(2*PI*PI);
END;{ SETUPPARAMULTIINT }

{ Generates the multiple Stratonovich integrals                         }
{ J1, J01, J10, J11, J011, J101, and J110                               }
{ Uses the time step size DELTA_Y; P = accuracy parameter               }
{ Assumes the Gaussian random number DWT has already been generated and }
{ SETUPPARAMULTIINT has been called before                              }

PROCEDURE MULTIINT(P:INTEGER;DWT:REAL;VAR J1,J01,J10,J11,J011,J101,J110:REAL);
VAR
 R,L:INTEGER;
 A10,B11P,B1P,C11P,FI1P,GSI,MUE1P:REAL;
 ETA1,FI1:VECTOR;
BEGIN
 GENERATE(FI1P,MUE1P);
 A10:=0.0;B1P:=0.0;B11P:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   GENERATE(FI1[R],ETA1[R]);
   A10:=A10+FI1[R]/R;
   B1P:=B1P+ETA1[R]/(R*R);
   B11P:=B11P+(FI1[R]*FI1[R]+ETA1[R]*ETA1[R])/(R*R);
  END;
 A10:=-(1./PI)*A10*SQRT(2.0)*SQDELTA_Y;
 A10:=A10-2.*SQDELTA_Y*SQRT(ROP)*MUE1P;
 B1P:=B1P*SQDELTA_Y/SQRT(2.0)+SQDELTA_Y*SQRT(ALPHAP)*FI1P;
 B11P:=B11P/(4.*PI*PI);
 GSI:=DWT;
 J1:=GSI*SQDELTA_Y; { increment of the Wiener trajectory = J1 }
 J10:=0.5*DELTA_Y*(J1+A10); { multiple integral J10 }
 J01:=J1*DELTA_Y-J10; { multiple integral J01 }
 J11:=0.5*J1*J1; { multiple integral J11 }
 C11P:=0.0;
 R:=0;
 REPEAT
  R:=R+1;
  L:=0;
  REPEAT
   L:=L+1;
   IF L<>R THEN
    C11P:=C11P+(R/(R*R-L*L))*(FI1[R]*FI1[L]/L-ETA1[R]*ETA1[L]*L/R);
  UNTIL L=P;
 UNTIL R=P;
 C11P:=-C11P/(2.*PI*PI);
 J101:=SQR(DELTA_Y*GSI)/6-DELTA_Y*A10*A10/4;
 J101:=J101+SQDELTA_Y*DELTA_Y*GSI*B1P/PI;
 J101:=J101-DELTA_Y*DELTA_Y*B11P; { multiple integral J101 }
 J110:=SQR(DELTA_Y*GSI)/6+DELTA_Y*A10*A10/4;
 J110:=J110-SQDELTA_Y*DELTA_Y*GSI*B1P/(2.*PI);
 J110:=J110+SQDELTA_Y*DELTA_Y*A10*GSI/4;
 J110:=J110-DELTA_Y*DELTA_Y*C11P; { multiple integral J110 }
 J011:=J11*DELTA_Y-J101-J110; { multiple integral J011 }
END;{ MULTIINT }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.1.7 (PC-Exercise 10.5.2)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the absolute errors }
{ for different time step sizes :                                }

 SETUPPARAMULTIINT(P,ALPHAP,ROP); { sets the parameters for MULTIINT }
 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the Taylor approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses the Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Generation of the multiple integrals : }

      MULTIINT(P,G1,J1,J01,J10,J11,J011,J101,J110);
      J00:=0.5*DELTA_Y*DELTA_Y;J111:=J11*DWTI/3;J1111:=J111*DWTI/4;

     { 2.0 order strong Taylor scheme(Stratonovich version) : }

      TIOLD:=TI-DELTA_Y;
      AA:=A(TIOLD,YT);DADX:=DAX(TIOLD,YT);DDADXX:=DDAXX(TIOLD,YT);
      BB:=B(TIOLD,YT);DBDX:=DBX(TIOLD,YT);DDBDXX:=DDBXX(TIOLD,YT);
      DDBDXT:=DDBXT(TIOLD,YT);DDDBDXXX:=DDDBXXX(TIOLD,YT);
      L1B11:=BB*DBDX;CORRDRIFT:=AA-0.5*L1B11;DL1B11DX:=DBDX*DBDX+BB*DDBDXX;
      L0A11:=DAT(TIOLD,YT)-0.5*(DBT(TIOLD,YT)*DBDX+BB*DDBDXT);
      L0A11:=L0A11+CORRDRIFT*(DADX-0.5*DL1B11DX);
      L1A11:=BB*(DADX-0.5*DL1B11DX);
      L1L1A11:=DBDX*L1A11+BB*BB*(DDADXX-0.5*(3.*DBDX*DDBDXX+BB*DDDBDXXX));
      L0B11:=DBT(TIOLD,YT)+CORRDRIFT*DBDX;
      L0L1B11:=DBT(TIOLD,YT)*DBDX+BB*DDBDXT+CORRDRIFT*DL1B11DX;
      L1L0B11:=BB*(DDBTX(TIOLD,YT)+(DADX-0.5*DL1B11DX)*DBDX+CORRDRIFT*DDBDXX);
      L1L1B11:=BB*DL1B11DX;
      L1L1L1B11:=DBDX*L1L1B11+BB*BB*(3.*DBDX*DDBDXX+BB*DDDBDXXX);
      YT:=YT+CORRDRIFT*DELTA_Y+BB*J1+L1B11*J11+L1A11*J10+L0B11*J01;
      YT:=YT+L0A11*J00+L1L1B11*J111+L1L1L1B11*J1111;
      YT:=YT+L0L1B11*J011+L1L0B11*J101+L1L1A11*J110;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(t=';
 CR:=CR+CHCR(T)+')'+'  <2.0 Taylor>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph at t = ';
 CR:=CR+CHCR(T)+'  <2.0 Taylor>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X1X7 }