{ Plots linearly interpolated trajectories of the displacement of the       }
{ Duffing Van der Pol oscillators generated by the two-step approximation   }
{ proposed by Lepingle and Ribemont                                         }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Written by Henri Schurz, 9.10.1991                                        }
{ Note : For a correct printout of the paths one has to choose the scaling  }
{        parameter carefully.                                               }

PROGRAM PRX4X2X7; { PC-Exercise 11.4.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 NUM=128;           { number of the time steps              }
 T0=0.0;            { initial time                          }
 T=8.0;             { end time                              }
 DELTA=(T-T0)/NUM;  { time step size                        }
 X10=-2.0;          { initial value of the first component  }
 X20=0.0;           { initial value of the second component }
 C=0.01;            { parameter in the diffusion function   }
 ABSCMIN=T0;        { left end point                        }
 ABSCMAX=T;         { right end point                       }
 ORDMIN=-2.0;       { minimum of the ordinate               }
 ORDMAX=+2.0;       { maximum of the ordinate               }
 ORDPOINT=0.0;      { significant ordinate point            }

TYPE
 VECTOR=ARRAY[0..NUM] OF REAL;

VAR
 CR:STRING;           { help string                                 }
 K:INTEGER;           { counter                                     }
 AXISX,AXISY:INTEGER; { location of the axes                        }
 DISTX,DISTY:INTEGER; { scale parameters                            }
 SQDELTA:REAL;        { sqrt of the time step size                  }
 TK:REAL;             { subinterval end                             }
 H1,H2:REAL;          { help numbers                                }
 G1,G2:REAL;          { Gaussian random numbers                     }
 DWTK:REAL;           { Wiener process increment  W(t(k+1)) - W(tk) }
 Y1T:VECTOR;          { values of the displacement                  }
 ABSCISSA:VECTOR;     { subinterval points                          }

{ Prepares the screen for the printout of the trajectory         }
{ X-axis is placed in the center; CY,CX ... strings for the axes }

PROCEDURE COORDSYS(CY,CX:STRING);
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+10;
 AXISX:=TRUNC(MAXY/2);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-2*IH-20;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,AXISX-DISTY-IH,'^');OUTTEXTXY(AXISY,AXISX-DISTY-2*IH,CY);
 LINE(AXISY,AXISX-DISTY-IH,AXISY,AXISX+DISTY+IH);
 LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-DISTY;
 LINE(AXISY-3,AXISX-DISTY,AXISY+3,AXISX-DISTY);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX+TRUNC((0.5-DY)*2.0*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX+DISTY,AXISY+3,AXISX+DISTY);
 OUTTEXTXY(AXISY-7,AXISX+DISTY,CHCR(ORDMIN));
 SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+10,CX);
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 IF ((ABSCMIN=0.0) AND ((ABSCMAX=6.0) OR (ABSCMAX=7.0) OR (ABSCMAX=8.0)))
  THEN FACTOR:=TRUNC(ABSCMAX);
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=1 TO FACTOR DO
  BEGIN
   I1:=AXISY+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+15;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Plots the trajectory of the displacement on the screen assuming COORDSYS }
{ has been called before and x-axis is placed in the screen center         }
{ N0,NN = indices of the first and last data picked                        }
{ LTN = line thickness                                                     }

PROCEDURE PLOTGRAPH(LTN,N0,NN:INTEGER;ORDINATE,ABSCISSA:VECTOR);
VAR
 IL,IR,IHL,IHR:INTEGER; { screen coordinates                      }
 I:INTEGER;             { data index                              }
 HALFORD:REAL;          { corresponds to the height of the x-axis }
 FACTORX,FACTORY:REAL;  { scaling parameters                      }
BEGIN
 SETLINESTYLE(0,0,LTN);
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);HALFORD:=(ORDMAX+ORDMIN)/2;
 FACTORY:=DISTY/(ORDMAX-HALFORD);
 IR:=AXISY+TRUNC((ABSCISSA[N0]-ABSCMIN)*FACTORX);
 IHR:=AXISX-TRUNC((ORDINATE[N0]-HALFORD)*FACTORY);
 I:=N0;
 REPEAT
  I:=I+1;
  IL:=IR;IHL:=IHR;
  IR:=AXISY+TRUNC((ABSCISSA[I]-ABSCMIN)*FACTORX);
  IHR:=AXISX-TRUNC((ORDINATE[I]-HALFORD)*FACTORY);
  LINE(IL,IHL,IR,IHR);
 UNTIL I=NN;
 SETLINESTYLE(0,0,1);
END;{ PLOTGRAPH }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 4.2.7 (PC-Exercise 11.4.1)');
 STATUSLINE('Be patient! This will take the computer some time.');

{ Generation of the two-step approximation and data : }

 ABSCISSA[0]:=T0;
 Y1T[0]:=X10;Y1T[1]:=X10+X20*DELTA;
 TK:=T0+DELTA;ABSCISSA[1]:=TK;
 SQDELTA:=SQRT(DELTA);K:=1;
 REPEAT
  K:=K+1;
  TK:=TK+DELTA;
  IF K MOD 2 = 1 THEN GENERATE(G1,G2) ELSE G1:=G2;
  DWTK:=SQDELTA*G1;
  H1:=Y1T[K-1];H2:=Y1T[K-2];
  Y1T[K]:=(2.0-DELTA)*H1+(DELTA*(1.0+DELTA*(1.0-H2*H2))-1.0)*H2+C*DWTK*DELTA;
  ABSCISSA[K]:=TK;
 UNTIL K=NUM;

{ Printout : }

 CLEARDEVICE;
 COORDSYS('Y1(t)','t');    { draws the coordinate system }
 PLOTGRAPH(1,0,NUM,Y1T,ABSCISSA); { plots the trajectory }
 CR:='Displacement of the Duffing Van der Pol oscialltor';
 CR:=CR+'(DELTA = '+CHCR(DELTA)+')';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X2X7 }