{ Confidence intervals for the absolute errors in the two-step order 1.5    }
{ approximation at the time T and the (log2,log2) - graph                   }
{ Considers the stochastic differential equation                            }
{       dX(t) = ALPHA * X(t) dt + BETA * X(t) dW(t)    with  X(T0) = X0     }
{ on the time interval [T0,T] where W(t) is a Wiener process                }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X2X8; { PC-Exercise 11.4.2 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                   }
 T0=0.0;         { left end point                                        }
 T=1.0;          { right end point                                       }
 DELTA=(T-T0)/8; { largest time step size of the explicit approximations }
 X0=1.0;         { initial value                                         }
 ALPHA=1.5;      { parameter in the drift function A(t,x)                }
 BETA=0.1;       { parameter in the diffusion function B(t,x)            }
 M=20;           { number of batches                                     }
 N=100;          { sample size of one batch                              }
 QUANTILE=1.73;  { percentage point of the t-distribution                }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 TI:REAL;               { subinterval point                                 }
 DELTA_Y:REAL;          { time step size of the explicit approximation      }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 KAPPA1,KAPPA2:REAL;    { constants in the numerical scheme                 }
 DWTN,VN1,VN2,YN,YTOLD:REAL; { values supporting the scheme evaluation      }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 I11,I111:REAL;         { values of the multiple Ito integrals I11 and I111 }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the explicit approximation using DELTA_Y }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP((ALPHA-0.5*BETA*BETA)*(TI-T0)+BETA*WT);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.2.8 (PC-Exercise 11.4.2)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the absolute errors }
{ for different time step sizes :                                }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }
  KAPPA1:=1.0+ALPHA*DELTA_Y;                { scheme constant  }
  KAPPA2:=BETA*BETA*(ALPHA*SQDELTA_Y+BETA); { scheme constant  }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the two-step approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    I:=I+1;          { time step index }
    TI:=TI+DELTA_Y;  { current time    }
    GENERATE(G1,G2); { uses Polar Marsaglia method }
    DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
    WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
    I11:=0.5*(DWTI*DWTI-DELTA_Y);I111:=(DWTI*(DWTI*DWTI-3.*DELTA_Y))/6;
    VN1:=BETA*YT*(DWTI+ALPHA*DWTI*DELTA_Y+BETA*I11+BETA*BETA*I111);

   { Explicit 1.5 order scheme as the starting routine : }

    YT:=YT*(0.5*ALPHA*ALPHA*DELTA_Y*DELTA_Y+(1.0+BETA*DWTI)*KAPPA1
      +BETA*BETA*(DWTI*DWTI-DELTA_Y)/2+KAPPA2*DWTI*(DWTI*DWTI-3.*DELTA_Y)/6);

    YN:=X0;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      DWTN:=DWTI;
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      I11:=0.5*(DWTI*DWTI-DELTA_Y); { multiple integral I11             }
      I111:=(DWTI*(DWTI*DWTI-3.*DELTA_Y))/6; { multiple integral I111   }
      VN2:=VN1;VN1:=BETA*YT*(DWTI+ALPHA*DWTI*DELTA_Y+BETA*I11+BETA*BETA*I111);

     { Two step order 1.5 scheme : }

      YTOLD:=YT;
      YT:=YN*(1.0-ALPHA*BETA*DWTN*DELTA_Y)+2.*ALPHA*DELTA_Y*YT+VN1+VN2;
      YN:=YTOLD;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(t=';
 CR:=CR+CHCR(T)+')'+'  <Two step 1.5>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph at t = ';
 CR:=CR+CHCR(T)+'  <Two step 1.5>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X2X8 }