{ Confidence intervals for the absolute errors in the implicit order 2.0    }
{ Runge-Kutta approximation with scalar additive noise at the time T and    }
{ the (log2,log2) - graph of the absolute errors                            }
{ Considers the stochastic differential equation                            }
{  dX(t) = (ALPHA*X(t)/(1+t)+ X0*(1+t)^ALPHA) dt + X0*(1+t)^ALPHA dW(t)     }
{ with X(T0)=X0 on the time interval [T0,T] where W(t) is a Wiener process  }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X3X6; { PC-Exercise 12.3.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                   }
 T0=0.0;         { left end point                                        }
 T=0.5;          { right end point                                       }
 DELTA=(T-T0)/4; { largest time step size of the implicit approximations }
 X0=1.0;         { initial value                                         }
 ALPHA=2.0;      { parameter in the drift function A(t,x)                }
 M=20;           { number of batches                                     }
 N=100;          { sample size of one batch                              }
 QUANTILE=1.73;  { percentage point of the t-distribution                }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 TI:REAL;               { subinterval point                                 }
 DELTA_Y:REAL;          { time step size of the implicit approximation      }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 KAPPA:REAL;            { constant in the numerical scheme                  }
 HH,H0,H1,H2,H3,H4:REAL;{ help numbers supporting the scheme evaluation     }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 DELZ:REAL;             { multiple Ito integral I10                         }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the implicit approximation using DELTA_Y }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP(ALPHA*LN(1.0+TI))*(WT+1.0+TI);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.3.6 (PC-Exercise 12.3.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the absolute errors }
{ for different time step sizes :                                }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }
  KAPPA:=ALPHA*DELTA_Y;     { scheme constant                  }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the implicit approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;          { time step index             }
      TI:=TI+DELTA_Y;  { current time                }
      GENERATE(G1,G2); { uses Polar Marsaglia method }
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      DELZ:=0.5*SQDELTA_Y*DELTA_Y*(G1+G2/SQRT(3.0)); { multiple integral I10 }

     { Implicit order 2.0 strong Runge-Kutta scheme with additive noise : }

      HH:=1.0+TI-DELTA_Y;H1:=HH+DELTA_Y/2.;H2:=EXP(ALPHA*LN(HH));
      H4:=EXP(ALPHA*LN(1.0+TI));H0:=1.0+KAPPA*((2.0+KAPPA/HH)/H1-0.5/HH);
      H3:=2.*ALPHA*X0*H2/H1;H1:=KAPPA*H2/H1+2.*EXP(ALPHA*LN(H1))-0.5*(H4+H2);
      H1:=X0*DELTA_Y*H1;H4:=X0*(H4-H2)/DELTA_Y;H2:=X0*H2;
      HH:=1.0+0.5*KAPPA/(1.0+TI);
      YT:=H0*YT+H1+H2*DWTI+H3*(0.5*DELZ+0.25*DELTA_Y*DWTI);
      YT:=(YT+H4*(DELTA_Y*DWTI-DELZ))/HH;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the strong error EPS(Implicit R.-Kutta';
 CR:=CR+'(2.0),t='+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='(log2(EPS),log2(DELTA)) - graph at t = ';
 CR:=CR+CHCR(T)+' <Implicit order 2.0 Runge Kutta>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X3X6 }