{ Confidence intervals for the strong errors in the implicit two-step order }
{ 1.5 approximation with implicitness ALPHAK(.) = 1.0  at the time T and    }
{ plotting of the (log2,log2) - graph of these errors                       }
{ whereas the degree of connection between two steps BETAK(.)=1.0           }
{ using the implicit order 1.5 strong Taylor scheme as its starting routine }
{ Considers the two-dimensional system of stochastic differential equations }
{      dX1(t) = ALPHA * (X2(t)-X1(t)) dt + BETA * X1(t) dW(t)               }
{      dX2(t) = ALPHA * (X1(t)-X2(t)) dt + BETA * X2(t) dW(t)               }
{ with  X(T0) = (X10,X20)  on the time interval [T0,T]                      }
{ where W(t) is a one-dimensional Wiener process                            }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the strong errors at the   }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the strong errors against the log2 of the step sizes    }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X3X8; { PC-Exercise 12.4.2 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                     }
 T0=0.0;         { left end point                                          }
 T=1.0;          { right end point                                         }
 DELTA=(T-T0)/4; { largest time step size of the implicit approximations   }
 X10=1.0;        { initial value of the first component of the solution    }
 X20=0.0;        { initial value of the second component of the solution   }
 ALPHA=5.0;      { parameter in the drift matrix A(t,x1,x2)                }
 BETA=0.01;      { parameter in the diffusion matrix B(t,x1,x2)            }
 M=20;           { number of batches                                       }
 N=100;          { sample size of one batch                                }
 QUANTILE=1.73;  { percentage point of the t-distribution                  }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;                { help string                                    }
 G:INTEGER;                { index of the current time step size            }
 I:INTEGER;                { time step index                                }
 J:INTEGER;                { batch index                                    }
 K:INTEGER;                { sample index within the current batch          }
 TI:REAL;                  { subinterval point                              }
 DELTA_Y:REAL;             { time step size of the implicit approximation   }
 SQDELTA_Y:REAL;           { square root of the time step size DELTA_Y      }
 H,HH,HI,HII,V1N1,V1N2,V2N1,V2N2,Y1N,Y2N:REAL; { local help numbers         }
 KAPPA,KAPPA0,KAPPA1,KAPPA2:REAL; { global scheme constants                 }
 G1,G2:REAL;               { Gaussian random numbers                        }
 WT:REAL;                  { values of the Wiener process at time ti        }
 DWTI:REAL;                { Wiener process increment  W(t(i+1)) - W(ti)    }
 I11,I111:REAL;            { multiple Ito integrals I11 and I111            }
 X1T,X2T:REAL;             { components of the exact solution (X1(t),X2(t)) }
 Y1T,Y2T:REAL;             { components of the implicit approximation       }
 AVERAGE,VARIANCE:REAL;    { statistical parameters                         }
 EPSYLON:VECTOR0;          { sum of the strong errors within a batch        }
 DEL:VECTOR1;              { time step sizes                                }
 DIFFER:VECTOR1;           { half of the confidence interval lengths        }
 EPS:VECTOR1;              { strong errors for different time step sizes    }

{ Generates the components of the exact solution }

PROCEDURE EXPLSOL(TI,WT:REAL;VAR X1,X2:REAL);
VAR
 EROP,EROM,Q1,Q2:REAL;
BEGIN
 EROP:=EXP(BETA*(-0.5*BETA*(TI-T0)+WT));EROM:=EROP*EXP(-2.0*ALPHA*(TI-T0));
 Q1:=0.5*(EROP+EROM);Q2:=0.5*(EROP-EROM);
 X1:=Q1*X10+Q2*X20;X2:=Q2*X10+Q1*X20;
END;{ EXPLSOL }

{ Generates the error criterion formula using Euclidean norm }

FUNCTION SQRTERR(X1,X2,Y1,Y2:REAL):REAL;
BEGIN
 SQRTERR:=SQRT((X1-Y1)*(X1-Y1)+(X2-Y2)*(X2-Y2)); { Euclidean norm }
END;{ SQRTERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.3.8 (PC-Exercise 12.4.2)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the strong errors }
{ for different time step sizes :                              }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used   }
  DELTA_Y:=DELTA_Y/2;       { current time step size             }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y             }
  KAPPA0:=ALPHA*DELTA_Y;    { initialization of scheme constants }
  KAPPA1:=1.0-KAPPA0;KAPPA2:=1.0+KAPPA0;KAPPA:=1.+2.0*KAPPA0*KAPPA2;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the implicit approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    HII:=Y2T-Y1T;V1N1:=Y1T;V2N1:=Y2T;Y1N:=Y1T;Y2N:=Y2T;

   { One step of the implicit order 1.5 strong Taylor scheme(Ito version) : }

    I:=I+1;          { time step index }
    TI:=TI+DELTA_Y;  { current time    }
    GENERATE(G1,G2); { uses Polar Marsaglia method }
    DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
    WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
    I11:=0.5*(DWTI*DWTI-DELTA_Y); { multiple integral I11             }
    I111:=DWTI*(DWTI*DWTI-3.*DELTA_Y)/6.; { multiple integral I111    }
    HH:=1.0+BETA*(DWTI+BETA*(I11+BETA*I111));HI:=HII;HII:=HII*HH/KAPPA;
    Y1T:=Y1T*HH+KAPPA0*HII*KAPPA2;Y2T:=Y2T*HH-KAPPA0*HII*KAPPA2;

    HH:=HH-1.0;
    V1N1:=V1N1*HH+0.5*KAPPA0*BETA*DWTI*HI;
    V2N1:=V2N1*HH-0.5*KAPPA0*BETA*DWTI*HI;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      I11:=0.5*(DWTI*DWTI-DELTA_Y); { multiple integral I11             }
      I111:=DWTI*(DWTI*DWTI-3.*DELTA_Y)/6.; { multiple integral I111    }

     { Implicit two-step order 1.5 strong scheme(Ito version) : }

      HH:=BETA*(DWTI+BETA*(I11+BETA*I111));
      V1N2:=V1N1;V1N1:=Y1T*HH+0.5*KAPPA0*BETA*DWTI*HII;
      V2N2:=V2N1;V2N1:=Y2T*HH-0.5*KAPPA0*BETA*DWTI*HII;
      H:=HI;HI:=HII;HII:=(KAPPA1*H-2.*KAPPA0*HI+V2N1-V1N1+V2N2-V1N2)/KAPPA2;
      HH:=Y1T;Y1T:=Y1N+0.5*KAPPA0*(HII+2.*HI+H)+V1N1+V1N2;Y1N:=HH;
      HH:=Y2T;Y2T:=Y2N-0.5*KAPPA0*(HII+2.*HI+H)+V2N1+V2N2;Y2N:=HH;

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the strong error EPS(Implicit two-step 1.5';
 CR:=CR+',t='+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='(log2(EPS),log2(DELTA)) - graph at t='+CHCR(T)+' <';
 CR:=CR+'Implicit two-step order 1.5>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X3X8 }