{ Confidence intervals for the absolute errors in the implicit two-step     }
{ order 2.0 approximation with scalar additive noise at the time T and      }
{ the (log2,log2) - graph of the absolute errors                            }
{ whereas the degree of connection of two steps GAMMA = 1.0                 }
{ using the implicit order 2.0 Taylor scheme as its starting routine        }
{ Considers the stochastic differential equation                            }
{  dX(t) = (ALPHA*X(t)/(1+t)+ X0*(1+t)^ALPHA) dt + X0*(1+t)^ALPHA dW(t)     }
{ with X(T0)=X0 on the time interval [T0,T] where W(t) is a Wiener process  }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }

PROGRAM PRX4X3X9; { PC-Exercise 12.4.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                   }
 T0=0.0;         { left end point                                        }
 T=0.5;          { right end point                                       }
 DELTA=(T-T0)/4; { largest time step size of the implicit approximations }
 X0=1.0;         { initial value                                         }
 ALPHA=2.0;      { parameter in the drift function A(t,x)                }
 M=20;           { number of batches                                     }
 N=100;          { sample size of one batch                              }
 QUANTILE=1.73;  { percentage point of the t-distribution                }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 TI:REAL;               { subinterval point                                 }
 DELTA_Y:REAL;          { time step size of the implicit approximation      }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 KAPPA0,KAPPA1:REAL;    { constants in the numerical scheme                 }
 HH,H1,H2,H3,VN1,VN2,YN1,YN2:REAL;  { local help numbers                    }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the implicit approximation using DELTA_Y }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP(ALPHA*LN(1.0+TI))*(WT+1.0+TI);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.3.9 (PC-Exercise 12.4.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the absolute errors }
{ for different time step sizes :                                }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                    { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;        { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);  { square root of DELTA_Y           }
  KAPPA0:=0.5*ALPHA*DELTA_Y; { scheme constants                 }
  KAPPA1:=0.5*X0*DELTA_Y;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the implicit approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    YN1:=YT;

   { One step of the implicit order 2.0 Taylor scheme(implicitness 0.5) : }

    I:=I+1;          { time step index             }
    TI:=TI+DELTA_Y;  { current time                }
    GENERATE(G1,G2); { uses Polar Marsaglia method }
    DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
    WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
    H2:=1.0+TI-DELTA_Y;HH:=1.0+TI;H1:=1.0+KAPPA0/H2;H2:=EXP(ALPHA*LN(H2));
    H3:=X0*H2*H1;H2:=KAPPA1*(EXP(ALPHA*LN(HH))+H2);HH:=1.0-KAPPA0/HH;
    YT:=(H1*YT+H2+H3*DWTI)/HH;

    VN1:=X0*(1.0+T0+KAPPA0)*DWTI*EXP((ALPHA-1.0)*LN(1.0+T0));
    WHILE TI<T DO
     BEGIN
      I:=I+1;          { time step index             }
      TI:=TI+DELTA_Y;  { current time                }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Implicit two-step order 2.0 scheme with additive noise : }

      VN2:=VN1;YN2:=YN1;YN1:=YT;
      H1:=1.0+TI-2.*DELTA_Y;H2:=H1+DELTA_Y;H3:=H2+DELTA_Y;
      HH:=1.0-KAPPA0/H3;VN1:=EXP((ALPHA-1.0)*LN(H2));
      H3:=KAPPA1*(EXP(ALPHA*LN(H3))+2.*VN1*H2+EXP(ALPHA*LN(H1)));
      VN1:=X0*DWTI*VN1*(H2+KAPPA0);H2:=2.*KAPPA0/H2;H1:=1.0+KAPPA0/H1;
      YT:=(H1*YN2+H2*YN1+H3+VN1+VN2)/HH;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval    }
  IF VARIANCE<0.0 THEN VARIANCE:=0.0; { control over too small values }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length    }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the confidence intervals : }

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the strong error EPS(Implicit two-step(2.0)';
 CR:=CR+',t='+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)','');
 CR:='(log2(EPS),log2(DELTA)) - graph at t = ';
 CR:=CR+CHCR(T)+' <Impl. two-step order 2.0>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X3X9 }