{ Simulation studies with the bilinear stochastic differential equation     }
{ Comparison of the efficiency between selected schemes : explicit order    }
{ 1.0 strong scheme using Stratonovich drift, explicit order 1.0 strong     }
{ scheme involving only Ito drift, explicit order 1.0 strong scheme using   }
{ simplified supporting value, explicit order 1.5 strong scheme involving   }
{ only Ito drift, Euler scheme generally implemented, Euler scheme using    }
{ the bilinearity and the order 2.0 strong Taylor scheme specially implemen-}
{ ted for the bilinear equation in the one-dimensional case at the time T   }
{ Considers the linear stochastic differential equation                     }
{       dX(t) = ALPHA * X(t) dt + BETA * X(t) dW(t)   with  X(T0) = X0      }
{ on the time interval [T0,T] where W(t) is a Wiener process                }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N { without printout!)  }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Plots the log2 of the elapsed time against - log2 of these errors         }
{ Plots the log2 of the elapsed time against the log2 of the step sizes     }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }
{        For the measurement of the necessary time take the sample size     }
{        large enough. Confidence intervals can be plotted by calling the   }
{        routine CONFINV. See preparations at the end of this file.         }

PROGRAM PRX4X4X4;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,EXTGRAPH;

CONST
 NUM=9;         { number of different time step sizes                 }
 T0=0.0;        { left end point                                      }
 T=1.0;         { right end point                                     }
 DELTA=T-T0;    { largest time step size of the strong approximations }
 X0=1.0;        { initial value                                       }
 ALPHA=1.5;     { parameter in the drift function A(t,x)              }
 BETA=0.1;      { parameter in the diffusion function B(t,x)          }
 M=20;{100}     { number of batches                                   }
 N=100;{1000}   { sample size of one batch                            }
 QUANTILE=1.73; { percentage point of the t-distribution              }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 TIME:STRING;           { elapsed total computational time in seconds       }
 HOUR,MINUTE,SECOND,SEC100:WORD; { help time values                         }
 THOUR,TMINUTE,TSECOND,TSEC100:WORD; { help time values                     }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 RTIME:REAL;            { elapsed time converted in a REAL type             }
 SQRT3:REAL;            { square root of 3.0                                }
 TIOLD:REAL;            { left subinterval point                            }
 TI:REAL;               { right subinterval point                           }
 DELTA_Y:REAL;          { time step size of the strong approximation        }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 GAMMA1,GAMMA2:REAL;    { constants in the order 2.0 Taylor scheme(special) }
 KAPPA1,KAPPA2:REAL;    { constants in the explicit schemes              }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the strong approximation using DELTA_Y   }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }
 INVEPS:VECTOR1;        { inverted errors EPS                               }
 TIMER:VECTOR1;         { time elapsed by the generation                    }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=BETA*XI;
END;{ B }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP((ALPHA-0.5*BETA*BETA)*(TI-T0)+BETA*WT);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Takes the elapsed time in seconds for run times not exceeding one day }
{ Assumes GETTIME(HOUR,MINUTE,SECOND,SEC100) has been called before     }
{ Output time as a string TIME and as a real number RTIME               }

PROCEDURE TIMEINSEC(VAR TIME:STRING;VAR RTIME:REAL);
VAR
 ABSSEC,ABSSEC100,OLDHOUR,OLDMINUTE,OLDSEC100,OLDSECOND:WORD;
 CR:STRING;
BEGIN
 OLDHOUR:=HOUR;OLDMINUTE:=MINUTE;OLDSECOND:=SECOND;OLDSEC100:=SEC100;
 GETTIME(HOUR,MINUTE,SECOND,SEC100);
 IF SEC100<OLDSEC100 THEN
   BEGIN OLDSECOND:=OLDSECOND+1;ABSSEC100:=100-OLDSEC100+SEC100; END
  ELSE ABSSEC100:=SEC100-OLDSEC100;
 IF SECOND<OLDSECOND THEN
   BEGIN OLDMINUTE:=OLDMINUTE+1;ABSSEC:=60-OLDSECOND+SECOND; END
  ELSE ABSSEC:=SECOND-OLDSECOND;
 IF MINUTE<OLDMINUTE THEN
   BEGIN OLDHOUR:=OLDHOUR+1;ABSSEC:=ABSSEC+60*(60-OLDMINUTE+MINUTE); END
  ELSE ABSSEC:=ABSSEC+60*(MINUTE-OLDMINUTE);
 IF HOUR<OLDHOUR THEN ABSSEC:=ABSSEC+3600*(24-OLDHOUR+HOUR)
  ELSE ABSSEC:=ABSSEC+3600*(HOUR-OLDHOUR);
 STR(ABSSEC,CR);TIME:=CR+'.';STR(ABSSEC100,CR);
 IF ((LENGTH(CR)=1) AND (CR<>'0')) THEN CR:='0'+CR;
 TIME:=TIME+CR;
 RTIME:=ABSSEC+ABSSEC100/100;
END;{ TIMEINSEC }

{ Provides echo signals on the screen that parameters have been installed }
{ and schemes are just in progress or schemes have been done              }
{ Input NN determining the output line and scheme number                  }

PROCEDURE ECHO(NN:INTEGER;SCHEMETITLE:STRING);
VAR POS1,POS2,POS3,POS4,THM:INTEGER;
BEGIN
 THM:=TEXTHEIGHT('M');
 POS1:=TRUNC(MAXX/2);POS2:=3*(NN+5)*THM;POS3:=11*THM;POS4:=13*THM;
 CASE NN OF
  -4..-2   : OUTTEXTXY(POS1,POS2,SCHEMETITLE);
    -1     : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... in progress');
   1..10   : BEGIN
              SETFILLSTYLE(0,0);BAR(1,POS3,MAXX-1,POS4);SETFILLSTYLE(0,1);
              OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... done');
             END;
   11,12   : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... installed')
 END;
END;{ ECHO }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 4.4.4 (Efficiency comparison between explicit schemes)');
 STATUSLINE('Be patient! This will take the computer some time!');
 CR:='dX(t)  =  ALPHA * X(t) dt  +  BETA * X(t) dW(t)';
 ECHO(-3,CR); { delivers an echo signal to the screen equation implemented }
 CR:='<Parameters> : M='+CHCR(M)+'/N='+CHCR(N)+'/ALPHA=';
 CR:=CR+CHCR(ALPHA)+'/BETA='+CHCR(BETA)+'/X(0)='+CHCR(X0);
 ECHO(11,CR); { delivers an echo signal to the screen on parameters used }
 ECHO(12,'Number of different time step sizes used : '+CHCR(NUM));

{ Euler approximation generally implemented : }

 CR:='Euler generally implemented';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used          }
    WT:=0.0; { value of the Wiener process at t = T0 }

   { Generation of the Euler approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Euler scheme generally implemented : }

      YT:=YT+A(TI-DELTA_Y,YT)*DELTA_Y+B(TI-DELTA_Y,YT)*DWTI;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);TIMER[G]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<1>  Euler generally implemented in '+TIME+' seconds';
 ECHO(1,CR); { delivers an echo signal to the screen scheme ... done }

{ Explicit order 1.0 approximation using Stratonovich drift : }

 CR:='Explicit 1.0 using Stratonovich drift';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100);    { gets the current time            }
  G:=G+1;                                { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;                    { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);              { square root of DELTA_Y           }
  KAPPA1:=(ALPHA-0.5*BETA*BETA)*DELTA_Y; { scheme constants                 }
  KAPPA2:=0.5*(KAPPA1/SQDELTA_Y+BETA);KAPPA1:=1.0+KAPPA1;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the explicit scheme approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Explicit 1.0 order scheme involving Stratonovich drift : }

      YT:=YT*(KAPPA1+BETA*DWTI*(1.0+KAPPA2*DWTI));

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<2>  Explicit 1.0 using Stratonovich drift in '+TIME+' seconds';
 ECHO(2,CR); { delivers an echo signal to the screen scheme ... done }

{ Explicit order 1.0 approximation involving only Ito drift : }

 CR:='Explicit 1.0 involving only Ito drift';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100);    { gets the current time            }
  G:=G+1;                                { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;                    { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);              { square root of DELTA_Y           }
  KAPPA1:=(ALPHA-0.5*BETA*(BETA+ALPHA*SQDELTA_Y))*DELTA_Y;{ scheme constants}
  KAPPA2:=0.5*(BETA+ALPHA*SQDELTA_Y);KAPPA1:=1.0+KAPPA1;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the explicit scheme approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Explicit 1.0 order scheme involving only Ito drift for scalar noise : }

      YT:=YT*(KAPPA1+BETA*DWTI*(1.0+KAPPA2*DWTI));

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+2*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+2*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+2*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+2*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+2*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<3>  Explicit 1.0 involving only Ito drift in '+TIME+' seconds';
 ECHO(3,CR); { delivers an echo signal to the screen scheme ... done }

{ Explicit order 1.0 approximation using simplified supporting value : }

 CR:='Explicit 1.0 using simplified supporting value';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100);    { gets the current time            }
  G:=G+1;                                { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;                    { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);              { square root of DELTA_Y           }
  KAPPA1:=1.0+(ALPHA-0.5*BETA*BETA)*DELTA_Y; { scheme constant              }
  KAPPA2:=0.5*BETA;                      { scheme constant                  }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the explicit scheme approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Explicit 1.0 order scheme using supporting value without drift part : }

      YT:=YT*(KAPPA1+BETA*DWTI*(1.0+KAPPA2*DWTI));

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+3*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+3*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+3*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+3*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+3*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<4>  Explicit 1.0 using simplified supporting value in '+TIME+' seconds';
 ECHO(4,CR); { delivers an echo signal to the screen scheme ... done }

{ Explicit order 1.5 approximation involving only Ito drift : }

 CR:='Explicit 1.5 involving only Ito drift';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time  }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }
  KAPPA1:=1.0+ALPHA*DELTA_Y;                { scheme constant  }
  KAPPA2:=BETA*BETA*(ALPHA*SQDELTA_Y+BETA); { scheme constant  }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the explicit scheme approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Explicit 1.5 order scheme involving only Ito drift : }

      YT:=YT*(0.5*ALPHA*ALPHA*DELTA_Y*DELTA_Y+(1.0+BETA*DWTI)*KAPPA1
      +BETA*BETA*(DWTI*DWTI-DELTA_Y)/2+KAPPA2*DWTI*(DWTI*DWTI-3.*DELTA_Y)/6);

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+4*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+4*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+4*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+4*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+4*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<5>  Explicit 1.5 involving only Ito drift in '+TIME+' seconds';
 ECHO(5,CR); { delivers an echo signal to the screen scheme ... done }

{ Euler approximation using the bilinearity : }

 CR:='Euler using the bilinearity';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time   }
  G:=G+1;                    { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;        { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);  { square root of DELTA_Y           }
  KAPPA1:=1.0+ALPHA*DELTA_Y; { scheme constant                  }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used          }
    WT:=0.0; { value of the Wiener process at t = T0 }

   { Generation of the Euler approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Euler scheme using the bilinearity : }

      YT:=YT*(KAPPA1+BETA*DWTI);

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+5*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+5*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+5*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+5*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+5*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<6>  Euler using the bilinearity in '+TIME+' seconds';
 ECHO(6,CR); { delivers an echo signal to the screen scheme ... done }

{ The order 2.0 Taylor approximation specially implemented : }

 CR:='Taylor 2.0 using the bilinear structure';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                              { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;                  { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);            { square root of DELTA_Y           }
  GAMMA1:=DELTA_Y*(ALPHA-BETA*BETA/2); { scheme constants                 }
  GAMMA2:=GAMMA1+1.0;
  GAMMA1:=1.0+GAMMA1*(1.0+(ALPHA-BETA*BETA/2)*DELTA_Y/2);

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the Taylor approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses the Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { 2.0 order strong Taylor scheme(Stratonovich version) : }

      YT:=YT*(GAMMA1+BETA*DWTI*
       (GAMMA2*(1.0+BETA*DWTI/2)+BETA*BETA*DWTI*DWTI*(1.0+BETA*DWTI/4)/6));

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+6*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+6*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+6*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+6*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+6*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<7>  Taylor 2.0 with using the bilinearity in '+TIME+' seconds';
 ECHO(7,CR); { delivers an echo signal to the screen scheme ... done }
 STATUSLINE('Ready. Press any key except <ESC> !');
 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the error graphs in the logarithmic graphic table : }

 CLEARDEVICE;
 GRAPH441(6,NUM,EPS,DEL,'log2(EPS)','log2(DELTA)');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph';
 CR:=CR+'<Explicit,Taylor 2.0,t='+CHCR(T)+'>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the logarithmic graphic table for the efficiency comparison : }

 CLEARDEVICE;
 GRAPH441(7,NUM,TIMER,INVEPS,'log2(TIME)','-log2(EPS)');
 CR:='Linearly interpolated (-log2(EPS),log2(TIME)) - graph';
 CR:=CR+'<Explicit,Taylor 2.0,t='+CHCR(T)+'>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the time consumption in the logarithmic graphic table : }

 CLEARDEVICE;
 GRAPH441(7,NUM,TIMER,DEL,'log2(TIME)','log2(DELTA)');
 CR:='Linearly interpolated (log2(TIME),log2(DELTA)) - graph';
 CR:=CR+'<Explicit,Taylor 2.0,t='+CHCR(T)+'>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX4X4X4 }

{ If desired
    choose the corresponding confidence intervals by EPS, DIFFER and DEL
   and add the following :

  Printout of the confidence intervals :

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(t=';
 CR:=CR+CHCR(T)+')'+'  <Explicit>';
 STATUSLINE(CR);
}