{ Confidence intervals for the errors E ( g(Y(T) - g(X(T)) ) for the order  }
{ 4.0 weak Taylor approximations at the time T  w.r.t. a given function     }
{ g(.), also plotting the (log2,log2) - graph for the absolute values       }
{ Considers the stochastic differential equation with additive noise        }
{     dX(t) = ALPHA * X(t) dt + BETA dW(t)          with X(T0) = X0         }
{  on the time interval [T0,T] where W(t) is a Wiener process               }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the mean errors at the     }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch numbers remember that the corresponding per- }
{        centage points should also be changed.                             }

PROGRAM PRX5X1X5; { PC-Exercise 14.4.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=3;         { number of different time step sizes               }
 T0=0.0;        { initial time                                      }
 T=1.0;         { final time                                        }
 DELTA=T;       { largest time step size of the weak approximations }
 X0=0.1;        { initial value                                     }
 ALPHA=2.0;     { parameter in the drift function A(x)              }
 BETA=0.01;     { parameter in the diffusion                        }
 M=20;          { number of batches                                 }
 N=100;         { batch size                                        }
 QUANTILE=1.73; { percentage point of the t-distribution            }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;                 { help string                                   }
 G:INTEGER;                 { index of the time step size used              }
 I:INTEGER;                 { time step index                               }
 J:INTEGER;                 { batch index                                   }
 K:INTEGER;                 { sample index within the current batch         }
 TI:REAL;                   { subinterval point                             }
 DELTA_Y:REAL;              { time step size of the weak approximation      }
 SQDELTA_Y:REAL;            { square root of the time step size DELTA_Y     }
 KAPPA0,KAPPA1,KAPPA2:REAL; { scheme parameter                              }
 G1,G2:REAL;                { Gaussian random numbers                       }
 DWTI:REAL;                 { Wiener process increment  W(t(i+1)) - W(ti)   }
 DELZ:REAL;                 { multiple Ito integral I10                     }
 EGXT:REAL;                 { value of  E g(X(t)) at t = T                  }
 YT:REAL;                   { value of the weak approximation using DELTA_Y }
 AVERAGE,VARIANCE:REAL;     { statistical parameters                        }
 MUYLON:VECTOR0;            { sum of the mean errors within a batch         }
 DEL:VECTOR1;               { time step sizes                               }
 DIFFER:VECTOR1;            { half of the confidence interval lengths       }
 MU:VECTOR1;                { mean errors for different time step sizes     }

{ Generates the exact mean value of the function g(X(t)) }

FUNCTION MEANGXT(TI:REAL):REAL;
BEGIN
 MEANGXT:=X0*EXP(ALPHA*(TI-T0)); { first moment of g(X(t)) }
END;{ MEANGXT }

{ Generates the functional form of g(.) }

FUNCTION GXT(X:REAL):REAL;
BEGIN
 GXT:=X; { compares the first moments }
END;{ GXT }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 5.1.5 (PC-Exercise 14.4.1)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the mean errors MU }
{ for different time step sizes :                               }

 EGXT:=MEANGXT(T); { calculates E g(X(T)) }
 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used     }
  DELTA_Y:=DELTA_Y/2;       { current time step size               }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y               }
  KAPPA1:=ALPHA*DELTA_Y;    { calculation of the scheme parameters }
  KAPPA2:=KAPPA1*KAPPA1;KAPPA0:=1.0+KAPPA1+KAPPA2*(1.0+KAPPA1/3.+KAPPA2/12)/2;
  KAPPA2:=ALPHA*BETA*(1.0+KAPPA1);
  KAPPA1:=BETA*(1.0+KAPPA1*KAPPA1*(KAPPA1/4-DELTA_Y)/6);

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                         }
   MUYLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1; { index of the trajectory used }

   { Generation of the weak approximation and its mean error MU : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;          { time step index }
      TI:=TI+DELTA_Y;  { current time    }
      GENERATE(G1,G2); { uses Polar Marsaglia method }
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      DELZ:=0.5*SQDELTA_Y*DELTA_Y*(G1+G2/SQRT(3.0)); { multiple integral I10 }

     { Simplified order 4.0 weak Taylor scheme(Ito version) : }

      YT:=KAPPA0*YT+KAPPA1*DWTI+KAPPA2*DELZ;

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    MUYLON[J]:=MUYLON[J]+GXT(YT);

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N-EGXT; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the results : }

 CLEARDEVICE;
 CONFINV(NUM,MU,DIFFER,DEL,'MU','DELTA');
 CR:='90% Confidence intervals for the mean error MU(Simpl. 4.0 weak Taylor';
 CR:=CR+',t='+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 FOR G:=1 TO NUM DO MU[G]:=ABS(MU[G]); { plotting requires positive data }
 GRAPH313(NUM,MU,DEL,'log2(ABS(MU))','log2(DELTA)','');
 CR:='Linearly interpolated (log2(ABS(MU)),log2(DELTA)) - graph at t=';
 CR:=CR+CHCR(T)+' <4.0 weak>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX5X1X5 }