{ Confidence intervals for the errors V g(Y(T)) - E g(X(T)) for the extra-  }
{ polation proposed by Talay and Tubaro  w.r.t. a given function g(.), also }
{ plotting the (log2,log2) - graph for the absolute values of these errors  }
{ Considers the stochastic differential equation                            }
{     dX(t) = A(t,X(t)) dt + B(t,X(t)) dW(t)        with X(T0) = X0         }
{  on the time interval [T0,T] where W(t) is a Wiener process               }
{ Extrapolation of X(t) by the Euler scheme with different step sizes DELTA }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the mean errors at the     }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch numbers remember that the corresponding per- }
{        centage points should also be changed.                             }

PROGRAM PRX5X2X4; { PC-Exercise 15.3.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                }
 T0=0.0;         { initial time                                       }
 T=1.0;          { final time                                         }
 DELTA=(T-T0)/8; { largest time step size of the Euler approximations }
 X0=0.1;         { initial value                                      }
 ALPHA=1.5;      { parameter in the function A(t,x)                   }
 BETA=0.01;      { parameter in the function B(t,x)                   }
 M=20;           { number of batches                                  }
 N=100;          { batch size                                         }
 QUANTILE=1.73;  { percentage point of the t-distribution             }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                      }
 G:INTEGER;             { index of the time step size used                 }
 I:INTEGER;             { time step index                                  }
 J:INTEGER;             { batch index                                      }
 K:INTEGER;             { sample index within the current batch            }
 TI:REAL;               { subinterval point                                }
 DELTA_Y:REAL;          { time step size of the extrapolation              }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y        }
 G1,G2:REAL;            { Gaussian random numbers                          }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)      }
 DW2TI:REAL;            { sum of neighboured Wiener process increments     }
 EGXT:REAL;             { value of  E g(X(t)) at t = T                     }
 YT:REAL;               { value of the Euler approximation using DELTA_Y   }
 Y2T:REAL;              { value of the Euler approximation using 2 DELTA_Y }
 AVERAGE,VARIANCE:REAL; { statistical parameters                           }
 ERRV:VECTOR0;          { mean errors of the extrapolations for the batch  }
 EGYT,EGY2T:VECTOR0;    { estimated mean values E g(Y(T)) within a batch   }
 DEL:VECTOR1;           { time step sizes                                  }
 DIFFER:VECTOR1;        { half of the confidence interval lengths          }
 MU:VECTOR1;            { mean errors for different time step sizes        }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=BETA*XI;
END;{ B }

{ Generates the exact mean value of the function g(X(t)) }

FUNCTION MEANGXT(TI:REAL):REAL;
BEGIN
 MEANGXT:=X0*EXP(ALPHA*(TI-T0)); { first moment of g(X(t)) }
END;{ MEANGXT }

{ Generates the functional form of g(.) }

FUNCTION GXT(X:REAL):REAL;
BEGIN
 GXT:=X; { compares the first moments }
END;{ GXT }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 5.2.4 (PC-Exercise 15.3.1)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the mean errors MU }
{ for different time step sizes :                               }

 EGXT:=MEANGXT(T); { calculates E g(X(T)) }
 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;        { batch index                               }
   EGYT[J]:=0.0;  { estimate of E g(Y(T)) for the batch used  }
   EGY2T[J]:=0.0; { estimate of E g(Y2(T)) for the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1; { index of the trajectory used }

   { Generation of the weak approximation Y(T) and          }
   { Estimation of the mean error MU of the extrapolation : }

    I:=0;
    TI:=T0;  { initial time                                           }
    YT:=X0;  { initial value of the Euler approximation for DELTA_Y   }
    Y2T:=X0; { initial value of the Euler approximation for 2 DELTA_Y }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE BEGIN DW2TI:=DWTI;G1:=G2; END;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }

     { Euler scheme for DELTA_Y : }

      YT:=YT+A(TI-DELTA_Y,YT)*DELTA_Y+B(TI-DELTA_Y,YT)*DWTI;

     { Euler scheme for 2 * DELTA_Y : }

      IF I MOD 2 = 0 THEN
       BEGIN
        DW2TI:=DW2TI+DWTI; { corresponding Wiener process increment }
        Y2T:=Y2T+2.*A(TI-2.*DELTA_Y,Y2T)*DELTA_Y+B(TI-2.*DELTA_Y,Y2T)*DW2TI;
       END;

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    EGYT[J]:=EGYT[J]+GXT(YT);
    EGY2T[J]:=EGY2T[J]+GXT(Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EGYT[J]:=EGYT[J]/N; { estimate of E g(Y(T)) for the batch }
   EGY2T[J]:=EGY2T[J]/N; { estimate of E g(Y2(T)) for the batch }
   ERRV[J]:=2.*EGYT[J]-EGY2T[J]-EGXT; { error of the extrapolation }
  UNTIL J=M;{ REPEAT for different batches }

 { Calculation of the confidence intervals and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,ERRV,AVERAGE,VARIANCE);
  MU[G]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the results : }

 CLEARDEVICE;
 CONFINV(NUM,MU,DIFFER,DEL,'MU','DELTA');
 CR:='90% Confidence intervals for the mean error MU(2.0 weak Extrapolation,';
 CR:=CR+'t='+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 FOR G:=1 TO NUM DO MU[G]:=ABS(MU[G]); { plotting requires positive data }
 GRAPH313(NUM,MU,DEL,'log2(ABS(MU))','log2(DELTA)','');
 CR:='Linearly interpolated (log2(ABS(MU)),log2(DELTA))-graph at t=';
 CR:=CR+CHCR(T)+' <2.0 Extrap.>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX5X2X4 }