{ Simulation studies with a nonlinear stochastic differential equation      }
{ Calculation of confidence intervals for the errors E ( g(Y(T) - g(X(T)) ) }
{ Comparison of the efficiency between selected schemes : Simplified Euler, }
{ explicit order 2.0 weak, order 2.0 weak extrapolation using simplified    }
{ Euler, derivative-free order 2.0 weak predictor-corrector and order 3.0   }
{ weak extrapolation using simplified order 2.0 weak Taylor schemes which   }
{ are implemented with the use of the special equation structure at time t=T}
{ Considers the nonlinear stochastic differential equation                  }
{ dX(t)=-(sin(2*X(t))+0.25*sin(4*X(t)))dt+sqrt(2)*cos(X(t))*cos(X(t))dW(t)  }
{ with  X(T0)=X0 on the time interval [T0,T] where W(t) is a Wiener process }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the mean errors at the     }
{ time T using M batches (M=20) with the sample size N (see printout!)      }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Plots the log2 of the elapsed time against - log2 of these errors         }
{ Plots the log2 of the elapsed time against the log2 of the step sizes     }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }
{        For the measurement of the necessary time take the sample size     }
{        large enough. Confidence intervals can be plotted by calling the   }
{        routine CONFINV. See program insertions at the end of this file.   }
{        If confidence intervals too small then coloured numbers only are   }
{        visible. Data can be selected by choosing from MU, DIFFER and DEL. }
{        If changing T, EXT, GXT or MEANGXT take into account their func-   }
{        tional dependence each another.                                    }

PROGRAM PRX5X4X6;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,EXTGRAPH;

CONST
 NUM=5;          { number of different time step sizes                 }
 T0=0.0;         { initial time                                        }
 T=16;           { final time                                          }
 DELTA=(T-T0)/8; { largest time step size of the weak approximations   }
 X0=1.0;         { initial value                                       }
 EXT=0.0000001149149961; { expectation of g(X(t)) = X(t) at time t = T }
 M=100;          { number of batches                                   }
 N=100;          { batch size                                          }
 QUANTILE=1.66;  { percentage point of the t-distribution              }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 TIME:STRING;           { elapsed total computational time in seconds       }
 HOUR,MINUTE,SECOND,SEC100:WORD; { help time values                         }
 THOUR,TMINUTE,TSECOND,TSEC100:WORD; { help time values                     }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 RTIME:REAL;            { elapsed time converted in a REAL type             }
 SQRT2:REAL;            { square root of 2.0                                }
 SQRT3:REAL;            { square root of 3.0                                }
 TI:REAL;               { right subinterval point                           }
 DELTA_Y:REAL;          { time step size of the weak approximations         }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 SQ2DELTA_Y:REAL;       { square root of the time step size 2*DELTA_Y       }
 A,AA,B,BB,PHI,RM,RP,YM,YQ,YP:REAL; { help values for scheme evaluation     }
 COS2,COS4,SIN2,SIN4,L0A,L0B,L1A,L1B:REAL; { help values for extrapolation  }
 U:REAL;                { three-point distributed random number             }
 DWTI:REAL;             { increment  W(t(i+1)) - W(ti)                      }
 EGXT:REAL;             { value of  E g(X(t)) at t = T                      }
 YT:REAL;               { value of the weak approximation using DELTA_Y     }
 Y2T:REAL;              { value of the weak approximation using 2*DELTA_Y   }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 MUYLON:VECTOR0;        { sum of the mean errors within a batch             }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 MU:VECTOR1;            { mean errors for different time step sizes         }
 INVAMU:VECTOR1;        { inverted absolute mean errors MU                  }
 TIMER:VECTOR1;         { time elapsed by the generation                    }

{ Generates the exact mean value of the function g(X(t)) }

FUNCTION MEANGXT(TI:REAL):REAL;
BEGIN
 MEANGXT:=EXT; { first moment of g(X(t)) at t=T }
END;{ MEANGXT }

{ Generates the functional form of g(.) }

FUNCTION GXT(X:REAL):REAL;
BEGIN
 GXT:=X; { compares the first moments }
END;{ GXT }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Takes the elapsed time in seconds for run times not exceeding one day }
{ Assumes GETTIME(HOUR,MINUTE,SECOND,SEC100) has been called before     }
{ Output time as a string TIME and as a real number RTIME               }

PROCEDURE TIMEINSEC(VAR TIME:STRING;VAR RTIME:REAL);
VAR
 ABSSEC,ABSSEC100,OLDHOUR,OLDMINUTE,OLDSEC100,OLDSECOND:WORD;
 CR:STRING;
BEGIN
 OLDHOUR:=HOUR;OLDMINUTE:=MINUTE;OLDSECOND:=SECOND;OLDSEC100:=SEC100;
 GETTIME(HOUR,MINUTE,SECOND,SEC100);
 IF SEC100<OLDSEC100 THEN
   BEGIN OLDSECOND:=OLDSECOND+1;ABSSEC100:=100-OLDSEC100+SEC100; END
  ELSE ABSSEC100:=SEC100-OLDSEC100;
 IF SECOND<OLDSECOND THEN
   BEGIN OLDMINUTE:=OLDMINUTE+1;ABSSEC:=60-OLDSECOND+SECOND; END
  ELSE ABSSEC:=SECOND-OLDSECOND;
 IF MINUTE<OLDMINUTE THEN
   BEGIN OLDHOUR:=OLDHOUR+1;ABSSEC:=ABSSEC+60*(60-OLDMINUTE+MINUTE); END
  ELSE ABSSEC:=ABSSEC+60*(MINUTE-OLDMINUTE);
 IF HOUR<OLDHOUR THEN ABSSEC:=ABSSEC+3600*(24-OLDHOUR+HOUR)
  ELSE ABSSEC:=ABSSEC+3600*(HOUR-OLDHOUR);
 STR(ABSSEC,CR);TIME:=CR+'.';STR(ABSSEC100,CR);
 IF ((LENGTH(CR)=1) AND (CR<>'0')) THEN CR:='0'+CR;
 TIME:=TIME+CR;
 RTIME:=ABSSEC+ABSSEC100/100;
END;{ TIMEINSEC }

{ Provides echo signals on the screen that parameters have been installed }
{ and schemes are in progress or schemes have just finished               }
{ Input NN determining the output line and scheme number                  }

PROCEDURE ECHO(NN:INTEGER;SCHEMETITLE:STRING);
VAR POS1,POS2,POS3,POS4,THM:INTEGER;
BEGIN
 THM:=TEXTHEIGHT('M');
 POS1:=TRUNC(MAXX/2);POS2:=3*(NN+5)*THM;POS3:=11*THM;POS4:=13*THM;
 CASE NN OF
  -4..-2   : OUTTEXTXY(POS1,POS2,SCHEMETITLE);
    -1     : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... in progress');
   1..10   : BEGIN
              SETFILLSTYLE(0,0);BAR(1,POS3,MAXX-1,POS4);SETFILLSTYLE(0,1);
              OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... done');
             END;
   11,12   : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... installed')
 END;
END;{ ECHO }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 CR:='Problem 5.4.6 (Efficiency comparison between selected weak schemes)';
 MAINWINDOW(CR);
 STATUSLINE('Be patient! This will take the computer some time!');
 CR:='dX(t)=-(sin(2*X(t))+0.25*sin(4*X(t)))dt+sqrt(2)*cos(X(t))*cos(X(t))dW(t)';
 ECHO(-4,CR); { delivers an echo signal to the screen for equation implemented }
 CR:='<Parameters> : M='+CHCR(M)+'/N='+CHCR(N)+'/T=';
 CR:=CR+CHCR(T)+'/X(0)='+CHCR(X0);
 ECHO(11,CR); { delivers an echo signal to the screen on parameters used }
 ECHO(12,'Number of different time step sizes used : '+CHCR(NUM));

 SQRT2:=SQRT(2.0);
 SQRT3:=SQRT(3.0);
 EGXT:=MEANGXT(16); { calculates E g(X(T=16)) }

{ Estimation of the confidence intervals for the mean errors MU }
{ for different time step sizes and weak approximations :       }

{ Simplified Euler approximation : }

 CR:='Simplified Euler';
 ECHO(-1,CR); { displays the scheme being implemented }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                         }
   MUYLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }

   { Generation of the simplified Euler approximation and its mean error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }

     { Generation of the simplified random increments W(.)(t(i+1)) - W(.)(ti) }

      GENER01(0.5,SQDELTA_Y,-SQDELTA_Y,DWTI);

     { Simplified Euler scheme : }

      B:=COS(YT);B:=SQRT2*B*B;A:=-SIN(2.*YT)-0.25*SIN(4.*YT);
      YT:=YT+A*DELTA_Y+B*DWTI;

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    MUYLON[J]:=MUYLON[J]+GXT(YT);

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N-EGXT; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVAMU[G]:=1./ABS(AVERAGE); { inverted absolute mean error MU }
  TIMEINSEC(TIME,RTIME);
  TIMER[G]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { calculates the total computational time elapsed }
 CR:='<1>  Simplified Euler in '+TIME+' seconds';
 ECHO(1,CR); { delivers an echo signal to the screen scheme ... done }

{ Explicit order 2.0 weak approximation : }

 CR:='Explicit order 2.0 weak';
 ECHO(-1,CR); { displays the scheme being implemented }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                         }
   MUYLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }

   { Generation of the order 2.0 weak approximation and its mean error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      U:=RANDOM;      { generation of the three point distributed U }
      IF U>1./3. THEN U:=0.0 ELSE
       IF U>1./6. THEN U:=-1.0 ELSE U:=+1.0;
      DWTI:=U*SQDELTA_Y*SQRT3;{ simplified increment  W(t(i+1)) - W(ti) }

     { Explicit order 2.0 weak scheme : }

      A:=-SIN(2.*YT)-0.25*SIN(4.*YT);B:=COS(YT);B:=SQRT2*B*B;
      YQ:=YT+A*DELTA_Y;RM:=YQ-B*SQDELTA_Y;RP:=YQ+B*SQDELTA_Y;YQ:=YQ+B*DWTI;
      A:=0.5*(A-SIN(2.*YQ)-0.25*SIN(4.*YQ));
      AA:=COS(RP);AA:=AA*AA;BB:=COS(RM);BB:=BB*BB;
      B:=0.25*SQRT2*(AA+BB+SQRT2*B);BB:=0.25*SQRT2*(AA-BB);
      YT:=YT+A*DELTA_Y+B*DWTI+0.25*BB*(DWTI*DWTI-DELTA_Y);

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    MUYLON[J]:=MUYLON[J]+GXT(YT);

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N-EGXT; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G+NUM]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G+NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVAMU[G+NUM]:=1./ABS(AVERAGE); { inverted absolute mean error MU }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { calculates the total computational time elapsed }
 CR:='<2>  Explicit order 2.0 weak in '+TIME+' seconds';
 ECHO(2,CR); { delivers an echo signal to the screen scheme ... done }

{ Order 2.0 weak extrapolation using simplified Euler approximation : }

 CR:='Order 2.0 weak extrapolation using simplified Euler';
 ECHO(-1,CR); { displays the scheme being implemented }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                      { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;          { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);    { square root of DELTA_Y           }
  SQ2DELTA_Y:=SQRT(2*DELTA_Y); { square root of 2*DELTA_Y         }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                         }
   MUYLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }

   { Generation of the order 2.0 weak extrapolation and its mean error : }

    I:=0;
    TI:=T0;  { initial time                                       }
    YT:=X0;  { initial value of the approximation using DELTA_Y   }
    Y2T:=X0; { initial value of the approximation using 2*DELTA_Y }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }

     { Generation of the simplified random increments W(.)(t(i+1)) - W(.)(ti) }

      GENER01(0.5,SQDELTA_Y,-SQDELTA_Y,DWTI);

     { Simplified Euler scheme for step size DELTA_Y : }

      B:=COS(YT);B:=SQRT2*B*B;A:=-SIN(2.*YT)-0.25*SIN(4.*YT);
      YT:=YT+A*DELTA_Y+B*DWTI;

     { Simplified Euler scheme for step size 2*DELTA_Y : }

      IF I MOD 2 = 0 THEN
       BEGIN
        GENER01(0.5,SQ2DELTA_Y,-SQ2DELTA_Y,DWTI);
        B:=COS(Y2T);B:=SQRT2*B*B;A:=-SIN(2.*Y2T)-0.25*SIN(4.*Y2T);
        Y2T:=Y2T+2.*A*DELTA_Y+B*DWTI;
       END;

     END;{ WHILE }

   { Summation of the functional values 2 g(Y(T)) - g(Y2(T)) : }

    MUYLON[J]:=MUYLON[J]+2*GXT(YT)-GXT(Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N-EGXT; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+2*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G+2*NUM]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G+2*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVAMU[G+2*NUM]:=1./ABS(AVERAGE); { inverted absolute mean error MU }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+2*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { calculates the total computational time elapsed }
 CR:='<3>  Order 2.0 weak extrapolation using Euler in ';
 CR:=CR+TIME+' seconds';
 ECHO(3,CR); { delivers an echo signal to the screen scheme ... done }

{ Derivative-free order 2.0 weak predictor-corrector approximation : }

 CR:='Derivative-free order 2.0 weak predictor-corrector';
 ECHO(-1,CR); { displays the scheme being implemented }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                         }
   MUYLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }

   { Generation of the order 2.0 weak approximation and its mean error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      U:=RANDOM;      { generation of the three point distributed U }
      IF U>1./3. THEN U:=0.0 ELSE
       IF U>1./6. THEN U:=-1.0 ELSE U:=+1.0;
      DWTI:=U*SQDELTA_Y*SQRT3;{ simplified increment  W(t(i+1)) - W(ti) }

     { Derivative-free order 2.0 weak predictor-corrector scheme : }

      A:=-SIN(2.*YT)-0.25*SIN(4.*YT);B:=COS(YT);B:=SQRT2*B*B;
      YQ:=YT+A*DELTA_Y;YP:=YQ+B*SQDELTA_Y;YM:=YQ-B*SQDELTA_Y;YQ:=YQ+B*DWTI;
      AA:=COS(YP);AA:=AA*AA;BB:=COS(YM);BB:=BB*BB;
      PHI:=0.25*SQRT2*((AA+BB+SQRT2*B)*DWTI
                       +(AA-BB)*(DWTI*DWTI-DELTA_Y)/SQDELTA_Y);
      AA:=-SIN(2.*YQ)-0.25*SIN(4.*YQ);
      YQ:=YT+0.5*(AA+A)*DELTA_Y+PHI; { predictor }
      AA:=-SIN(2.*YQ)-0.25*SIN(4.*YQ);
      YT:=YT+0.5*(AA+A)*DELTA_Y+PHI; { corrector }

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    MUYLON[J]:=MUYLON[J]+GXT(YT);

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N-EGXT; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+3*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G+3*NUM]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G+3*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVAMU[G+3*NUM]:=1./ABS(AVERAGE); { inverted absolute mean error MU }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+3*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { calculates the total computational time elapsed }
 CR:='<4>  Derivative-free order 2.0 weak pred.-corr. in ';
 CR:=CR+TIME+' seconds';
 ECHO(4,CR); { delivers an echo signal to the screen scheme ... done }

{ Order 3.0 weak extrapolation based on order 2.0 Taylor approximation : }

 CR:='Order 3.0 weak extrapolation using simplified 2.0 Taylor';
 ECHO(-1,CR); { displays the scheme being implemented }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                      { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;          { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y);    { square root of DELTA_Y           }
  SQ2DELTA_Y:=SQRT2*SQDELTA_Y; { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                         }
   MUYLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }

   { Generation of the order 3.0 weak extrapolation and its mean error : }

    I:=0;
    TI:=T0;  { initial time                                       }
    YT:=X0;  { initial value of the approximation using DELTA_Y   }
    Y2T:=X0; { initial value of the approximation using 2*DELTA_Y }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      U:=RANDOM;      { generation of the three point distributed U }
      IF U>1./3. THEN U:=0.0 ELSE
       IF U>1./6. THEN U:=-1.0 ELSE U:=+1.0;
      DWTI:=U*SQDELTA_Y*SQRT3;{ simplified increment  W(t(i+1)) - W(ti) }

     { Order 2.0 weak Taylor scheme for time step size DELTA_Y : }

      AA:=SIN(YT);BB:=COS(YT);
      SIN2:=2.*AA*BB;COS2:=BB*BB-AA*AA;
      SIN4:=2.*SIN2*COS2;COS4:=COS2*COS2-SIN2*SIN2;
      A:=-SIN2-0.25*SIN4;B:=SQRT2*BB*BB;
      L0A:=-A*(2.*COS2+COS4)+4.*BB*BB*BB*BB*(SIN2+SIN4);
      L0B:=-SQRT2*SIN2*(A+BB*BB*BB*BB);
      L1A:=-B*(2.*COS2+COS4);L1B:=-SQRT2*SIN2*B;
      YT:=YT+A*DELTA_Y+B*DWTI+0.5*L0A*DELTA_Y*DELTA_Y
            +0.5*(L0B+L1A)*DWTI*DELTA_Y+0.5*L1B*(DWTI*DWTI-DELTA_Y);

      IF I MOD 2 = 0 THEN
       BEGIN { order 2.0 weak Taylor scheme for time step size 2*DELTA_Y }
        U:=RANDOM;      { generation of the three point distributed U }
        IF U>1./3. THEN U:=0.0 ELSE
        IF U>1./6. THEN U:=-1.0 ELSE U:=+1.0;
        DWTI:=U*SQ2DELTA_Y*SQRT3;{ simplified increment  W(t(i+1)) - W(ti) }
        AA:=SIN(Y2T);BB:=COS(Y2T);
        SIN2:=2.*AA*BB;COS2:=BB*BB-AA*AA;
        SIN4:=2.*SIN2*COS2;COS4:=COS2*COS2-SIN2*SIN2;
        A:=-SIN2-0.25*SIN4;B:=SQRT2*BB*BB;
        L0A:=-A*(2.*COS2+COS4)+4.*BB*BB*BB*BB*(SIN2+SIN4);
        L0B:=-SQRT2*SIN2*(A+BB*BB*BB*BB);
        L1A:=-B*(2.*COS2+COS4);L1B:=-SQRT2*SIN2*B;
        Y2T:=Y2T+2.*A*DELTA_Y+B*DWTI+2.0*L0A*DELTA_Y*DELTA_Y
              +(L0B+L1A)*DWTI*DELTA_Y+L1B*(0.5*DWTI*DWTI-DELTA_Y);
       END;

     END;{ WHILE }

   { Summation of the functional values ( 4 * g(Y(T)) - g(Y2(T)) ) / 3 : }

    MUYLON[J]:=MUYLON[J]+(4.*GXT(YT)-GXT(Y2T))/3;

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N-EGXT; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+4*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G+4*NUM]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G+4*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVAMU[G+4*NUM]:=1./ABS(AVERAGE); { inverted absolute mean error MU }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+4*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { calculates the total computational time elapsed }
 CR:='<5>  Order 3.0 weak extrapolation using 2.0 Taylor in '+TIME+' seconds';
 ECHO(5,CR); { delivers an echo signal to the screen scheme ... done }
 STATUSLINE('Ready. Press any key except <ESC> !');
 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the confidence intervals : }
{ Note: If confidence intervals too small then colored numbers only are   }
{       visible! Data can be selected by choosing from MU, DIFFER and DEL }

 CLEARDEVICE;
 CONFINV(5,NUM,MU,DIFFER,DEL,'MU','DELTA'); { for the first four schemes }
 CR:='90% Confidence intervals for the mean error MU(t=';
 CR:=CR+CHCR(T)+')'+' <Weak schemes>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the error graphs in the logarithmic graphic table : }

 CLEARDEVICE;
 FOR G:=1 TO 5*NUM DO MU[G]:=ABS(MU[G]); { plotting requires positive data }
 GRAPH441(5,NUM,MU,DEL,'log2(|MU|)','log2(DELTA)');
 CR:='Linearly interpolated (log2(|MU|),log2(DELTA)) - graph at t=';
 CR:=CR+CHCR(T)+' <Weak>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the logarithmic graphic table for the efficiency comparison : }

 CLEARDEVICE;
 GRAPH441(5,NUM,TIMER,INVAMU,'log2(TIME)','-log2(|MU|)');
 CR:='Linearly interpolated (-log2(|MU|),log2(TIME)) - graph at t=';
 CR:=CR+CHCR(T)+' <Weak>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the time consumption in the logarithmic graphic table : }

 CLEARDEVICE;
 GRAPH441(5,NUM,TIMER,DEL,'log2(TIME)','log2(DELTA)');
 CR:='Linearly interpolated (log2(TIME),log2(DELTA)) - graph at t=';
 CR:=CR+CHCR(T)+' <Weak>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX5X4X6 }

{ If desired
    choose the corresponding confidence intervals from MU, DIFFER and DEL
   and include EXTGRAPH in the unit declaration and the following in the main
    program before the logarithmic error graphs are plotted :

  Printout of the confidence intervals :

 CLEARDEVICE;
 CONFINV(5,NUM,MU,DIFFER,DEL,'MU','DELTA'); { for five schemes at NUM points }
 CR:='90% Confidence intervals for the mean error MU(t=';
 CR:=CR+CHCR(T)+')'+' <Weak schemes>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }
}