{ Estimation of probabilities that X(T) lies in the interval [C1,C2] using  }
{ the direct Euler estimator                                                }
{ Considers the stochastic differential equation                            }
{     dX(t) = A(t,X(t)) dt + B(t,X(t)) dW(t)        with X(T0) = X0         }
{  on the time interval [T0,T] where W(t) is a Wiener process               }
{ Equidistant approximation Y(t) of X(t) by the Euler scheme with different }
{ time step sizes DELTA                                                     }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the estimates E ( g(Y(T) ) }
{ based on the Euler approximations at the time T using M batches (M=20)    }
{ with the sample size N = 200 (g(.) is the indicator function of [C1,C2])  }
{ Plots the confidence intervals for different time step sizes              }
{ Displays the set of the estimates for these probabilities                 }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch numbers remember that the corresponding per- }
{        centage points should also be changed.                             }

PROGRAM PRX5X5X2; { PC-Exercise 16.3.4 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes                }
 T0=0.0;         { initial time                                       }
 T=1.0;          { final time                                         }
 DELTA=(T-T0)/8; { largest time step size of the Euler approximations }
 X0=0.0;         { initial value                                      }
 C1=0.3;         { left interval endpoint                             }
 C2=0.4;         { right interval endpoint ( C1 < C2 )                }
 M=20;           { number of batches                                  }
 N=200;          { batch size                                         }
 QUANTILE=1.73;  { percentage point of the t-distribution             }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                    }
 G:INTEGER;             { index of the current time step size            }
 I:INTEGER;             { time step index                                }
 J:INTEGER;             { batch index                                    }
 K:INTEGER;             { sample index within the current batch          }
 TI:REAL;               { subinterval point                              }
 DELTA_Y:REAL;          { time step size of the Euler approximation      }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y      }
 G1,G2:REAL;            { Gaussian random numbers                        }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)    }
 EGXT:REAL;             { value of  E g(X(t)) at t = T                   }
 YT:REAL;               { value of the Euler approximation using DELTA_Y }
 AVERAGE,VARIANCE:REAL; { statistical parameters                         }
 MUYLON:VECTOR0;        { sum of the estimates within a batch            }
 DEL:VECTOR1;           { time step sizes                                }
 DIFFER:VECTOR1;        { half of the confidence interval lengths        }
 MU:VECTOR1;            { Euler estimates for different time step sizes  }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=0.5*(1.0-SIN(XI));
END;{ A }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=1.0;
END;{ B }

{ Generates the functional form of g(.) }

FUNCTION GXT(X:REAL):REAL;
BEGIN
 IF ((X<C1) OR (X>C2)) THEN GXT:=0.0
  ELSE GXT:=1.0; { provides the indicator function of the interval [C1,C2] }
END;{ GXT }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 5.5.2 (PC-Exercise 16.3.4)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for E(g(X(T))) }
{ for different time step sizes :                       }

 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                            }
   MUYLON[J]:=0.0; { sum of the estimates of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1; { index of the trajectory used }

   { Generation of the Euler approximation and its estimate MU : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }

     { Euler scheme : }

      YT:=YT+A(TI-DELTA_Y,YT)*DELTA_Y+B(TI-DELTA_Y,YT)*DWTI;

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    MUYLON[J]:=MUYLON[J]+GXT(YT);

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N; { estimate for the simulated batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the results : }

 CLEARDEVICE;
 CR:='Prob(X(T) in ['+CHCR(C1)+','+CHCR(C2)+'])';
 CONFINV(NUM,MU,DIFFER,DEL,CR,'DELTA');
 CR:='90% Confidence intervals for Prob(X(T) in ['+CHCR(C1)+',';
 CR:=CR+CHCR(C2)+']) (Direct Euler,T=';
 CR:=CR+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the midpoints of the confidence intervals : }

 CLEARDEVICE;SETTEXTJUSTIFY(0,1);
 G:=0;
 REPEAT
  G:=G+1;
  CR:='Delta = '+CHCR(DEL[G])+'   Prob(X(T) in ['+CHCR(C1)+','+CHCR(C2)+'])';
  CR:=CR+' = '+CHCR(MU[G])+' +/- '+CHCR(DIFFER[G]);
  OUTTEXTXY(10,TRUNC(MAXY/NUM)+3*G*TEXTHEIGHT('M'),CR);
 UNTIL G=NUM;
 CR:='Direct Euler estimates for the probability P(X(T) in ['+CHCR(C1)+',';
 CR:=CR+CHCR(C2)+']) at time T='+CHCR(T);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX5X5X2 }