{ This unit includes all procedures needed for the (A)utomatically }
{ data-(A)dapted (GRAPH)ic plot(S), e.g. for                       }
{ trajectories, logarithmic plots and confidence intervals.        }
{ Note : The graphic procedures are not appropriate to plot        }
{        constant functions.                                       }

UNIT AAGRAPHS;
INTERFACE
USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE;

TYPE
  VECTOR=ARRAY[0..NUMINV] OF REAL;
  VECTOR1=ARRAY[1..50] OF REAL;

{ plots a trajectory }

PROCEDURE GRAPH111(ORDINATE,ABSCISSA:VECTOR;CY,CX,C:STRING);

{ plots two trajectories in the same graphic table }

PROCEDURE GRAPH321(ORDINATE1,ORDINATE2,ABSCISSA:VECTOR;CY,CX,C1,C2:STRING);

{ plots confidence intervals }

PROCEDURE CONFINV(NUM:INTEGER;ORDINATE,DIFFER,ABSCISSA:VECTOR1;CY,CX:STRING);

{ plots a function in a (ld(eps),ld(delta)) - graphic table }

PROCEDURE GRAPH313(NUM:INTEGER;ORDINATE,ABSCISSA:VECTOR1;CY,CX,C:STRING);

{ plots two functions in the same (ld(eps),ld(delta)) - graphic table }

PROCEDURE GRAPH312(NUM:INTEGER;ORDINATE1,ORDINATE2,ABSCISSA:VECTOR1;
                   CY,CX,C1,C2:STRING);

IMPLEMENTATION

{ plots a trajectory }

PROCEDURE GRAPH111(ORDINATE,ABSCISSA:VECTOR;CY,CX,C:STRING);
 VAR IB,IC,ID,IE,IL:INTEGER;
     AXEX,AXEY:INTEGER;
     DISTX,DISTY:INTEGER;
     OLDORD,OLDABSC,NEWORD,NEWABSC:INTEGER;
     ORDMAX,ORDMIN,ABSCMAX,ABSCMIN:REAL;
     MAXDISTORD:REAL;
     MINDISTABSC:REAL;
     CL,CR:STRING;
 PROCEDURE EXTREMA;
  VAR IL:INTEGER;
      A,AA:REAL;
  BEGIN
   A:=ORDINATE[0];
   ORDMAX:=A;ORDMIN:=A;
   ABSCMAX:=ABSCISSA[0];
   ABSCMIN:=ABSCMAX;
   MINDISTABSC:=ABS(ABSCMIN-ABSCISSA[1]);
   FOR IL:=1 TO NUMINV DO
    BEGIN
     A:=ORDINATE[IL];
     AA:=ABSCISSA[IL];
     IF ORDMAX<A THEN ORDMAX:=A;
     IF ORDMIN>A THEN ORDMIN:=A;
     IF ABSCMAX<AA THEN ABSCMAX:=AA;
     IF ABSCMIN>AA THEN ABSCMIN:=AA;
     IF ABS(AA-ABSCISSA[IL-1])<MINDISTABSC THEN
      MINDISTABSC:=ABS(AA-ABSCISSA[IL-1]);
    END;
  END;
 FUNCTION ORDFUNC(A:REAL):INTEGER;
  VAR AU:REAL;
  BEGIN
   AU:=ORDMAX-ORDMIN;
   ORDFUNC:=AXEY-10-TRUNC((A-ORDMIN)*DISTY/AU+0.0000001);
  END;
 FUNCTION ABSCFUNC(O:REAL):INTEGER;
  VAR OU:REAL;
  BEGIN
   OU:=ABSCMAX-ABSCMIN;
   ABSCFUNC:=AXEX+10+TRUNC((O-ABSCMIN)*DISTX/OU+0.0000001);
  END;
 PROCEDURE SCALING;
  VAR IK,IL,I0,I3,K:INTEGER;
      I1,I2:LONGINT;
      OLD_ORDFUNC,OLD_ABSCFUNC:INTEGER;
      PARAHEIGHT:INTEGER;
      Uk,U0,U1,U2:REAL;
      CL,CR:STRING;
  BEGIN
   LINE(AXEX-5,AXEY,AXEX+DISTX+TRUNC(MAXX/20),AXEY);
   LINE(AXEX,AXEY+5,AXEX,AXEY-10-DISTY-2*IB);
   IK:=TRUNC((AXEY-10-DISTY-2*IB)/2);
   SETTEXTJUSTIFY(1,1);
   IF TEXTWIDTH(CY)<AXEX-4 THEN
     OUTTEXTXY(ID,IK,CY)
    ELSE
     OUTTEXTXY(5+TRUNC(TEXTWIDTH(CY)/2),IK,CY);
   SETTEXTJUSTIFY(1,0);
   IF TEXTWIDTH(CX)<IC-4 THEN
     OUTTEXTXY(TRUNC(19*MAXX/20),AXEY+3*(IB+3),CX)
    ELSE
     OUTTEXTXY(TRUNC(MAXX-5-TEXTWIDTH(CX)/2),AXEY+3*(IB+3),CX);
   SETTEXTJUSTIFY(1,2);
   OUTTEXTXY(AXEX,AXEY-10-DISTY-2*IB,'^');
   SETTEXTJUSTIFY(2,1);
   OUTTEXTXY(AXEX+10+DISTX+TRUNC(MAXX/20)-2,AXEY+1,'>');
   SETTEXTJUSTIFY(1,2);
   Uk:=ABSCMAX;
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   Uk:=ABSCMIN;
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   OLD_ABSCFUNC:=K;
   IK:=0;
   Uk:=(ABSCMAX-ABSCMIN)/16;
   WHILE Uk<MINDISTABSC DO Uk:=Uk*2;
   U0:=ABSCMIN+Uk;
   WHILE U0<ABSCMAX DO
    BEGIN
     K:=ABSCFUNC(U0);
     IF ((ABS(OLD_ABSCFUNC-K)>TEXTWIDTH(' 0.000 '))
         AND (ABS(ABSCFUNC(ABSCMAX)-K)>TEXTWIDTH(CHCR(ABSCMAX)))) THEN
       BEGIN
        OLD_ABSCFUNC:=K;
        LINE(K,AXEY-3,K,AXEY+3);
        CR:=CHCR(U0);
        IK:=IK+1;
        OUTTEXTXY(K,AXEY+7+(IK MOD 2)*8,CR);
       END;
      U0:=U0+Uk;
     END;
   SETTEXTJUSTIFY(1,1);
   U1:=ORDMAX;U2:=ORDMIN;
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   IF U1<0 THEN I1:=I1-1;
   IF ABS(I1-I2)>0 THEN
     BEGIN
      OLD_ORDFUNC:=0;
      IF I2<U2 THEN I2:=I2+1;
      IF ABS(I1-I2)<3 THEN
       BEGIN
        I3:=ORDFUNC(U1);
        IF ABS(ORDFUNC(I1)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U1);
          OUTTEXTXY(ID,I3,CL);
         END;
        I3:=ORDFUNC(U2);
        IF ABS(ORDFUNC(I2)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U2);
          OUTTEXTXY(ID,I3,CL);
         END;
       END;
      PARAHEIGHT:=1;
      WHILE (I1-I2)/PARAHEIGHT>20 DO PARAHEIGHT:=PARAHEIGHT*10;
      I1:=I1+PARAHEIGHT-(I1 MOD PARAHEIGHT);
      IF U1<0 THEN I1:=I1-PARAHEIGHT;
      REPEAT
       I1:=I1-PARAHEIGHT;
       I0:=ORDFUNC(I1);
       IF ABS(OLD_ORDFUNC-I0)>TEXTHEIGHT('M') THEN
        BEGIN
         LINE(AXEX-3,I0,AXEX+3,I0);
         STR(I1,CR);OUTTEXTXY(ID,I0,CR);
         OLD_ORDFUNC:=I0;
        END;
      UNTIL I1-PARAHEIGHT<I2;
     END
    ELSE
     BEGIN
      K:=ORDFUNC(U1);
      LINE(AXEX-3,K,AXEX+3,K);CL:=CHCR(U1);
      OUTTEXTXY(ID,K,CL);
      K:=ORDFUNC(U2);
      LINE(AXEX-3,K,AXEX+3,K);CR:=CHCR(U2);
      IF CL<>CR THEN OUTTEXTXY(ID,K,CR);
      IF ((ORDMAX>0) AND (ORDMIN<0) AND (CL<>'0') AND (CR<>'0')) THEN
       BEGIN
        K:=ORDFUNC(0.0);
        IF ((ABS(K-ORDFUNC(U1))>TEXTHEIGHT('M'))
            AND (ABS(K-ORDFUNC(U2))>TEXTHEIGHT('M'))) THEN
         BEGIN
          LINE(AXEX-3,K,AXEX+3,K);
          OUTTEXTXY(ID,K,'0.0');
         END;
       END;
     END;
  END;
 PROCEDURE MARKGRAPHIC(POS:INTEGER;C:STRING);
  VAR CR:STRING;
   PROCEDURE SHORTCR(VAR C:STRING);
   VAR CL:STRING;
   BEGIN
    IF LENGTH(C)>0 THEN
     BEGIN
      CL:=COPY(C,1,1);
      WHILE CL=' ' DO
       BEGIN
        C:=COPY(C,2,LENGTH(C)-1);
        IF LENGTH(C)>0 THEN CL:=COPY(C,1,1) ELSE CL:=C;
       END;
     END;
    IF LENGTH(C)>0 THEN
     BEGIN
      CL:=COPY(C,LENGTH(C),1);
      WHILE CL=' ' DO
       BEGIN
        C:=COPY(C,1,LENGTH(C)-1);
        IF LENGTH(C)>0 THEN CL:=COPY(C,LENGTH(C),1) ELSE CL:=C;
       END;
     END;
   END;
 BEGIN
  CR:=C;SHORTCR(CR);
  IF NEWABSC-AXEX>TEXTWIDTH(CR+'   ')+4 THEN
    BEGIN
     SETTEXTJUSTIFY(2,0);
     IF CR<>'' THEN CR:=CR+' ->';
     OUTTEXTXY(NEWABSC-3,POS,CR);
    END
   ELSE
    BEGIN
     SETTEXTJUSTIFY(0,0);
     IF CR<>'' THEN CR:='<- '+CR;
     OUTTEXTXY(NEWABSC+3,POS,CR);
    END;
 END;
BEGIN
  IB:=TEXTHEIGHT('M');
  IC:=TRUNC(MAXX/10);
  AXEX:=IC;
  IF AXEX<TEXTWIDTH(CHCR(+111.111222333444555666)) THEN
   AXEX:=2+TEXTWIDTH(CHCR(+111.111222333444555666));
  ID:=TRUNC(AXEX/2);
  AXEY:=MAXY-4*(IB+7)-TRUNC(MAXY/30);
  DISTX:=MAXX-10-AXEX-IC;DISTY:=AXEY-2*(IB+7)-10;
  EXTREMA;
  SETTEXTSTYLE(0,0,1);
  SCALING;
  SETCOLOR(MAXCOLOR);
  OLDORD:=ORDFUNC(ORDINATE[0]);
  OLDABSC:=ABSCFUNC(ABSCISSA[0]);
  IE:=0;MAXDISTORD:=OLDORD;
  FOR IL:=1 TO NUMINV DO
   BEGIN
    NEWORD:=ORDFUNC(ORDINATE[IL]);
    NEWABSC:=ABSCFUNC(ABSCISSA[IL]);
    LINE(OLDABSC,OLDORD,NEWABSC,NEWORD);
    OLDORD:=NEWORD;
    OLDABSC:=NEWABSC;
    IF MAXDISTORD<NEWORD THEN
     BEGIN
      IE:=IL;
      MAXDISTORD:=NEWORD;
     END;
   END;
  NEWABSC:=ABSCFUNC(ABSCISSA[IE]);
  NEWORD:=ORDFUNC(ORDINATE[IE]);
  MARKGRAPHIC(NEWORD,C);
END;{ end of GRAPH111 }

{ plots two trajectories in the same graphic table }

PROCEDURE GRAPH321(ORDINATE1,ORDINATE2,ABSCISSA:VECTOR;CY,CX,C1,C2:STRING);
 VAR IB,IC,ID,IE,IL:INTEGER;
     AXEX,AXEY:INTEGER;
     DISTX,DISTY:INTEGER;
     OLDORD1,OLDORD2,OLDABSC,NEWORD1,NEWORD2,NEWABSC:INTEGER;
     ORDMAX,ORDMIN,ABSCMAX,ABSCMIN:REAL;
     MAXDISTORD:REAL;
     MINDISTABSC:REAL;
     CL,CR:STRING;
 PROCEDURE EXTREMA;
  VAR IL:INTEGER;
      O1,O2,AA:REAL;
  BEGIN
   O1:=ORDINATE1[0];
   O2:=ORDINATE2[0];
   ORDMAX:=O1;ORDMIN:=O1;
   IF ORDMAX<O2 THEN ORDMAX:=O2 ELSE ORDMIN:=O2;
   ABSCMAX:=ABSCISSA[0];
   ABSCMIN:=ABSCMAX;
   MINDISTABSC:=ABS(ABSCMIN-ABSCISSA[1]);
   FOR IL:=1 TO NUMINV DO
    BEGIN
     O1:=ORDINATE1[IL];
     O2:=ORDINATE2[IL];
     AA:=ABSCISSA[IL];
     IF ORDMAX<O1 THEN ORDMAX:=O1;
     IF ORDMIN>O1 THEN ORDMIN:=O1;
     IF ORDMAX<O2 THEN ORDMAX:=O2;
     IF ORDMIN>O2 THEN ORDMIN:=O2;
     IF ABSCMAX<AA THEN ABSCMAX:=AA;
     IF ABSCMIN>AA THEN ABSCMIN:=AA;
     IF ABS(AA-ABSCISSA[IL-1])<MINDISTABSC THEN
      MINDISTABSC:=ABS(AA-ABSCISSA[IL-1]);
    END;
  END;
 FUNCTION ORDFUNC(A:REAL):INTEGER;
  VAR AU:REAL;
  BEGIN
   AU:=ORDMAX-ORDMIN;
   ORDFUNC:=AXEY-10-TRUNC((A-ORDMIN)*DISTY/AU+0.0000001);
  END;
 FUNCTION ABSCFUNC(O:REAL):INTEGER;
  VAR OU:REAL;
  BEGIN
   OU:=ABSCMAX-ABSCMIN;
   ABSCFUNC:=AXEX+10+TRUNC((O-ABSCMIN)*DISTX/OU+0.0000001);
  END;
 PROCEDURE SCALING;
  VAR IK,IL,I0,I3,K:INTEGER;
      I1,I2:LONGINT;
      OLD_ORDFUNC,OLD_ABSCFUNC:INTEGER;
      PARAHEIGHT:INTEGER;
      Uk,U0,U1,U2:REAL;
      CL,CR:STRING;
  BEGIN
   LINE(AXEX-5,AXEY,AXEX+DISTX+TRUNC(MAXX/20),AXEY);
   LINE(AXEX,AXEY+5,AXEX,AXEY-10-DISTY-2*IB);
   IK:=TRUNC((AXEY-10-DISTY-2*IB)/2);
   SETTEXTJUSTIFY(1,1);
   IF TEXTWIDTH(CY)<AXEX-4 THEN
     OUTTEXTXY(ID,IK,CY)
    ELSE
     OUTTEXTXY(5+TRUNC(TEXTWIDTH(CY)/2),IK,CY);
   SETTEXTJUSTIFY(1,0);
   IF TEXTWIDTH(CX)<IC-4 THEN
     OUTTEXTXY(TRUNC(19*MAXX/20),AXEY+3*(IB+3),CX)
    ELSE
     OUTTEXTXY(TRUNC(MAXX-5-TEXTWIDTH(CX)/2),AXEY+3*(IB+3),CX);
   SETTEXTJUSTIFY(1,2);
   OUTTEXTXY(AXEX,AXEY-10-DISTY-2*IB,'^');
   SETTEXTJUSTIFY(2,1);
   OUTTEXTXY(AXEX+10+DISTX+TRUNC(MAXX/20)-2,AXEY+1,'>');
   SETTEXTJUSTIFY(1,2);
   Uk:=ABSCMAX;
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   Uk:=ABSCMIN;
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   OLD_ABSCFUNC:=K;
   IK:=0;
   Uk:=(ABSCMAX-ABSCMIN)/16;
   WHILE Uk<MINDISTABSC DO Uk:=Uk*2;
   U0:=ABSCMIN+Uk;
   WHILE U0<ABSCMAX DO
    BEGIN
     K:=ABSCFUNC(U0);
     IF ((ABS(OLD_ABSCFUNC-K)>TEXTWIDTH(' 0.000 '))
         AND (ABS(ABSCFUNC(ABSCMAX)-K)>TEXTWIDTH(CHCR(ABSCMAX)))) THEN
       BEGIN
        OLD_ABSCFUNC:=K;
        LINE(K,AXEY-3,K,AXEY+3);
        CR:=CHCR(U0);
        IK:=IK+1;
        OUTTEXTXY(K,AXEY+7+(IK MOD 2)*8,CR);
       END;
      U0:=U0+Uk;
     END;
   SETTEXTJUSTIFY(1,1);
   U1:=ORDMAX;U2:=ORDMIN;
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   IF U1<0 THEN I1:=I1-1;
   IF ABS(I1-I2)>0 THEN
     BEGIN
      OLD_ORDFUNC:=0;
      IF I2<U2 THEN I2:=I2+1;
      IF ABS(I1-I2)<3 THEN
       BEGIN
        I3:=ORDFUNC(U1);
        IF ABS(ORDFUNC(I1)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U1);
          OUTTEXTXY(ID,I3,CL);
         END;
        I3:=ORDFUNC(U2);
        IF ABS(ORDFUNC(I2)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U2);
          OUTTEXTXY(ID,I3,CL);
         END;
       END;
      PARAHEIGHT:=1;
      WHILE (I1-I2)/PARAHEIGHT>20 DO PARAHEIGHT:=PARAHEIGHT*10;
      I1:=I1+PARAHEIGHT-(I1 MOD PARAHEIGHT);
      IF U1<0 THEN I1:=I1-PARAHEIGHT;
      REPEAT
       I1:=I1-PARAHEIGHT;
       I0:=ORDFUNC(I1);
       IF ABS(OLD_ORDFUNC-I0)>TEXTHEIGHT('M') THEN
        BEGIN
         LINE(AXEX-3,I0,AXEX+3,I0);
         STR(I1,CR);OUTTEXTXY(ID,I0,CR);
         OLD_ORDFUNC:=I0;
        END;
      UNTIL I1-PARAHEIGHT<I2;
     END
    ELSE
     BEGIN
      K:=ORDFUNC(U1);
      LINE(AXEX-3,K,AXEX+3,K);CL:=CHCR(U1);
      OUTTEXTXY(ID,K,CL);
      K:=ORDFUNC(U2);
      LINE(AXEX-3,K,AXEX+3,K);CR:=CHCR(U2);
      IF CL<>CR THEN OUTTEXTXY(ID,K,CR);
      IF ((ORDMAX>0) AND (ORDMIN<0) AND (CL<>'0') AND (CR<>'0')) THEN
       BEGIN
        K:=ORDFUNC(0.0);
        IF ((ABS(K-ORDFUNC(U1))>TEXTHEIGHT('M'))
            AND (ABS(K-ORDFUNC(U2))>TEXTHEIGHT('M'))) THEN
         BEGIN
          LINE(AXEX-3,K,AXEX+3,K);
          OUTTEXTXY(ID,K,'0.0');
         END;
       END;
     END;
  END;
 PROCEDURE MARKGRAPHIC(POSC1,POSC2:INTEGER;C1,C2:STRING);
  VAR CR:STRING;
   PROCEDURE SHORTCR(VAR C:STRING);
   VAR CL:STRING;
   BEGIN
    IF LENGTH(C)>0 THEN
     BEGIN
      CL:=COPY(C,1,1);
      WHILE CL=' ' DO
       BEGIN
        C:=COPY(C,2,LENGTH(C)-1);
        IF LENGTH(C)>0 THEN CL:=COPY(C,1,1) ELSE CL:=C;
       END;
     END;
    IF LENGTH(C)>0 THEN
     BEGIN
      CL:=COPY(C,LENGTH(C),1);
      WHILE CL=' ' DO
       BEGIN
        C:=COPY(C,1,LENGTH(C)-1);
        IF LENGTH(C)>0 THEN CL:=COPY(C,LENGTH(C),1) ELSE CL:=C;
       END;
     END;
   END;
 BEGIN
  CR:=C1;SHORTCR(CR);
  IF NEWABSC-AXEX>TEXTWIDTH(CR+'   ')+4 THEN
    BEGIN
     SETTEXTJUSTIFY(2,0);
     IF CR<>'' THEN CR:=CR+' ->';
     OUTTEXTXY(NEWABSC-3,POSC1,CR);
     CR:=C2;SHORTCR(CR);
     IF MAXX-NEWABSC>TEXTWIDTH('   '+CR)+4 THEN
       BEGIN
        SETTEXTJUSTIFY(0,2);
        IF CR<>'' THEN CR:='<- '+CR;
        OUTTEXTXY(NEWABSC+3,POSC2,CR);
       END
      ELSE
       BEGIN
        SETTEXTJUSTIFY(2,2);
        IF CR<>'' THEN CR:=CR+' ->';
        OUTTEXTXY(NEWABSC-3,POSC2,CR);
       END;
    END
   ELSE
    BEGIN
     SETTEXTJUSTIFY(0,0);
     IF CR<>'' THEN CR:='<- '+CR;
     OUTTEXTXY(NEWABSC+3,POSC1,CR);
     CR:=C2;SHORTCR(CR);
     IF NEWABSC-AXEX>TEXTWIDTH('   '+CR)+4 THEN
       BEGIN
        SETTEXTJUSTIFY(2,2);
        IF CR<>'' THEN CR:=CR+' ->';
        OUTTEXTXY(NEWABSC-3,POSC2,CR);
       END
      ELSE
       BEGIN
        SETTEXTJUSTIFY(0,2);
        IF CR<>'' THEN CR:='<- '+CR;
        OUTTEXTXY(NEWABSC+3,POSC2,CR);
       END;
    END;
 END;
BEGIN
  IB:=TEXTHEIGHT('M');
  IC:=TRUNC(MAXX/10);
  AXEX:=IC;
  IF AXEX<TEXTWIDTH(CHCR(+111.111222333444555666)) THEN
   AXEX:=2+TEXTWIDTH(CHCR(+111.111222333444555666));
  ID:=TRUNC(AXEX/2);
  AXEY:=MAXY-4*(IB+7)-TRUNC(MAXY/30);
  DISTX:=MAXX-10-AXEX-IC;DISTY:=AXEY-2*(IB+7)-10;
  EXTREMA;
  SETTEXTSTYLE(0,0,1);
  SCALING;
  SETCOLOR(MAXCOLOR);
  OLDORD1:=ORDFUNC(ORDINATE1[0]);
  OLDORD2:=ORDFUNC(ORDINATE2[0]);
  OLDABSC:=ABSCFUNC(ABSCISSA[0]);
  IE:=0;MAXDISTORD:=ABS(OLDORD1-OLDORD2);
  FOR IL:=1 TO NUMINV DO
   BEGIN
    NEWORD1:=ORDFUNC(ORDINATE1[IL]);
    NEWABSC:=ABSCFUNC(ABSCISSA[IL]);
    LINE(OLDABSC,OLDORD1,NEWABSC,NEWORD1);
    OLDORD1:=NEWORD1;
    NEWORD2:=ORDFUNC(ORDINATE2[IL]);
    LINE(OLDABSC,OLDORD2,NEWABSC,NEWORD2);
    OLDORD2:=NEWORD2;
    OLDABSC:=NEWABSC;
    IF MAXDISTORD<ABS(NEWORD1-NEWORD2) THEN
     BEGIN
      IE:=IL;
      MAXDISTORD:=ABS(NEWORD1-NEWORD2);
     END;
   END;
  NEWABSC:=ABSCFUNC(ABSCISSA[IE]);
  NEWORD1:=ORDFUNC(ORDINATE1[IE]);
  NEWORD2:=ORDFUNC(ORDINATE2[IE]);
  IF NEWORD1-NEWORD2<0 THEN
    MARKGRAPHIC(NEWORD1,NEWORD2,C1,C2)
   ELSE
    MARKGRAPHIC(NEWORD2,NEWORD1,C2,C1);
END;{ end of GRAPH321 }

{ plots confidence intervals }

PROCEDURE CONFINV(NUM:INTEGER;ORDINATE,DIFFER,ABSCISSA:VECTOR1;
                   CY,CX:STRING);
 VAR IB,IC,ID,IL:INTEGER;
     AXEX,AXEY:INTEGER;
     DISTX,DISTY:INTEGER;
     ORD1,ORD2,ABSC:INTEGER;
     ORDMAX,ORDMIN,ABSCMAX,ABSCMIN:REAL;
     MINDISTABSC:REAL;
     CR:STRING;
 PROCEDURE EXTREMA;
  VAR IL:INTEGER;
      A,B,AA:REAL;
  BEGIN
   A:=ORDINATE[1]+DIFFER[1];
   ORDMAX:=A;ORDMIN:=A-2*DIFFER[1];
   ABSCMAX:=ABSCISSA[1];
   ABSCMIN:=ABSCMAX;
   MINDISTABSC:=ABS(ABSCMIN-ABSCISSA[2]);
   FOR IL:=2 TO NUM DO
    BEGIN
     A:=ORDINATE[IL]+DIFFER[IL];
     B:=ORDINATE[IL]-DIFFER[IL];
     AA:=ABSCISSA[IL];
     IF ORDMAX<A THEN ORDMAX:=A;
     IF ORDMIN>B THEN ORDMIN:=B;
     IF ABSCMAX<AA THEN ABSCMAX:=AA;
     IF ABSCMIN>AA THEN ABSCMIN:=AA;
     IF ABS(AA-ABSCISSA[IL-1])<MINDISTABSC THEN
      MINDISTABSC:=ABS(AA-ABSCISSA[IL-1]);
    END;
  END;
 FUNCTION ORDFUNC(A:REAL):INTEGER;
  VAR AU:REAL;
  BEGIN
   AU:=ORDMAX-ORDMIN;
   ORDFUNC:=AXEY-10-TRUNC((A-ORDMIN)*DISTY/AU+0.0000001);
  END;
 FUNCTION ABSCFUNC(O:REAL):INTEGER;
  VAR OU:REAL;
  BEGIN
   OU:=ABSCMAX-ABSCMIN;
   ABSCFUNC:=AXEX+10+TRUNC((O-ABSCMIN)*DISTX/OU+0.0000001);
  END;
 PROCEDURE SCALING;
  VAR IK,IL,I0,I1,I2,I3,K:INTEGER;
      OLD_ORDFUNC,OLD_ABSCFUNC:INTEGER;
      PARAHEIGHT:INTEGER;
      Uk,U0,U1,U2:REAL;
      CL,CR:STRING;
  BEGIN
   LINE(AXEX-5,AXEY,AXEX+DISTX+TRUNC(MAXX/20),AXEY);
   LINE(AXEX,AXEY+5,AXEX,AXEY-10-DISTY-IB);
   IK:=TRUNC((AXEY-10-DISTY-IB)/2);
   SETTEXTJUSTIFY(1,2);
   IF TEXTWIDTH(CY)<AXEX-4 THEN
     OUTTEXTXY(ID,IK,CY)
    ELSE
     OUTTEXTXY(5+TRUNC(TEXTWIDTH(CY)/2),IK,CY);
   IF TEXTWIDTH(CX)<IC-4 THEN
     OUTTEXTXY(TRUNC(19*MAXX/20),AXEY+2*(IB+3),CX)
    ELSE
     OUTTEXTXY(TRUNC(MAXX-5-TEXTWIDTH(CX)/2),AXEY+2*(IB+3),CX);
   OUTTEXTXY(AXEX,AXEY-10-DISTY-IB,'^');
   SETTEXTJUSTIFY(2,1);
   OUTTEXTXY(AXEX+10+DISTX+TRUNC(MAXX/20)-2,AXEY+1,'>');
   SETTEXTJUSTIFY(1,2);
   Uk:=ABSCMAX;
   K:=ABSCFUNC(Uk);I1:=K;
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   OLD_ABSCFUNC:=K;I2:=K;
   Uk:=ABSCMIN;
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   IK:=0;
   IL:=0;
   REPEAT
    IL:=IL+1;
    U1:=ABSCISSA[IL];
    IF ((U1<>ABSCMAX) AND (U1<>ABSCMIN)) THEN
     BEGIN
      K:=ABSCFUNC(U1);
      IF ((ABS(OLD_ABSCFUNC-K)>TEXTWIDTH(' 0.000 '))
         AND (ABS(I1-K)>TEXTWIDTH(' 0.000 '))
         AND (ABS(I2-K)>TEXTWIDTH(' 0.000 '))
         AND (ABS(K-OLD_ABSCFUNC)>=MINDISTABSC)) THEN
       BEGIN
        LINE(K,AXEY-3,K,AXEY+3);IF NUM>4 THEN IK:=IK+1 ELSE IK:=1;
        CR:=CHCR(U1);OUTTEXTXY(K,AXEY+7+(IK MOD 2)*8,CR);
        OLD_ABSCFUNC:=K;
       END;
     END;
   UNTIL IL=NUM;
   SETTEXTJUSTIFY(1,1);
   U1:=ORDMAX;U2:=ORDMIN;
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   IF ((I1>I2) AND (U1<0)) THEN I1:=I1-1;
   IF ABS(I1-I2)>0 THEN
     BEGIN
      OLD_ORDFUNC:=0;
      IF I2<U2 THEN I2:=I2+1;
      IF ABS(I1-I2)<3 THEN
       BEGIN
        I3:=ORDFUNC(U1);
        IF ABS(ORDFUNC(I1)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U1);
          OUTTEXTXY(ID,I3,CL);
         END;
        I3:=ORDFUNC(U2);
        IF ABS(ORDFUNC(I2)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U2);
          OUTTEXTXY(ID,I3,CL);
         END;
       END;
      PARAHEIGHT:=1;
      WHILE (I1-I2)/PARAHEIGHT>20 DO PARAHEIGHT:=PARAHEIGHT*10;
      I1:=I1+PARAHEIGHT-(I1 MOD PARAHEIGHT);
      IF U1<0 THEN I1:=I1-PARAHEIGHT;
      REPEAT
       I1:=I1-PARAHEIGHT;
       I0:=ORDFUNC(I1);
       IF ABS(OLD_ORDFUNC-I0)>TEXTHEIGHT('M') THEN
        BEGIN
         LINE(AXEX-3,I0,AXEX+3,I0);
         STR(I1,CR);OUTTEXTXY(ID,I0,CR);
         OLD_ORDFUNC:=I0;
        END;
      UNTIL I1-PARAHEIGHT<I2;
     END
    ELSE
     BEGIN
      K:=ORDFUNC(U1);
      LINE(AXEX-3,K,AXEX+3,K);CL:=CHCR(U1);
      OUTTEXTXY(ID,K,CL);
      K:=ORDFUNC(U2);
      LINE(AXEX-3,K,AXEX+3,K);CR:=CHCR(U2);
      IF CL<>CR THEN OUTTEXTXY(ID,K,CR);
      IF ((ORDMAX>0) AND (ORDMIN<0) AND (CL<>'0') AND (CR<>'0'))
       THEN
        BEGIN
         K:=ORDFUNC(0.0);
         IF ((ABS(K-ORDFUNC(U1))>TEXTHEIGHT('M'))
             AND (ABS(K-ORDFUNC(U2))>TEXTHEIGHT('M'))) THEN
          BEGIN
           LINE(AXEX-3,K,AXEX+3,K);
           OUTTEXTXY(ID,K,'0.0');
          END;
        END;
     END;
  END;
BEGIN
  IB:=TEXTHEIGHT('M')+5;
  IC:=TRUNC(MAXX/10);
  AXEX:=IC;
  IF AXEX<TEXTWIDTH(CHCR(+111.111222333444555666)) THEN
   AXEX:=2+TEXTWIDTH(CHCR(+111.111222333444555666));
  ID:=TRUNC(AXEX/2);
  AXEY:=MAXY-4*(IB+5)-TRUNC(MAXY/30);
  DISTX:=MAXX-10-AXEX-IC;DISTY:=AXEY-10-2*(IB+5);
  EXTREMA;
  SETTEXTSTYLE(0,0,1);
  SCALING;
  SETCOLOR(MAXCOLOR);
  FOR IL:=1 TO NUM DO
   BEGIN
    ORD1:=ORDFUNC(ORDINATE[IL]+DIFFER[IL]);
    ORD2:=ORDFUNC(ORDINATE[IL]-DIFFER[IL]);
    ABSC:=ABSCFUNC(ABSCISSA[IL]);
    LINE(ABSC,ORD1,ABSC,ORD2);
    LINE(ABSC-3,ORD1,ABSC+3,ORD1);
    LINE(ABSC-3,ORD2,ABSC+3,ORD2);
   END;
END;{ end of CONFINV }

{ plots a function in a (ld(eps),ld(delta)) - graphic table }

PROCEDURE GRAPH313(NUM:INTEGER;ORDINATE,ABSCISSA:VECTOR1;CY,CX,C:STRING);
 VAR IB,IC,ID,IL:INTEGER;
     AXEX,AXEY:INTEGER;
     DISTX,DISTY:INTEGER;
     OLDORD,OLDABSC,NEWORD,NEWABSC:INTEGER;
     ORDMAX,ORDMIN,ABSCMAX,ABSCMIN:REAL;
     MINDISTABSC:REAL;
     LN2:REAL;
     CR:STRING;
 FUNCTION LD(Z:REAL):REAL;
 BEGIN
  LD:=LN(Z)/LN2;
 END;
 PROCEDURE EXTREMA;
  VAR IL:INTEGER;
      A,AA:REAL;
  BEGIN
   A:=ORDINATE[1];
   ORDMAX:=A;ORDMIN:=A;
   ABSCMAX:=ABSCISSA[1];
   ABSCMIN:=ABSCMAX;
   MINDISTABSC:=ABS(LD(ABSCMIN)-LD(ABSCISSA[2]));
   FOR IL:=2 TO NUM DO
    BEGIN
     A:=ORDINATE[IL];
     AA:=ABSCISSA[IL];
     IF ORDMAX<A THEN ORDMAX:=A;
     IF ORDMIN>A THEN ORDMIN:=A;
     IF ABSCMAX<AA THEN ABSCMAX:=AA;
     IF ABSCMIN>AA THEN ABSCMIN:=AA;
     IF ABS(LD(AA)-LD(ABSCISSA[IL-1]))<MINDISTABSC THEN
      MINDISTABSC:=ABS(LD(AA)-LD(ABSCISSA[IL-1]));
    END;
  END;
 FUNCTION ORDFUNC(A:REAL):INTEGER;
  VAR AU:REAL;
  BEGIN
   AU:=LD(ORDMAX)-LD(ORDMIN);
   ORDFUNC:=AXEY-10-TRUNC((A-LD(ORDMIN))*DISTY/AU+0.0000001);
  END;
 FUNCTION ABSCFUNC(O:REAL):INTEGER;
  VAR OU:REAL;
  BEGIN
   OU:=LD(ABSCMAX)-LD(ABSCMIN);
   ABSCFUNC:=AXEX+10+TRUNC((O-LD(ABSCMIN))*DISTX/OU+0.0000001);
  END;
 PROCEDURE SCALING;
  VAR IK,IL,I0,I1,I2,I3,K:INTEGER;
      OLD_ORDFUNC,OLD_ABSCFUNC:INTEGER;
      PARAHEIGHT:INTEGER;
      Uk,U0,U1,U2:REAL;
      CL,CR:STRING;
  BEGIN
   LINE(AXEX-5,AXEY,AXEX+DISTX+TRUNC(MAXX/20),AXEY);
   LINE(AXEX,AXEY+5,AXEX,AXEY-10-DISTY-IB);
   IK:=TRUNC((AXEY-10-DISTY-IB)/2);
   SETTEXTJUSTIFY(1,2);
   IF TEXTWIDTH(CY)<AXEX-4 THEN
     OUTTEXTXY(ID,IK,CY)
    ELSE
     OUTTEXTXY(5+TRUNC(TEXTWIDTH(CY)/2),IK,CY);
   IF TEXTWIDTH(CX)<IC-4 THEN
     OUTTEXTXY(TRUNC(19*MAXX/20),AXEY+2*(IB+3),CX)
    ELSE
     OUTTEXTXY(TRUNC(MAXX-5-TEXTWIDTH(CX)/2),AXEY+24,CX);
   OUTTEXTXY(AXEX,AXEY-10-DISTY-IB,'^');
   SETTEXTJUSTIFY(2,1);
   OUTTEXTXY(AXEX+10+DISTX+TRUNC(MAXX/20)-2,AXEY+1,'>');
   SETTEXTJUSTIFY(1,2);
   Uk:=LD(ABSCMAX);
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   OLD_ABSCFUNC:=K;
   Uk:=LD(ABSCMIN);
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   U1:=LD(ABSCMAX);U2:=LD(ABSCMIN);
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   I0:=I1+1;IK:=1;
   WHILE (I1-I2)/IK>19 DO IK:=IK*2;
   IF ABS(I1-I2)>1 THEN
     BEGIN
      I1:=I1+IK-(I1 MOD IK);
      REPEAT
       I1:=I1-IK;
       K:=ABSCFUNC(I1);
       IF ((ABS(OLD_ABSCFUNC-K)>TEXTWIDTH('000'))
           AND (ABS(ABSCFUNC(U2)-K)>TEXTWIDTH('000'))
           AND (ABS(I1-I0)>=MINDISTABSC)) THEN
        BEGIN
         LINE(K,AXEY-3,K,AXEY+3);
         STR(I1,CR);OUTTEXTXY(K,AXEY+10,CR);
         OLD_ABSCFUNC:=K;I0:=I1;
        END;
      UNTIL I1-IK<I2;
     END;
   SETTEXTJUSTIFY(1,1);
   U1:=LD(ORDMAX);U2:=LD(ORDMIN);
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   IF ABS(I1-I2)>0 THEN
     BEGIN
      OLD_ORDFUNC:=0;
      IF I2<U2 THEN I2:=I2+1;
      IF ABS(I1-I2)<3 THEN
       BEGIN
        I3:=ORDFUNC(U1);
        IF ABS(ORDFUNC(I1)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U1);
          OUTTEXTXY(ID,I3,CL);
         END;
        I3:=ORDFUNC(U2);
        IF ABS(ORDFUNC(I2)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U2);
          OUTTEXTXY(ID,I3,CL);
         END;
       END;
      PARAHEIGHT:=1;
      WHILE (I1-I2)/PARAHEIGHT>20 DO
       IF PARAHEIGHT=1 THEN PARAHEIGHT:=PARAHEIGHT*2 ELSE
        IF PARAHEIGHT=2 THEN PARAHEIGHT:=PARAHEIGHT*5 ELSE
         PARAHEIGHT:=PARAHEIGHT*10;
      I1:=I1+PARAHEIGHT-(I1 MOD PARAHEIGHT);
      IF U1<0 THEN I1:=I1-PARAHEIGHT;
      REPEAT
       I1:=I1-PARAHEIGHT;
       I0:=ORDFUNC(I1);
       IF ABS(OLD_ORDFUNC-I0)>TEXTHEIGHT('M') THEN
        BEGIN
         LINE(AXEX-3,I0,AXEX+3,I0);
         STR(I1,CR);OUTTEXTXY(ID,I0,CR);
         OLD_ORDFUNC:=I0;
        END;
      UNTIL I1-PARAHEIGHT<I2;
     END
    ELSE
     BEGIN
      K:=ORDFUNC(U1);
      LINE(AXEX-3,K,AXEX+3,K);CL:=CHCR(U1);
      OUTTEXTXY(ID,K,CL);
      K:=ORDFUNC(U2);
      LINE(AXEX-3,K,AXEX+3,K);CR:=CHCR(U2);
      IF CL<>CR THEN OUTTEXTXY(ID,K,CR);
      IF ((LD(ORDMAX)>0) AND (LD(ORDMIN)<0) AND (CL<>'0') AND (CR<>'0'))
       THEN
        BEGIN
         K:=ORDFUNC(0.0);
         IF ((ABS(K-ORDFUNC(U1))>TEXTHEIGHT('M'))
             AND (ABS(K-ORDFUNC(U2))>TEXTHEIGHT('M'))) THEN
          BEGIN
           LINE(AXEX-3,K,AXEX+3,K);
           OUTTEXTXY(ID,K,'0.0');
          END;
        END;
     END;
  END;
 PROCEDURE SHORTCR(VAR C:STRING);
 VAR CL:STRING;
 BEGIN
  IF LENGTH(C)>0 THEN
   BEGIN
    CL:=COPY(C,1,1);
    WHILE CL=' ' DO
     BEGIN
      C:=COPY(C,2,LENGTH(C)-1);
      IF LENGTH(C)>0 THEN CL:=COPY(C,1,1) ELSE CL:=C;
     END;
   END;
  IF LENGTH(C)>0 THEN
   BEGIN
    CL:=COPY(C,LENGTH(C),1);
    WHILE CL=' ' DO
     BEGIN
      C:=COPY(C,1,LENGTH(C)-1);
      IF LENGTH(C)>0 THEN CL:=COPY(C,LENGTH(C),1) ELSE CL:=C;
     END;
   END;
 END;
BEGIN
  IB:=TEXTHEIGHT('M');
  IC:=TRUNC(MAXX/10);
  AXEX:=IC;
  IF AXEX<TEXTWIDTH(CHCR(+111.111222333444555666)) THEN
   AXEX:=2+TEXTWIDTH(CHCR(+111.111222333444555666));
  ID:=TRUNC(AXEX/2);
  AXEY:=MAXY-4*(IB+5)-TRUNC(MAXY/30);
  DISTX:=MAXX-10-AXEX-IC;DISTY:=AXEY-10-2*(IB+5);
  LN2:=LN(2);
  EXTREMA;
  SETTEXTSTYLE(0,0,1);
  SCALING;
  SETCOLOR(MAXCOLOR);
  OLDORD:=ORDFUNC(LD(ORDINATE[1]));
  OLDABSC:=ABSCFUNC(LD(ABSCISSA[1]));
  LINE(OLDABSC,OLDORD-2,OLDABSC,OLDORD+2);
  FOR IL:=2 TO NUM DO
   BEGIN
    NEWORD:=ORDFUNC(LD(ORDINATE[IL]));
    NEWABSC:=ABSCFUNC(LD(ABSCISSA[IL]));
    LINE(OLDABSC,OLDORD,NEWABSC,NEWORD);
    LINE(NEWABSC,NEWORD-2,NEWABSC,NEWORD+2);
    OLDORD:=NEWORD;
    OLDABSC:=NEWABSC;
   END;
  NEWABSC:=ABSCFUNC(LD(ABSCISSA[2]));
  NEWORD:=ORDFUNC(LD(ORDINATE[2]));
  CR:=C;SHORTCR(CR);
  IF CR<>'' THEN
   IF NEWABSC-AXEX>TEXTWIDTH(CR+'   ')+4 THEN
     BEGIN
      SETTEXTJUSTIFY(2,0);
      CR:=CR+' ->';
      OUTTEXTXY(NEWABSC-3,NEWORD,CR);
     END
    ELSE
     BEGIN
      SETTEXTJUSTIFY(0,0);
      CR:='<- '+CR;
      OUTTEXTXY(NEWABSC+3,NEWORD,CR);
     END;
END;{ end of GRAPH313 }

{ plots two functions in the same (ld(eps),ld(delta)) - graphic table }

PROCEDURE GRAPH312(NUM:INTEGER;ORDINATE1,ORDINATE2,ABSCISSA:VECTOR1;
                   CY,CX,C1,C2:STRING);
 VAR IB,IC,ID,IL:INTEGER;
     AXEX,AXEY:INTEGER;
     DISTX,DISTY:INTEGER;
     XPOS1,XPOS2:INTEGER;
     OLDORD1,OLDORD2,OLDABSC,NEWORD1,NEWORD2,NEWABSC:INTEGER;
     ORDMAX,ORDMIN,ABSCMAX,ABSCMIN:REAL;
     MINDISTABSC:REAL;
     LN2:REAL;
     CR:STRING;
 FUNCTION LD(Z:REAL):REAL;
 BEGIN
  LD:=LN(Z)/LN2;
 END;
 PROCEDURE EXTREMA;
  VAR IL:INTEGER;
      O1,O2,AA:REAL;
  BEGIN
   O1:=ORDINATE1[1];
   O2:=ORDINATE2[1];
   ORDMAX:=O1;ORDMIN:=O1;
   IF ORDMAX<O2 THEN ORDMAX:=O2 ELSE ORDMIN:=O2;
   ABSCMAX:=ABSCISSA[1];
   ABSCMIN:=ABSCMAX;
   MINDISTABSC:=ABS(LD(ABSCMIN)-LD(ABSCISSA[2]));
   FOR IL:=2 TO NUM DO
    BEGIN
     O1:=ORDINATE1[IL];
     O2:=ORDINATE2[IL];
     AA:=ABSCISSA[IL];
     IF ORDMAX<O1 THEN ORDMAX:=O1;
     IF ORDMIN>O1 THEN ORDMIN:=O1;
     IF ORDMAX<O2 THEN ORDMAX:=O2;
     IF ORDMIN>O2 THEN ORDMIN:=O2;
     IF ABSCMAX<AA THEN ABSCMAX:=AA;
     IF ABSCMIN>AA THEN ABSCMIN:=AA;
     IF ABS(LD(AA)-LD(ABSCISSA[IL-1]))<MINDISTABSC THEN
      MINDISTABSC:=ABS(LD(AA)-LD(ABSCISSA[IL-1]));
    END;
  END;
 FUNCTION ORDFUNC(A:REAL):INTEGER;
  VAR AU:REAL;
  BEGIN
   AU:=LD(ORDMAX)-LD(ORDMIN);
   ORDFUNC:=AXEY-10-TRUNC((A-LD(ORDMIN))*DISTY/AU+0.0000001);
  END;
 FUNCTION ABSCFUNC(O:REAL):INTEGER;
  VAR OU:REAL;
  BEGIN
   OU:=LD(ABSCMAX)-LD(ABSCMIN);
   ABSCFUNC:=AXEX+10+TRUNC((O-LD(ABSCMIN))*DISTX/OU+0.0000001);
  END;
 PROCEDURE SCALING;
  VAR IK,IL,I0,I1,I2,I3,K:INTEGER;
      OLD_ORDFUNC,OLD_ABSCFUNC:INTEGER;
      PARAHEIGHT:INTEGER;
      Uk,U0,U1,U2:REAL;
      CL,CR:STRING;
  BEGIN
   LINE(AXEX-5,AXEY,AXEX+DISTX+TRUNC(MAXX/20),AXEY);
   LINE(AXEX,AXEY+5,AXEX,AXEY-10-DISTY-IB);
   IK:=TRUNC((AXEY-10-DISTY-IB)/2);
   SETTEXTJUSTIFY(1,2);
   IF TEXTWIDTH(CY)<AXEX-4 THEN
     OUTTEXTXY(ID,IK,CY)
    ELSE
     OUTTEXTXY(5+TRUNC(TEXTWIDTH(CY)/2),IK,CY);
   IF TEXTWIDTH(CX)<IC-4 THEN
     OUTTEXTXY(TRUNC(19*MAXX/20),AXEY+2*(IB+3),CX)
    ELSE
     OUTTEXTXY(TRUNC(MAXX-5-TEXTWIDTH(CX)/2),AXEY+2*(IB+3),CX);
   OUTTEXTXY(AXEX,AXEY-10-DISTY-IB,'^');
   SETTEXTJUSTIFY(2,1);
   OUTTEXTXY(AXEX+10+DISTX+TRUNC(MAXX/20)-2,AXEY+1,'>');
   SETTEXTJUSTIFY(1,2);
   Uk:=LD(ABSCMAX);
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   OLD_ABSCFUNC:=K;
   Uk:=LD(ABSCMIN);
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   U1:=LD(ABSCMAX);U2:=LD(ABSCMIN);
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   I0:=I1+1;IK:=1;
   WHILE (I1-I2)/IK>19 DO IK:=IK*2;
   IF ABS(I1-I2)>1 THEN
     BEGIN
      I1:=I1+IK-(I1 MOD IK);
      REPEAT
       I1:=I1-IK;
       K:=ABSCFUNC(I1);
       IF ((ABS(OLD_ABSCFUNC-K)>TEXTWIDTH('000'))
           AND (ABS(ABSCFUNC(U2)-K)>TEXTWIDTH('000'))
           AND (ABS(I1-I0)>=MINDISTABSC)) THEN
        BEGIN
         LINE(K,AXEY-3,K,AXEY+3);
         STR(I1,CR);OUTTEXTXY(K,AXEY+10,CR);
         OLD_ABSCFUNC:=K;I0:=I1;
        END;
      UNTIL I1-IK<I2;
     END;
   SETTEXTJUSTIFY(1,1);
   U1:=LD(ORDMAX);U2:=LD(ORDMIN);
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   IF ABS(I1-I2)>0 THEN
     BEGIN
      OLD_ORDFUNC:=0;
      IF I2<U2 THEN I2:=I2+1;
      IF ABS(I1-I2)<3 THEN
       BEGIN
        I3:=ORDFUNC(U1);
        IF ABS(ORDFUNC(I1)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U1);
          OUTTEXTXY(ID,I3,CL);
         END;
        I3:=ORDFUNC(U2);
        IF ABS(ORDFUNC(I2)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U2);
          OUTTEXTXY(ID,I3,CL);
         END;
       END;
      PARAHEIGHT:=1;
      WHILE (I1-I2)/PARAHEIGHT>20 DO
       IF PARAHEIGHT=1 THEN PARAHEIGHT:=PARAHEIGHT*2 ELSE
        IF PARAHEIGHT=2 THEN PARAHEIGHT:=PARAHEIGHT*5 ELSE
         PARAHEIGHT:=PARAHEIGHT*10;
      I1:=I1+PARAHEIGHT-(I1 MOD PARAHEIGHT);
      IF U1<0 THEN I1:=I1-PARAHEIGHT;
      REPEAT
       I1:=I1-PARAHEIGHT;
       I0:=ORDFUNC(I1);
       IF ABS(OLD_ORDFUNC-I0)>TEXTHEIGHT('M') THEN
        BEGIN
         LINE(AXEX-3,I0,AXEX+3,I0);
         STR(I1,CR);OUTTEXTXY(ID,I0,CR);
         OLD_ORDFUNC:=I0;
        END;
      UNTIL I1-PARAHEIGHT<I2;
     END
    ELSE
     BEGIN
      K:=ORDFUNC(U1);
      LINE(AXEX-3,K,AXEX+3,K);CL:=CHCR(U1);
      OUTTEXTXY(ID,K,CL);
      K:=ORDFUNC(U2);
      LINE(AXEX-3,K,AXEX+3,K);CR:=CHCR(U2);
      IF CL<>CR THEN OUTTEXTXY(ID,K,CR);
      IF ((LD(ORDMAX)>0) AND (LD(ORDMIN)<0) AND (CL<>'0') AND (CR<>'0'))
       THEN
        BEGIN
         K:=ORDFUNC(0.0);
         IF ((ABS(K-ORDFUNC(U1))>TEXTHEIGHT('M'))
             AND (ABS(K-ORDFUNC(U2))>TEXTHEIGHT('M'))) THEN
          BEGIN
           LINE(AXEX-3,K,AXEX+3,K);
           OUTTEXTXY(ID,K,'0.0');
          END;
        END;
     END;
  END;
 PROCEDURE MARKGRAPHIC(XPOSC1,YPOSC1,XPOSC2,YPOSC2:INTEGER;C1,C2:STRING);
  VAR CR:STRING;
   PROCEDURE SHORTCR(VAR C:STRING);
   VAR CL:STRING;
   BEGIN
    IF LENGTH(C)>0 THEN
     BEGIN
      CL:=COPY(C,1,1);
      WHILE CL=' ' DO
       BEGIN
        C:=COPY(C,2,LENGTH(C)-1);
        IF LENGTH(C)>0 THEN CL:=COPY(C,1,1) ELSE CL:=C;
       END;
     END;
    IF LENGTH(C)>0 THEN
     BEGIN
      CL:=COPY(C,LENGTH(C),1);
      WHILE CL=' ' DO
       BEGIN
        C:=COPY(C,1,LENGTH(C)-1);
        IF LENGTH(C)>0 THEN CL:=COPY(C,LENGTH(C),1) ELSE CL:=C;
       END;
     END;
   END;
 BEGIN
  CR:=C1;SHORTCR(CR);
  IF XPOSC1-AXEX>TEXTWIDTH(CR+'   ')+4 THEN
    BEGIN
     SETTEXTJUSTIFY(2,0);
     IF CR<>'' THEN CR:=CR+' ->';
     OUTTEXTXY(XPOSC1-3,YPOSC1,CR);
     CR:=C2;SHORTCR(CR);
     IF MAXX-XPOSC2>TEXTWIDTH('   '+CR)+4 THEN
       BEGIN
        SETTEXTJUSTIFY(0,2);
        IF CR<>'' THEN CR:='<- '+CR;
        OUTTEXTXY(XPOSC2+3,YPOSC2,CR);
       END
      ELSE
       BEGIN
        SETTEXTJUSTIFY(2,2);
        IF CR<>'' THEN CR:=CR+' ->';
        OUTTEXTXY(XPOSC2-3,YPOSC2,CR);
       END;
    END
   ELSE
    BEGIN
     SETTEXTJUSTIFY(0,0);
     IF CR<>'' THEN CR:='<- '+CR;
     OUTTEXTXY(XPOSC1+3,YPOSC1,CR);
     CR:=C2;SHORTCR(CR);
     IF XPOSC2-AXEX>TEXTWIDTH('   '+CR)+4 THEN
       BEGIN
        SETTEXTJUSTIFY(2,2);
        IF CR<>'' THEN CR:=CR+' ->';
        OUTTEXTXY(XPOSC2-3,YPOSC2,CR);
       END
      ELSE
       BEGIN
        SETTEXTJUSTIFY(0,2);
        IF CR<>'' THEN CR:='<- '+CR;
        OUTTEXTXY(XPOSC2+3,YPOSC2,CR);
       END;
    END;
 END;
BEGIN
  IB:=TEXTHEIGHT('M');
  IC:=TRUNC(MAXX/10);
  AXEX:=IC;
  IF AXEX<TEXTWIDTH(CHCR(+111.111222333444555666)) THEN
   AXEX:=2+TEXTWIDTH(CHCR(+111.111222333444555666));
  ID:=TRUNC(AXEX/2);
  AXEY:=MAXY-4*(IB+5)-TRUNC(MAXY/30);
  DISTX:=MAXX-10-AXEX-IC;DISTY:=AXEY-10-2*(IB+5);
  LN2:=LN(2);
  EXTREMA;
  SETTEXTSTYLE(0,0,1);
  SCALING;
  SETCOLOR(MAXCOLOR);
  OLDORD1:=ORDFUNC(LD(ORDINATE1[1]));
  OLDORD2:=ORDFUNC(LD(ORDINATE2[1]));
  OLDABSC:=ABSCFUNC(LD(ABSCISSA[1]));
  LINE(OLDABSC,OLDORD1-2,OLDABSC,OLDORD1+2);
  LINE(OLDABSC,OLDORD2-2,OLDABSC,OLDORD2+2);
  FOR IL:=2 TO NUM DO
   BEGIN
    NEWORD1:=ORDFUNC(LD(ORDINATE1[IL]));
    NEWABSC:=ABSCFUNC(LD(ABSCISSA[IL]));
    LINE(OLDABSC,OLDORD1,NEWABSC,NEWORD1);
    LINE(NEWABSC,NEWORD1-2,NEWABSC,NEWORD1+2);
    OLDORD1:=NEWORD1;
    NEWORD2:=ORDFUNC(LD(ORDINATE2[IL]));
    LINE(OLDABSC,OLDORD2,NEWABSC,NEWORD2);
    LINE(NEWABSC,NEWORD2-2,NEWABSC,NEWORD2+2);
    OLDORD2:=NEWORD2;
    OLDABSC:=NEWABSC;
   END;
  XPOS1:=ABSCFUNC(LD(ABSCISSA[2]));
  XPOS2:=ABSCFUNC(LD(ABSCISSA[NUM-1]));
  NEWORD1:=ORDFUNC(LD(ORDINATE1[2]));
  NEWORD2:=ORDFUNC(LD(ORDINATE2[2]));
  IF NEWORD1-NEWORD2<0 THEN
    BEGIN
     NEWORD2:=ORDFUNC(LD(ORDINATE2[NUM-1]));
     MARKGRAPHIC(XPOS1,NEWORD1,XPOS2,NEWORD2,C1,C2);
    END
   ELSE
    BEGIN
     NEWORD1:=ORDFUNC(LD(ORDINATE1[NUM-1]));
     MARKGRAPHIC(XPOS1,NEWORD2,XPOS2,NEWORD1,C2,C1);
    END;
END;{ end of GRAPH312 }

END.{ end of AAGRAPHS }