{ This unit includes all plot procedures needed in the simulation studies }
{ according to chapters 4.4 and 5.4.                                      }

UNIT EXTGRAPH;
INTERFACE
USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE;

TYPE
  VECTOR=ARRAY[0..NUMINV] OF REAL;
  VECTOR1=ARRAY[1..100] OF REAL;

{ Plots several functions in the same (ld(ABSCISSA),ld(ORDINATE)) - graphic }
{ table whereas ORDINATE and ABSCISSA are input data to be linearly inter-  }
{ polated in this logarithmic graphic table                                 }
{ N selects the number of desired graphs                                    }
{ NUM determines the number of points to be interpolated                    }

PROCEDURE GRAPH441(N,NUM:INTEGER;ORDINATE,ABSCISSA:VECTOR1;CY,CX:STRING);

{ Plots confidence intervals                                   }
{ NUM is the length of one segment = number of time step sizes }
{ G determines the number of segments = number of schemes      }

PROCEDURE CONFINV(G,NUM:INTEGER;ORDINATE,DIFFER,ABSCISSA:VECTOR1;CY,CX:STRING);

IMPLEMENTATION

{ Plots functions in a (ld(ABSCISSA),ld(ORDINATE)) - graphic table }

PROCEDURE GRAPH441(N,NUM:INTEGER;ORDINATE,ABSCISSA:VECTOR1;CY,CX:STRING);
 VAR IB,IC,ID,IL1,IL2:INTEGER;
     AXEX,AXEY:INTEGER;
     DISTX,DISTY:INTEGER;
     OLDORD,OLDABSC,NEWORD,NEWABSC:INTEGER;
     ORDMAX,ORDMIN,ABSCMAX,ABSCMIN:REAL;
     MINDISTABSC:REAL;
     LN2:REAL;
     GRAPHLABEL:INTEGER;
     CR:STRING;
 FUNCTION LD(Z:REAL):REAL;
 BEGIN
  LD:=LN(Z)/LN2;
 END;{ LD }
 PROCEDURE EXTREMA;
  VAR IL:INTEGER;
      A,AA:REAL;
  BEGIN
   A:=ORDINATE[1];
   ORDMAX:=A;ORDMIN:=A;
   ABSCMAX:=ABSCISSA[1];
   ABSCMIN:=ABSCMAX;
   MINDISTABSC:=ABS(LD(ABSCMIN)-LD(ABSCISSA[2]));
   FOR IL:=2 TO N*NUM DO
    BEGIN
     A:=ORDINATE[IL];
     AA:=ABSCISSA[IL];
     IF ORDMAX<A THEN ORDMAX:=A;
     IF ORDMIN>A THEN ORDMIN:=A;
     IF ABSCMAX<AA THEN ABSCMAX:=AA;
     IF ABSCMIN>AA THEN ABSCMIN:=AA;
     IF ABS(LD(AA)-LD(ABSCISSA[IL-1]))<MINDISTABSC THEN
      MINDISTABSC:=ABS(LD(AA)-LD(ABSCISSA[IL-1]));
    END;
  END;{ EXTREMA }
 FUNCTION ORDFUNC(A:REAL):INTEGER;
  VAR AU:REAL;
  BEGIN
   AU:=LD(ORDMAX)-LD(ORDMIN);
   ORDFUNC:=AXEY-10-TRUNC((A-LD(ORDMIN))*DISTY/AU+0.0000001);
  END;{ ORDFUNC }
 FUNCTION ABSCFUNC(O:REAL):INTEGER;
  VAR OU:REAL;
  BEGIN
   OU:=LD(ABSCMAX)-LD(ABSCMIN);
   ABSCFUNC:=AXEX+10+TRUNC((O-LD(ABSCMIN))*DISTX/OU+0.0000001);
  END;{ ABSCFUNC }
 PROCEDURE SCALING;
  VAR IK,IL,I0,I1,I2,I3,K:INTEGER;
      OLD_ORDFUNC,OLD_ABSCFUNC:INTEGER;
      PARAHEIGHT:INTEGER;
      UK,U1,U2:REAL;
      CL,CR:STRING;
  BEGIN
   LINE(AXEX-5,AXEY,AXEX+DISTX+TRUNC(MAXX/20),AXEY);
   LINE(AXEX,AXEY+5,AXEX,AXEY-10-DISTY-IB);
   IK:=TRUNC((AXEY-10-DISTY-IB)/2);
   SETTEXTJUSTIFY(1,2);
   IF TEXTWIDTH(CY)<AXEX-4 THEN
     OUTTEXTXY(ID,IK,CY)
    ELSE
     OUTTEXTXY(5+TRUNC(TEXTWIDTH(CY)/2),IK,CY);
   IF TEXTWIDTH(CX)<IC-4 THEN
     OUTTEXTXY(TRUNC(19*MAXX/20),AXEY+2*(IB+3),CX)
    ELSE
     OUTTEXTXY(TRUNC(MAXX-5-TEXTWIDTH(CX)/2),AXEY+24,CX);
   OUTTEXTXY(AXEX,AXEY-10-DISTY-IB,'^');
   SETTEXTJUSTIFY(2,1);
   OUTTEXTXY(AXEX+10+DISTX+TRUNC(MAXX/20)-2,AXEY+1,'>');
   SETTEXTJUSTIFY(1,2);
   U1:=LD(ABSCMAX);U2:=LD(ABSCMIN);
   I1:=TRUNC(U1);IF U1<0 THEN I1:=I1-1;I2:=TRUNC(U2);IF U2>0 THEN I2:=I2+1;
   UK:=I1;
   K:=ABSCFUNC(U1);LINE(K,AXEY-3,K,AXEY+3);
   IF ((ABS(U1-U2)<10) OR (UK=U1)) THEN
     BEGIN
      CR:=CHCR(U1);OUTTEXTXY(K,AXEY+7,CR);
      OLD_ABSCFUNC:=K;
     END
    ELSE OLD_ABSCFUNC:=2*K;
   UK:=I2;
   K:=ABSCFUNC(U2);LINE(K,AXEY-3,K,AXEY+3);
   IF ((ABS(U1-U2)<10) OR (UK=U2)) THEN
     BEGIN
      CR:=CHCR(U2);OUTTEXTXY(K,AXEY+7,CR);
     END;
   I0:=I1+1;IK:=1;
   WHILE (I1-I2)/IK>19 DO IK:=IK*2;
   IF ABS(I1-I2)>1 THEN
     BEGIN
      I1:=I1+IK-(I1 MOD IK);
      REPEAT
       I1:=I1-IK;
       K:=ABSCFUNC(I1);
       IF ((ABS(OLD_ABSCFUNC-K)>TEXTWIDTH('000'))
           AND (ABS(ABSCFUNC(U2)-K)>TEXTWIDTH('000'))
           AND (ABS(I1-I0)>=MINDISTABSC)) THEN
        BEGIN
         LINE(K,AXEY-3,K,AXEY+3);
         STR(I1,CR);OUTTEXTXY(K,AXEY+10,CR);
         OLD_ABSCFUNC:=K;I0:=I1;
        END;
      UNTIL I1-IK<I2;
     END;
   SETTEXTJUSTIFY(1,1);
   U1:=LD(ORDMAX);U2:=LD(ORDMIN);
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   IF ABS(I1-I2)>0 THEN
     BEGIN
      OLD_ORDFUNC:=0;
      IF I2<U2 THEN I2:=I2+1;
      IF ABS(I1-I2)<3 THEN
       BEGIN
        I3:=ORDFUNC(U1);
        IF ABS(ORDFUNC(I1)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U1);
          OUTTEXTXY(ID,I3,CL);
         END;
        I3:=ORDFUNC(U2);
        IF ABS(ORDFUNC(I2)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U2);
          OUTTEXTXY(ID,I3,CL);
         END;
       END;
      PARAHEIGHT:=1;
      WHILE (I1-I2)/PARAHEIGHT>20 DO
       IF PARAHEIGHT=1 THEN PARAHEIGHT:=PARAHEIGHT*2 ELSE
        IF PARAHEIGHT=2 THEN PARAHEIGHT:=PARAHEIGHT*5 ELSE
         PARAHEIGHT:=PARAHEIGHT*10;
      I1:=I1+PARAHEIGHT-(I1 MOD PARAHEIGHT);
      IF U1<0 THEN I1:=I1-PARAHEIGHT;
      REPEAT
       I1:=I1-PARAHEIGHT;
       I0:=ORDFUNC(I1);
       IF ABS(OLD_ORDFUNC-I0)>TEXTHEIGHT('M') THEN
        BEGIN
         LINE(AXEX-3,I0,AXEX+3,I0);
         STR(I1,CR);OUTTEXTXY(ID,I0,CR);
         OLD_ORDFUNC:=I0;
        END;
      UNTIL I1-PARAHEIGHT<I2;
     END
    ELSE
     BEGIN
      K:=ORDFUNC(U1);
      LINE(AXEX-3,K,AXEX+3,K);CL:=CHCR(U1);
      OUTTEXTXY(ID,K,CL);
      K:=ORDFUNC(U2);
      LINE(AXEX-3,K,AXEX+3,K);CR:=CHCR(U2);
      IF CL<>CR THEN OUTTEXTXY(ID,K,CR);
      IF ((LD(ORDMAX)>0) AND (LD(ORDMIN)<0) AND (CL<>'0') AND (CR<>'0'))
       THEN
        BEGIN
         K:=ORDFUNC(0.0);
         IF ((ABS(K-ORDFUNC(U1))>TEXTHEIGHT('M'))
             AND (ABS(K-ORDFUNC(U2))>TEXTHEIGHT('M'))) THEN
          BEGIN
           LINE(AXEX-3,K,AXEX+3,K);
           OUTTEXTXY(ID,K,'0.0');
          END;
        END;
     END;
  END;{ SCALING }
BEGIN
  IB:=TEXTHEIGHT('M');
  IC:=TRUNC(MAXX/10);
  AXEX:=IC;
  IF AXEX<TEXTWIDTH(CHCR(+111.111222333444555666)) THEN
   AXEX:=2+TEXTWIDTH(CHCR(+111.111222333444555666));
  ID:=TRUNC(AXEX/2);
  AXEY:=MAXY-4*(IB+5)-TRUNC(MAXY/30);
  DISTX:=MAXX-10-AXEX-IC;DISTY:=AXEY-10-2*(IB+5);
  LN2:=LN(2);
  EXTREMA;
  SETTEXTSTYLE(0,0,1);
  SCALING;
  SETCOLOR(MAXCOLOR);
  IL1:=-NUM;
  REPEAT
   IL1:=IL1+NUM;
   GRAPHLABEL:=TRUNC((IL1+NUM)/NUM);CR:=CHCR(GRAPHLABEL);
   {IF MAXCOLOR>=N THEN SETCOLOR(MAXCOLOR-TRUNC(IL1/NUM));}
   OLDORD:=ORDFUNC(LD(ORDINATE[IL1+1]));
   OLDABSC:=ABSCFUNC(LD(ABSCISSA[IL1+1]));
   OUTTEXTXY(OLDABSC,OLDORD,CR);
   FOR IL2:=IL1+2 TO IL1+NUM DO
    BEGIN
     NEWORD:=ORDFUNC(LD(ORDINATE[IL2]));
     NEWABSC:=ABSCFUNC(LD(ABSCISSA[IL2]));
     LINE(OLDABSC,OLDORD,NEWABSC,NEWORD);
     OUTTEXTXY(NEWABSC,NEWORD,CR);
     OLDORD:=NEWORD;
     OLDABSC:=NEWABSC;
    END;
   NEWABSC:=ABSCFUNC(LD(ABSCISSA[IL1+1+((GRAPHLABEL+1) MOD 2)]));
   NEWORD:=ORDFUNC(LD(ORDINATE[IL1+1+((GRAPHLABEL+1) MOD 2)]));
   SETCOLOR(MAXCOLOR);
  UNTIL IL1=(N-1)*NUM;
END;{ GRAPH441 }

{ Plots confidence intervals for G schemes and NUM step sizes }

PROCEDURE CONFINV(G,NUM:INTEGER;ORDINATE,DIFFER,ABSCISSA:VECTOR1;CY,CX:STRING);
 VAR IB,IC,ID,IK,IL:INTEGER;
     AXEX,AXEY:INTEGER;
     DISTX,DISTY:INTEGER;
     ORD1,ORD2,ABSC:INTEGER;
     ORDMAX,ORDMIN,ABSCMAX,ABSCMIN:REAL;
     MINDISTABSC:REAL;
     CR:STRING;
 PROCEDURE EXTREMA;
  VAR IL:INTEGER;
      A,B,AA:REAL;
  BEGIN
   A:=ORDINATE[1]+DIFFER[1];
   ORDMAX:=A;ORDMIN:=A-2*DIFFER[1];
   ABSCMAX:=ABSCISSA[1];
   ABSCMIN:=ABSCMAX;
   MINDISTABSC:=ABS(ABSCMIN-ABSCISSA[2]);
   FOR IL:=2 TO G*NUM DO
    BEGIN
     A:=ORDINATE[IL]+DIFFER[IL];
     B:=ORDINATE[IL]-DIFFER[IL];
     AA:=ABSCISSA[IL];
     IF ORDMAX<A THEN ORDMAX:=A;
     IF ORDMIN>B THEN ORDMIN:=B;
     IF ABSCMAX<AA THEN ABSCMAX:=AA;
     IF ABSCMIN>AA THEN ABSCMIN:=AA;
     IF ABS(AA-ABSCISSA[IL-1])<MINDISTABSC THEN
      MINDISTABSC:=ABS(AA-ABSCISSA[IL-1]);
    END;
  END;
 FUNCTION ORDFUNC(A:REAL):INTEGER;
  VAR AU:REAL;
  BEGIN
   AU:=ORDMAX-ORDMIN;
   ORDFUNC:=AXEY-10-TRUNC((A-ORDMIN)*DISTY/AU+0.0000001);
  END;
 FUNCTION ABSCFUNC(O:REAL):INTEGER;
  VAR OU:REAL;
  BEGIN
   OU:=ABSCMAX-ABSCMIN;
   ABSCFUNC:=AXEX+10+TRUNC((O-ABSCMIN)*DISTX/OU+0.0000001);
  END;
 PROCEDURE SCALING;
  VAR IK,IL,I0,I1,I2,I3,K:INTEGER;
      OLD_ORDFUNC,OLD_ABSCFUNC:INTEGER;
      PARAHEIGHT:INTEGER;
      Uk,U0,U1,U2:REAL;
      CL,CR:STRING;
  BEGIN
   LINE(AXEX-5,AXEY,AXEX+DISTX+TRUNC(MAXX/20),AXEY);
   LINE(AXEX,AXEY+5,AXEX,AXEY-10-DISTY-IB);
   IK:=TRUNC((AXEY-10-DISTY-IB)/2);
   SETTEXTJUSTIFY(1,2);
   IF TEXTWIDTH(CY)<AXEX-4 THEN
     OUTTEXTXY(ID,IK,CY)
    ELSE
     OUTTEXTXY(5+TRUNC(TEXTWIDTH(CY)/2),IK,CY);
   IF TEXTWIDTH(CX)<IC-4 THEN
     OUTTEXTXY(TRUNC(19*MAXX/20),AXEY+2*(IB+3),CX)
    ELSE
     OUTTEXTXY(TRUNC(MAXX-5-TEXTWIDTH(CX)/2),AXEY+2*(IB+3),CX);
   OUTTEXTXY(AXEX,AXEY-10-DISTY-IB,'^');
   SETTEXTJUSTIFY(2,1);
   OUTTEXTXY(AXEX+10+DISTX+TRUNC(MAXX/20)-3,AXEY+1,'>');
   SETTEXTJUSTIFY(1,2);
   Uk:=ABSCMAX;
   K:=ABSCFUNC(Uk);I1:=K;
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   OLD_ABSCFUNC:=K;I2:=K;
   Uk:=ABSCMIN;
   K:=ABSCFUNC(Uk);
   LINE(K,AXEY-3,K,AXEY+3);
   CR:=CHCR(Uk);
   OUTTEXTXY(K,AXEY+7,CR);
   IK:=0;
   IL:=0;
   REPEAT
    IL:=IL+1;
    U1:=ABSCISSA[IL];
    IF ((U1<>ABSCMAX) AND (U1<>ABSCMIN)) THEN
     BEGIN
      K:=ABSCFUNC(U1);
      IF ((ABS(OLD_ABSCFUNC-K)>TEXTWIDTH('0.000000'))
         AND (ABS(I1-K)>TEXTWIDTH('0.000000'))
         AND (ABS(I2-K)>TEXTWIDTH('0.000000'))
         AND (ABS(K-OLD_ABSCFUNC)>=MINDISTABSC)) THEN
       BEGIN
        LINE(K,AXEY-3,K,AXEY+3);IF NUM>4 THEN IK:=IK+1 ELSE IK:=1;
        CR:=CHCR(U1);OUTTEXTXY(K,AXEY+7+(IK MOD 2)*8,CR);
        OLD_ABSCFUNC:=K;
       END;
     END;
   UNTIL IL=NUM;
   SETTEXTJUSTIFY(1,1);
   U1:=ORDMAX;U2:=ORDMIN;
   I1:=TRUNC(U1);I2:=TRUNC(U2);
   IF ((I1>I2) AND (U1<0)) THEN I1:=I1-1;
   IF ABS(I1-I2)>0 THEN
     BEGIN
      OLD_ORDFUNC:=0;
      IF I2<U2 THEN I2:=I2+1;
      IF ABS(I1-I2)<3 THEN
       BEGIN
        I3:=ORDFUNC(U1);
        IF ABS(ORDFUNC(I1)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U1);
          OUTTEXTXY(ID,I3,CL);
         END;
        I3:=ORDFUNC(U2);
        IF ABS(ORDFUNC(I2)-I3)>TEXTHEIGHT('M') THEN
         BEGIN
          LINE(AXEX-3,I3,AXEX+3,I3);
          CL:=CHCR(U2);
          OUTTEXTXY(ID,I3,CL);
         END;
       END;
      PARAHEIGHT:=1;
      WHILE (I1-I2)/PARAHEIGHT>20 DO PARAHEIGHT:=PARAHEIGHT*10;
      I1:=I1+PARAHEIGHT-(I1 MOD PARAHEIGHT);
      IF U1<0 THEN I1:=I1-PARAHEIGHT;
      REPEAT
       I1:=I1-PARAHEIGHT;
       I0:=ORDFUNC(I1);
       IF ABS(OLD_ORDFUNC-I0)>TEXTHEIGHT('M') THEN
        BEGIN
         LINE(AXEX-3,I0,AXEX+3,I0);
         STR(I1,CR);OUTTEXTXY(ID,I0,CR);
         OLD_ORDFUNC:=I0;
        END;
      UNTIL I1-PARAHEIGHT<I2;
     END
    ELSE
     BEGIN
      K:=ORDFUNC(U1);
      LINE(AXEX-3,K,AXEX+3,K);CL:=CHCR(U1);
      OUTTEXTXY(ID,K,CL);
      K:=ORDFUNC(U2);
      LINE(AXEX-3,K,AXEX+3,K);CR:=CHCR(U2);
      IF CL<>CR THEN OUTTEXTXY(ID,K,CR);
      IF ((ORDMAX>0) AND (ORDMIN<0) AND (CL<>'0') AND (CR<>'0'))
       THEN
        BEGIN
         K:=ORDFUNC(0.0);
         IF ((ABS(K-ORDFUNC(U1))>TEXTHEIGHT('M'))
             AND (ABS(K-ORDFUNC(U2))>TEXTHEIGHT('M'))) THEN
          BEGIN
           LINE(AXEX-3,K,AXEX+3,K);
           OUTTEXTXY(ID,K,'0.0');
          END;
        END;
     END;
  END;
BEGIN
  IB:=TEXTHEIGHT('M')+5;
  IC:=TRUNC(MAXX/10);
  AXEX:=IC;
  IF AXEX<TEXTWIDTH(CHCR(+111.111222333444555666)) THEN
   AXEX:=2+TEXTWIDTH(CHCR(+111.111222333444555666));
  ID:=TRUNC(AXEX/2);
  AXEY:=MAXY-4*(IB+5)-TRUNC(MAXY/30);
  DISTX:=MAXX-10-AXEX-IC;DISTY:=AXEY-10-2*(IB+5);
  EXTREMA;
  SETTEXTSTYLE(0,0,1);
  SCALING;
  SETTEXTJUSTIFY(1,1);
  IK:=0;
  REPEAT
   IK:=IK+1;
   FOR IL:=(IK-1)*NUM+1 TO IK*NUM DO
    BEGIN
     ORD1:=ORDFUNC(ORDINATE[IL]+DIFFER[IL]);
     ORD2:=ORDFUNC(ORDINATE[IL]-DIFFER[IL]);ABSC:=ABSCFUNC(ABSCISSA[IL]);
     LINE(ABSC,ORD1,ABSC,ORD2);
     LINE(ABSC-3,ORD1,ABSC+3,ORD1);LINE(ABSC-3,ORD2,ABSC+3,ORD2);
     IF MAXCOLOR>G THEN SETCOLOR(MAXCOLOR+1-IK);
     OUTTEXTXY(ABSC,TRUNC((ORD1+ORD2)/2),CHCR(IK));
     OUTTEXTXY(ABSC,ORD1,CHCR(IK));OUTTEXTXY(ABSC,ORD2,CHCR(IK));
     IF MAXCOLOR>G THEN SETCOLOR(MAXCOLOR);
    END
  UNTIL IK=G;
END;{ CONFINV }

END.{ EXTGRAPH }
