{ To initialize graphics, report any errors that may occur, save the exit }
{ procedure address and close graphics mode                               }
{ Adapted from 'BGIDEMO.PAS' of Borland International, Inc.,              }
{ Assembled by Henri Schurz, 9.10. 1991                                   }

UNIT INIT;
INTERFACE
USES CRT,DOS,GRAPH;

CONST

{ Maximum number of time steps which can be ploted and are limited }
{ by the installed graphics device driver                          }

 NUMINV=512;{ = 2^+9 }

 FONTS:ARRAY[0..4] OF STRING[13] =
 ('DefaultFont', 'TriplexFont', 'SmallFont', 'SansSerifFont', 'GothicFont');

 LINESTYLES:ARRAY[0..4] OF STRING[9] =
 ('SolidLn', 'DottedLn', 'CenterLn', 'DashedLn', 'UserBitLn');

{ The twelve predefined fill styles supported }

 FILLSTYLES:ARRAY[0..11] OF STRING[14] =
 ('EmptyFill', 'SolidFill', 'LineFill', 'LtSlashFill', 'SlashFill',
  'BkSlashFill', 'LtBkSlashFill', 'HatchFill', 'XHatchFill',
  'InterleaveFill', 'WideDotFill', 'CloseDotFill');

{ The two text directions available }

 TEXTDIRECT:ARRAY[0..1] OF STRING[8] =
 ('HorizDir', 'VertDir');

{ The horizontal text justifications available }

 HORIZJUST:ARRAY[0..2] OF STRING[10] =
 ('LeftText', 'CenterText', 'RightText');

{ The vertical text justifications available }

 VERTJUST:ARRAY[0..2] OF STRING[10] =
 ('BottomText', 'CenterText', 'TopText');

VAR
 GRAPHDRIVER:INTEGER;    { graphics device driver                }
 GRAPHMODE:INTEGER;      { graphics mode value                   }
 MAXX,MAXY:WORD;         { maximum resolution of the screen      }
 ERRORCODE:INTEGER;      { reports any graphics errors           }
 MAXCOLOR:WORD;          { maximum color value available         } 
 OLDEXITPROC:POINTER;    { saves exit procedure address          }
 INGRAPHICSMODE:BOOLEAN; { flags initialization of graphics mode }
 PATHTODRIVER  :STRING;  { stores the DOS path to *.BGI & *.CHR  }

PROCEDURE MYEXITPROC;
PROCEDURE INITIALIZE;

IMPLEMENTATION

{$F+}

{ Saves the exit procedure address and closes graphics mode }

PROCEDURE MYEXITPROC;
BEGIN
 EXITPROC:=OLDEXITPROC;
 CLOSEGRAPH;
END;{ MYEXITPROC }

{$F-}

{ Initializes graphics, reports any errors that may occur and sets up }
{ graphics parameters                                                 }

PROCEDURE INITIALIZE;
BEGIN
{ When using CRT and GRAPHICS, turn off CRT's memory-mapped writes }
 DIRECTVIDEO:=FALSE;
 OLDEXITPROC:=EXITPROC; { saves previous exit proc       }
 EXITPROC:=@MYEXITPROC; { inserts our exit proc in chain }
 PATHTODRIVER:='';
 REPEAT

{$IFDEF USE8514}        { checks for USE8514 $DEFINE }

  GRAPHDRIVER:=IBM8514;
  GRAPHMODE:=IBM8514Hi;

{$ELSE}

  GRAPHDRIVER:=DETECT; { automatically set up }

{$ENDIF}

  INITGRAPH(GRAPHDRIVER,GRAPHMODE,PATHTODRIVER);
  ERRORCODE:=GRAPHRESULT;   { preserves error return }
  IF ERRORCODE <> GROK THEN { error ?                }
   BEGIN
    WRITELN('Graphics error: ',GRAPHERRORMSG(ERRORCODE));
    IF ERRORCODE = GRFILENOTFOUND THEN { can't find driver file }
      BEGIN
       WRITELN('Enter full path to BGI driver or type <Ctrl-Break> to quit:');
       READLN(PATHTODRIVER);
       WRITELN;
      END
     ELSE
      HALT(1); { some other error : terminates }
   END;
 UNTIL ERRORCODE=GROK;
 RANDOMIZE;             { initializes the random number generator  }
 MAXCOLOR:=GETMAXCOLOR; { gets the maximum allowable drawing color }
 MAXX:=GETMAXX;         { gets screen resolution value             }
 MAXY:=GETMAXY;         { gets screen resolution value             }
END;{ INITIALIZE }

END.{ INIT }