{ Random number generators            }
{ Written by Henri Schurz, 9.10. 1991 }

UNIT RANDNUMB;
INTERFACE
USES CRT,DOS,GRAPH;

PROCEDURE GENER01(P,X1,X2:REAL;VAR XU:REAL);
PROCEDURE GENER02(LAMBDA:REAL;VAR XU:REAL);
PROCEDURE GENER03(VAR G1,G2:REAL);
PROCEDURE GENERATE(VAR G1,G2:REAL);

IMPLEMENTATION

{ Generates a two-point distributed random number }

PROCEDURE GENER01(P,X1,X2:REAL;VAR XU:REAL);
BEGIN
 XU:=RANDOM;
 IF XU <= P THEN XU:=X1 ELSE XU:=X2;
END;{ GENER01 }

{ Generates an exponentially distributed random number }
{ with parameter Lambda > 0.0                          }

PROCEDURE GENER02(LAMBDA:REAL;VAR XU:REAL);
BEGIN
 XU:=RANDOM;
 IF XU > 0. THEN XU:=-LN(XU)/LAMBDA ELSE XU:=0.;
END;{ GENER02 }

{ Generates two independent N(0,1) random numbers }
{ by the Box-Muller method                        }

PROCEDURE GENER03(VAR G1,G2:REAL);
VAR
 U1,U2:REAL;
BEGIN
 REPEAT U1:=RANDOM UNTIL U1>0.;U2:=RANDOM;
 U1:=LN(U1);U2:=PI*U2;
 U1:=SQRT(-U1-U1);U2:=U2+U2;
 G1:=U1*COS(U2);G2:=U1*SIN(U2);
END;{ GENER03 }

{ Generates two independent N(0,1) random numbers }
{ by the Polar-Marsaglia method                   }

PROCEDURE GENERATE(VAR G1,G2:REAL);
VAR
 V1,V2,W,LW:REAL;
BEGIN
 REPEAT
  V1:=2.*RANDOM-1.;V2:=2.*RANDOM-1.;W:=V1*V1+V2*V2;
 UNTIL ((W<=1.0) AND (W>0.0)); { obviously LN(0) does not exist. }
 LW:=LN(W)/W;LW:=SQRT(-LW-LW);G1:=V1*LW;G2:=V2*LW;
END;{ GENERATE }

END.{ RANDNUMB }

