{ To support and control the screen   }
{ Created by Henri Schurz, 8.10. 1991 }

UNIT SERVICE;
INTERFACE
USES CRT,DOS,GRAPH;

PROCEDURE WAITE;
PROCEDURE WAITTOGO;
FUNCTION CHCR(X:REAL):STRING;

IMPLEMENTATION

{ Waits for the user to stop the program and continue in CRT mode }

PROCEDURE WAITE;
VAR
 CH:CHAR;
BEGIN
 REPEAT UNTIL KEYPRESSED;CH:=READKEY
END;{ WAITE }

{ Waits for the user to abort the program or continue in GRAPHIC mode }

PROCEDURE WAITTOGO;
CONST
 ESC=#27;
VAR
 CH:CHAR;
BEGIN
 REPEAT UNTIL KEYPRESSED;
 CH:=READKEY;
 IF CH = #0 THEN CH:=READKEY; { traps function keys  }
 IF CH = ESC THEN HALT(0);    { terminates program   }
END;{ WAITTOGO }

{ Converts real numbers to strings with truncation < 6E-accur }

FUNCTION CHCR(X:REAL):STRING;
CONST
 ACCUR=6; { <=6 }
VAR XBEFORE,XBEHIND:LONGINT;
 CL,CS:STRING;
 ACCURACY:REAL;
BEGIN
 ACCURACY:=EXP(-LN(10)*ACCUR);
 IF ((X=ROUND(X)) OR (ABS(X-ROUND(X))<ACCURACY)) THEN STR(ROUND(X),CL)
  ELSE
   BEGIN
    XBEFORE:=TRUNC(ABS(X));
    XBEHIND:=TRUNC((ABS(X)-XBEFORE)/ACCURACY+0.1);
    STR(XBEHIND,CL);
    WHILE LENGTH(CL) < ACCUR DO CL:='0'+CL;
    CS:=COPY(CL,LENGTH(CL),1);
    WHILE ((CS = '0') AND (LENGTH(CL) >= 1)) DO
     BEGIN
      CL:=COPY(CL,1,LENGTH(CL)-1);CS:=COPY(CL,LENGTH(CL),1);
     END;
    STR(XBEFORE,CS);
    CL:=CS+'.'+CL;
    IF X < 0 THEN CL:='-'+CL;
   END;
 CHCR:=CL;
END;{ CHCR }

END.{ SERVICE }