{ To make a window, set a view port and display a bottom line on the screen }
{ Adapted from 'BGIDEMO.PAS' of Borland International, Inc.,                }
{ Assembled by Henri Schurz, 9.10. 1991                                     }

UNIT SETSCR;
INTERFACE
USES CRT,DOS,GRAPH,INIT;

PROCEDURE MAINWINDOW(IS:STRING);
PROCEDURE STATUSLINE(MSG:STRING);

IMPLEMENTATION

{ Sets the maxcolor }

PROCEDURE DEFAULTCOLORS;
BEGIN
 SETCOLOR(MAXCOLOR);
END;{ DEFAULTCOLORS }

{ Draws a border around the current view port }

PROCEDURE DRAWBORDER;
VAR
 VIEWPORT : VIEWPORTTYPE;
BEGIN
 DEFAULTCOLORS;
 SETLINESTYLE(SOLIDLN,0,NORMWIDTH);
 GETVIEWSETTINGS(VIEWPORT);
 WITH VIEWPORT DO
  RECTANGLE(0,0,x2-x1,y2-y1);
END;{ DRAWBORDER }

{ Sets the view port to the entire screen }

PROCEDURE FULLPORT;
BEGIN
 SETVIEWPORT(0,0,MAXX,MAXY,CLIPON);
END;{ FULLPORT }

{ Makes a default window and view port on the screen }

PROCEDURE MAINWINDOW(IS:STRING);
BEGIN
 DEFAULTCOLORS;                        { resets the colors }
 CLEARDEVICE;                          { clears the screen }
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1); { default text font }
 SETTEXTJUSTIFY(CENTERTEXT,TOPTEXT);   { left justify text }
 IF IS<>'' THEN
  BEGIN
   FULLPORT;                   { full screen view port }
   OUTTEXTXY(MAXX DIV 2,2,IS); { draw the header       }
  { Draws main window }
   SETVIEWPORT(0,TEXTHEIGHT('M')+4,MAXX,MAXY-(TEXTHEIGHT('M')+4),CLIPON);
   DRAWBORDER; { puts a border around it }
  END;
{ Moves the edges in 1 pixel on all sides so border isn't in the view port }
 SETVIEWPORT(1,TEXTHEIGHT('M')+5,MAXX-1,MAXY-(TEXTHEIGHT('M')+5),CLIPON);
END;{ MAINWINDOW }

{ Displays a status line at the bottom of the screen }

PROCEDURE STATUSLINE(MSG:STRING);
BEGIN
 FULLPORT;
 DEFAULTCOLORS;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);
 SETTEXTJUSTIFY(CENTERTEXT,TOPTEXT);
 SETLINESTYLE(SOLIDLN,0,NORMWIDTH);
 SETFILLSTYLE(EMPTYFILL,0);
 BAR(0,MAXY-(TEXTHEIGHT('M')+4),MAXX,MAXY); { erases old status line }
 RECTANGLE(0,MAXY-(TEXTHEIGHT('M')+4),MAXX,MAXY);
 OUTTEXTXY(MAXX DIV 2,MAXY-(TEXTHEIGHT('M')+2),MSG);
{ Goes back to the main window }
 SETVIEWPORT(1,TEXTHEIGHT('M')+5,MAXX-1,MAXY-(TEXTHEIGHT('M')+5),CLIPON);
END;{ STATUSLINE }

END.{ SETSCR }