#include "cboxe.h"

main()
{
	/*[The lengths of arrays has been increased by one, first 
					one is not used ]*/
	int Code[101],Dim,NN;
	float X[52], Y[52], Xm[51], Ym[51],Xi[21], Yi[21],Bc[101],F[101];
	float G[101][101],H[101][101],D,stress[61],displ[41];
       
	Dim = 100;	/*[Dim = Max dimension of the system AX = F]*/

	/*[ Read Data ]*/
	
	Input11(Xi,Yi,X,Y,Code,Bc);
	
	
	/*[ Compute matrices G and H and form the system AX = F  ]*/
	
	Sys11(X,Y,Xm,Ym,G,H,Bc,F,Code,Dim);
	
	/*[Solve the system AX = F ]*/
	
	NN = 2*N;
	
	Solve(G,F,&D,NN,Dim);
	
	/*[ Compute stress and displacement at interior points ]*/
	
	Inter11(Bc,F,Code,Xi,Yi,X,Y,stress,displ);
	
	/*[Output solution at boundary nodes and interior Points ]*/
	
	Out11(Xm,Ym,Bc,F,Xi,Yi,stress,displ);
}
#include "cboxe.h"

void Inter11( Bc,F,Code,Xi,Yi,X,Y,stress,displ)
float Bc[101],F[101],Xi[21],Yi[21],X[52],Y[52],stress[61],displ[41];
int Code[101]; 
{
	int NN,i,j,k,kk,lk,found;
	float temp,dx11,dy11,dx12,dy12,dx22,dy22,sx11,sy11,sx12,sy12,sx22,sy22;
    float H11,H12,H21,H22,G11,G12,G22;

	found = 0;

	/*[ Enter all displacements in  Bc and all tractions in F ]*/

	NN = 2*N;
	for(i=1;i<=NN;i++)				
	{		
		if( Code[i] > 0 ) 
		{
			temp = Bc[i];
            Bc[i] = F[i];
            F[i] = temp;
		}
		else
			F[i] *= mu;
	}
     
	/*[Compute stress and displacement at interior points]*/

	if(L)
	{
		for(k=1;k<=L;k++)       
		{
			displ[2*k-1] = 0.0;
			displ[2*k] = 0.0;
			stress[3*k-2] = 0.0;
			stress[3*k-1] = 0.0;
			stress[3*k] = 0.0;

			for(j=1;j<=N;j++)				
			{
				if((M-1) > 0)           
				{
					if (!(j-Last[1]))   
					kk = 1;
					else
					{
			  			found = 0;
						for(lk=2;lk<=M;lk++)		   
			    		{
			     			if(!(j-Last[lk])) 
							{
			       				kk = Last[lk-1]+1;
								found = 1;
								break;
							}
			    		}
						if(!found)
							kk = j+1;
			  		}
				}
				else
				kk = j+1;
				Quad11(Xi[k],Yi[k],X[j],Y[j],X[kk],Y[kk],&H11,&H12,&H21,&H22,
						&G11,&G12,&G22);

          		displ[2*k-1]+=F[2*j-1]*G11+F[2*j]*G12-
							Bc[2*j-1]*H11-Bc[2*j]*H12;

          		displ[2*k] += F[2*j-1]*G12+F[2*j]*G22-
                           		Bc[2*j-1]*H21-Bc[2*j]*H22;
		 		Stress(Xi[k],Yi[k],X[j],Y[j],X[kk],Y[kk],&dx11,&dy11,
							&dx12,&dy12,&dx22,&dy22,&sx11,&sy11,
							&sx12,&sy12,&sx22,&sy22);
				stress[3*k-2] += F[2*j-1]*dx11+F[2*j]*dy11-
	                          Bc[2*j-1]*sx11-Bc[2*j]*sy11;
				stress[3*k-1] += F[2*j-1]*dx12+F[2*j]*dy12-
	                          	Bc[2*j-1]*sx12-Bc[2*j]*sy12;
				stress[3*k] += F[2*j-1]*dx22+F[2*j]*dy22-
	                          Bc[2*j-1]*sx22-Bc[2*j]*sy22;
			}
		}
	}
}
#include "cboxe.h"


 void  Quad11(Xp,Yp,X1,Y1,X2,Y2,H11,H12,H21,H22,G11,G12,G22)
	float Xp,Yp,X1,Y1,X2,Y2,*H11,*H12,*H21,*H22,*G11,*G12,*G22;
	
{
	float Ax,Ay,Bx,By,nx,ny,sgn,Denom,Ra,rx,ry,slope,Perp;
	float Z[] =  {0.0, 0.86113631, -0.86113631, 0.33998104, -0.33998104};
	float W[] = {0.0, 0.34785485,  0.34785485, 0.65214515,  0.65214515};
	float Xg[5],Yg[5],HL;
	int i;

	Ax = (X2-X1)/2.0;
	Bx = (X2+X1)/2.0;
	Ay = (Y2-Y1)/2.0;
	By = (Y2+Y1)/2.0;
	nx = (Y2-Y1)/(2*sqrt(SQ(Ax)+SQ(Ay)));
	ny = (X1-X2)/(2*sqrt(SQ(Ax)+SQ(Ay)));
	if(Ax)
	{
		slope = Ay/Ax;
		Perp = fabs(( slope*Xp-Yp+Y1-slope*X1)/sqrt(SQ(slope)+1));
	}
	else
		Perp = fabs(Xp-X1);
       
	/*[ Determine the direction of the outward normal ]*/

	sgn = (X1-Xp)*(Y2-Yp)-(X2-Xp)*(Y1-Yp);
	if (sgn < 0) 
		Perp = -Perp;

	(*H11) = 0.0;
	(*H12) = 0.0;
	(*H21) = 0.0;
	(*H22) = 0.0;
	(*G11) = 0.0;
	(*G12) = 0.0;
	(*G22) = 0.0;

	/*[ Compute coefficients of the matrices G and H ]*/       

	Denom = 4*pi*(1-nu);
	HL = sqrt(SQ(Ax)+SQ(Ay));
	for(i=1;i<=4;i++)
	{
	    Xg[i] = Ax*Z[i] + Bx;
        Yg[i] = Ay*Z[i] + By;
        Ra = sqrt(SQ(Xp-Xg[i]) + SQ(Yp-Yg[i]));
        rx = (Xg[i]-Xp)/Ra;
        ry = (Yg[i]-Yp)/Ra;

        (*G11) += ((3-4*nu)*log(1.0/Ra)+ SQ(rx))*W[i]*
                            	HL/(2*Denom*mu);
        (*G12)   += rx*ry*W[i]*HL/(2*Denom*mu);
         
	    (*G22)     += ((3-4*nu)*log(1.0/Ra)+SQ(ry))*W[i]*
                       			HL/(2*Denom*mu);
         
		(*H11) -= Perp*((1-2*nu)+2*SQ(rx))/(SQ(Ra)*Denom)*W[i]*
                       			HL;
        (*H12) -= (Perp*2*rx*ry/Ra+(1-2*nu)*(nx*ry-ny*rx))*
                       		W[i]*HL/(Ra*Denom);
        (*H21) -= (Perp*2*rx*ry/Ra+(1-2*nu)*(ny*rx-nx*ry))*
                       		 W[i]*HL/(Ra*Denom);
        (*H22) -= Perp*((1-2*nu)+2*SQ(ry))*W[i]*
                       			HL/(SQ(Ra)*Denom);
        
	}

       
}

void Diag11(X1,Y1,X2,Y2,G11,G12,G22)
float X1,Y1,X2,Y2,*G11,*G12,*G22;
{
	float Ax,Ay,SR,Denom;

	Ax = (X2-X1)/2;
	Ay = (Y2-Y1)/2;
	SR =sqrt(SQ(Ax)+SQ(Ay));;
	Denom = 4*3.141492*mu*(1-nu);
 	(*G11) = SR*((3-4*nu)*(1-log(SR))+SQ(X2-X1)/(4*SQ(SR)))/Denom;
 	(*G22) = SR*((3-4*nu)*(1-log(SR))+SQ(Y2-Y1)/(4*SQ(SR)))/Denom;
 	(*G12) = (X2-X1)*(Y2-Y1)/(4*SR*Denom);

}
#include "cboxe.h"

void Stress( Xp,Yp,X1,Y1,X2,Y2,dx11,dy11,dx12,dy12,
             dx22,dy22,sx11,sy11,sx12,sy12,sx22,sy22)
float Xp,Yp,X1,Y1,X2,Y2,*dx11,*dy11,*dx12,*dy12;
float *dx22,*dy22,*sx11,*sy11,*sx12,*sy12,*sx22,*sy22; 
{
	float Xg[5],Yg[5],Z[5],W[5]; 	/*[dimension increased by 1]*/
	float Ax,Bx,Ay,By,nx,ny,slope,Perp,sgn,SR,FA,AL,Denom,rx,ry,Ra;
	int i;

	Z[1] = 0.86113631;
	Z[2] = -Z[1];
	Z[3] = 0.33998104;
	Z[4] = -Z[3];
	W[1] = 0.34785485;
	W[2] = W[1];
	W[3] = 0.65214515;
	W[4] = W[3];
	
	Ax = (X2-X1)/2.0;
	Bx = (X2+X1)/2.0;
	Ay = (Y2-Y1)/2.0;
	By = (Y2+Y1)/2.0;
	SR = sqrt(SQ(Ax)+SQ(Ay));
	nx = (Y2-Y1)/(2*SR);
	ny = (X1-X2)/(2*SR);
	
	if( Ax ) 
	{
		slope = Ay/Ax;
		Perp = fabs((slope*Xp-Yp+Y1-slope*X1)/sqrt(SQ(slope)+1));
	}
	else
		Perp = fabs(Xp-X1);
        
	/*[Determine the direction of the outward normal ]*/

	sgn = (X1-Xp)*(Y2-Yp)-(X2-Xp)*(Y1-Yp);

	if ( sgn < 0 ) 
		Perp = -Perp;
        
	(*dx11) = 0.0;
	(*dy11) = 0.0;
	(*dx12) = 0.0;
	(*dy12) = 0.0;
	(*dx22) = 0.0;
	(*dy22) = 0.0;
	(*sx11) = 0.0;
	(*sy11) = 0.0;
	(*sx12) = 0.0;
	(*sy12) = 0.0;
	(*sx22) = 0.0;
	(*sy22) = 0.0;

	/*[ Compute displacement and stress coefficients ]*/
	

	FA = 1.0-4.0*nu;
	AL = 1.0-2.0*nu;
	Denom = 4.0*pi*(1.0-nu); 	
  
         
	for(i=1;i<=4;i++)
	{
		Xg[i] = Ax*Z[i]+Bx;
		Yg[i] = Ay*Z[i]+By;
		Ra  = sqrt(SQ(Xp-Xg[i])+SQ(Yp-Yg[i]));
		rx = (Xg[i]-Xp)/Ra;
		ry = (Yg[i]-Yp)/Ra;
		(*dx11) += (AL*rx+2*cube(rx))*W[i]*SR/(Denom*Ra);
		(*dy11) += (2*SQ(rx)*ry-AL*ry)*W[i]*SR/(Denom*Ra);
		(*dx12) += (AL*ry+2*(SQ(rx))*ry)/(Denom*Ra)*W[i]*SR;
		(*dy12) += (AL*rx+2*rx*SQ(ry))/(Denom*Ra)*W[i]*SR;
		(*dx22) += (2*rx*SQ(ry)-AL*rx)/(Denom*Ra)*W[i]*SR;
		(*dy22) += (AL*ry+2*cube(ry))/(Denom*Ra)*W[i]*SR;
		(*sx11) += (2*Perp/Ra*(AL*rx+nu*2*rx-4*cube(rx))+
                       4*nu*nx*SQ(rx)+AL*(2*nx*SQ(rx)+2*nx)-
                       FA*nx)*2*mu/(Denom*SQ(Ra))*W[i]*SR;
		(*sy11) += (2*Perp/Ra*(AL*ry-4*SQ(rx)*ry)+
                       4*nu*nx*rx*ry+AL*2*ny*SQ(rx)-
                       FA*ny)*2*mu/(Denom*SQ(Ra))*W[i]*SR;
		(*sx12) += (2*Perp/Ra*(nu*ry-4*SQ(rx)*ry)+2*nu*
                       (nx*ry*rx+ny*SQ(rx))+AL*(2*nx*rx*
                       ry+ny))*2*mu/(Denom*SQ(Ra))*W[i]*SR;
		(*sy12) += (2*Perp/Ra*(nu*rx-4*rx*SQ(ry))+2*nu*
                       (nx*SQ(ry)+ny*rx*ry)+AL*(2*ny*rx*ry+
                       nx))*2*mu/(Denom*SQ(Ra))*W[i]*SR;
		(*sx22) += (2*Perp/Ra*(AL*rx-4*rx*SQ(ry))+4*nu*
                       ny*rx*ry+AL*2*nx*SQ(ry)-FA*nx)*2*mu/
                       (Denom*SQ(Ra))*W[i]*SR;
		(*sy22) += (2*Perp/Ra*(AL*ry+2*nu*ry-4*cube(ry))+
                       4*nu*ny*SQ(ry)+AL*(2*ny*SQ(ry)+2*ny)-
                       FA*ny)*2*mu/(Denom*SQ(Ra))*W[i]*SR;

     }   


 }  
#include "cboxe.h"


void Input11(Xi,Yi,X,Y,Code,Bc)
float Xi[21],Yi[21],X[52],Y[52],Bc[101];
int Code[101];
{
	int i,j,k,Dim,NN,lnsize;
	FILE *infile,*outfile;
	char Title[80],line1[100];
	lnsize = 120;
	
	printf("Enter the Title:");
	scanf("%s",Title);
	
	printf("\nNOTE: FIRST LINE IN THE INPUT FILE SHOULD BE EITHER BLANK OR THE TITLE NOT DATA \n");
	printf("\nEnter the name of the input file:");
    scanf("%12s", inname);
	printf("\nEnter the name of the output file:");
	scanf("%12s", outname);
       
       
	infile = fopen(inname, "r");
	outfile = fopen(outname,"w");
	
	fgets(line1,lnsize,infile);
	fprintf(outfile,"%s\n",Title);
	
	
	fscanf(infile,"%d %d %d", &N, &L, &M); 
	fprintf(outfile,"\nNumber of Boundary Elements = %2d \n",N);
	fprintf(outfile,"Number of Interior Points = %2d \n",L);
	
	for(i = 1; i<=5; i++) 
	   fscanf(infile,"%d",&Last[i]); 

	fscanf(infile,"%f %f", &mu, &nu);
	fprintf(outfile, "\nShear Modulus = %10.4f \n",mu);
	fprintf(outfile,"Poisson Ratio = %10.4f \n",nu);

	if(M > 0)
		{
			fprintf(outfile,"Number of different Boundaries = %d\n\n",M);
			for(i=1;i<=M;i++)
				fprintf(outfile,"Last node on  boundary%2d = %2d\n\n",i,Last[i]);
		}


	/*[ Read coordinates of extreme points ]*/

  fprintf(outfile,"\nCOORDINATES OF EXTREME POINTS OF THE BOUNDARY ELEMENTS\n");
		fprintf(outfile,"\n\nPoint      X 	 	    Y\n");
        for(i = 1; i<=N; i++)
        {
        	fscanf(infile,"%f %f", &X[i],&Y[i]);
	  		fprintf(outfile,"%2d  %10.4f \t %10.4f \n",i,X[i],Y[i]);
        }

	/*[Read boundary conditions in Bc vector. If Code[i] = 0, the Bc[] 	value is a prescribed displacement; if Code[] = 1, the Bc[] value is a prescribed traction. ]*/ 

	fprintf(outfile,"\nBoundary Conditions\n\n");
	fprintf(outfile,"	  Prescribed Value			  Prescribed Value\n");
	fprintf(outfile,"Node   X-direction		Code	   Y-direction		Code\n");
	
	for( i = 1; i<= N; i++)
	{ 
		fscanf(infile,"%d %f %d %f",&Code[2*i-1],&Bc[2*i-1],										
				&Code[2*i],&Bc[2*i]);   
	 
	   fprintf(outfile,"%2d \t %10.4f \t\t %2d \t %10.4f \t\t %2d\n",i,
	   Bc[2*i-1],Code[2*i-1],Bc[2*i-1],Code[2*i]);										 
	 
	}

	if( L)
	{
		fprintf(outfile,"\nInterior Point Coordinates\n");
		fprintf(outfile,"\nPoint 	   Xi 	  	 	   Yi\n"); 
		for(i=1;i<=L;i++)
		{
			fscanf(infile,"%f %f",&Xi[i],&Yi[i]);
			fprintf(outfile,"%2d \t %10.4f \t %10.4f\n",i,Xi[i],Yi[i]);
		    }
		  }
  
  		for(i=1;i<=80;i++)
			fprintf(outfile,"*");
		fprintf(outfile,"\n");
  		fclose(infile);
		fclose(outfile);
}
#include "cboxe.h"

void Out11(Xm,Ym,Bc,F,Xi,Yi,stress,displ)
float Xm[51],Ym[51],Bc[101],F[101],Xi[21],Yi[21],stress[61],displ[41];
{
	
	FILE *outfile;
	int i,j,k;
	
	outfile = fopen(outname,"a");
		
	fprintf(outfile,"\nResults:\n\n Boundary Nodes\n\n");
	fprintf(outfile,"	   X		  Y		     Displ X	Displ Y  Traction X  Traction Y\n");
	for(i=1;i<=N;i++)
		fprintf(outfile,"(%10.4f, %10.4f) %10.4f %10.4f %10.4f %10.4f\n",
						Xm[i],Ym[i],Bc[2*i-1],Bc[2*i],F[2*i-1],F[2*i]);
		
	if(L)
	{	
		fprintf(outfile,"\nInterior point displacements\n\n");
		fprintf(outfile,"	   Xi		  Yi		 Displacement X		Displacement Y\n");
		for(k=1;k<=L;k++)
			fprintf(outfile,"(%10.4f,%10.4f) \t %10.4f \t %10.4f\n",
				Xi[k],Yi[k],displ[2*k-1],displ[2*k]); 
		
		fprintf(outfile,"\nInterior point stresses\n\n");
		fprintf(outfile,"	   Xi         Yi        Sigma X           Tau XY       Sigma Y\n");
	
		for(k=1;k<=L;k++)
			fprintf(outfile,"(%10.4f,%10.4f)\t %10.4f \t  %10.4f \t%10.4f\n",
					Xi[k],Yi[k],stress[3*k-2],stress[3*k-1],stress[3*k]);
					
	}
	fclose(outfile);
}
#include "cboxe.h"


/*[function  Solve : Solution of the linear systems of equations by the Gauss elimination method providing for interchanging rows when encountering a zero diagonal coeficient.

A : System Matrix
B:  Originally it contains the Independent coefficients.  After solutions it
	contains the values of the system unknowns.                            				   				
N:  Actual number of unknowns.
Dim: Row and Column Dimension of A.
 
]*/

void Solve(A,B,D,N,Dim)

	float A[101][101],B[101],*D;  /*[ D is assigned some value here ]*/
  	int N,Dim;

{
	int N1,i,j,k,i1,l,k1,found;
	float c;
	
/*[ found is a flag which is used to check if any non zero coeff is found ]*/	
	
	
	N1 = N - 1;

	for(k=1;k<=N1;k++)
	{
		k1 = k + 1;
		c = A[k][k];
		
		if( (fabs(c) - tol) <=0 )
		{
			found = 0;
			for(j=k1;j<=N;j++)  /*[Try to Interchange rows to get Nonzero ]*/
	
	        {
            	if( (fabs(A[j][k]) - tol) > 0.0 ) 
                {
				 	for(l=k;l<=N;l++)
                    {
                     	c = A[k][l];
                        A[k][l] = A[j][l];
                        A[j][l] = c;
                     }
				  		c = B[k];
				  		B[k] = B[j];
				  		B[j] = c;
				  		c = A[k][k];
						found = 1;		/*[ coeff is found ]*/
						break;
				}
			}
		 }

		if(!found)
		{
			printf("Singularity in Row %d 1",k);
	   		(*D) = 0.0;          
	    	return;   /*[ If no coefficient is found the control is 	transferred to main ]*/
		}
	


	/*[ Divide row by diagonal coefficient ]*/		

  		c = A[k][k];
		for(j = k1;j<=N;j++)
		   A[k][j] /= c;
		B[k] /= c;  
 
/*[ Eliminate unknown X[k] from row i ]*/

		for(i = k1;i<=N; i++)
		{
		  c = A[i][k];
		  for(j = k1;j<= N;j++)
		 	A[i][j] -= c*A[k][j];
		  B[i] -= c*B[k];
		}
	}
/*[ Compute the last unknown ]*/

	if((fabs(A[N][N]) - tol) > 0.0)
	{
	   B[N] /= A[N][N];

/*[Apply back substitution to compute the remaining unknowns  ]*/

	   for(l = 1;l<= N1;l++)
	   {
	      k = N - l;
	      k1 = k +1;
	      for(j = k1;j<=N;j++)
			B[k] -= A[k][j]*B[j];
	   }
/*[Compute the value of the determinent ]*/

	(*D) = 1.0;
	for(i=1;i<=N;i++)
	  (*D) *= A[i][i];

   }
  else
  {
  		printf("Singularity in Row %d 2",k);
	   	(*D) = 0.0;
   }          

  return;	
}
#include "cboxe.h"

void Sys11(X, Y, Xm, Ym, G, H, Bc, F, Code, Dim) 
float X[52], Y[52], Xm[51], Ym[51];
float G[101][101], H[101][101], F[101], Bc[101];
int   Code[101], Dim;
{    
	float temp;
	int i,j,k,NN,kk,found;
	found = 0;
	
	/*[Compute coordinates of the mid-nodes  ]*/

	X[N+1] = X[1];
	Y[N+1] = Y[1];

 	for(i=1;i<=N;i++)
    {
		Xm[i] = (X[i] + X[i+1])/2.0;
		Ym[i] = (Y[i] + Y[i+1])/2.0;
	}
 					

	if( (M-1) > 0 )
	{
		Xm[Last[1]] = (X[Last[1]]+X[1])/2.0;  
		Ym[Last[1]] = (Y[Last[1]]+Y[1])/2.0;
		for(k=2;k<=M;k++)
        {
			Xm[Last[k]] = (X[Last[k]] + X[Last[k-1] + 1])/2.0;
			Ym[Last[k]] = (Y[Last[k]] + Y[Last[k-1] + 1])/2.0;
        }
	}
   
	                
	for(i=1;i<=N;i++)
	{
		for(j=1;j<=N;j++)
		{
			if((M-1) > 0.0) 	
			{			   
				if(!(j-Last[1] )) 	
					kk=1;
				else
				{
					found = 0;
					for(k=2;k<=M;k++)
					{	
						if(!(j-Last[k])) 
                        {
							kk=Last[k-1]+1;
							found = 1;
							break;
						}
					}
					if(!found)
						kk = j+1;
				}
			}
			else
				kk=j+1; 
     
			if(i-j)
			{
				Quad11(Xm[i],Ym[i],X[j],Y[j],X[kk],Y[kk],&H[2*i-1][2*j-1],
					&H[2*i-1][2*j],&H[2*i][2*j-1],&H[2*i][2*j],
					&G[2*i-1][2*j-1],&G[2*i-1][2*j],&G[2*i][2*j]);
				G[2*i][2*j-1] = G[2*i-1][2*j];
			}          
			else
			{
				Diag11(X[j],Y[j],X[kk],Y[kk],&G[2*i-1][2*j-1],
					&G[2*i-1][2*j],&G[2*i][2*j]);
				H[(2*i-1)][(2*j-1)] = 0.5;
				H[(2*i)][(2*j)] = 0.5;
				H[(2*i-1)][(2*j)] = 0.0;
				H[(2*i)][(2*j-1)] = 0.0;
				G[(2*i)][(2*j-1)] = G[(2*i-1)][(2*j)];
			}
		}
	}

	/*[Reorder the columns of equation as in (5.28)  
		and form system matrix A which is stored in G]*/

	NN = 2*N;  
	for(j=1;j<=NN;j++)			
	{				
		if(Code[j] > 0)     		
		{
			for(i=1;i<=NN;i++)			
			{
				temp =  G[i][j];
				G[i][j] = -H[i][j];
				H[i][j] = - temp;
			}
		}
		else
		{
			for(i=1;i<=NN;i++)			
				G[i][j] *= mu;
		}
	}

	/*[ Form the right-side vector F which is stored in F]*/

	for(i = 1;i<=NN;i++)			
	{
		F[i] = 0.0;
		for(j=1;j<=NN;j++)				
            F[i] +=  H[i][j] * Bc[j];
	}
}       
