#include "cbox3.h"
/*[					Program Be3

	This program solves two dimensional potential problems using 
	quadratic boundary elements.  
	
 ]*/
main()
{
	float X[102],Y[102],F[101],Bc[151],Xi[21],Yi[21];
	float u[21],qx[21],qy[21],D;
	float G[100][150],H[100][100];
	int Code[151],Dim,thrice;
	
/*[	 	Set maximum dimension of the system of equations (Dim) 
		Dim = Maximum number of nodes = 2 * maximum number of elements
		thrice = 3 * maximum number of elements									
]*/
		
	Dim = 100;
	thrice = 150;
	
	/*[ Read input data ]*/
	Input3(Xi,Yi,X,Y,Code,Bc);
	
	/*[	Compute the matrices G and H and form system  A X = F ]*/
	Sys3(X,Y,G,H,F,Bc,Code,Dim,thrice);
	
	
	/*[Solve system ofequations]*/
	Solve(H,F,&D,N,Dim);

	
	/*[ Compute potential at interior points ]*/
	Inter3(F,Bc,Code,Xi,Yi,X,Y,u,qx,qy);
	
	/*[ Print results at boundary nodes and interior points ]*/
	Out3(X,Y,F,Bc,Xi,Yi,u,qx,qy);

}



#include "cbox3.h"

void Input3(Xi,Yi,X,Y,Code,Bc)
	float Xi[21],Yi[21],X[102],Y[102],Bc[151];
	int Code[151];
	{
	
		FILE  *infile, *outfile;
		int i,j,k,lnsize,nodes;
		char title[80],line1[100];
		lnsize = 100; 

/*[	  N = number of boundary nodes 
	  nodes = number of boundary nodes = 2*N
   	  L = number of interior points            ]*/

		printf(" \nEnter title:");
		scanf("%s", title);

		printf("\nNOTE:FIRST LINE IN INPUT FILE SHOULD BE THE TITLE OR LEFT BLANK NO DATA\n");        
		printf("\n Enter the name of the input file:");
        scanf("%s", inname);
        printf("\n Enter the name of the output file:");
        scanf("%s", outname);
        printf("\n");
       
        infile = fopen(inname, "r" );
        outfile = fopen(outname,"w" );
		
		fgets(line1,lnsize,infile);
		fprintf(outfile,"%s\n\n",title);
		fprintf(outfile,"Input \n");
		


/*[Read the number of boundary elements,  interior points,
		different boundaries and the last node of each boundary ]*/
		
		fscanf(infile,"%d %d",&nodes,&L);

		N = 2*nodes;
		fprintf(outfile," \nNumber of Boundary Elements = %d \n",nodes);

		fprintf(outfile,"Number of Interior Points = %d \n",L);
				
		fprintf(outfile," \nCordinates of The Extreme"); 
		fprintf(outfile," Points of the Boundary Elements \n"); 

/*[Read Boundary Nodes Coordinates in Arrays X and Y	]*/		

		fprintf(outfile,"\nPoint    X          Y \n");
		for(i=1;i<=N;i++)
		 { 
		   fscanf(infile,"%f %f",&X[i],&Y[i]);
		   fprintf(outfile,"%2d %10.4f %10.4f \n",i,X[i],Y[i]);
		 }
		fprintf(outfile," \n \n");
		  

/*[ Read boundary Conditions in Bc[i] vector. If Code[i] = 0, then the Bc[i] value is prescribed potential. If Code[i] = 1, then the Bc[i] value is prescribed potential derivative (flux).  Three boundary conditions are read for each element.  Nodes between two elements may have two different values of the potential derivative but only one value of the potential.   ]*/						


		fprintf(outfile,"Boundary Conditions \n");
		fprintf(outfile,"\nNode		Code	Prescribed Value \n");

		for(i=1;i<=nodes;i++)
		{
			fprintf(outfile,"\t %2d \t",i);
			for(j=1;j<=3;j++)
		  	{
		  		fscanf(infile,"%d %f",&Code[3*i-3+j],&Bc[3*i-3+j]);
		  		fprintf(outfile,"%2d \t %10.4f \t",Code[3*i-3+j],Bc[3*i-3+j]);
			}
			fprintf(outfile," \n");
		}
		
		fprintf(outfile," \n \n");


/*[  Read coordinates of the interior points   ]*/

		if( L)
		 {
		   fprintf(outfile," \nInterior Point Coordinates \n");
		   fprintf(outfile,"\nPoint    Xi         Yi\n"); 
		   for(i=1;i<=L;i++)
		    {
		     fscanf(infile,"%f %f",&Xi[i],&Yi[i]);
			 fprintf(outfile,"%2d %10.4f %10.4f\n",i,Xi[i],Yi[i]);
		    }
		  }
  
  		for(i=1;i<=80;i++)
		fprintf(outfile,"*");
		fprintf(outfile," \n");
  		fclose(infile);
		fclose(outfile);
  }
  
  
  

#include "cbox3.h"

void Sys3(X,Y,G,H,F,Bc,Code,Dim,thrice)
float X[102],Y[102],G[100][150];
float H[100][100],F[101],Bc[151];
int Code[151],Dim,thrice;

{
	int i,j,k,kk,ll,nodes,Node;
	float temp,Hw[4],Gw[4],Dq1[4],Dq2[4],Du1[4],Du2[4];
	
	
/*[ This Subroutine Computes the matrices G and H  and forms the system
	A X = F.  Note that  H is a square matrix (2*nodes,2*nodes), but G 				
		is rectangular (2*nodes,3*nodes).   ]*/													

		nodes = N/2;
		for(i=1;i<=N;i++)
		{
			for(j=1;j<=N;j++)
				H[i][j] = 0.0;
			for(j=1;j<=3*nodes;j++)
				G[i][j] = 0.0;
		}
				
		X[N+1] = X[1];
		Y[N+1] = Y[1];
		
/*[Compute the matrices Gw and Hw for each collocation point and each
		boundary element  ]*/																		   

	for(ll = 1;ll<=N;ll++)
	{
		for(i=1;i<=N-1; i=i+2)
		{
			if((ll - i)*(ll-i-1)*(ll-i-2)*(ll-i+N-2))
				Quad3(X[ll],Y[ll],X[i],Y[i],X[i+1],Y[i+1],
				X[i+2],Y[i+2],Hw,Gw,Dq1,Dq2,Du1,Du2,0);
			else
				{
					Node = ll - i + 1;
					if((ll ==1) && (i == N-1))
						Node += N;
					Quad3(X[ll],Y[ll],X[i],Y[i],X[i+1],Y[i+1],
						X[i+2],Y[i+2],Hw,Gw,Dq1,Dq2,Du1,Du2,0);
					Diag3(X[i],Y[i],X[i+1],Y[i+1],X[i+2],Y[i+2],Gw,Node);
				}
				
/*[Substitute the matrices Gw and Hw into the matrices G and H   ]*/ 		

			for(j=1;j<=3;j++)
			{
				k = 3*(i-1)/2;
				G[ll][k+j] += Gw[j];
				if(i-N+1)
					H[ll][i-1+j] += Hw[j];
				else
				{
					if((j-3) < 0)
						H[ll][i-1+j] += Hw[j];
					else
						H[ll][1] += Hw[j];
				}
			}
		}
	}
				
/*[ Compute the diagonal coefficients of the matrix H   ]*/	
	
	for(i=1;i<=N;i++)
	{
		H[i][i] = 0.0;
		for(j=1;j<=N;j++)
		{
			if(i != j)
				H[i][i] -= H[i][j];
		}


/*[ Add one to the diagonal coefficients for exterior problems   ]*/	

		if( H[i][i] < 0.0)
			H[i][i] += 2*pi;  
	}



/*[ Reorder the columns of the system A X = F  with the boundary conditions and form the system matrix A which is stored in H    ]*/


	for(i=1;i<=nodes;i++)
	{
		for(j=1;j<=3;j++)
		{
			if(Code[3*i-3+j] <= 0)
			{
				if(!(((i - nodes) != 0) || (j != 3)))
				{
					if(Code[1] > 0)
					{
						for(k=1;k<=N;k++)
						{
							temp = H[k][1];
							H[k][1] = -G[k][3*i];
							G[k][3*i] = -temp;
						}
					}
					else
					{
						for(k=1;k<=N;k++)
						{
							H[k][1] -=  G[k][3*i];	
							G[k][3*i] = 0.0;
						}
					}
				}
				else
				{
					if((i==1) || (j>1) || (Code[3*i-3] == 1))
					{
						for(k=1;k<=N;k++)
						{
							temp = H[k][2*i-2+j];
							H[k][2*i-2+j] = -G[k][3*i-3+j];
							G[k][3*i-3+j] = -temp;
						}
					}
					else
					{
						for(k=1;k<=N;k++)
						{
							H[k][2*i-1] -=  G[k][3*i-2];
							G[k][3*i-2] = 0.0;
						}
					}
				}
			}	
		}
	}
						
						
/*[ From the right side vector F which is stored in F    ]*/


	for(i=1;i<=N;i++)
	{
		F[i] = 0.0;
		for(j=1;j<=3*nodes;j++)
			F[i] += G[i][j]*Bc[j];
	}

}
			


#include "cbox3.h"

/*[This Subroutine computes the matrix Gw when the collocaton point is one											of the nodes of the integration element. The coefficients are computed numerically: the non-singular part by the standard Gauss Quadrature, and the logarithmic part by logarithmic quadrature.   ]*/

void Diag3(Xg1,Yg1,Xg2,Yg2,Xg3,Yg3,Gw,Node)
 
	float Xg1,Yg1,Xg2,Yg2,Xg3,Yg3,Gw[4];
	int Node;
{

    
const float z[] =  {0.0,0.9739065285,-0.9739065285,0.8650633666,-0.8650633666,
					 0.6794095683,-0.6794095682,0.4333953941,-0.4333953941,
					 0.1488743389,-0.1488743389};
const float W[] = {0.0,0.0666713443,0.0666713443,0.1494513491,0.1494513491,
					 0.2190863625,0.2190863625,0.2692667193,0.2692667193,
					 0.2955242247,0.2955242247};
const float zln[] = {0.0,0.0090426309,0.0539712662,0.1353118246,0.2470524162,
					  0.3802125396,0.5237923179,0.6657752055,0.7941904160,
					  0.8981610912,0.9688479887};
const float Wln[] = {0.0,0.1209551319,0.1863635425,0.1956608732,0.1735771421,
						0.1356956729,0.0936467585,0.0557877273,0.0271598109,
						0.0095151826,0.0016381576};

float A1,B1,A2,B2,phi3,phi2,phi1,phil3,phil2,phil1,philn3,philn2,philn1;
float X3,Y3,X2,Y2,X1,Y1,J11,J1,J2,xln,S3,S2,S1;
int i;		

	if(Node == 1)
	{
			X3 = Xg3 - Xg1;
			Y3 = Yg3 - Yg1;
			X2 = Xg2 - Xg1;
			Y2 = Yg2 - Yg1;
			A1 = (X3-2*X2)*0.5;
			B1 = X2;
			A2 = (Y3-2*Y2)*0.5;
			B2 = Y2;
	}
	else if(Node == 2)
	{
			X3 = Xg3 - Xg2;
			Y3 = Yg3 - Yg2;
			X1 = Xg1 - Xg2;
			Y1 = Yg1 - Yg2;
			A1 = X1+X3;
			B1 = X3 - X1;
			A2 = Y1+Y3;
			B2 = Y3-Y1;
	}
	else if(Node == 3)
	{
			X2 = Xg2 - Xg3;
			Y2 = Yg2 - Yg3;
			X1 = Xg1 - Xg3;
			Y1 = Yg1 - Yg3;
			A1 = (X1-2*X2)*0.5;
			B1 = -X2;
			A2 = (Y1-2*Y2)*0.5;
			B2 = -Y2;
	}
	
	
	for(i=1;i<=3;i++)
		Gw[i] = 0.0;
		
	for(i=1;i<=10;i++)			/*[Compute shape functions ]*/
	{
		phi3 = 0.5*z[i]*(z[i]+1.0);
		phi2 = 1.0 - z[i]*z[i];
		phi1 = 0.5*z[i]*(z[i]-1.0);
		phil3 = zln[i]*(2.0*zln[i] - 1.0);
		phil2 = 4.0*zln[i]*(1.0-zln[i]);
		phil1 = (zln[i]-1.0)*(2.0*zln[i] - 1.0);
		philn3 = 0.5*zln[i]*(zln[i]+1.0);
		philn2 = 1.0 - zln[i]*zln[i];
		philn1 = 0.5*zln[i]*(zln[i]-1.0);
		
			
			
	if(Node == 1)
	{
	  J1=sqrt(sq((4*A1*zln[i]-2*A1+0.5*X3))+sq((4*A2*zln[i]-2*A2+0.5*Y3)))*2;
	  J2 =sqrt(sq((A1*z[i]*2+0.5*X3))+sq((A2*z[i]*2+0.5*Y3))); 
	  xln = -log(2*sqrt(sq(z[i]*A1+B1) + sq(z[i]*A2+B2)));
	  S3 = phil3*J1*Wln[i]+phi3*J2*xln*W[i];
	  S2 = phil2*J1*Wln[i]+phi2*J2*xln*W[i];
	  S1 = phil1*J1*Wln[i]+phi1*J2*xln*W[i];	
	}
	else if(Node == 2)
	{	   	  
		J1=  sqrt(sq((0.5*B1-A1*zln[i]))+ sq((0.5*B2-A2*zln[i])));
	  	J11 =sqrt(sq((0.5*B1+A1*zln[i]))+ sq((0.5*B2+A2*zln[i])));
		J2 = sqrt(sq((0.5*B1+A1*z[i]))+  sq((0.5*B2+A2*z[i]))); 
	  	xln = -0.5*log(sq(z[i]*A1*0.5+B1*0.5) + sq(z[i]*A2*0.5+B2*0.5));
	  	S3 = (philn1*J1+philn3*J11)*Wln[i]+phi3*J2*xln*W[i];
	  	S2 = philn2*(J1+J11)*Wln[i]+phi2*J2*xln*W[i];
	  	S1 =  (philn3*J1+philn1*J11)*Wln[i]+phi1*J2*xln*W[i]; 
	}
	else if(Node == 3)
	{
					J1=sqrt(sq((2*A1-4*A1*zln[i]-0.5*X1))+sq((2*A2-4*A2*zln[i]-0.5*Y1)))*2;
	  J2 =sqrt(sq((2*A1*z[i]-0.5*X1))+sq((2*A2*z[i]-0.5*Y1))); 
	  xln = -log(2*sqrt(sq(A1*z[i]+B1) + sq(A2*z[i]+B2)));
	  S3 = phil1*J1*Wln[i]+phi3*J2*xln*W[i];
	  S2 = phil2*J1*Wln[i]+phi2*J2*xln*W[i];
	  S1 = phil3*J1*Wln[i]+phi1*J2*xln*W[i];	
	}
	
	Gw[3] += S3;
	Gw[2] += S2;
	Gw[1] += S1;
	}
	
	}
			

# include "cbox3.h"

void Inter3(F,Bc,Code,Xi,Yi,X,Y,u,qx,qy)

float F[101],Bc[151],Xi[21],Yi[21];
float X[102],Y[102],u[21],qx[21],qy[21];
int Code[151];
{
	int i,j,k,lk,kk,found,nodes,ij2;
	float A,B,temp,Hw[4],Gw[4],Dq1[4],Dq2[4],Du1[4],Du2[4];
	
	found = 0; 	/*[	Initialization ]*/
/*[ Rearrange the arrays F and Bc to store all values of the
		potential in F and the potential derivatives in Bc ]*/
		
	nodes = N/2;
	for(i=1;i<=nodes;i++)
	{
		for(j=1;j<=3;j++)
		{
			if(Code[3*i-3+j] <=0)
			{
				if(!(((i != nodes) || (j != 3))))
				{
					if(Code[1]> 0)
					{
						temp = F[1];
						F[1] = Bc[3*i];
						Bc[3*i] = temp;
					}
					else
						Bc[3*i] = Bc[1];
				}
				else
				{
					if(!((i == 1) || (j > 1) || (Code[3*i-3] == 1)))
						Bc[3*i-2] = Bc[3*i-3];
					else
					{
						temp = F[2*i-2+j];
						F[2*i-2+j] = Bc[3*i-3+j];
						Bc[3*i-3+j] = temp;
					}
				}
			}
		}
	}
			
				
						
	
/*[ Compute the values of the potential and the fluxes at interior points ]*/

	if(L)
	{
		for(k=1;k<=L;k++)
		{
			u[k] = 0.0;
			qx[k] = 0.0;
			qy[k] = 0.0;
			for(i=1;i<=nodes;i++)
			{
				Quad3(Xi[k],Yi[k],X[2*i-1],Y[2*i-1],X[2*i],Y[2*i],
						 X[2*i+1],Y[2*i+1],Hw,Gw,Dq1,Dq2,Du1,Du2,1);
				for(j=1;j<=3;j++)
				{
					ij2 = 2*i-2+j;
					if(ij2 > (2*nodes))
						ij2 = j -2;
					u[k] 	 += Gw[j]*Bc[3*i-3+j]-Hw[j]*F[ij2];
					qx[k] += Du1[j]*Bc[3*i-3+j]-Dq1[j]*F[ij2];
					qy[k] += Du2[j]*Bc[3*i-3+j]-Dq2[j]*F[ij2];
				}
			}

			u[k] /= (2*pi);
			qx[k] /= (2*pi);
			qy[k] /= (2*pi);
		}
	}
}
	

#include "cbox3.h"

void Out3(X,Y,F,Bc,Xi,Yi,u,qx,qy)

float X[102],Y[102],F[101],Bc[151],Xi[21],Yi[21];
float u[21],qx[21],qy[21];
{
	FILE *outfile;
	int i,j,k,nodes;
	
	nodes = N/2;
	
	outfile = fopen(outname,"a");
		
	fprintf(outfile," \nResults \n\n");
	

	
		fprintf(outfile,"\n%10.4f \t %10.4f \t %10.4f \t %10.4f \t %10.4f\n",
					X[1],Y[1],F[1],Bc[3*nodes],Bc[1]);
		fprintf(outfile,"%10.4f \t %10.4f \t %10.4f \t %10.4f \t %10.4f\n",
					X[2],Y[2],F[2],Bc[2],Bc[2]);
					
		
		for(i=2;i<=nodes;i++)
		{
			fprintf(outfile,"%10.4f \t %10.4f \t %10.4f \t %10.4f \t %10.4f\n",
					X[2*i-1],Y[2*i-1],F[2*i-1],Bc[3*i-3],Bc[3*i-2]);
			fprintf(outfile,"%10.4f \t %10.4f \t %10.4f \t %10.4f \t %10.4f\n",
					X[2*i],Y[2*i],F[2*i],Bc[3*i-1],Bc[3*i-1]);
		}	
	if(L)
	{
		fprintf(outfile,"\n\n\n		interior Points \n\n");
		fprintf(outfile,"          (Xi,Yi)              u         q_x       q_y\n");
		for(k=1;k<=L;k++)
			fprintf(outfile,"(%10.4f, %10.4f) %10.4f %10.4f %10.4f\n",
						Xi[k],Yi[k],u[k],qx[k],qy[k]);
	}
		
	 
	fclose(outfile);
}  
		  


#include "cbox3.h"
void Quad3(Xp,Yp,X1,Y1,X2,Y2,X3,Y3,Hw,Gw,Dq1,Dq2,Du1,Du2,K)
	float Xp,Yp,X1,Y1,X2,Y2,X3,Y3,Hw[4],Gw[4];
	float Dq1[4],Dq2[4],Du1[4],Du2[4];
	int K;
{
    
/*[This program Computes the matrices Hw and Gw which relate a node (Xp,Yp) with a boundary element using Gauss Quadrature. For k=1, it also computes the matrices Dq1,Dq2,Du1,Du2 which relate an interior point with a boundary element and are needed for computation of the interior flux values.
		
		Ra 		= Radius
		rx,ry,rn	= Radius Derivatives 
		nx,ny 		= Components of the unit Normal to the element
		Xg,Yg		= Integration Point along the element
		J		= Jocobian
]*/

const float z[] = {0.0,0.9739065285,-0.9739065285,0.8650633666,-0.8650633666,
					0.6794095683,-0.6794095682,0.4333953941,-0.4333953941,
					0.1488743389,-0.1488743389};
const float W[] = {0.0,0.0666713443,0.0666713443,0.1494513491,0.1494513491,
					0.2190863625,0.2190863625,0.2692667193,0.2692667193,
					0.2955242247,0.2955242247};
float A,B,C,D,phi[4],Xg,Yg,J,nx,ny,Ra,rx,ry,rn;
int i,j,k;


	for(i=1;i<=3;i++)
	{
		Hw[i] = 0.0;
		Gw[i] = 0.0;
		Dq1[i] = 0.0;
		Dq2[i] = 0.0;
		Du1[i] = 0.0;
		Du2[i] = 0.0;
	}
	A = X3 - 2*X2 + X1;
	B = (X3-X1)/2.0;
	C = Y3-2*Y2+Y1;
	D = (Y3 - Y1)/2.0;
	
	for(i=1;i<=10;i++)
	{
/*[Compute the values of the shape functions at the integration points  ]*/
		phi[1] = z[i]*(z[i]-1)*0.5;
		phi[2] = 1.0 - z[i]*z[i];
		phi[3] = z[i]*(z[i]+1)*0.5;
		
/*[Compute geometrical properties at integration points   ]*/
		Xg = X1*phi[1]+X2*phi[2]+X3*phi[3];
		Yg = Y1*phi[1]+Y2*phi[2]+Y3*phi[3];
		J = sqrt(((z[i]*A+B)*(z[i]*A+B))+((z[i]*C+D)*(z[i]*C+D)));
		nx = (z[i]*C+D)/J;
		ny = -(z[i]*A+B)/J;
		Ra = sqrt(((Xp - Xg)*(Xp - Xg)) + ((Yp - Yg)*(Yp - Yg)));
		rx = (Xg-Xp)/Ra;
		ry = (Yg-Yp)/Ra;
		rn = rx*nx+ry*ny;

/*[Compute the matrices Gw, Hw, Dq1, Dq2, Du1, and Du2 	]*/

		for(j=1;j<=3;j++)
		{
			if(K>0)
			{
				Du1[j] += rx*W[i]*J*phi[j]/Ra;
				Du2[j] += ry*W[i]*J*phi[j]/Ra;
				Dq1[j] -= ((2.0*sq(rx)-1.0)*nx+2.0*rx*ry*ny)*
							W[i]*J*phi[j]/sq(Ra);
				Dq2[j] -=  ((2.0*sq(ry)-1.0)*ny+2.0*rx*ry*nx)*
							W[i]*J*phi[j]/sq(Ra);
			}
			Gw[j] += log(1.0/Ra)*W[i]*J*phi[j];	
			Hw[j] -= rn/Ra*W[i]*J*phi[j];
		}
	}
				
}



#include "cbox3.h"


/*[ The routine Solve computes the solution of the linear systems of equations  A X = F by the Gauss Elimination method providing for interchanging rows when encountering a zero diagonal coeficient.

A : system Matrix
B:  Originally it contains the Independent coefficients.  After solutions it
	contains the values of the system unknowns.                            				   				
N:  Actual number of unknowns.
Dim: Row and Column Dimension of A.
 
]*/


void Solve(A,B,D,N,Dim)

	float A[100][100],B[101],*D;  /*[ D is assigned some value here ]*/
  	int N,Dim;

{
	int N1,i,j,k,i1,l,k1,found;
	float c;
	
/*[ found is a flag which is used to check if any nonzero coefficient is found ]*/	
	
	
	N1 = N - 1;

	for(k=1;k<=N1;k++)
	{
		k1 = k + 1;
		c = A[k][k];
		
		if( (fabs(c) - tol) <=0 )
		{
			found = 0;
			for(j=k1;j<=N;j++)  
/*[Try to interchange rows to get nonzero coefficient  ]*/
	
	        {
            	if( (fabs(A[j][k]) - tol) > 0.0 ) 
                {
				 	for(l=k;l<=N;l++)
                    {
                     	c = A[k][l];
                        A[k][l] = A[j][l];
                        A[j][l] = c;
                     }
				  		c = B[k];
				  		B[k] = B[j];
				  		B[j] = c;
				  		c = A[k][k];
						found = 1;		
/*[ coeff is found ]*/
						break;
				}
			}
		 }

		if(!found)
		{
			printf("Singularity in Row %d \n",k);
	   		(*D) = 0.0;          
	    	return;   
/*[ If no coefficient is found ,the control is transferred to main ]*/
		}
	


/*[ Divide row by diagonal coefficient ]*/		

  		c = A[k][k];
		for(j = k1;j<=N;j++)
		   A[k][j] /= c;
		B[k] /= c;  
 
/*[ Eliminate unknown X[k] from row i ]*/

		for(i = k1;i<=N; i++)
		{
		  c = A[i][k];
		  for(j = k1;j<= N;j++)
		 	A[i][j] -= c*A[k][j];
		  B[i] -= c*B[k];
		}
	}
/*[ Compute the last unknown ]*/

	if((fabs(A[N][N]) - tol) > 0.0)
	{
	   B[N] /= A[N][N];

/*[Apply back substitution to compute the remaining unknowns  ]*/

	   for(l = 1;l<= N1;l++)
	   {
	      k = N - l;
	      k1 = k +1;
	      for(j = k1;j<=N;j++)
			B[k] -= A[k][j]*B[j];
	   }
/*[Compute the value of the determinent ]*/

	(*D) = 1.0;
	for(i=1;i<=N;i++)
	  (*D) *= A[i][i];

   }
  else
  {
  		printf("Singularity in Row %d \n",k);
	   	(*D) = 0.0;
   }          

  return;	
}
	 
