#include "cboxe.h"

main()
{
	float G[101][151],H[101][101];
	float X[52],Y[52];
	float F[151],Bc[101],Xi[21],Yi[21],stress[61],dis[41];
	int Code[151],Dim,thrice,NN,D,i;
	
	
/*[Set maximum dimension of the system of equations

	Dim  = 2 * Maximum number of nodes = 4 * Maximum number of elements
	thrice = 3 * Maximum number of nodes = 6 * Maximum number of elements
]*/

	
	Dim = 100;
	thrice = 150;
	
	
/*[Read Data ]  */
		Input12(Xi,Yi,X,Y,Code,F);
		
/*[Compute G and H matrices and Form Syestem (A X = F)  ]*/
	Sys12(X,Y,G,H,Bc,F,Code,Dim,thrice);
		
		/*[for(i=1;i<=N;i++)
			printf(" %f : %f \n",H[i][i],Bc[i]); ]*/

/*[Solve system of equations  A X = F  ]*/
		NN = 2*N;
		Solve(H,Bc,&D,NN,Dim);

/*[	Compute stress and displacementvalues at points   ]*/

	Inter12(Bc,F,Code,Xi,Yi,X,Y,stress,dis);	
	
/*[Print results at boundary nodes and interior points   ]*/

	Out12(X,Y,Bc,F,Xi,Yi,stress,dis);
}		

	
	
#include "cboxe.h"

void Quad12(Xp,Yp,X1,Y1,X2,Y2,X3,Y3,Hw,Gw)
float Xp,Yp,X1,Y1,X2,Y2,X3,Y3;
float Gw[3][7],Hw[3][7];
{
const float z[] = {0.0,0.9739065285,-0.9739065285,0.8650633666,-0.8650633666,
					0.6794095683,-0.6794095682,0.4333953941,-0.4333953941,
					0.1488743389,-0.1488743389};
const float W[] = {0.0,0.0666713443,0.0666713443,0.1494513491,0.1494513491,
					0.2190863625,0.2190863625,0.2692667193,0.2692667193,
					0.2955242247,0.2955242247};
float A,B,C,D,Denom,phi1,phi2,phi3,Xg,Yg,J,nx,ny,Ra,rx,ry,rn;
int i,j,k;



	for(i=1;i<=2;i++)
	{
		for(j=1;j<=6;j++)
		{
			Hw[i][j] = 0.0;
			Gw[i][j] = 0.0;
		}
	}
	
	A = X3-2*X2+X1;
	B = (X3-X1)/2.0;
	C = Y3-2*Y2+Y1;
	D = (Y3-Y1)/2.0;
	Denom = 4*pi*(1-nu);
	
	for(i=1;i<=10;i++)
	{

/*[Compute the values of the shape functions at the integration points   ]*/
		phi1 = z[i]*(z[i] - 1.0)*0.5;
		phi2 = 1.0 - z[i]*z[i];
		phi3 = z[i]*(z[i] + 1.0)*0.5;

/*[Compute geometrical properties at the integration points    ]*/
	
		Xg = X1*phi1+X2*phi2+X3*phi3;
		Yg = Y1*phi1+Y2*phi2+Y3*phi3;
		J = sqrt(SQ(z[i]*A+B) + 	SQ(z[i]*C+D));
		nx= (z[i]*C+D)/J;
		ny = -(z[i]*A+B)/J;
		Ra = sqrt(SQ(Xp-Xg) + SQ(Yp-Yg));
		rx = (Xg-Xp)/Ra;
		ry = (Yg-Yp)/Ra;
		rn = rx*nx + ry*ny;
		
/*[Compute the matrices Gw and Hw ]*/
		Gw[1][1] += ((3-4*nu)*log(1.0/Ra)+SQ(rx))*W[i]*J*phi1/(2*Denom*mu);
		Gw[1][2] += rx*ry*W[i]*J*phi1/(2*Denom*mu);
		Gw[2][1] = Gw[1][2];
		Gw[2][2] += ((3-4*nu)*log(1.0/Ra)+SQ(ry))*W[i]*J*phi1/(2*Denom*mu);
		Hw[1][1] -= rn*((1-2*nu)+2*SQ(rx))/(Ra*Denom)*W[i]*J*phi1;
		Hw[1][2] -= (rn*2*rx*ry+(1-2*nu)*(nx*ry-ny*rx))*W[i]*
						J*phi1/(Ra*Denom);
		Hw[2][1] -= (rn*2*rx*ry+(1-2*nu)*(ny*rx-nx*ry))*W[i]*
						J*phi1/(Ra*Denom);
		Hw[2][2] -= rn*((1-2*nu)+2*SQ(ry))*W[i]*J*phi1/(Ra*Denom);
		Gw[1][3] += ((3-4*nu)*log(1.0/Ra)+SQ(rx))*W[i]*J*phi2/(2*Denom*mu);
		Gw[1][4] += rx*ry*W[i]*J*phi2/(2*Denom*mu);
		Gw[2][3] = Gw[1][4];
		Gw[2][4] += ((3-4*nu)*log(1.0/Ra)+SQ(ry))*W[i]*J*phi2/(2*Denom*mu);
		Hw[1][3] -= rn*((1-2*nu)+2*SQ(rx))/(Ra*Denom)*W[i]*J*phi2;
		Hw[1][4] -= (rn*2*rx*ry+(1-2*nu)*(nx*ry-ny*rx))*W[i]*
						J*phi2/(Ra*Denom);
		Hw[2][3] -= (rn*2*rx*ry+(1-2*nu)*(ny*rx-nx*ry))*W[i]*
						J*phi2/(Ra*Denom);
		Hw[2][4] -= rn*((1-2*nu)+2*SQ(ry))*W[i]*J*phi2/(Ra*Denom);
		Gw[1][5] += ((3-4*nu)*log(1.0/Ra)+SQ(rx))*W[i]*J*phi3/(2*Denom*mu);
		Gw[1][6] += rx*ry*W[i]*J*phi3/(2*Denom*mu);
		Gw[2][5] = Gw[1][6];
		Gw[2][6] += ((3-4*nu)*log(1.0/Ra)+SQ(ry))*W[i]*J*phi3/(2*Denom*mu);
		Hw[1][5] -= rn*((1-2*nu)+2*SQ(rx))/(Ra*Denom)*W[i]*J*phi3;
		Hw[1][6] -= (rn*2*rx*ry+(1-2*nu)*(nx*ry-ny*rx))*W[i]*
						J*phi3/(Ra*Denom);
		Hw[2][5] -= (rn*2*rx*ry+(1-2*nu)*(ny*rx-nx*ry))*W[i]*
						J*phi3/(Ra*Denom);
		Hw[2][6] -= rn*((1-2*nu)+2*SQ(ry))*W[i]*J*phi3/(Ra*Denom);
	}
}



#include "cboxe.h"


void Input12(Xi,Yi,X,Y,Code,F)
	float X[52],Y[52],F[151],Xi[21],Yi[21];
	int Code[151];
{
	FILE  *infile, *outfile;
	int i,j,k,Ne,lnsize = 100;
	char Title[80],line1[100]; 
	
/*[	Ne  = Number of Boundary Elements
	L   = Number of interior Points
	mu  = Shear Modulus
	nu  = Shear Modulus        ]*/

printf("Enter the Title of your project:");
        scanf( "%s", Title); 
		printf("\nNOTE: FIRST LINE IN THE INPUT FILE SHOULD BE EITHER BLANK OR THE Title NOT DATA \n"); 
        printf("\n Enter the name of the input file:");
        scanf("%s", inname);
        printf("\n Enter the name of the output file:");
        scanf("%s", outname);
        printf("\n");
       
        infile = fopen(inname, "r" );
        outfile = fopen(outname,"w" );
		
		fgets(line1,lnsize,infile);
		fprintf(outfile," \n %s \n DATA \n\n",line1);

/*[Read the number of boundary elements and interior points     ]*/

		fscanf(infile,"%d %d %f %f",&Ne,&L,&mu,&nu);
		fprintf(outfile,"\nNumber of Boundary Elements = %d \n",Ne); 
		fprintf(outfile,"Number of interior Points = %2d \n",L);
		fprintf(outfile,"Shear Modulus = %10.3f \n",mu);
		fprintf(outfile,"Poisson Ratio = %10.3f \n \n",nu);
		
		N = 2*Ne;
		
/*[Read coordinates of boundary nodes   ]*/

	fprintf(outfile,"Bondary Nodes Coordinates \n \n");
	fprintf(outfile,"Node	        X               Y \n");
	for(i=1;i<=N;i++)
	{
		fscanf(infile,"%f %f",&X[i],&Y[i]);
		fprintf(outfile," %2d \t %10.3f \t %10.3f \n",i,X[i],Y[i]); 
	}
	
/*[Read boundary conditions in F vector.  If Code[i] = 0, the the F[i] value is a preassigned  displacement;   if Code[i] = 1, then the F[i] value is a preassigned traction.
Six boundary conditions are read per element.
Nodes between two elements may have two different values of the traction but only one value of the displacement. 
]*/


	fprintf(outfile," \n \n \n");
	fprintf(outfile,"Boundary Conditions \n \n");
	fprintf(outfile," 								Prescribed Values \n");
	fprintf(outfile," 	  -----First Node-----	   ----Second Node----	   -----Third Node----\n");
	fprintf(outfile," Ele  X Dir	  C   Y Dir   C   X Dir	  C   Y Dir   C   X Dir	  C   Y Dir   C \n");

	for(i=1;i<=Ne;i++)
	{
		fprintf(outfile," %2d ",i);
		for(j=1;j<=6;j++)
		{
			fscanf(infile,"%d %f",&Code[6*i-6+j],&F[6*i-6+j]);
			fprintf(outfile,"%8.3f %2d ",F[6*i-6+j],Code[6*i-6+j]);
		}
		fprintf(outfile,"\n");
	}
	
	fprintf(outfile," \n \n \n");
	
	if(L)
	{
		for(i=1;i<=L;i++)
			fscanf(infile,"%f %f",&Xi[i],&Yi[i]);
	}
	for(i=1;i<=80;i++)
		fprintf(outfile,"*");
	fclose(infile);
	fclose(outfile);
}
	
		 
		



#include "cboxe.h"

void Sys12(X,Y,G,H,Bc,F,Code,Dim,thrice)
	float G[101][151],H[101][101];
	float X[52],Y[52];
	float F[151],Bc[101];
	int Code[151],Dim,thrice;
{
	float Hw[3][7],Gw[3][7],temp;
	int i,j,k,NN,Node,ll;
	
	NN = 2*N;
	Ne = N/2;
	
	for(i=1;i<=NN;i++)
	{
		for(j=1;j<=NN;j++)
			H[i][j] = 0.0;
		for(j=1;j<=3*N;j++)
			G[i][j] = 0.0;
	}
	
	X[N+1] = X[1];
	Y[N+1] = Y[1];
	
/*[Compute the matrices Gw and Hw for each collacation point and each boundary 
	element   ]*/

	for(ll=1;ll<=N;ll++)
	{
		for(i=1;i<=N-1;i = i+2)	
		{
			if((ll-i)*(ll-i-1)*(ll-i-2)*(ll-i+N-2)!= 0)
				Quad12(X[ll],Y[ll],X[i],Y[i],X[i+1],Y[i+1],
				X[i+2],Y[i+2],Hw,Gw);
			else
			{
				Node = ll-i+1;
				if((ll == 1) && (i == N-1))
					Node += N;
				Quad12(X[ll],Y[ll],X[i],Y[i],X[i+1],Y[i+1],
				X[i+2],Y[i+2],Hw,Gw);
				Diag12(X[i],Y[i],X[i+1],Y[i+1],X[i+2],Y[i+2],Gw,Node);
			}
	
	
/*[Substitute the matrices Gw and Hw into the matrices G and H  ]*/
	
			for(k=1;k<=2;k++)
			{
				for(j=1;j<=6;j++)
				{
					G[2*ll-2+k][3*i-3+j] += Gw[k][j];
					if((i-N+1))
						H[2*ll-2+k][2*i-2+j] += Hw[k][j];
					else
					{
						if((j-5) >= 0)
							H[2*ll-2+k][j-4] += Hw[k][j];
						else
							H[2*ll-2+k][2*i-2+j] += Hw[k][j];
					}
				}
			}
		}
	}						
				
	for(i=1;i<=N;i++)	
	{
		H[2*i-1][2*i-1] = 0.0;
		H[2*i][2*i-1] = 0.0;
		H[2*i-1][2*i] = 0.0;
		H[2*i][2*i] = 0.0;
		for(j=1;j<=N;j++)
		{
			if(i != j)
			{
				H[2*i-1][2*i-1] -= H[2*i-1][2*j-1];
				H[2*i][2*i-1] -= H[2*i][2*j-1];
				H[2*i-1][2*i] -= H[2*i-1][2*j];
				H[2*i][2*i] -= H[2*i][2*j];
			}
		}

/*[Add one to the diagonal coefficients for exterior problems	]*/

		if(H[2*i-1][2*i-1] < 0.0)
		{
			H[2*i-1][2*i-1] += 1.0;
			H[2*i][2*i] += 1.0;
		}
	}
	
/*[Reorder the columns of the system A X = F  with the boundary conditions and form the system matrix A which is stored in H   ]*/


	for(i=1;i<=Ne;i++)
	{
		for(j=1;j<=6;j++)
		{
			if(Code[6*i-6+j] <= 0)
			{
				if(((i-Ne) != 0) || (j < 5))
				{
					if((i == 1) || (j > 2) || (Code[6*i-8+j] == 1))
					{
						for(k=1;k<=NN;k++)
						{
							temp = H[k][4*i-4+j];
							H[k][4*i-4+j] = -G[k][6*i-6+j]*mu;
							G[k][6*i-6+j] = -temp;
						}
					}
					else
					{
						for(k=1;k<=NN;k++)
						{
							H[k][4*i-4+j] -= G[k][6*i-6+j]*mu;
							G[k][6*i-6+j] = 0.0;
						}
					}
				}
				else
				{
					if(Code[j-4] > 0)
					{
						for(k=1;k<=NN;k++)
						{
							temp = H[k][j-4];
							H[k][j-4] = -G[k][6*i-6+j]*mu;
							G[k][6*i-6+j] = -temp;
						}
					}
					else
					{
						for(k=1;k<=NN;k++)
						{
							H[k][j-4] -= G[k][6*i-6+j]*mu;
							G[k][6*i-6+j] = 0.0;
						}
					}
				}
			}
		}
	}
	
/*[Form the right sideide vector F which is stored in Bc ]*/
	
	for(i=1;i<=NN;i++)
	{
		Bc[i] = 0.0;
		for(j=1;j<=6*Ne;j++)
			Bc[i] += G[i][j]*F[j];
	}
}
					
					
#include "cboxe.h"

/*[This function computes the values of the stresses and displacements at
 	the interior points.   ]*/

void Inter12(Bc,F,Code,Xi,Yi,X,Y,stress,dis)
float Bc[101],F[151],Xi[21],Yi[21],X[52],Y[52],stress[61],dis[41];
int Code[151];
{
	float Hw[3][7],Gw[3][7],dxx[7],dxy[7],dyy[7],sxx[7],sxy[7],syy[7],temp;
	int i,j,k,ij4;
	
	
/*[Rearrange the arrays Bc and F to store all the values of the displacement in Bc and all the values traction in F   ]*/

	for(i=1;i<=Ne;i++)
	{
		for(j=1;j<=6;j++)
		{
			if(Code[6*i-6+j] <= 0)
			{
				if(((i-Ne) != 0) || (j < 5))
				{
					if((i == 1) || (j > 2) || (Code[6*i-8+j] == 1))
					{
						temp = Bc[4*i-4+j]*mu;
						Bc[4*i-4+j] = F[6*i-6+j];
						F[6*i-6+j] = temp;
					}
					else
						F[6*i-6+j] = F[6*i-8+j];
				}
				else
				{
					if(Code[j-4] > 0)
					{
						temp = Bc[j-4]*mu;
						Bc[j-4] = F[6*i-6+j];
						F[6*i-6+j] = temp;
					}
					else
						F[6*i-6+j]=F[j-4];
						
					}
				}
			}
		}
	
	
/*[Compute the values of stresses and displacements   ]*/

	if(L)
	{
		for(k=1;k<=L;k++)
		{
			stress[3*k-2] = 0.0;
			stress[3*k-1] = 0.0;
			stress[3*k] = 0.0;
			dis[2*k-1] = 0.0;
			dis[2*k] = 0.0;
			for(i=1;i<=Ne;i++)
			{
				Quad12(Xi[k],Yi[k],X[2*i-1],Y[2*i-1],X[2*i],Y[2*i],
					X[2*i+1],Y[2*i+1],Hw,Gw);
				Stress12(Xi[k],Yi[k],X[2*i-1],Y[2*i-1],X[2*i],Y[2*i],
					X[2*i+1],Y[2*i+1],dxx,dxy,dyy,sxx,sxy,syy);
				for(j=1;j<=6;j++)
				{
					ij4 = 4*i-4+j;
					if(ij4 > (4*Ne))
						ij4 = j-4;
					stress[3*k-2] += dxx[j]*F[6*i-6+j]-sxx[j]*Bc[ij4];
					stress[3*k-1] += dxy[j]*F[6*i-6+j]-sxy[j]*Bc[ij4];
					stress[3*k]   += dyy[j]*F[6*i-6+j]-syy[j]*Bc[ij4];
					dis[2*k-1] += Gw[1][j]*F[6*i-6+j]-Hw[1][j]*Bc[ij4];
					dis[2*k]   += Gw[2][j]*F[6*i-6+j]-Hw[2][j]*Bc[ij4];
				}
			}
		}
	}
}


#include "cboxe.h"

void Diag12(XG1,YG1,XG2,YG2,XG3,YG3,Gw,Node)
float XG1,YG1,XG2,YG2,XG3,YG3,Gw[3][7];
int Node;
{
const float z[] =  {0.0,0.9739065285,-0.9739065285,0.8650633666,-0.8650633666,
					 0.6794095683,-0.6794095682,0.4333953941,-0.4333953941,
					 0.1488743389,-0.1488743389};
const float W[] = {0.0,0.0666713443,0.0666713443,0.1494513491,0.1494513491,
					 0.2190863625,0.2190863625,0.2692667193,0.2692667193,
					 0.2955242247,0.2955242247};
const float zln[] = {0.0,0.0090426309,0.0539712662,0.1353118246,0.2470524162,
					  0.3802125396,0.5237923179,0.6657752055,0.7941904160,
					  0.8981610912,0.9688479887};
const float Wln[] = {0.0,0.1209551319,0.1863635425,0.1956608732,0.1735771421,
						0.1356956729,0.0936467585,0.0557877273,0.0271598109,
						0.0095151826,0.0016381576};

	float A1,B1,A2,B2,phi3,phi2,phi1,phil3,phil2,phil1,philn3,philn2,philn1,T1,T2,T3,A,B,C;
	float X3,Y3,X2,Y2,X1,Y1,J11,J1,J2,xln,S3,S2,S1,Den,Fac1,Fac2;
	int i,j,I;
	
	
	if(Node == 1)
	{
		X3 = XG3-XG1;
		Y3 = YG3-YG1;
		X2 = XG2-XG1;
		Y2 = YG2-YG1;
		A1 = (X3-2*X2)*0.5;
		B1 = X2;
		A2 = (Y3-2*Y2)*0.5;
		B2 = Y2;
	}
	else if(Node == 2)
	{
		X3 = XG3-XG2;
		Y3 = YG3-YG2;
		X1 = XG1-XG2;
		Y1 = YG1-YG2;
		A1 = X1 + X3;
		B1 = X3 - X1;
		A2 = Y1 + Y3;
		B2 = Y3 - Y1;
	}
	else if(Node == 3)
	{
		X2 = XG2-XG3;
		Y2 = YG2-YG3;
		X1 = XG1-XG3;
		Y1 = YG1-YG3;
		A1 = (X1-2*X2)*0.5;
		B1 = -X2;
		A2 = (Y1-2*Y2)*0.5;
		B2 = -Y2;
	}
	
	for(i=1;i<=2;i++)
		for(j=1;j<=6;j++)
			Gw[i][j] = 0.0;
	
	A = A1*A1 + A2*A2;
	B = 2*(A1*B1 + A2*B2);
	C = B1*B1 + B2*B2;
	Fac1 = (3-4*nu)/(8.0 * pi * mu * (1-nu));
	Fac2 = Fac1/(3 - 4*nu);

	for(I=1;I<=10;I++)
	{
		Den = SQ(A1*z[I]+B1)+ SQ(A2*z[I]+B2);
		T1 = SQ(A1*z[I]+B1)/Den;
		T2 = SQ(A2*z[I]+B2)/Den;
		T3 = (A1*z[I]+B1)*(A2*z[I]+B2)/Den;
		
/*[Compute the shape functions for Gauss quadrature   ]*/

	phi3 = 0.5*z[I]*(z[I] + 1.0);
	phi2 = 1.0 - SQ(z[I]);
	phi1 = 0.5*z[I]*(z[I] - 1.0);
	phil3 = zln[I]*(2.0*zln[I] - 1.0);
	phil2 = 4.0 * zln[I] * (1.0 - zln[I]);
	phil1 = (zln[I] - 1.0)*(2.0*zln[I] - 1.0);
	philn3 = 0.5*zln[I]*(zln[I]+1.0);
	philn2 = 1.0 - SQ(zln[I]);
	philn1 = 0.5*zln[I]*(zln[I] - 1.0);
	
/*[Compute the coefficients of Gw  ]*/

	if(Node == 1)
	{
	J1=sqrt(SQ(4*A1*zln[I]-2*A1+0.5*X3)+SQ(4*A2*zln[I]-2*A2+0.5*Y3))*2;
		J2 = sqrt(SQ(A1*z[I]*2+0.5*X3)+SQ(A2*z[I]*2+0.5*Y3));
		xln = -log(2*sqrt(SQ(z[I]*A1+B1) + SQ(z[I]*A2+B2)));
		S3 = Fac1*(phil3*J1*Wln[I]+phi3*J2*xln*W[I]);
		S2 = Fac1*(phil2*J1*Wln[I]+phi2*J2*xln*W[I]);
		S1 = Fac1*(phil1*J1*Wln[I]+phi1*J2*xln*W[I]);
	}
	else if(Node == 2)
	{
		J1 =  sqrt(SQ(0.5*B1-A1*zln[I]) + SQ(0.5*B2-A2*zln[I]));
		J11 = sqrt(SQ(0.5*B1+A1*zln[I]) + SQ(0.5*B2+A2*zln[I]));
		J2 =  sqrt(SQ(0.5*B1+A1*z[I]) + SQ(0.5*B2+A2*z[I]));
		xln = -0.5*log(SQ(z[I]*A1*0.5+B1*0.5)+SQ(z[I]*A2*0.5+B2*0.5));
		S3 = Fac1*((philn1*J1+philn3*J11)*Wln[I]+phi3*J2*xln*W[I]);
		S2 = Fac1*(philn2*(J1+J11)*Wln[I]+phi2*J2*xln*W[I]);
		S1 = Fac1*((philn3*J1+philn1*J11)*Wln[I]+phi1*J2*xln*W[I]);
	}
	else if(Node == 3)
	{
		J1 = sqrt(SQ(2*A1-4*A1*zln[I]-0.5*X1)+SQ(2*A2-4*A2*zln[I]-0.5*Y1))*2;
		J2 = sqrt(SQ(2*A1*z[I]-0.5*X1)+SQ(2*A2*z[I]-0.5*Y1)); 
		xln  = -log(2*sqrt(SQ(A1*z[I]+B1) + SQ(A2*z[I]+B2)));
		S3 = Fac1*(phil1*J1*Wln[I]+phi3*J2*xln*W[I]);
		S2 = Fac1*(phil2*J1*Wln[I]+phi2*J2*xln*W[I]);
		S1 = Fac1*(phil3*J1*Wln[I]+phi1*J2*xln*W[I]);
	}
	
	Gw[1][5] += S3+Fac2*phi3*T1*J2*W[I];
	Gw[1][3] += S2+Fac2*phi2*T1*J2*W[I];
	Gw[1][1] += S1+Fac2*phi1*T1*J2*W[I];
	Gw[1][6] += Fac2*T3*J2*phi3*W[I];
	Gw[1][4] += Fac2*T3*J2*phi2*W[I];		
	Gw[1][2] += Fac2*T3*J2*phi1*W[I];
	Gw[2][5] = Gw[1][6];
	Gw[2][3] = Gw[1][4];
	Gw[2][1] = Gw[1][2];
	Gw[2][6] += S3+Fac2*T2*J2*phi3*W[I];
	Gw[2][4] += S2+Fac2*T2*J2*phi2*W[I];
	Gw[2][2] += S1+Fac2*T2*J2*phi1*W[I];
	}
}
			

		
				
#include "cboxe.h"

void Out12(X,Y,Bc,F,Xi,Yi,stress,dis)
float X[52],Y[52],Bc[101],F[151],Xi[21],Yi[21],stress[61],dis[41];
{
	int i,j,k;
	FILE *outfile;
	
/*[This subroutine prints the values of the displacements and tractions at boundary nodes, and at the interior points ]*/

	outfile = fopen(outname,"a");
	
	fprintf(outfile," \nResults \n\n");
	fprintf(outfile,"BOUNDARY NODES  \n \n");
	fprintf(outfile,"ELE		    X				Y		 Displacement X   Displacement Y \n \n");
 	
	
	for(i=1;i<=N;i++)
		fprintf(outfile,"%2d \t %10.3f \t %10.3f \t %10.3f \t %10.3f \n",i,X[i],Y[i],Bc[2*i-1],Bc[2*i]);
		
	fprintf(outfile," \n\n\n");

	fprintf(outfile,"\n						 Traction X   Traction Y   Traction X   Traction Y \n");
	fprintf(outfile,"	   X          Y      BEFORE NODE  BEFORE NODE  AFTER NODE   AFTER NODE \n \n");
	fprintf(outfile,"%10.3f %10.3f  %10.3f  %10.3f  %10.3f  %10.3f \n",X[1],Y[1],F[6*Ne-1],F[6*Ne],F[1],F[2]);
	fprintf(outfile,"%10.3f %10.3f  %10.3f  %10.3f  %10.3f  %10.3f \n",X[2],Y[2],F[3],F[4],F[3],F[4]);  
	
	for(i=2;i<=Ne;i++)
	{
			fprintf(outfile,"%10.3f %10.3f  %10.3f  %10.3f  %10.3f  %10.3f \n",X[2*i-1],Y[2*i-1],F[6*i-7],F[6*i-6],F[6*i-5],F[6*i-4]);
			fprintf(outfile,"%10.3f %10.3f  %10.3f  %10.3f  %10.3f  %10.3f \n",X[2*i],Y[2*i],F[6*i-3],F[6*i-2],F[6*i-3],F[6*i-2]); 
	}
	
	fprintf(outfile," \n\n\n");
	
	if(L)
	{
		fprintf(outfile,"interior POINT DISPLACAEMENTS \n \n");
		fprintf(outfile,"	   X            Y         DISPLACEMENT X    DISPLACEMENT Y \n");
		for(i=1;i<=L;i++)
			fprintf(outfile,"%10.3f \t %10.3f \t %10.3f \t %10.3f \n",Xi[i],Yi[i],dis[2*i-1],dis[2*i]);
		
		fprintf(outfile," \n\n\n");
		
		fprintf(outfile,"interior POINT STRESSES \n \n");
		fprintf(outfile,"	   X          Y       SIGMA X     TAU XY   SIGMA Y \n");
		for(i=1;i<=L;i++) 
			fprintf(outfile,"%10.3f %10.3f %10.3f %10.3f %10.3f \n",Xi[i],Yi[i],stress[3*i-2],stress[3*i-1],stress[3*i]);
	}
	fprintf(outfile," \n\n\n");
	for(i=1;i<=80;i++)
		fprintf(outfile,"*");
	fclose(outfile);
}

			
			
		#include "cboxe.h"

void Stress12(Xp,Yp,X1,Y1,X2,Y2,X3,Y3,dxx,dxy,dyy,sxx,sxy,syy)
float Xp,Yp,X1,Y1,X2,Y2,X3,Y3;
float dxx[7],dxy[7],dyy[7],sxx[7],sxy[7],syy[7];

{

/*[	This Subroutine computes the values of the S and D matrices using Gauss 
	Quadrature in order to compute he stress at any Interna point.
]*/

const float z[] =  {0.0,0.9739065285,-0.9739065285,0.8650633666,-0.8650633666,
					 0.6794095683,-0.6794095682,0.4333953941,-0.4333953941,
					 0.1488743389,-0.1488743389};
const float W[] = {0.0,0.0666713443,0.0666713443,0.1494513491,0.1494513491,
					 0.2190863625,0.2190863625,0.2692667193,0.2692667193,
					 0.2955242247,0.2955242247};

	float A,B,C,D,Denom,factor1,factor2,phi1,phi2,phi3,Xg,Yg,J,nx,ny,Ra,rx,ry,rn;
	int i,j,k;

	for(j=1;j<=6;j++)
	{
		dxx[j] = 0.0;
		dxy[j] = 0.0;
		dyy[j] = 0.0;
		sxx[j] = 0.0;
		sxy[j] = 0.0;
		syy[j] = 0.0;
	}
	
	factor1 = 1-4*nu;
	factor2 = 1-2*nu;
	A = X3-2*X2+X1;
	B = (X3-X1)/2.0;
	C = Y3-2*Y2+Y1;
	D = (Y3-Y1)/2.0;
	Denom = 4*pi*(1-nu);

	for(i=1;i<=10;i++)
	{

/*[		Compute the values of the shape functions at the integration points 
]*/
		phi1 = z[i]*(z[i] - 1.0)*0.5;
		phi2 = 1.0 - (z[i]*z[i]);
		phi3 = z[i]*(z[i] + 1.0)*0.5;

/*[		Compute geometrical properties at the integration points
]*/
	
		Xg = X1*phi1+X2*phi2+X3*phi3;
		Yg = Y1*phi1+Y2*phi2+Y3*phi3;
		J = sqrt(SQ(z[i]*A+B) + 	SQ(z[i]*C+D));
		nx= (z[i]*C+D)/J;
		ny = -(z[i]*A+B)/J;
		Ra = sqrt(SQ(Xp-Xg) + SQ(Yp-Yg));
		rx = (Xg-Xp)/Ra;
		ry = (Yg-Yp)/Ra;
		rn = rx*nx + ry*ny;
		
/*[		Compute D and S coefficients
]*/

		dxx[1] += (factor2*rx+2*cube(rx))*W[i]*J*phi1/(Denom*Ra);
		dxx[2] += (2*SQ(rx)*ry-factor2*ry)*W[i]*J*phi1/(Denom*Ra);
		dxx[3] += (factor2*rx+2*cube(rx))*W[i]*J*phi2/(Denom*Ra);
		dxx[4] += (2*SQ(rx)*ry-factor2*ry)*W[i]*J*phi2/(Denom*Ra);
		dxx[5] += (factor2*rx+2*cube(rx))*W[i]*J*phi3/(Denom*Ra);
		dxx[6] += (2*SQ(rx)*ry-factor2*ry)*W[i]*J*phi3/(Denom*Ra);
		dxy[1] += (factor2*ry+2*SQ(rx)*ry)*phi1/(Denom*Ra)*W[i]*J;
		dxy[2] += (factor2*rx+2*rx*SQ(ry))*phi1/(Denom*Ra)*W[i]*J;
		dxy[3] += (factor2*ry+2*SQ(rx)*ry)*phi2/(Denom*Ra)*W[i]*J;
		dxy[4] += (factor2*rx+2*rx*SQ(ry))*phi2/(Denom*Ra)*W[i]*J;
		dxy[5] += (factor2*ry+2*SQ(rx)*ry)*phi3/(Denom*Ra)*W[i]*J;
		dxy[6] += (factor2*rx+2*rx*SQ(ry))*phi3/(Denom*Ra)*W[i]*J;
		dyy[1] += (2*SQ(ry)*rx-factor2*rx)*phi1/(Denom*Ra)*W[i]*J;
		dyy[2] += (factor2*ry+2*cube(ry))*phi1/(Denom*Ra)*W[i]*J;
		dyy[3] += (2*SQ(ry)*rx-factor2*rx)*phi2/(Denom*Ra)*W[i]*J;
		dyy[4] += (factor2*ry+2*cube(ry))*phi2/(Denom*Ra)*W[i]*J;
		dyy[5] += (2*SQ(ry)*rx-factor2*rx)*phi3/(Denom*Ra)*W[i]*J;
		dyy[6] += (factor2*ry+2*cube(ry))*phi3/(Denom*Ra)*W[i]*J;
		
		
		sxx[1] += (2*rn*(factor2*rx+nu*2*rx-4*cube(rx))+4*nu*nx*SQ(rx)+
					factor2*(2*nx*SQ(rx)+2*nx)-factor1*nx)*2*mu*phi1/(Denom*SQ(Ra))*
					W[i]*J;
		sxx[2] += (2*rn*(factor2*ry-4*SQ(rx)*ry)+4*nu*nx*rx*ry+
					factor2*2*ny*SQ(rx)-factor1*ny)*2*mu*phi1/(Denom*SQ(Ra))*
					W[i]*J;
		sxx[3] += (2*rn*(factor2*rx+nu*2*rx-4*cube(rx))+4*nu*nx*SQ(rx)+
					factor2*(2*nx*SQ(rx)+2*nx)-factor1*nx)*2*mu*phi2/(Denom*SQ(Ra))*
					W[i]*J;
		sxx[4] += (2*rn*(factor2*ry-4*SQ(rx)*ry)+4*nu*nx*rx*ry+
					factor2*2*ny*SQ(rx)-factor1*ny)*2*mu*phi2/(Denom*SQ(Ra))*
					W[i]*J;
		sxx[5] += (2*rn*(factor2*rx+nu*2*rx-4*cube(rx))+4*nu*nx*SQ(rx)+
					factor2*(2*nx*SQ(rx)+2*nx)-factor1*nx)*2*mu*phi3/(Denom*SQ(Ra))*
					W[i]*J;
		sxx[6] += (2*rn*(factor2*ry-4*SQ(rx)*ry)+4*nu*nx*rx*ry+
					factor2*2*ny*SQ(rx)-factor1*ny)*2*mu*phi3/(Denom*SQ(Ra))*
					W[i]*J;
		
		sxy[1] += (2*rn*(nu*ry-4*SQ(rx)*ry)+2*nu*(nx*ry*
					rx+ny*rx*rx)+factor2*(2*nx*rx*ry+ny))*2*mu*phi1/
					(Denom*SQ(Ra))*W[i]*J;
 
		sxy[2] += (2*rn*(nu*rx-4*rx*SQ(ry))+2*nu*(nx*SQ(ry)
					+ny*rx*ry)+factor2*(2*ny*rx*ry+nx))*2*mu*phi1/
					(Denom*SQ(Ra))*W[i]*J;
		
		sxy[3] += (2*rn*(nu*ry-4*SQ(rx)*ry)+2*nu*(nx*ry*
					rx+ny*rx*rx)+factor2*(2*nx*rx*ry+ny))*2*mu*phi2/
					(Denom*SQ(Ra))*W[i]*J;
		
		sxy[4] += (2*rn*(nu*rx-4*rx*SQ(ry))+2*nu*(nx*SQ(ry)
					+ny*rx*ry)+factor2*(2*ny*rx*ry+nx))*2*mu*phi2/
					(Denom*SQ(Ra))*W[i]*J;
		
		sxy[5] += (2*rn*(nu*ry-4*SQ(rx)*ry)+2*nu*(nx*ry*
					rx+ny*rx*rx)+factor2*(2*nx*rx*ry+ny))*2*mu*phi3/
					(Denom*SQ(Ra))*W[i]*J;
		
		sxy[6] += (2*rn*(nu*rx-4*rx*SQ(ry))+2*nu*(nx*SQ(ry)
					+ny*rx*ry)+factor2*(2*ny*rx*ry+nx))*2*mu*phi3/
					(Denom*SQ(Ra))*W[i]*J;
					
		syy[1] += (2*rn*(factor2*rx-4*rx*SQ(ry))+4*nu*ny*rx*ry+
					factor2*2*nx*SQ(ry)-factor1*nx)*2*mu*phi1/(Denom*SQ(Ra))*W[i]*J;
					
		
		syy[2] += (2*rn*(factor2*ry+2*nu*ry-4*cube(ry))+4*nu*ny*SQ(ry)+
					factor2*(2*ny*SQ(ry)+2*ny)-factor1*ny)*2*mu*phi1/
					(Denom*SQ(Ra))*W[i]*J;
					
		syy[3] += (2*rn*(factor2*rx-4*rx*SQ(ry))+4*nu*ny*rx*ry+
					factor2*2*nx*SQ(ry)-factor1*nx)*2*mu*phi2/(Denom*SQ(Ra))*W[i]*J;
					
		syy[4] += (2*rn*(factor2*ry+2*nu*ry-4*cube(ry))+4*nu*ny*SQ(ry)+
					factor2*(2*ny*SQ(ry)+2*ny)-factor1*ny)*2*mu*phi2/
					(Denom*SQ(Ra))*W[i]*J;	
					
		syy[5] += (2*rn*(factor2*rx-4*rx*SQ(ry))+4*nu*ny*rx*ry+
					factor2*2*nx*SQ(ry)-factor1*nx)*2*mu*phi3/(Denom*SQ(Ra))*W[i]*J;
					
		syy[6] += (2*rn*(factor2*ry+2*nu*ry-4*cube(ry))+4*nu*ny*SQ(ry)+
					factor2*(2*ny*SQ(ry)+2*ny)-factor1*ny)*2*mu*phi3/
					(Denom*SQ(Ra))*W[i]*J;
	}



}



#include "cboxe.h"


/*[		
				function  SLNPD 
Solution of the linear systems of equations by the Gauss Elimination method providing for interchanging rows when encountering a zero diagonal coeficient.

A : Syestem Matrix
B:  Originally it contains the Independent coefficients.  After solutions it
	contains the values of the system unknowns.                            				   				
N:  Actual number of unknowns.
Dim: Row and Column Dimension of A.
 
]*/



void Solve(A,B,D,N,Dim)

	float A[101][101],B[101],*D;  /*[ D is assigned some value here ]*/
  	int N,Dim;

{
	int N1,i,j,k,i1,l,k1,found;
	float c;
	
/*[ found is a flag which is used to check if any non zero coeff is found ]*/	
	
	
	N1 = N - 1;

	for(k=1;k<=N1;k++)
	{
		k1 = k + 1;
		c = A[k][k];
		
		if( (fabs(c) - tol) <=0 )
		{
			found = 0;
			for(j=k1;j<=N;j++)  /*[Try to Interchange rows to get Nonzero ]*/
	
	        {
            	if( (fabs(A[j][k]) - tol) > 0.0 ) 
                {
				 	for(l=k;l<=N;l++)
                    {
                     	c = A[k][l];
                        A[k][l] = A[j][l];
                        A[j][l] = c;
                     }
				  		c = B[k];
				  		B[k] = B[j];
				  		B[j] = c;
				  		c = A[k][k];
						found = 1;		/*[ coeff is found ]*/
						break;
				}
			}
		 }

		if(!found)
		{
			printf("Singularity in Row %d \n",k);
	   		(*D) = 0.0;          
	    	return;   /*[ If no coeff is found the control is trans to main ]*/
		}
	


	/*[ Divide Row by Diagonal coefficient ]*/		

  		c = A[k][k];
		for(j = k1;j<=N;j++)
		   A[k][j] /= c;
		B[k] /= c;  
 
/*[ Eliminate Unknown X[k] from Row i ]*/

		for(i = k1;i<=N; i++)
		{
		  c = A[i][k];
		  for(j = k1;j<= N;j++)
		 	A[i][j] -= c*A[k][j];
		  B[i] -= c*B[k];
		}
	}
/*[ Compute the Last Unknown ]*/

	if((fabs(A[N][N]) - tol) > 0.0)
	{
	   B[N] /= A[N][N];

/*[Apply Back Substitution to compute the remaining unknowns  ]*/

	   for(l = 1;l<= N1;l++)
	   {
	      k = N - l;
	      k1 = k +1;
	      for(j = k1;j<=N;j++)
			B[k] -= A[k][j]*B[j];
	   }
/*[Compute the Value of the Determinent ]*/

	(*D) = 1.0;
	for(i=1;i<=N;i++)
	  (*D) *= A[i][i];

   }
  else
  {
  		printf("Singularity in Row %d \n",k);
	   	(*D) = 0.0;
   }          

  return;	
}
	 
					