(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7126,        126]*)
(*NotebookOutlinePosition[      8235,        163]*)
(*  CellTagsIndexPosition[      8191,        159]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
" \n \n\n                       MATERIAL\n\n\nMathematica session for the \
1-way ANOVA\n\nMathematica has no packages for factorial designs, hence you \
are asked\nto\nprogramm the formulas by yourselve. The file anova1.m on the \
support\ndisk \nshows you how this can be done. it contains the command \
anova1,\nwhich returns the variance table of the 1-way Anova, as printed on \
page\n344.\n $0$ stands here for a blank. Make sure that you load the \
statistics \npackages needed before loading the anova.m file (why?). \nBy \
drawing the graph of an F-distribution, make sure that its\nquantiles are \
computed directly. We shall examine the data set on page\n342 \n'Fertilizers' \
effect on yield of crops' which is contained in the file\nyield.m on the \
support disk.\n\nIn[1]:= <<statisti`descript`\nIn[2]:= <<statisti`normaldi`\n\
In[3]:= <<exercise`yield`\nIn[4]:= <<exercise`anova1`\nIn[5]:= anova1[.95]\n\
Out[5]// TableForm =\n        Source   Degree    Sum       Mean      F-Ratio  \
  F-Value\n        Between     3     890.174   296.725     24.7912    8.61917\
\n10^{-8}\n        Within     26     311.192    11.9689     0         0\n     \
   Total      29    1201.37      0          0         0\n\nIn[6]:= Quit\n\n\n\
Mathematica session for chapter 9.2:\nThe file anova.m on the support disk \
contains the command anova2,\nwhich returns the variance table for the 2-way \
ANOVA as described on\npage 351.\n\nIn[1]:= <<statisti`descript`\nIn[2]:= \
<<statisti`normaldi`\nIn[3]:= <<exercise`producti`\nIn[4]:= \
<<exercise`anova2`\nIn[5]:= anova2[.95]\nOut[5]// TableForm =\n        Source \
      Degree    Sum       Mean       F-Ratio      F-Value\n        A Factor   \
     1     911.25     911.25     79.2391     \n0.000880215\n        B Factor  \
      1    3150.05    3150.05    273.917      \n0.0000780576\n        \
Interaction     1       0.45       0.45      0.0391304  \n0.852837\n        \
Within         16     184.0       11.5       0           0\n        Total     \
     19    4245.75       0         0           0\nIn[6]:= Quit\n\nNote that \
the hypothesis $H_{AB}$ cannot be rejected at a very high\nlevel.\nHence we \
may assume that there is no interaction between workers and\nmachines,\nas we \
suspected in the beginning. Also, the hypotheses $H_A$ and $H_B$\nare \n\
rejected, meaning that there is an effect whether to employ skilled or \n\
unskilled workers, and there is also an effect whether to invest in new \n\
machines or not.\n\n\n\nFILES FOR THE SUPPORT DISK:\n\nyield.m\n\nfert[1] = \
{161, 168, 172, 159, 163, 161, 160, 169};\nfert[2] = {152, 153, 152, 155, \
157, 160, 158};\nfert[3] = {157, 152, 153, 156, 154, 152};\nfert[4] = {147, \
149, 151, 148, 149, 147, 152, 156, 150};\n\n\nanova1.m\n\nfertlength = \
Table[Length[fert[i]], {i,1,4}]; \nsumoffertlength= Sum[fertlength[[i]], \
{i,1,4}]; \nmeanoffert= Table[N[Mean[fert[i]]], {i,1,4}];\ntotalmean= (1/ \
sumoffertlength)*\nSum[fertlength[[i]]*meanoffert[[i]],{i,1,4}];\nTTS = \
Sum[Sum[(fert[i][[j]]-totalmean)^2,\n{j,1,fertlength[[i]]}],{i,1,4}];\nSST = \
Sum[fertlength[[i]](meanoffert[[i]]-totalmean)^2, {i,1,4}];\nSSE = Sum[ \
N[(fertlength[[i]]-1)*Variance[fert[i]]], {i,1,4}];\nMST = SST/3\nMSE = \
SSE/(sumoffertlength-4)\nfvalue=1- CDF[FRatioDistribution[3, \
sumoffertlength-4], N[MST/MSE]];\nanova1 =TableForm[{ \n            {Source, \
Degree, Sum, Mean, F-Ratio, F-Value},\n            {Between, 3,SST, MST, \
MST/MSE, fvalue},\n            {Within, sumoffertlength-4, SSE, MSE,0, 0},\n  \
          {Total, sumoffertlength-1, TTS, 0, 0, 0}}];\n\n\n\nproducti.m\n\n\
productivity[{1,1}]={ 69,  69,  72,  74,  75};\nproductivity[{1,2}]={ 95,  \
98, 100,  96,  97};\nproductivity[{2,1}]={ 81,  88,  84,  87,  88};\n\
productivity[{2,2}]={105, 110, 107, 112, 118};\n\n\nanova2.m\n\nworker[1] = \
Join[productivity[{1,1}], productivity[{1,2}]];\nworker[2] = \
Join[productivity[{2,1}], productivity[{2,2}]];\nmachine[1] = \
Join[productivity[{1,1}], productivity[{2,1}]];\nmachine[2] = \
Join[productivity[{1,2}], productivity[{2,2}]];\ntotal= Join[worker[1], \
worker[2]];\nTTS = N[(Length[total]-1) Variance[total]];\nSSA = N[ 2 * \
Length[productivity[{1,1}]]Sum[(Mean[worker[i]]- \n      \
Mean[total])^2,{i,1,2}]];\nSSB = N[ 2 * \
Length[productivity[{1,1}]]Sum[(Mean[machine[i]]- \n      \
Mean[total])^2,{i,1,2}]];\nSSI = N[Length[productivity[{1,1}]] Sum[Sum[\n     \
 (Mean[productivity[{i,j}]] - Mean[worker[i]] -\n      Mean[machine[j]]+ \
Mean[total])^2,{j,1,2}], {i,1,2}]];\nSSE = \
N[Sum[Sum[Sum[(productivity[{i,j}][[k]]-\nMean[productivity[{i,j}]])^2,\n     \
 {k,1,Length[productivity[{1,1}]]}],{j,1,2}],{i,1,2}]];\nMSE = \
SSE/(4*(Length[productivity[{1,1}]]-1));\nfvalueA = 1- \
CDF[FRatioDistribution[1, Length[productivity[{1,1}]]-1], \n          \
N[SSA/MSE]];\nfvalueB = 1- CDF[FRatioDistribution[1, \
Length[productivity[{1,1}]]-1], \n          N[SSB/MSE]];\nfvalueI = 1- \
CDF[FRatioDistribution[1, Length[productivity[{1,1}]]-1], \n          \
N[SSI/MSE]];\nanova2 =TableForm[ {\n   {Source, Degree, Sum, Mean, F-Ratio, \
F-Value},\n   {Factor A, 1, SSA, SSA, SSA/ MSE, fvalueA},\n   {Factor B, 1, \
SSB, SSB, SSB/ MSE, fvalueB},\n   {Interaction, 1, SSI, SSI, SSI/ MSE, \
fvalueI},\n   {Within, 4*(Length[productivity[{1,1}]]-1), SSE, MSE,0, 0},\n   \
{Total, 4*Length[productivity[{1,1}]]-1, TTS, 0, 0, 0}}];"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{20, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 5412, 74, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
