(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11701,        195]*)
(*NotebookOutlinePosition[     12810,        232]*)
(*  CellTagsIndexPosition[     12766,        228]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`Billiard`\"]\n\nNextBounce::usage = \"\n\
NextBounce[currentposition,r] computes the next bouncing point of a ball \n\
inside a square table with a circular obstacle of radius r. The initial \n\
conditions are given in the list currentposition that has four real \n\
coordinates, respectively the absissa, ordinate, incoming angle of the ball, \
\nand the current time. The result is returned as another list of four \n\
elements, the abscissa and ordinate of the new bouncing point, the new \n\
direction of the ball and the current time incremented by the running time \n\
between the two bounces.\"\n\nTrajectory::usage =\"\n\
Trajectory[shootingangle,tmax,r] draws a square table with a centered \n\
circular obstacle of radius r (default 0.5). Draws inside this support the \n\
trajectory of a ball starting at the bottom left corner with initial\n\
direction shootingangle, up to time tmax. \"\n\nBundle::usage =\"\n\
Bundle[listofangles,tmax,r] draws a square table with a centered circular\n\
obstacle of radius r. Draws inside the trajectories of balls starting at the \
\nbottom left corner with initial directions read in listofangles, up to \n\
time tmax. \"\n\nDifferences::usage = \"\nDifferences[angle,dangle,tmax,r] \
simulates two trajectories of balls in a \nsquare table with a centered \
circular obstacle with radius r. Both \ntrajectories start from the bottom \
left corner. They are followed up to time \ntmax. The shooting angle of the \
first trajectory is angle, its difference \nwith the second shooting angle is \
dangle. The function represents three \nconsecutive graphics. The first one \
is the billiard table with the two \ntrajectories . The second one is the \
evolution of the absolute difference \nof angles as a function of time. The \
third one is the norm of the difference \nof positions as a function of time. \
\"\n\n\nBegin [\"`Private`\"]\n\n\nNextBounce[currentposition_List,r_]:=\n  \
Block[\n       {xold,yold,aold,cosaold,sinaold,epsi=10^(-6), \n\t\
tnorth,teast,tsouth,twest,tcircle1,tcircle2,delta,beta,\n\t\
trun,xnew,ynew,anew},\n\n\t\t\t    (* Old coordinates \
----------------------------*)\n       xold = currentposition[[1]];\n       \
yold = currentposition[[2]];\n       aold = currentposition[[3]];\n       \
cosaold = Cos[aold];\n       sinaold = Sin[aold];\n\n\t\t\t    (* Hitting \
time of the four edges -------------*)\n       tnorth = (+1-yold)/sinaold; \
If[tnorth<epsi,tnorth=Infinity];\n       teast  = (+1-xold)/cosaold; If[teast \
<epsi,teast =Infinity];\n       tsouth = (-1-yold)/sinaold; \
If[tsouth<epsi,tsouth=Infinity];\n       twest  = (-1-xold)/cosaold; If[twest \
<epsi,twest =Infinity];\n\n\t\t\t    (* Hitting time of the circular obstacle \
------*)\n       delta  = (xold*cosaold+yold*sinaold)^2-(xold^2+yold^2-r^2);\n\
       If[delta>0,\n\t  (\n\t   delta    = Sqrt[delta];\n\t   tcircle1 = \
-(xold*cosaold+yold*sinaold) + delta;\n\t   \
If[tcircle1<epsi,tcircle1=Infinity];\n\t   tcircle2 = \
-(xold*cosaold+yold*sinaold) - delta;\n\t   \
If[tcircle2<epsi,tcircle2=Infinity];\n\t  ),\n\t  (\n\t   tcircle1 = \
Infinity;\n\t   tcircle2 = Infinity;\n\t  )\n\t ];\n\n\t\t\t    (* Next \
bounce is at minimal hitting time -----*)\n       trun = \
Min[{tnorth,teast,tsouth,twest,tcircle1,tcircle2}];\n\n       \
Switch[Position[{tnorth,teast,tsouth,twest,tcircle1,tcircle2},\n\t\t\t\t\t\
trun][[1,1]],\n\n\t     1,             (* Next bounce on north edge \
------------------*)\n\t     (\n\t      xnew = xold + trun*cosaold;\n\t      \
ynew = 1.;\n\t      anew = N[2*Pi]-aold;\n\t     ),\n\t     2,             (* \
Next bounce on east edge -------------------*)\n\t     (\n\t      ynew = yold \
+ trun*sinaold;\n\t      xnew = 1.;\n\t      anew = N[Pi]-aold; \
If[anew<0,anew = anew+N[2*Pi]];\n\t     ),\n\t     3,             (* Next \
bounce on south edge ------------------*)\n\t     (\n\t      xnew = xold + \
trun*cosaold;\n\t      ynew = -1.;\n\t      anew = N[2*Pi]-aold;\n\t     ),\n\
\t     4,             (* Next bounce on west edge -------------------*)\n\t   \
  (\n\t      ynew = yold + trun*sinaold;\n\t      xnew = -1.;\n\t      anew = \
N[Pi]-aold; If[anew<0,anew = anew+N[2*Pi]];\n\t     ),\n\t     5,             \
(* Next bounce on circle ----------------------*)\n\t     (\n\t      xnew = \
xold + trun*cosaold;\n\t      ynew = yold + trun*sinaold;\n\t      anew = \
Mod[2*ArcTan[xnew,ynew]-aold,N[2*Pi]];\n\t     ),\n\t     6,             (* \
Next bounce on circle ----------------------*)\n\t     (\n\t      xnew = xold \
+ trun*cosaold;\n\t      ynew = yold + trun*sinaold;\n\t      anew = \
Mod[2*ArcTan[xnew,ynew]-aold-N[Pi],N[2*Pi]];\n\t     )];\n\t\t\t    \n\t\t\t  \
  (* Protection against leaky corners -----------*)\n       \
If[(Abs[xnew*ynew]>1-epsi),\n\t   If[(aold<N[Pi/2]),anew=N[3*Pi/2]-aold,\n\t  \
    If[(aold<N[Pi]),anew=N[5*Pi/2]-aold,\n\t\t \
If[(aold<N[3*Pi/2]),anew=N[3*Pi/2]-aold,\n\t\t      anew=N[3*Pi/2]-aold]]]];\n\
\n       Return[{xnew,ynew,anew,currentposition[[4]]+trun}];\n\n    ]\n\n\n\n\
Trajectory[shootingangle_,tmax_,r_]:=\n  Block[\n       \
{running=0.,traj={{-1.,-1.}},next},\n\n       next = \
{-1.,-1.,N[shootingangle],0.};\n\n       While[running<N[tmax],\n\t    (\n\t  \
   next = NextBounce[next,r];\n\t     traj = Append[traj,Take[next,2]];\n\t   \
  running = Last[next];\n\t    )\n\t    ];\n\n       Show[\n\t    Graphics[{\n\
\t\t    Thickness[0.01],\n\t\t    \
Line[{{-1,-1},{-1,1},{1,1},{1,-1},{-1,-1}}],\n\t\t    Circle[{0,0},r],\n\t\t  \
  Thickness[0.005],\n\t\t    Line[traj]\n\t\t    }],\n\t    AspectRatio->1\n\t\
   ]\n    ]\n\n\nBundle[listofangles_List,tmax_,r_]:=\n  Block[\n       \
{nbtraj,running=0.,traj,next,i,g1,g2},\n\n       nbtraj = \
Length[listofangles];\n       traj=Table[{{-1.,-1.}},{nbtraj}];\n       Do[(\n\
\t   next = {-1.,-1.,N[listofangles[[i]]],0.};\n\t   running = 0.;\n\t   \
While[running<N[tmax],\n\t\t (\n\t\t  next = NextBounce[next,r];\n\t\t  \
traj[[i]] = Append[traj[[i]],Take[next,2]];\n\t\t  running = Last[next];\n\t\t\
 )\n\t\t];\n\t  ),{i,1,nbtraj}];\n       \n       g1 = Graphics[{\n\t\t      \
Thickness[0.01],\n\t\t      Line[{{-1,-1},{-1,1},{1,1},{1,-1},{-1,-1}}],\n\t\t\
      Circle[{0,0},r]\n\t\t     }];\n       g2 = Table[Graphics\n\t\t    [{\n\
\t\t      Thickness[0.005],\n\t\t      Line[traj[[i]]]\n\t\t     \
}],{i,1,nbtraj}];\n\n       Show[Prepend[g2,g1], AspectRatio->1];\n\n\n    ];\
\n\n\nDifferences[angle_,dangle_,tmax_,r_]:=\n  Block[\n       \
{listofangles,running=0.,traj,next,i,g1,g2,\n\t\
angles,diffangles,aold,diffpos,i1,i2},\n\n       listofangles = \
N[{angle,angle+dangle}];\n       \
traj=Table[{{-1.,-1.,listofangles[[i]],0.}},{i,1,2}];\n\n       Do[(\n\t   \
next = {-1.,-1.,listofangles[[i]],0.};\n\t   running = 0.;\n\t   \
While[running<N[tmax],\n\t\t (\n\t\t  next = NextBounce[next,r];\n\t\t  \
traj[[i]] = Append[traj[[i]],next];\n\t\t  running = Last[next];\n\t\t )\n\t\t\
];\n\t  ),{i,1,2}];\n\n\t\t\t    (* Computation of differences \
-----------------*)\n       angles = \
Table[Transpose[Drop[Transpose[traj[[i]]],2]],{i,1,2}];\n       aold = \
Abs[dangle];\n       diffangles = {{0.,aold}};\n       diffpos = {{0.,0.}};\n \
      i1 = 2; i2 = 2;\n\n       \
While[(i1<=Length[angles[[1]]])&&(i2<=Length[angles[[2]]]),\n\t  (\n\t   \
If[angles[[1,i1,2]]<angles[[2,i2,2]],\n\t      (\n\t       diffangles = \
Append[diffangles,\n\t\t\t\t{angles[[1,i1,2]],aold}];\n\t       aold = \
Abs[angles[[1,i1,1]]-angles[[2,i2-1,1]]];\n\t       diffangles = \
Append[diffangles,\n\t\t\t\t{angles[[1,i1,2]],aold}];\n\t       diffpos = \
Append[diffpos,\n\t\t\t\t{angles[[1,i1,2]],\n\t\t\t\t \
Sqrt[(traj[[1,i1,1]]-traj[[2,i2-1,1]]-\n\t\t\t\t       \
(traj[[2,i2,1]]-traj[[2,i2-1,1]])*\n\t\t\t\t       \
(angles[[1,i1,2]]-angles[[2,i2-1,2]])/\n\t\t\t\t       \
(angles[[2,i2,2]]-angles[[2,i2-1,2]])\n\t\t\t\t       )^2 +\n\t\t\t\t      \
(traj[[1,i1,2]]-traj[[2,i2-1,2]]-\n\t\t\t\t       \
(traj[[2,i2,2]]-traj[[2,i2-1,2]])*\n\t\t\t\t       \
(angles[[1,i1,2]]-angles[[2,i2-1,2]])/\n\t\t\t\t       \
(angles[[2,i2,2]]-angles[[2,i2-1,2]])\n\t\t\t\t       )^2]}];\n\t       i1 = \
i1+1;\n\t      ),\n\t      (\n\t       diffangles = Append[diffangles,\n\t\t\t\
\t{angles[[2,i2,2]],aold}];\n\t       aold = \
Abs[angles[[1,i1-1,1]]-angles[[2,i2,1]]];\n\t       diffangles = \
Append[diffangles,\n\t\t\t\t{angles[[2,i2,2]],aold}];\n\t       diffpos = \
Append[diffpos,\n\t\t\t\t{angles[[2,i2,2]],\n\t\t\t\t \
Sqrt[(traj[[2,i2,1]]-traj[[1,i1-1,1]]-\n\t\t\t\t       \
(traj[[1,i1,1]]-traj[[1,i1-1,1]])*\n\t\t\t\t       \
(angles[[2,i2,2]]-angles[[1,i1-1,2]])/\n\t\t\t\t       \
(angles[[1,i1,2]]-angles[[1,i1-1,2]])\n\t\t\t\t       )^2 +\n\t\t\t\t      \
(traj[[2,i2,2]]-traj[[1,i1-1,2]]-\n\t\t\t\t       \
(traj[[1,i1,2]]-traj[[1,i1-1,2]])*\n\t\t\t\t       \
(angles[[2,i2,2]]-angles[[1,i1-1,2]])/\n\t\t\t\t       \
(angles[[1,i1,2]]-angles[[1,i1-1,2]])\n\t\t\t\t       )^2]}];\n\t       i2 = \
i2+1;\n\t      )\n\t     ];\n\t  )];\n\t\t\t    \n\t\t\t    (* Representation \
of trajectories -------------*)\n       g1 = Graphics[{\n\t\t      \
Thickness[0.01],\n\t\t      Line[{{-1,-1},{-1,1},{1,1},{1,-1},{-1,-1}}],\n\t\t\
      Circle[{0,0},r]\n\t\t     }];\n       g2 = Table[Graphics\n\t\t    [{\n\
\t\t      Thickness[0.005],\n\t\t      \
Line[Transpose[Take[Transpose[traj[[i]]],2]]]\n\t\t     }],{i,1,2}];\n\n      \
 Show[Prepend[g2,g1], AspectRatio->1];\n\n\n\n\t\t\t    (* Representation of \
angle differences --------*)\n       Show[Graphics[{\n\t\tThickness[0.005],\n\
\t\tLine[diffangles]}],\n\t\tAxes->True,\n\t\tFrame->True,\n\t\t\
AxesLabel->{\"Time\",\"Difference of angles\"}\n\t    ];\n\n\t\t\t    (* \
Representation of position differences -----*)\n       Show[Graphics[{\n\t\t\
Thickness[0.005],\n\t\tLine[diffpos]}],\n\t\tAxes->True,\n\t\tFrame->True,\n\t\
\tAxesLabel->{\"Time\",\"Difference of positions\"}\n\t    ]\n       ];\n\n\
End[]\n\nEndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{28, Automatic}, {30, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 9987, 143, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
