(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     62156,        997]*)
(*NotebookOutlinePosition[     63265,       1034]*)
(*  CellTagsIndexPosition[     63221,       1030]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"Dan Merrill, Matthew Tarler, Harish Aiyar (CWRU Biomed Eng students)\nBox \
and Whiskers package\n\n \n\
(***********************************************************************\n\n  \
                  Mathematica-Compatible Notebook\n\nThis notebook can be \
used on any computer system with Mathematica 3.0,\nMathReader 3.0, or any \
compatible application. The data for the notebook\nstarts with the line of \
stars above.\n\nTo get the notebook into a Mathematica-compatible \
application, do one of\nthe following:\n\n* Save the data starting with the \
line of stars above into a file\n  with a name ending in .nb, then open the \
file inside the application;\n\n* Copy the data starting with the line of \
stars above to the\n  clipboard, then use the Paste menu command inside the \
application.\n\nData for notebooks contains only printable 7-bit ASCII and \
can be\nsent directly in email or through ftp in text mode.  Newlines can be\n\
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).\n\nNOTE: If you modify the \
data for this notebook not in a Mathematica-\ncompatible application, you \
must delete the line below containing the\nword CacheID, otherwise \
Mathematica-compatible applications may try to\nuse invalid cache data.\n\n\
For more information on notebooks and Mathematica-compatible\napplications, \
contact Wolfram Research:\n  web: http://www.wolfram.com\n  email: \
info@wolfram.com\n  phone: +1-217-398-0700 (U.S.)\n\nNotebook reader \
applications are available free of charge from\nWolfram Research.\n\
***********************************************************************)\n\n\
(*CacheID: 232*)\n\n\n(*NotebookFileLineBreakTest\n\
NotebookFileLineBreakTest*)\n(*NotebookOptionsPosition[     53889,       \
1597]*)\n(*NotebookOutlinePosition[     54728,       1624]*)\n(*  \
CellTagsIndexPosition[     54684,       1620]*)\n(*WindowFrame->Normal*)\n\n\n\
\nNotebook[{\n\nCell[CellGroupData[{\nCell[BoxData[{\n    \\(\\nBeginPackage[\
\"\\<UVW`BoxAndWhiskersPlot`\\>\"]\\n\\),\n    \\(BWPlot::usage =\n      \
\"\\<BWPlot[{a,b,...},options] makes a single graphical output with the \\\n\
given option or list of options with box and whisker plots for each vector \\\
\na,b,...\\>\"\\n\\),\n    \\(BWPlotArray::usage =\n      \
\"\\<BWPlotArray[{a,b,...},{options_a,options_b,...}] makes a different \\\n\
graph with box and whisker for each vector a,b,... using the corresponding \\\
\noption or list of options for the corresponding graph\\>\"\\n\\t\\),\n    \
\\(Begin[\"\\<`Private`\\>\"]\\n\\),\n    \\(MakeBW[inputdata_List, \
Options_List] := \\ \\n\n      Block[{Mindata, Maxdata, Meddata, Q1data, \
Q3data, BWout, n, size,\n          data = inputdata}, \\n\\t\\tBWout = {}; \
\\n\\t\\t\n        Do[\\n\\t\\t\\tdata[\\([n]\\)] = \
Sort[inputdata[\\([n]\\)]]; \\n\\t\\t\\t\n          sizep1 = \
Length[data[\\([n]\\)]] + 1; \\t\\n\\t\\t\\t\n          \
Percentile[datalist_List, perc_] :=\n            \
datalist[\\([Floor[\\((Length[datalist] + 1)\\)\\ perc]]\\)]\\\n              \
  \\((1 - FractionalPart[\\((Length[datalist] + 1)\\)\\ perc])\\) +\n         \
     datalist[\\([Ceiling[\\((Length[datalist] + 1)\\)\\ perc]]\\)\\ ]\n      \
          FractionalPart[\\((Length[datalist] + 1)\\)\\ perc]; \\n\\t\\t\\t\n \
         Mindata = data[\\([n, 1]\\)]; \\n\\t\\t\\t\n          Maxdata = \
data[\\([n, sizep1 - 1]\\)]; \\n\\t\\t\\t\n          Meddata = \
Percentile[data[\\([n]\\)], .5]; \\n\\t\\t\\t\n          Q1data = \
Percentile[data[\\([n]\\)], .25]; \\n\\t\\t\\t\n          Q3data = \
Percentile[data[\\([n]\\)], .75]; \\n\\t\\t\\t\n          \\(BWout =\n        \
    Append[BWout,\n              Graphics[{RGBColor[0, 0, 0],\n               \
   Line[{{3  n, Mindata}, {3  n, Maxdata}}],\n                  Line[{{3  n - \
.25, Mindata}, {3  n + .25, Mindata}}],\n                  Line[{{3  n - .25, \
Maxdata}, {3  n + .25, Maxdata}}],\n                  RGBColor[1, 1, 1],\n    \
              Rectangle[{3  n - 1, Q1data\\ }, {3  n + 1\\ , Q3data}],\n      \
            RGBColor[0, 0, 0],\n                  Line[{{3  n - 1, Q1data}, \
{3  n - 1, Q3data}, {3  n + 1,\n                        Q3data}, {3  n + 1, \
Q1data}, {3  n - 1, Q1data}}],\n                  RGBColor[0, 0, 0],\n        \
          Line[{{3  n - 1, Meddata}, {3  n + 1, Meddata}}]},\n                \
Axes -> {False, True},\n                PlotRange -> {{0, 3  Length[BWout] + \
5}, All}, Options]]; \\)\\n\n          \\t\\t\\t, {n, Length[inputdata]}]; \
\\t\\n\\t\\t\\tReturn[BWout]; \\t\\t\\n\n        \\t\\t]\\n\\),\n    \
\\(BWPlot[inputdatalist_List, Optionslist_List] := \\n\\t\n      \
Block[{BWout}, \\n\\t\\tBWout = MakeBW[inputdatalist, Optionslist]; \\n\n     \
   \\t\\t\\tShow[BWout, PlotRange -> {{0, 3  Length[BWout] + 5}, All}]; ];\n  \
  \\n\\nBWPlotArray[inputdatalist_List, Optionslist_List] := \\n\\t\\t\\t\n   \
   Block[{n, Arrayout}, \\n\\t\\t\\t\\tArrayout = {}; \\n\\t\\t\\t\\t\n       \
 Do[\\n\\t\\t\\t\\t\\t\n          Arrayout =\n            Append[Arrayout,\n  \
            First[MakeBW[{inputdatalist[\\([n]\\)]},\n                  \
Optionslist[\\([n]\\)]]]], {n, Length[inputdatalist]}]; \\n\n        \
\\t\\t\\t\\ Show[GraphicsArray[Arrayout]]]; \
\\n\\nEnd[]\\t\\t\\t\\t\\t\\n\\t\\t\\),\n    \\(EndPackage[]\\n\\n\\)}], \
\"Input\"],\n\nCell[BoxData[\n    \\(\"UVW`BoxAndWhiskersPlot`\"\\)], \
\"Output\"],\n\nCell[BoxData[\n    \\(\"BWPlot[{a,b,...},options] makes a \
single graphical output with the \\\ngiven option or list of options with box \
and whisker plots for each vector \\\na,b,...\"\\)], \"Output\"],\n\n\
Cell[BoxData[\n    \\(\"BWPlotArray[{a,b,...},{options_a,options_b,...}] \
makes a different \\\ngraph with box and whisker for each vector a,b,... \
using the corresponding \\\noption or list of options for the corresponding \
graph\"\\)], \"Output\"],\n\nCell[BoxData[\n    \
\\(\"UVW`BoxAndWhiskersPlot`Private`\"\\)], \"Output\"],\n\nCell[BoxData[\n   \
 \\(\"UVW`BoxAndWhiskersPlot`Private`\"\\)], \"Output\"]\n}, Open  ]],\n\n\
Cell[CellGroupData[{\n\nCell[BoxData[{\n    \\(inputy\n       = {{2, 5, 4, \
3}, {9, 7, 8, 6, 10}, {1, 2, 3}, {100, 110, 150, 200}}\\),\n\n    \
\\(BWPlotArray[\n      inputy, {{PlotLabel -> \"\\<Title\\>\"}, {PlotLabel -> \
\"\\<#2\\>\"}, {}, {}}]\n      \\)}], \"Input\"],\n\nCell[BoxData[\n    \
\\({{2, 5, 4, 3}, {9, 7, 8, 6, 10}, {1, 2, 3}, {100, 110, 150, 200}}\\)],\n  \
\"Output\"],\n\nCell[BoxData[\n    RowBox[{\"{\",\n      RowBox[{\n        \
TagBox[\\(\\[SkeletonIndicator]  Graphics  \\[SkeletonIndicator]\\),\n        \
  False,\n          Editable->False], \",\",\n        \
TagBox[\\(\\[SkeletonIndicator]  Graphics  \\[SkeletonIndicator]\\),\n        \
  False,\n          Editable->False], \",\",\n        \
TagBox[\\(\\[SkeletonIndicator]  Graphics  \\[SkeletonIndicator]\\),\n        \
  False,\n          Editable->False], \",\",\n        \
TagBox[\\(\\[SkeletonIndicator]  Graphics  \\[SkeletonIndicator]\\),\n        \
  False,\n          Editable->False]}], \"}\"}]], \"Print\"],\n\n\
Cell[GraphicsData[\"PostScript\", \"\\<\\\n%!\n%%Creator: Mathematica\n\
%%AspectRatio: .14373\nMathPictureStart\n/Mabs {\nMgmatrix idtransform\n\
Mtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\
\nexch } bind def\n%% Graphics\n/Courier findfont 10  scalefont  setfont\n% \
Scaling calculations\n0.0238095 0.238095 0.00342212 0.238095 [\n[ 0 0 0 0 ]\n\
[ 1 .14373 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 \
setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .14373 L\n0 .14373 L\nclosepath\nclip\n\
newpath\n% Start of sub-graphic\np\n0.0238095 0.00342212 0.245293 0.140307 \
MathSubStart\n%% Graphics\n/Courier findfont 10  scalefont  setfont\n% \
Scaling calculations\n0 0.2 -0.377687 0.196201 [\n[-0.0125 .01472 -6 -4.5 ]\n\
[-0.0125 .01472 0 4.5 ]\n[-0.0125 .11282 -18 -4.5 ]\n[-0.0125 .11282 0 4.5 ]\n\
[-0.0125 .21092 -6 -4.5 ]\n[-0.0125 .21092 0 4.5 ]\n[-0.0125 .30902 -18 -4.5 \
]\n[-0.0125 .30902 0 4.5 ]\n[-0.0125 .40712 -6 -4.5 ]\n[-0.0125 .40712 0 4.5 \
]\n[-0.0125 .50522 -18 -4.5 ]\n[-0.0125 .50522 0 4.5 ]\n[-0.0125 .60332 -6 \
-4.5 ]\n[-0.0125 .60332 0 4.5 ]\n[.5 .63053 -17 0 ]\n[.5 .63053 17 14 ]\n[ 0 \
0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 \
setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n0 .01472 m\n.00625 \
.01472 L\ns\n[(2)] -0.0125 .01472 1 0 Mshowa\n0 .11282 m\n.00625 .11282 L\ns\n\
[(2.5)] -0.0125 .11282 1 0 Mshowa\n0 .21092 m\n.00625 .21092 L\ns\n[(3)] \
-0.0125 .21092 1 0 Mshowa\n0 .30902 m\n.00625 .30902 L\ns\n[(3.5)] -0.0125 \
.30902 1 0 Mshowa\n0 .40712 m\n.00625 .40712 L\ns\n[(4)] -0.0125 .40712 1 0 \
Mshowa\n0 .50522 m\n.00625 .50522 L\ns\n[(4.5)] -0.0125 .50522 1 0 Mshowa\n0 \
.60332 m\n.00625 .60332 L\ns\n[(5)] -0.0125 .60332 1 0 Mshowa\n.125 Mabswid\n\
0 .03434 m\n.00375 .03434 L\ns\n0 .05396 m\n.00375 .05396 L\ns\n0 .07358 m\n\
.00375 .07358 L\ns\n0 .0932 m\n.00375 .0932 L\ns\n0 .13244 m\n.00375 .13244 L\
\ns\n0 .15206 m\n.00375 .15206 L\ns\n0 .17168 m\n.00375 .17168 L\ns\n0 .1913 \
m\n.00375 .1913 L\ns\n0 .23054 m\n.00375 .23054 L\ns\n0 .25016 m\n.00375 \
.25016 L\ns\n0 .26978 m\n.00375 .26978 L\ns\n0 .2894 m\n.00375 .2894 L\ns\n0 \
.32864 m\n.00375 .32864 L\ns\n0 .34826 m\n.00375 .34826 L\ns\n0 .36788 m\n\
.00375 .36788 L\ns\n0 .3875 m\n.00375 .3875 L\ns\n0 .42674 m\n.00375 .42674 L\
\ns\n0 .44636 m\n.00375 .44636 L\ns\n0 .46598 m\n.00375 .46598 L\ns\n0 .4856 \
m\n.00375 .4856 L\ns\n0 .52484 m\n.00375 .52484 L\ns\n0 .54446 m\n.00375 \
.54446 L\ns\n0 .56408 m\n.00375 .56408 L\ns\n0 .5837 m\n.00375 .5837 L\ns\n\
.25 Mabswid\n0 0 m\n0 .61803 L\ns\ngsave\n.5 .63053 -78 -4 Mabsadd m\n1 1 \
Mabs scale\ncurrentpoint translate\n0 22 translate 1 -1 scale\n63.000000 \
15.000000 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n\
/Courier findfont 10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n\
0.000000 0.000000 0.000000 setrgbcolor\n0.000000 0.000000 rmoveto\n63.000000 \
15.000000 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n\
/Courier findfont 10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n\
0.000000 0.000000 0.000000 setrgbcolor\n(Title) show\n93.000000 15.000000 \
moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier \
findfont 10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000000 \
0.000000 0.000000 setrgbcolor\n0.000000 0.000000 rmoveto\n1.000000 \
setlinewidth\n%%DocumentNeededResources: font Courier\n\
%%DocumentSuppliedResources:\n%%DocumentNeededFonts: Courier\n\
%%DocumentSuppliedFonts:\n%%DocumentFonts: font Courier\ngrestore\n0 0 m\n1 0 \
L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\n0 0 0 r\n.5 Mabswid\n.6 \
.01472 m\n.6 .60332 L\ns\n.55 .01472 m\n.65 .01472 L\ns\n.55 .60332 m\n.65 \
.60332 L\ns\n1 1 1 r\n.4 .06377 m\n.4 .55427 L\n.8 .55427 L\n.8 .06377 L\nF\n\
0 0 0 r\n.4 .06377 m\n.4 .55427 L\n.8 .55427 L\n.8 .06377 L\n.4 .06377 L\ns\n\
.4 .30902 m\n.8 .30902 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n% Start of \
sub-graphic\np\n0.267442 0.00342212 0.488926 0.140307 MathSubStart\n%% \
Graphics\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0 \
0.2 -0.868191 0.147151 [\n[-0.0125 .01472 -6 -4.5 ]\n[-0.0125 .01472 0 4.5 ]\n\
[-0.0125 .16187 -6 -4.5 ]\n[-0.0125 .16187 0 4.5 ]\n[-0.0125 .30902 -6 -4.5 ]\
\n[-0.0125 .30902 0 4.5 ]\n[-0.0125 .45617 -6 -4.5 ]\n[-0.0125 .45617 0 4.5 ]\
\n[-0.0125 .60332 -12 -4.5 ]\n[-0.0125 .60332 0 4.5 ]\n[.5 .63053 -8 0 ]\n[.5 \
.63053 8 14 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of \
Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 \
setdash\n0 .01472 m\n.00625 .01472 L\ns\n[(6)] -0.0125 .01472 1 0 Mshowa\n0 \
.16187 m\n.00625 .16187 L\ns\n[(7)] -0.0125 .16187 1 0 Mshowa\n0 .30902 m\n\
.00625 .30902 L\ns\n[(8)] -0.0125 .30902 1 0 Mshowa\n0 .45617 m\n.00625 \
.45617 L\ns\n[(9)] -0.0125 .45617 1 0 Mshowa\n0 .60332 m\n.00625 .60332 L\ns\n\
[(10)] -0.0125 .60332 1 0 Mshowa\n.125 Mabswid\n0 .04415 m\n.00375 .04415 L\n\
s\n0 .07358 m\n.00375 .07358 L\ns\n0 .10301 m\n.00375 .10301 L\ns\n0 .13244 m\
\n.00375 .13244 L\ns\n0 .1913 m\n.00375 .1913 L\ns\n0 .22073 m\n.00375 .22073 \
L\ns\n0 .25016 m\n.00375 .25016 L\ns\n0 .27959 m\n.00375 .27959 L\ns\n0 \
.33845 m\n.00375 .33845 L\ns\n0 .36788 m\n.00375 .36788 L\ns\n0 .39731 m\n\
.00375 .39731 L\ns\n0 .42674 m\n.00375 .42674 L\ns\n0 .4856 m\n.00375 .4856 L\
\ns\n0 .51503 m\n.00375 .51503 L\ns\n0 .54446 m\n.00375 .54446 L\ns\n0 .57389 \
m\n.00375 .57389 L\ns\n.25 Mabswid\n0 0 m\n0 .61803 L\ns\ngsave\n.5 .63053 \
-69 -4 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 22 translate 1 -1 \
scale\n63.000000 15.000000 moveto\n%%IncludeResource: font Courier\n\
%%IncludeFont: Courier\n/Courier findfont 10.000000 scalefont\n[1 0 0 -1 0 0 \
] makefont setfont\n0.000000 0.000000 0.000000 setrgbcolor\n0.000000 0.000000 \
rmoveto\n63.000000 15.000000 moveto\n%%IncludeResource: font Courier\n\
%%IncludeFont: Courier\n/Courier findfont 10.000000 scalefont\n[1 0 0 -1 0 0 \
] makefont setfont\n0.000000 0.000000 0.000000 setrgbcolor\n(#2) show\n\
75.000000 15.000000 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: \
Courier\n/Courier findfont 10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont \
setfont\n0.000000 0.000000 0.000000 setrgbcolor\n0.000000 0.000000 rmoveto\n\
1.000000 setlinewidth\n%%DocumentNeededResources: font Courier\n\
%%DocumentSuppliedResources:\n%%DocumentNeededFonts: Courier\n\
%%DocumentSuppliedFonts:\n%%DocumentFonts: font Courier\ngrestore\n0 0 m\n1 0 \
L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\n0 0 0 r\n.5 Mabswid\n.6 \
.01472 m\n.6 .60332 L\ns\n.55 .01472 m\n.65 .01472 L\ns\n.55 .60332 m\n.65 \
.60332 L\ns\n1 1 1 r\n.4 .08829 m\n.4 .52974 L\n.8 .52974 L\n.8 .08829 L\nF\n\
0 0 0 r\n.4 .08829 m\n.4 .52974 L\n.8 .52974 L\n.8 .08829 L\n.4 .08829 L\ns\n\
.4 .30902 m\n.8 .30902 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n% Start of \
sub-graphic\np\n0.511074 0.00342212 0.732558 0.140307 MathSubStart\n%% \
Graphics\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0 \
0.2 -0.279587 0.294302 [\n[-0.0125 .01472 -6 -4.5 ]\n[-0.0125 .01472 0 4.5 ]\n\
[-0.0125 .16187 -18 -4.5 ]\n[-0.0125 .16187 0 4.5 ]\n[-0.0125 .30902 -6 -4.5 \
]\n[-0.0125 .30902 0 4.5 ]\n[-0.0125 .45617 -18 -4.5 ]\n[-0.0125 .45617 0 4.5 \
]\n[-0.0125 .60332 -6 -4.5 ]\n[-0.0125 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 \
.61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\n\
newpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n0 .01472 m\n.00625 .01472 L\ns\n\
[(1)] -0.0125 .01472 1 0 Mshowa\n0 .16187 m\n.00625 .16187 L\ns\n[(1.5)] \
-0.0125 .16187 1 0 Mshowa\n0 .30902 m\n.00625 .30902 L\ns\n[(2)] -0.0125 \
.30902 1 0 Mshowa\n0 .45617 m\n.00625 .45617 L\ns\n[(2.5)] -0.0125 .45617 1 0 \
Mshowa\n0 .60332 m\n.00625 .60332 L\ns\n[(3)] -0.0125 .60332 1 0 Mshowa\n.125 \
Mabswid\n0 .04415 m\n.00375 .04415 L\ns\n0 .07358 m\n.00375 .07358 L\ns\n0 \
.10301 m\n.00375 .10301 L\ns\n0 .13244 m\n.00375 .13244 L\ns\n0 .1913 m\n\
.00375 .1913 L\ns\n0 .22073 m\n.00375 .22073 L\ns\n0 .25016 m\n.00375 .25016 \
L\ns\n0 .27959 m\n.00375 .27959 L\ns\n0 .33845 m\n.00375 .33845 L\ns\n0 \
.36788 m\n.00375 .36788 L\ns\n0 .39731 m\n.00375 .39731 L\ns\n0 .42674 m\n\
.00375 .42674 L\ns\n0 .4856 m\n.00375 .4856 L\ns\n0 .51503 m\n.00375 .51503 L\
\ns\n0 .54446 m\n.00375 .54446 L\ns\n0 .57389 m\n.00375 .57389 L\ns\n.25 \
Mabswid\n0 0 m\n0 .61803 L\ns\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\n\
closepath\nclip\nnewpath\n0 0 0 r\n.5 Mabswid\n.6 .01472 m\n.6 .60332 L\ns\n\
.55 .01472 m\n.65 .01472 L\ns\n.55 .60332 m\n.65 .60332 L\ns\n1 1 1 r\n.4 \
.01472 m\n.4 .60332 L\n.8 .60332 L\n.8 .01472 L\nF\n0 0 0 r\n.4 .01472 m\n.4 \
.60332 L\n.8 .60332 L\n.8 .01472 L\n.4 .01472 L\ns\n.4 .30902 m\n.8 .30902 L\n\
s\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.754707 \
0.00342212 0.97619 0.140307 MathSubStart\n%% Graphics\n/Courier findfont 10  \
scalefont  setfont\n% Scaling calculations\n0 0.2 -0.573889 0.00588604 [\n\
[-0.0125 .01472 -18 -4.5 ]\n[-0.0125 .01472 0 4.5 ]\n[-0.0125 .13244 -18 -4.5 \
]\n[-0.0125 .13244 0 4.5 ]\n[-0.0125 .25016 -18 -4.5 ]\n[-0.0125 .25016 0 4.5 \
]\n[-0.0125 .36788 -18 -4.5 ]\n[-0.0125 .36788 0 4.5 ]\n[-0.0125 .4856 -18 \
-4.5 ]\n[-0.0125 .4856 0 4.5 ]\n[-0.0125 .60332 -18 -4.5 ]\n[-0.0125 .60332 0 \
4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 \
setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n0 .01472 \
m\n.00625 .01472 L\ns\n[(100)] -0.0125 .01472 1 0 Mshowa\n0 .13244 m\n.00625 \
.13244 L\ns\n[(120)] -0.0125 .13244 1 0 Mshowa\n0 .25016 m\n.00625 .25016 L\n\
s\n[(140)] -0.0125 .25016 1 0 Mshowa\n0 .36788 m\n.00625 .36788 L\ns\n[(160)] \
-0.0125 .36788 1 0 Mshowa\n0 .4856 m\n.00625 .4856 L\ns\n[(180)] -0.0125 \
.4856 1 0 Mshowa\n0 .60332 m\n.00625 .60332 L\ns\n[(200)] -0.0125 .60332 1 0 \
Mshowa\n.125 Mabswid\n0 .04415 m\n.00375 .04415 L\ns\n0 .07358 m\n.00375 \
.07358 L\ns\n0 .10301 m\n.00375 .10301 L\ns\n0 .16187 m\n.00375 .16187 L\ns\n\
0 .1913 m\n.00375 .1913 L\ns\n0 .22073 m\n.00375 .22073 L\ns\n0 .27959 m\n\
.00375 .27959 L\ns\n0 .30902 m\n.00375 .30902 L\ns\n0 .33845 m\n.00375 .33845 \
L\ns\n0 .39731 m\n.00375 .39731 L\ns\n0 .42674 m\n.00375 .42674 L\ns\n0 \
.45617 m\n.00375 .45617 L\ns\n0 .51503 m\n.00375 .51503 L\ns\n0 .54446 m\n\
.00375 .54446 L\ns\n0 .57389 m\n.00375 .57389 L\ns\n.25 Mabswid\n0 0 m\n0 \
.61803 L\ns\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\n\
0 0 0 r\n.5 Mabswid\n.6 .01472 m\n.6 .60332 L\ns\n.55 .01472 m\n.65 .01472 L\n\
s\n.55 .60332 m\n.65 .60332 L\ns\n1 1 1 r\n.4 .02943 m\n.4 .52974 L\n.8 \
.52974 L\n.8 .02943 L\nF\n0 0 0 r\n.4 .02943 m\n.4 .52974 L\n.8 .52974 L\n.8 \
.02943 L\n.4 .02943 L\ns\n.4 .1913 m\n.8 .1913 L\ns\nMathSubEnd\nP\n% End of \
sub-graphic\n% End of Graphics\nMathPictureEnd\n\\\n\\>\"], \"Graphics\",\n  \
ImageSize->{534.375, 76.75},\n  ImageMargins->{{43, 0}, {0, 0}},\n  \
ImageRegion->{{0, 1}, {0, 1}},\n  ImageCache->GraphicsData[\"Bitmap\", \
\"\\<\\\nCF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008F0000C0P10`4000010?\
ooooooc?ooZ_ooI_oo\n\
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?\
lc\noclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@\
X61PL30`000\n\
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/\
`c\n<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<\
iW<09VI\noiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<\
iTc09T0oiT0c1<C\n\
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<\
01LG5eIFEYFEUMCDe01E\n\
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/\
K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o\n\
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=\
Vc3=V\nVC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`\
3oc03oV@3oIRLW\n\
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:\
fYZJZVYZNSXj02Z\n\
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?\
oo0140\n003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@\
00A0008P00\n\
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0o`0H0000o`3o01P0003o0?l060000?\
l0\no`0H00008@04og/00_oo07D0000R0003o`0000<000?o0000M0001?l00?l20003o`000?l0K`\
0002<0\n00?o00000P000ol0000/00[o?P001?l00?l20003o`0002d02_oo03P0000T0005o`000?\
l0<`000ol0\n\
001000?o0`000ol0000a0003o`0004400oma00?o1002o`@00_mf00008@001?l00?l30003o`\
000340\n00?o0000@0000ol000030003o`00034000?o0000@P000ol000020003o`0006`000?\
o00000P001?l0\n\
0?l20004o`00o`<000?o0000K`0002800_l40003o`00034000?o0000@@03o`8000?o0000<@\
000ol0\n00120003o`0000800_lU02So80000ol000020004o`00o`8000Co003o0`\
000ol0000b00_o<P0002P0\n\
00?o00007`0TocL000?o0000<@000ol000120003o`00008000?o000090000ol0000T0003o`\
0001h0\n00?o00000P001?l00?l20004o`00o`<000?o0000900Xob<0000X0003o`0001l000?\
o000080000ol0\n\
000e0003o`00034000?o0000@P000ol000020003o`0002@000?o000090000ol0000N0003o`\
000080\n00Co003o0P001?l00?l30003o`0002@000?o000090000ol0000Q0000:\
0000ol0000O0003o`000200\n\
00?o0000=@000ol0000P02Co<@02o`@00_lU0003o`0002@000?o00007@02o`D00_l400;\
o10000ol0\n\
000T0003o`0002@000?o00008@0001D01?l300;o0`03o`@000?o00007`000ol0000P0003o`\
0003D0\n00?o000080000ol0000P0003o`0003D000?o000090000ol0000T0003o`00030000?\
o000090000ol0\n\
000T0003o`000240000F0003o`0000<00_l60005o`000?l08@000ol0000P0003o`0003D000?\
o0000\n80000ol0000P0003o`0003D000?o000090000ol0000T0003o`00030000?\
o000090000ol0000T0003\n\
o`000240000G0003o`0000X000Go0000o`0Q0003o`00020000?o0000=@000ol0000P0003o`\
000200\n00?o0000=@02obD000?o000090000ol0000`0003o`0002@000?\
o000090000ol0000Q000060000ol0\n\
000600?o10000ol0000O0003o`00020000?o0000=@000ol0000P0003o`00020000?o0000=@\
000ol0\n000T0003o`0002@000?o0000<0000ol0000T0003o`0002@000?o00008@\
0001D000Co003o20000ol0\n\
00040003o`0001l000?o000080000ol0000`0003o`00008000?o000080000ol0000P0003o`\
0003D0\n00?o000090000ol0000T0003o`00030000?o000090000ol0000T0003o`\
000240000F00;o2@04o`<0\n\
00?o00007`000ol0000P0003o`00030000?o00000P000ol0000P0003o`00020000?o0000=@\
02obD0\n00?o000090000ol0000M00?o0`04o`<00_l40003o`0002@000?\
o000090000ol0000Q0000:0000ol0\n\
000O0003o`00020000?o0000<@001Ol0003o028000?o000080000ol0000e0003o`0002@000?\
o0000\n90000ol0000N0003o`0000<000?o00000P001?l00?l30003o`0002@000?\
o000090000ol0000Q0000\n\
:0000ol0000O0003o`00020000?o0000<@001Ol0003o028000?o000080000ol0000e00;o9@\
000ol0\n000T0003o`0001h000?o000010001Ol0003o008000Go0000o`0V0003o`0002@000?\
o00008@000240\n\
0ol40003o`0001l000?o000080000ol0000b0004o`00ob8000?o000080000ol0000S00?o1002o`\
<0\n0ol30003o`0002@000?o000090000ol0000N0003o`\
0000D000Co003o0P001Ol0003o02H000?o0000\n\
90000ol0000Q000090001Ol0003o024000?o000080000ol0000_00Co0P000ol0000P0003o`\
000200\n00?o000090000ol0000300;o1P001?l00?lV0003o`0002@000?\
o00007P000ol000020004o`00o`80\n\
00Co003o0`000ol0000T0003o`0002@000?o00008@0002@000Go0000o`0Q0003o`00020000?\
o0000\n=@000ol0000P0003o`00020000?o000090000ol0000;0003o`0000;o9@\
000ol0000T0003o`0001d0\n\
0_l500;o1002o`@000?o000090000ol0000T0003o`000240000R00;o10000ol0000O0003o`\
000200\n00?o0000=@000ol0000P0003o`00020000?o000090000ol0000800?o0`\
000ol0000T0003o`0002@0\n\
00?o0000<0000ol0000T0003o`0002@000?o00008@0002@000Go0000o`0Q0003o`00020000?\
o0000\n=@000ol0000P0003o`00020000?o000090000ol000080003o`0000<000?\
o000090000ol0000T0003\n\
o`00030000?o000090000ol0000T0003o`000240000Q00?o10000ol0000O0003o`00020000?\
o0000\n=@000ol0000P0003o`00020000?o00008`02o`X01?l200;o9@000ol0000T0003o`\
00030000?o0000\n\
900Xob<0000X0003o`0001l000?o000080000ol0000e0003o`00020000?\
o000080000ol0000e0003\n\
o`0002@000?o000090000ol0000`0003o`0002@000?o000090000ol0000Q0000:\
0000ol0000O0003\n\
o`00020000?o0000=@000ol0000P0003o`00020000?o0000=@000ol0000T0003o`0002@000?\
o0000\n<0000ol0000T0003o`0002@000?o00008@0002P000?o00007`000ol0000P0003o`\
0003D000?o0000\n\
80000ol0000P0003o`0003D00_lU0003o`0002@000?o0000<0000ol0000T0003o`0002@000?\
o0000\n8@0001D00ol400;o0`03o`@000?o00007`000ol0000P0003o`0003000_l30003o`\
00020000?o0000\n\
80000ol0000e0003o`0002@000?o000090000ol0000M00?o1003o`<00_l40003o`0002@000?\
o0000\n90000ol0000Q000060001?l00002o`H000Go0000o`0Q0003o`00020000?o0000;`001?\
l00?l20003\n\
o`00020000?o000080000ol0000e0003o`0002@000?o000090000ol0000N0003o`0000@\
000Go0000\n\
o`020005o`000?l09P000ol0000T0003o`000240000H0003o`0000T000Go0000o`0Q02Co<@001?\
l0\n0?l20003o`0002009?lg00;o9@000ol0000T0003o`0001h000?o00000P04o`8000Co003o0`\
000ol0\n000T0003o`0002@000?o00008@0001H00_l900?o10000ol0000O0003o`00020000?\
o0000<002o`<0\n\
00?o000080000ol0000P0003o`0003D000?o000090000ol0000T0003o`0001h000?\
o00000P000ol0\n\
o`030004o`00o`<000?o000090000ol0000T0003o`000240000H0003o`0000H000?\
o000010000ol0\n\
000O0003o`00020000?o0000;`001?l00?l20003o`00020000?o000080000ol0000e0003o`\
0002@0\n00?o000090000ol0000N0003o`00008000?o0?l00`001?l00?l30003o`0002@000?\
o000090000ol0\n\
000Q00005@03o`T01?l30003o`0001l000?o000080000ol0000`00;o0`000ol0000P0003o`\
000200\n00?o0000=@02obD000?o000090000ol0000M00;o1@02o`@00_l40003o`0002@000?\
o000090000ol0\n\
000Q0000:0000ol0000O0003o`00020000?o0000=@000ol0000P0003o`00020000?o0000;`04o`\
80\n00?o000090000ol0000T0003o`00030000?o000090000ol0000T0003o`000240000X0003o`\
0001l0\n00?o000080000ol0000e0003o`00020000?o000080000ol0000`0003o`00008000?\
o000090000ol0\n\
000T0003o`00030000?o000090000ol0000T0003o`000240000R00?o0`000ol0000O0003o`\
000200\n00?o0000=@000ol0000P0003o`00020000?o0000<@001?l00002obD0:?lb0003o`\
0002@000?o0000\n\
90000ol0000Q00008`000ol000020003o`0001l000?o000080000ol0000e0003o`00020000?\
o0000\n80000ol0000b0004o`00obH000?o000090000ol0000`0003o`0002@000?\
o000090000ol0000Q0000\n\
8@04o`<000?o00007`000ol0000P0003o`0003D000?o000080000ol0000P0003o`\
0002l000Co003o\n\
0P000ol0000T0003o`0002@000?o0000<0000ol0000T0003o`0002@000?o00008@00024000?o0?\
l0\n10000ol0000O0003o`00020000?o0000=@000ol0000P0003o`00020000?o0000<002o`<00_\
lU0003\no`0002@000?o00007@03o`@00_l400;o10000ol0000T0003o`0002@000?o00008@\
00024000?o0?l0\n\
10000ol0000O0003o`00020000?o0000=@000ol0000P0003o`00020000?o0000=@\
000ol0000T0003\n\
o`0002@000?o00007P000ol000020004o`00o`8000Co003o0`000ol0000T0003o`0002@000?\
o0000\n8@0002800_l40003o`0001l000?o000080000ol0000_00?o0`000ol0000P0003o`\
00020000?o0000\n\
=@02obD000?o000090000ol0000N0003o`00008000Co003o0P001?l00?l30003o`0002@000?\
o0000\n90000ol0000Q0000:0000ol0000O0003o`00020000?o0000<P001?l00?lR0003o`\
00020000?o0000\n\
=@000ol0000T0003o`0002@000?o00007P000ol0000200?o0`001?l00?l30003o`0002@000?\
o0000\n90000ol0000Q0000:0000ol0000O0003o`00020000?o0000<003o`8000?\
o000080000ol0000P0003\n\
o`0003D000?o000090000ol0000T0003o`0001h000?o00000P000ol000030004o`00o`<000?\
o0000\n90000ol0000T0003o`000240000X0003o`0001l000?o000080000ol0000_0004o`00o`\
8000?o0000\n\
80000ol0000P0003o`0003D00_lU0003o`0002@000?o00007@02o`D00ol300;\
o10000ol0000T0003\n\
o`0002@000?o00008@0001H00ol300;o0`03o`@000?o00007`000ol0000P0003o`\
0002l000Co003o\n\
0P000ol0000P0003o`00020000?o0000=@000ol0000T0003o`0002@000?o0000<\
0000ol0000T0003\n\
o`0002@000?o00008@0001L000?o00000P02o`H000Go0000o`0Q0003o`00020000?o0000<002o`\
<0\n00?o000080000ol0000P0003o`0003D000?o000090000ol0000T0003o`00030000?\
o000090000ol0\n\
000T0003o`000240000E00Co2`001Ol0003o024000?o000080000ol0000e0003o`00020000?\
o0000\n80000ol0000e00;o9@000ol0000T0003o`00030000?o000090000ol0000T0003o`\
000240000E0003\n\
o`3o00T00ol40003o`0001l000?o000080000ol0000e0003o`00020000?\
o000080000ol0000S00Co\n\
0`02o`<00ol30003o`0002@000?o000090000ol0000`0003o`0002@000?\
o000090000ol0000Q0000\n\
5@000ol0o`090003o`0000@000?o00007`000ol0000P0003o`0003D000?o0000800TobH000?\
o0000\n0`02o`H000Co003o9P000ol0000T0003o`00030000?o000090000ol0000T0003o`\
000240000F00;o\n\
2@04o`<000?o00007`000ol0000P0003o`0003D000?o0000<@000ol0000g0003o`0000X000?\
o0000\n0_lU0003o`0002@000?o0000<0000ol0000T0003o`0002@000?o00008@0002P000?\
o00007`0TocL0\n\
00?o0000<@000ol0000h0003o`0000H00ol30003o`0002@000?o000090000ol0000M00?o1002o`\
@0\n0_l40003o`0002@000?o000090000ol0000Q0000:0000ol0000a0003o`0004H000?o0000<@\
000ol0\n000e0004o`00o`P000?o00000`000ol0000T0003o`0002@000?\
o00007P000ol000020004o`00o`80\n\
00Co003o0`000ol0000T0003o`0002@000?o00008@0002400ol40003o`00034000?o0000>P03o`\
@0\n0_l30003o`00034000?o0000=P02o`T01?l200;o9@000ol0000T0003o`0001h000?\
o00000P001?l0\n\
0?l20004o`00o`<000?o000090000ol0000T0003o`000240000T0005o`000?l0<`\
000ol0000k0003\n\
o`00008000Co003o0P000ol0000a0003o`0004L000?o000090000ol0000T0003o`0001h000?\
o0000\n0`02o`<000Co003o0`000ol0000T0003o`0002@000?o00008@0002@000Go0000o`0^00[\
o>@000ol0\n\
00020004o`00o`8000?o0000;@0:od@000?o000090000ol0000T0003o`0001h000?o00000P001?\
l0\n0?l20004o`00o`<000?o000090000ol0000T0003o`000240000Q00?o10000ol0001_0003o`\
000080\n00Co003o0P000ol0001k00;o9@000ol0000T0003o`0001d00_l500;o1002o`@000?\
o000090000ol0\n\
000T0003o`000240000Q0003o`0000@000?o0000K`000ol000020004o`00o`8000?o0000N`\
000ol0\n000T0003o`0002@000?o0000<0000ol0000T02So8`0002401?md00;o1@02oh4000?\
o000090000ol0\n\
000T0003o`00030000?o0000=`000ol0000e0000o`0T00;o9@000ol0000T0003o`00030000?\
o0000\n=`000ol0000e0000o`0T0003o`0002@000?o000090000ol0000`0003o`0003L000?\
o0000=@000?l0\n\
9002obD000?o000090000ol0000`0003o`0003L000?o0000=@0004H00ol200Go0P03o`\
801Ol200Co\n\
J@000ol0o`0400CoA`03o`<000?o000090000ol0000T0003o`0001d01?l300;o1002o`@000?\
o0000\n=`000ol0000e0000A`000ol000030003o`00008000Co003o0`001Ol0003o06h000?o0?\
l010000ol0\n\
001:0004o`00obH000?o000090000ol0000N0003o`00008000Co003o0P001?l00?l30003o`\
0003L0\n00?o0000=@0004L000?o00000`000ol000020003o`0000@000Co00001OmY00Ko0`\
000ol000190003\n\
o`0000;o9@0Xob4000Go0000o`020004o`00o`8000Go0000o`0d00_o<P0004D000Go0?l0o`\
030003\no`00008000?o000010001Ol0003o00<000?o0000J0000ol0o`060003o`0004H00_\
l30003o`0006h0\n\
00Co003o0P001?l00?l20005o`000?l0L@0004D000Go0?l0o`0200;o0`04o`@000?\
o00000P03ofX0\n\
1_l01@3o003o04X000Co003oK@001?l00?l20004o`00o`8000Co003o0`000ol0001_0000A@05o`\
P0\n00?o000010000ol0001a0003o`3o00<00_m800?oLP02o`@00_l400;oMP0004d000?\
o00000P000ol0\n\
000200?oM0000ol0o`3o04H0003o0?l060000?l0o`0H0000o`3o01P0003o0?l060000?l0o`\
0H0000\n\\\n\\>\"],\n  ImageRangeCache->{{{0, 533.375}, {75.75, 0}} -> \
{-0.125304, -0.0143759,\n  0.00796928, 0.00796928}, {{15.6875, 132.438}, \
{73.9375, 1.75}} -> {-2.29504,\n   1.63097, 0.0573519, 0.0584624}, {{144.125, \
260.812}, {73.9375, 1.75}} ->\n   {-9.48733, 5.50796, 0.0573519, 0.0779497}, \
{{272.5, 389.25}, {73.9375,\n  1.75}} -> {-14.9554, 0.679384, 0.0512663, \
0.0348393}, {{400.875, 517.625}, {\n  73.9375, 1.75}} -> {-21.5367, 83.9692, \
0.0512663, 1.74196}}],\n\nCell[BoxData[\n    TagBox[\\(\\[SkeletonIndicator]  \
GraphicsArray  \\[SkeletonIndicator]\\),\n      False,\n      \
Editable->False]], \"Output\"]\n}, Open  ]],\n\nCell[BoxData[\n    \
\\(\\(\\n\\(RemoveN1[inlist_List] := \\n\\t\n      Block[{outlist, n}, \\n\\t\
\\toutlist = {}; \\n\\t\\t\n        Do[\\n\\t\\t\\t\n          \
If[\\n\\t\\t\\t\\tinlist[\\([n]\\)] >= 0,\n            outlist = \
Append[outlist, inlist[\\([n]\\)]]], \\n\n          \\t\\t\\t{n, \
Length[inlist]}\\n\\t\\t]; \\n\\t\\tReturn[outlist]; \\n\\t\\t];\n    \
\\)\\n\\)\\)], \"Input\"],\n\nCell[CellGroupData[{\n\nCell[BoxData[{\n    \
\\(LungWait\n       = {77, \\(-1\\), 273, 371, 269, \\(-1\\), 130, 363, 417, \
\\(-1\\), 333, 124,\n        239, \\(-1\\), 274, 282, 598, \\(-1\\), \
\\(-1\\), 233, 114, 43, \\(-1\\),\n        \\(-1\\), \\(-1\\), 793, \\(-1\\), \
\\(-1\\), 366, 690, 408, \\(-1\\), \\(-1\\),\n        449, 762, 347, 801, \
332, \\(-1\\), \\(-1\\), 62, 148, 99, \\(-1\\), 80,\n        317, \\(-1\\), \
126, \\(-1\\), 180, \\(-1\\), \\(-1\\), \\(-1\\), 528, \\(-1\\),\n        \
246, 155, 162}\\),\n    \\(LungM\n       = {33.3, 37.5, 43.3, 5.6, 0, 33.3, \
\\(-1\\), 34.8, 33.3, 77.8, \\(-1\\),\n        \\(-1\\), \\(-1\\), 57.1, 40, \
\\(-1\\), 0, 25, 60, 0, 100, 50, 50, 28.6,\n        27.3, 30, 22.2, 33.3, \
19.4, 23.6, 53.8, 28.6, 66.7, \\(-1\\), 16.7,\n        \\(-1\\), 36.1, 43.5, \
33.3, 16.7, \\(-1\\), \\(-1\\), \\(-1\\), 50, 0, 35.8,\n        100, 43.2, \
100, 75, 0, 0, 100, 30, 25, \\(-1\\), 0, 50}\\),\n    \\(LungV\n       = {3, \
4, 8, 9, 1, 2, \\(-1\\), 8, 2, 2, \\(-1\\), \\(-1\\), \\(-1\\), 2, 4,\n       \
 \\(-1\\), 7, 4, 2, 1, 1, 2, 1, 7, 7, 10, 2, 3, 8, 27, 7, 2, 3, \\(-1\\),\n   \
     18, \\(-1\\), 12, 12, 3, 2, \\(-1\\), \\(-1\\), \\(-1\\), 2, 7, 13, 1, \
6, 1,\n        2, 1, 3, 1, 5, 8, \\(-1\\), 2, 1}\\n\\)}], \"Input\"],\n\n\
Cell[BoxData[\n    \\({77, \\(-1\\), 273, 371, 269, \\(-1\\), 130, 363, 417, \
\\(-1\\), 333, 124,\n      239, \\(-1\\), 274, 282, 598, \\(-1\\), \\(-1\\), \
233, 114, 43, \\(-1\\),\n      \\(-1\\), \\(-1\\), 793, \\(-1\\), \\(-1\\), \
366, 690, 408, \\(-1\\), \\(-1\\),\n      449, 762, 347, 801, 332, \\(-1\\), \
\\(-1\\), 62, 148, 99, \\(-1\\), 80, 317,\n      \\(-1\\), 126, \\(-1\\), \
180, \\(-1\\), \\(-1\\), \\(-1\\), 528, \\(-1\\), 246,\n      155, 162}\\)], \
\"Output\"],\n\nCell[BoxData[\n    RowBox[{\"{\",\n      RowBox[{\n        \
StyleBox[\"33.2999999999999962`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\",\n        StyleBox[\"37.5`\",\n          \
StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\",\n        \
StyleBox[\"43.3000000000000007`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\",\n        StyleBox[\"5.59999999999999964`\",\n \
         StyleBoxAutoDelete->True,\n          PrintPrecision->2], \",\", \
\"0\", \",\",\n        StyleBox[\"33.2999999999999962`\",\n          \
StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\", \\(-1\\), \",\
\",\n        StyleBox[\"34.7999999999999953`\",\n          \
StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\",\n        \
StyleBox[\"33.2999999999999962`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\",\n        StyleBox[\"77.7999999999999936`\",\n \
         StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\", \
\\(-1\\), \",\", \\(-1\\), \",\", \\(-1\\), \",\",\n        \
StyleBox[\"57.0999999999999996`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\", \"40\", \",\", \\(-1\\), \",\", \"0\", \",\", \
\"25\",\n        \",\", \"60\", \",\", \"0\", \",\", \"100\", \",\", \"50\", \
\",\", \"50\", \",\",\n        StyleBox[\"28.6000000000000031`\",\n          \
StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\",\n        \
StyleBox[\"27.2999999999999998`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\", \"30\", \",\",\n        \
StyleBox[\"22.1999999999999975`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\",\n        StyleBox[\"33.2999999999999962`\",\n \
         StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\",\n    \
    StyleBox[\"19.3999999999999985`\",\n          StyleBoxAutoDelete->True,\n \
         PrintPrecision->3], \",\",\n        \
StyleBox[\"23.6000000000000031`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\",\n        StyleBox[\"53.7999999999999989`\",\n \
         StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\",\n    \
    StyleBox[\"28.6000000000000031`\",\n          StyleBoxAutoDelete->True,\n \
         PrintPrecision->3], \",\",\n        \
StyleBox[\"66.6999999999999992`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\", \\(-1\\), \",\",\n        \
StyleBox[\"16.6999999999999992`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\", \\(-1\\), \",\",\n        \
StyleBox[\"36.1000000000000031`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\",\n        StyleBox[\"43.4999999999999964`\",\n \
         StyleBoxAutoDelete->True,\n          PrintPrecision->3], \",\",\n    \
    StyleBox[\"33.2999999999999962`\",\n          StyleBoxAutoDelete->True,\n \
         PrintPrecision->3], \",\",\n        \
StyleBox[\"16.6999999999999992`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\", \\(-1\\), \",\", \\(-1\\), \",\", \\(-1\\), \
\",\",\n        \"50\", \",\", \"0\", \",\",\n        \
StyleBox[\"35.7999999999999962`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\", \"100\", \",\",\n        \
StyleBox[\"43.2000000000000028`\",\n          StyleBoxAutoDelete->True,\n     \
     PrintPrecision->3], \",\", \"100\", \",\", \"75\", \",\", \"0\", \",\", \
\"0\", \",\",\n        \"100\", \",\", \"30\", \",\", \"25\", \",\", \
\\(-1\\), \",\", \"0\", \",\", \"50\"}],\n      \"}\"}]], \"Output\"],\n\n\
Cell[BoxData[\n    \\(General::\"spell1\" \\( : \\ \\)\n      \"Possible \
spelling error: new symbol name \\\"\\!\\(LungV\\)\\\" is similar to \\\n\
existing symbol \\\"\\!\\(LungM\\)\\\".\"\\)], \"Message\"],\n\nCell[BoxData[\
\n    \\({3, 4, 8, 9, 1, 2, \\(-1\\), 8, 2, 2, \\(-1\\), \\(-1\\), \\(-1\\), \
2, 4,\n      \\(-1\\), 7, 4, 2, 1, 1, 2, 1, 7, 7, 10, 2, 3, 8, 27, 7, 2, 3, \
\\(-1\\),\n      18, \\(-1\\), 12, 12, 3, 2, \\(-1\\), \\(-1\\), \\(-1\\), 2, \
7, 13, 1, 6, 1, 2,\n      1, 3, 1, 5, 8, \\(-1\\), 2, 1}\\)], \"Output\"]\n}, \
Closed]],\n\nCell[CellGroupData[{\n\nCell[BoxData[\n    \
\\(\\(\\nBWPlot[{RemoveN1[LungWait], RemoveN1[LungM], RemoveN1[LungV]}, {\n   \
     PlotLabel -> \"\\<Lung Wait,Mort,Vol\\>\"}]\\)\\)], \"Input\"],\n\n\
Cell[GraphicsData[\"PostScript\", \"\\<\\\n%!\n%%Creator: Mathematica\n\
%%AspectRatio: .61803\nMathPictureStart\n/Mabs {\nMgmatrix idtransform\n\
Mtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\
\nexch } bind def\n%% Graphics\n/Courier findfont 10  scalefont  setfont\n% \
Scaling calculations\n0 0.0714286 0.0147151 0.000734836 [\n[-0.0125 .01472 -6 \
-4.5 ]\n[-0.0125 .01472 0 4.5 ]\n[-0.0125 .16168 -18 -4.5 ]\n[-0.0125 .16168 \
0 4.5 ]\n[-0.0125 .30865 -18 -4.5 ]\n[-0.0125 .30865 0 4.5 ]\n[-0.0125 .45562 \
-18 -4.5 ]\n[-0.0125 .45562 0 4.5 ]\n[-0.0125 .60258 -18 -4.5 ]\n[-0.0125 \
.60258 0 4.5 ]\n[.5 .63053 -56 0 ]\n[.5 .63053 56 14 ]\n[ 0 0 0 0 ]\n[ 1 \
.61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\n\
newpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n0 .01472 m\n.00625 .01472 L\ns\n\
[(0)] -0.0125 .01472 1 0 Mshowa\n0 .16168 m\n.00625 .16168 L\ns\n[(200)] \
-0.0125 .16168 1 0 Mshowa\n0 .30865 m\n.00625 .30865 L\ns\n[(400)] -0.0125 \
.30865 1 0 Mshowa\n0 .45562 m\n.00625 .45562 L\ns\n[(600)] -0.0125 .45562 1 0 \
Mshowa\n0 .60258 m\n.00625 .60258 L\ns\n[(800)] -0.0125 .60258 1 0 Mshowa\n\
.125 Mabswid\n0 .05146 m\n.00375 .05146 L\ns\n0 .0882 m\n.00375 .0882 L\ns\n0 \
.12494 m\n.00375 .12494 L\ns\n0 .19842 m\n.00375 .19842 L\ns\n0 .23517 m\n\
.00375 .23517 L\ns\n0 .27191 m\n.00375 .27191 L\ns\n0 .34539 m\n.00375 .34539 \
L\ns\n0 .38213 m\n.00375 .38213 L\ns\n0 .41888 m\n.00375 .41888 L\ns\n0 \
.49236 m\n.00375 .49236 L\ns\n0 .5291 m\n.00375 .5291 L\ns\n0 .56584 m\n\
.00375 .56584 L\ns\n.25 Mabswid\n0 0 m\n0 .61803 L\ns\ngsave\n.5 .63053 -117 \
-4 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 22 translate 1 -1 \
scale\n63.000000 15.000000 moveto\n%%IncludeResource: font Courier\n\
%%IncludeFont: Courier\n/Courier findfont 10.000000 scalefont\n[1 0 0 -1 0 0 \
] makefont setfont\n0.000000 0.000000 0.000000 setrgbcolor\n0.000000 0.000000 \
rmoveto\n63.000000 15.000000 moveto\n%%IncludeResource: font Courier\n\
%%IncludeFont: Courier\n/Courier findfont 10.000000 scalefont\n[1 0 0 -1 0 0 \
] makefont setfont\n0.000000 0.000000 0.000000 setrgbcolor\n(Lung) show\n\
93.000000 15.000000 moveto\n(Wait) show\n117.000000 15.000000 moveto\n\
%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont \
10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000000 0.000000 \
0.000000 setrgbcolor\n(,) show\n123.000000 15.000000 moveto\n\
%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont \
10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000000 0.000000 \
0.000000 setrgbcolor\n(Mort) show\n147.000000 15.000000 moveto\n\
%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont \
10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000000 0.000000 \
0.000000 setrgbcolor\n(,) show\n153.000000 15.000000 moveto\n\
%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont \
10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000000 0.000000 \
0.000000 setrgbcolor\n(Vol) show\n171.000000 15.000000 moveto\n\
%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont \
10.000000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000000 0.000000 \
0.000000 setrgbcolor\n0.000000 0.000000 rmoveto\n1.000000 setlinewidth\n\
%%DocumentNeededResources: font Courier\n%%DocumentSuppliedResources:\n\
%%DocumentNeededFonts: Courier\n%%DocumentSuppliedFonts:\n%%DocumentFonts: \
font Courier\ngrestore\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\
\nnewpath\n0 0 0 r\n.5 Mabswid\n.21429 .04631 m\n.21429 .60332 L\ns\n.19643 \
.04631 m\n.23214 .04631 L\ns\n.19643 .60332 m\n.23214 .60332 L\ns\n1 1 1 r\n\
.14286 .11355 m\n.14286 .30773 L\n.28571 .30773 L\n.28571 .11355 L\nF\n0 0 0 \
r\n.14286 .11355 m\n.14286 .30773 L\n.28571 .30773 L\n.28571 .11355 L\n.14286 \
.11355 L\ns\n.14286 .21569 m\n.28571 .21569 L\ns\n.42857 .01472 m\n.42857 \
.0882 L\ns\n.41071 .01472 m\n.44643 .01472 L\ns\n.41071 .0882 m\n.44643 .0882 \
L\ns\n1 1 1 r\n.35714 .03103 m\n.35714 .05146 L\n.5 .05146 L\n.5 .03103 L\nF\n\
0 0 0 r\n.35714 .03103 m\n.35714 .05146 L\n.5 .05146 L\n.5 .03103 L\n.35714 \
.03103 L\ns\n.35714 .03919 m\n.5 .03919 L\ns\n.64286 .01545 m\n.64286 .03456 \
L\ns\n.625 .01545 m\n.66071 .01545 L\ns\n.625 .03456 m\n.66071 .03456 L\ns\n1 \
1 1 r\n.57143 .01618 m\n.57143 .01986 L\n.71429 .01986 L\n.71429 .01618 L\nF\n\
0 0 0 r\n.57143 .01618 m\n.57143 .01986 L\n.71429 .01986 L\n.71429 .01618 L\n\
.57143 .01618 L\ns\n.57143 .01692 m\n.71429 .01692 L\ns\n% End of Graphics\n\
MathPictureEnd\n\\\n\\>\"], \"Graphics\",\n  ImageSize->{288, 177.938},\n  \
ImageMargins->{{43, 0}, {0, 0}},\n  ImageRegion->{{0, 1}, {0, 1}},\n  \
ImageCache->GraphicsData[\"Bitmap\", \"\\<\\\n\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o6@\
3oool0\n0`000000oooo0?ooo`3o0?ooo`D0oooo000I0?ooo`030000003oool0oooo0?l0oooo1@\
3oool00180\n\
oooo0P0000050?ooo`030000003oool0oooo0?l0oooo1@3oool00140oooo00@000000?ooo`\
3oool0\n0000103oool00`000000oooo0?ooo`3o0?ooo`D0oooo000A0?ooo`\
040000003oool0oooo000000@0\n\
oooo0`00001W0?ooo`X000007`3ooolV000004h0oooo000A0?ooo`\
040000003oool0oooo000000@0\n\
oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0R0?\
ooobH00000CP3oool00140oooo\n\
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1[0?ooo`\
030000003oool0oooo03@0\n\
oooo00<000000?ooo`3oool0G`3oool00180oooo0P0000050?ooo`030000003oool0oooo06/\
0oooo\n00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`1O0?ooo`006@3oool00`\
000000oooo0?oo\n\
o`1I0?ooobH000008`3oool00`000000oooo0?ooo`1O0?ooo`006@3oool00`000000oooo0?ooo`\
1I\n0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool07@3oool:000005`\
0oooo000I0?oo\n\
o`030000003oool0oooo05T0oooo9P0000250?ooo`006@3oool00`000000oooo0?ooo`1I0?ooo`\
03\n0000003oool0oooo0280oooo00<000000?ooo`3oool0P`3oool001T0oooo00<000000?ooo`\
3oool0\n<03oool:000001l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`230?\
ooo`006@3o\n\
ool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0280oooo00<000000?ooo`\
3oool08P3o\n\
ool00`000000oooo0?ooo`230?ooo`006@3oool2000003D0oooo00<000000?ooo`\
3oool08P3ooolV\n\
000008D0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0=03oool00`\
00\n0000oooo0?ooo`2F0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003oool0oooo03@0\n\
oooo00<000000?ooo`3oool0UP3oool001T0oooo00<000000?ooo`3oool0=03oool00`\
000000oooo\n\
0?ooo`0d0?ooo`030000003oool0oooo09H0oooo000I0?ooo`030000003oool0oooo03@\
0oooo00<0\n\
00000?ooo`3oool0=03oool00`000000oooo0?ooo`2F0?ooo`006@3oool00`000000oooo0?ooo`\
0d\n0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0UP3oool001T0oooo00<\
000000?oo\n\
o`3oool0=03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo09H0oooo000I0?ooo`\
03\n0000003oool0oooo03@0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2F0?\
ooo`00\n6@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo03@0oooo00<000000?\
ooo`3oool0\n\
UP3oool001T0oooo0P00000e0?ooo`030000003oool0oooo0300oooo2P00002C0?ooo`006@\
3oool0\n0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`\
030000003oool0oooo\n\
03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`\
000000\noooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003oool0oooo0<d0oooo\n\
000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<\
00000\n0?ooo`3oool08P3ooolU00000;d0oooo000I0?ooo`030000003oool0oooo0280oooo00<\
000000?oo\n\
o`3oool08@3oool00`000000oooo0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`0R0?ooo`\
03\n0000003oool0oooo0240oooo00<000000?ooo`3oool0^`3oool001T0oooo0P00000S0?ooo`\
030000\n003oool0oooo0240oooo00<000000?ooo`3oool0^`3oool001T0oooo00<000000?ooo`\
3oool08P3o\n\
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo000I0?ooo`\
030000003oool0\n\
oooo0280oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?ooo`006@3oool00`\
00\n0000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0^`\
3oool001T0\n\
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;\
/0\noooo000I0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool08@3oool00`\
000000oooo\n\
0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`0R0?ooo`\
030000003oool0oooo0240oooo00<0\n\
00000?ooo`3oool0^`3oool001T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`\
0Q\n0?ooo`030000003oool0oooo0;/0oooo00050?ooo`@000000`3oool2000000@\
0oooo0P0000050?oo\n\
o`030000003oool0oooo0280oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?\
oo\no`001P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@\
000000?oo\n\
o`3oool00000103oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<\
00000\n0?ooo`3oool0^`3oool000L0oooo00D000000?ooo`3oool0oooo000000020?ooo`\
040000003oool0\n\
oooo00000080oooo00<000000?ooo`3oool00P3oool300000280oooo00<000000?ooo`3oool08@\
3o\nool00`000000oooo0?ooo`2k0?ooo`00203oool010000000oooo0?ooo`0000020?ooo`\
040000003o\n\
ool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0R0?ooo`\
030000\n003oool0oooo0240oooo00<000000?ooo`3oool0^`3oool000D0oooo00@000000?ooo`\
3oool00000\n\
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?\
oo\no`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo00060?\
ooo`80\n0000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0280oooo00<\
000000?ooo`3o\n\
ool08@3oool00`000000oooo0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`0R0?ooo`\
030000\n003oool0oooo0240oooo00<000000?ooo`3oool0^`3oool001T0oooo00<000000?ooo`\
3oool08P3o\n\
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo000I0?ooo`\
030000003oool0\n\
oooo0280oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?ooo`006@3oool00`\
00\n0000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0^`\
3oool001T0\n\
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;\
/0\noooo000I0?ooo`8000008`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;\
/0oooo\n000I0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool08@3oool00`\
000000oooo0?oo\n\
o`2k0?ooo`006@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<\
00000\n0?ooo`3oool0^`3oool001T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?\
ooo`0Q0?oo\n\
o`030000003oool0oooo0;/0oooo000I0?ooo`030000003oool0oooo0280oooo00<000000?ooo`\
3o\nool08@3oool00`000000oooo0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`0R0?\
ooobD00000\n\
_@3oool001T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`\
030000003o\n\
ool0oooo0;/0oooo000I0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool08@\
3oool0\n0`000000oooo0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`0R0?ooo`\
030000003oool0oooo\n\
0240oooo00<000000?ooo`3oool0^`3oool001T0oooo00<000000?ooo`3oool08P3oool00`\
000000\noooo0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo000I0?ooo`8000008`3oool00`\
000000oooo\n\
0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo000I0?ooo`\
030000003oool0oooo0280oooo00<0\n\
00000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`\
0R\n0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0^`3oool001T0oooo00<\
000000?oo\n\
o`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo000I0?ooo`\
03\n0000003oool0oooo0280oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?\
ooo`00\n6@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<000000?\
ooo`3oool0\n\
^`3oool001T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`\
030000003o\n\
ool0oooo0;/0oooo000I0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool08@\
3oool0\n0`000000oooo0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`0R0?ooo`\
030000003oool0oooo\n\
0240oooo00<000000?ooo`3oool0^`3oool001T0oooo0P00000S0?ooo`\
030000003oool0oooo0240\n\
oooo00<000000?ooo`3oool0^`3oool001T0oooo00<000000?ooo`3oool08P3oool00`\
000000oooo\n\
0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo000I0?ooo`\
030000003oool0oooo0280oooo00<0\n\
00000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?ooo`006@3oool00`000000oooo0?ooo`\
0R\n0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0^`3oool001T0oooo00<\
000000?oo\n\
o`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;/0oooo000I0?ooo`\
03\n0000003oool0oooo0280oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?\
ooo`00\n6@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<000000?\
ooo`3oool0\n\
^`3oool001T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`\
030000003o\n\
ool0oooo0;/0oooo00060?ooo`<000000`3oool2000000@0oooo0P0000050?ooo`\
030000003oool0\n\
oooo0280oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2k0?ooo`001`3oool01@\
00\n0000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`\
000000oooo0?oo\n\
o`020?ooo`030000003oool0oooo0280oooo9@00002m0?ooo`001@3oool400000080oooo00@\
00000\n0?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`<00000=03oool00`\
000000oooo\n\
0?ooo`3=0?ooo`001@3oool00`000000oooo000000030?ooo`\
040000003oool0oooo00000080oooo\n\
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<\
d0\noooo00050?ooo`030000003oool0000000<0oooo00@000000?ooo`\
3oool000000P3oool010000000\n\
oooo0?ooo`0000040?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@\
3oool000H0\n\
oooo0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0=03oool00`\
000000\noooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003oool0oooo0<d0oooo\n\
000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<\
00000\n0?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?\
ooo`0d0?oo\n\
o`030000003oool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`\
3o\nool0c@3oool001T0oooo0P00000e0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`\
030000003o\n\
ool0oooo03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=\
03oool0\n0`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003oool0oooo\n\
0<d0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@\
3oool001T0oooo\n\
00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?\
oo\no`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@\
0oooo00<00000\n\
0?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?\
oo\no`006@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`\
800000\n=@3oool00`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003o\n\
ool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@\
3oool0\n01T0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@\
3oool00`000000\n\
oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@\
0oooo\n00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`\
000000oooo0?oo\n\
o`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?\
oo\no`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo0P00000e0?\
ooo`03\n0000003oool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?\
ooo`3oool0\n\
c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@\
3oool0\n0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`\
030000003oool0oooo\n\
03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`\
000000\noooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003oool0oooo0<d0oooo\n\
00060?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo03@\
0oooo00<0\n\
00000?ooo`3oool0c@3oool000D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?\
oo\no`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0=03oool00`\
000000\noooo0?ooo`3=0?ooo`001@3oool010000000oooo0?ooo`0000020?ooo`\
040000003oool0oooo0000\n\
0080oooo00@000000?ooo`3oool00000103oool3000003@0oooo00<000000?ooo`3oool0c@\
3oool0\n00D0oooo0`0000030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`\
3oool00000103o\n\
ool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo00050?ooo`\
030000003oool0\n\
oooo00<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`\
030000\n003oool0oooo03@0oooo00<000000?ooo`3oool0c@3oool000H0oooo0`0000030?ooo`\
800000103o\n\
ool2000000D0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@\
3oool0\n0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`\
030000003oool0oooo\n\
03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`\
000000\noooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003oool0oooo0<d0oooo\n\
000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<\
00000\n0?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@3oool2000003D0oooo00<\
000000?oo\n\
o`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`\
00\n6@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`\
030000003o\n\
ool0oooo03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=\
03oool0\n0`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003oool0\noooo\n\
0<d0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@\
3oool001T0oooo\n\
00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?\
oo\no`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`800000=@3oool00`000000oooo0?\
ooo`3=\n0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<\
d0oooo000I0?ooo`03\n\
0000003oool0oooo03@0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`\
3oool0\n=03oool00`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`\
030000003o\n\
ool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0c@\
3oool0\n01T0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@\
3oool00`000000\n\
oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@\
0oooo\n00<000000?ooo`3oool0c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`\
000000oooo0?oo\n\
o`3=0?ooo`006@3oool2000003D0oooo00<000000?ooo`3oool0c@3oool001T0oooo00<000000?\
oo\no`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@3oool00`000000oooo0?ooo`0d0?\
ooo`03\n0000003oool0oooo0<d0oooo000I0?ooo`030000003oool0oooo03@0oooo00<000000?\
ooo`3oool0\n\
c@3oool001T0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`006@\
3oool0\n0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo000I0?ooo`\
030000003oool0oooo\n\
03@0oooo00<000000?ooo`3oool0c@3oool000H0oooo0P0000040?ooo`\
800000103oool2000000D0\n\
oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`3=0?ooo`001@\
3oool010000000oooo\n\
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`\
3oool00000103oool0\n\
0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<d0oooo00050?ooo`\
040000003oool0oooo\n\
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`<\
00000\n<03oool:00000<X0oooo00060?ooo`8000000`3oool010000000oooo0?ooo`0000020?\
ooo`040000\n\
003oool0oooo000000@0oooo00<000000?ooo`3oool0o`3oool50?ooo`001@\
3oool010000000oooo\n\
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`\
3oool00000103oool0\n\
0`000000oooo0?ooo`3o0?ooo`D0oooo00060?ooo`800000103oool2000000@0oooo0P0000050?\
oo\no`030000003oool0oooo0?l0oooo1@3oool001T0oooo00<000000?ooo`3oool0o`3oool50?\
ooo`00\no`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`\
00N03oool300000:D0\n\
oooo001k0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool06`3oool00`\
000000oooo\n\
0?ooo`1S0?ooo`00I03oool500000080oooo1@\
000000103oool000000000003oool200000080oooo\n\
100000070?ooo`040000003oool0oooo00000080oooo1@0000000`\
3oool000000000000300000080\n\
oooo0`0000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?\
oo\no`<000000P3oool4000000<0oooo0`0000030?ooo`030000003oool0oooo00<0oooo00<\
000000?oo\n\
o`3oool00`3oool300000080oooo1@00001@0?ooo`00I@3oool010000000oooo0?ooo`0000020?\
oo\no`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@\
000000oooo0?oo\n\
o`3oool0000000L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?\
oo\no`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?\
ooo`3o\nool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000050?\
ooo`040000\n\
003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`\
05\n0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`1@0?ooo`00I@\
3oool010000000\n\
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`\
3oool000000P3o\n\
ool01@000000oooo0?ooo`3oool0000000L0oooo100000020?ooo`@00000103oool00`\
000000oooo\n\
0?ooo`020?ooo`030000003oool0oooo00P0oooo00L000000?ooo`\
000000oooo0000003oool00000\n\
00<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`080?ooo`\
030000003oool0\n\
000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`\
030000003oool0oooo0500oooo001U\n\
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?\
oo\no`0000020?ooo`050000003oool0oooo0?ooo`0000001`\
3oool010000000oooo0000000000050?oo\n\
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?\
oo\no`070000003oool000000?ooo`000000oooo000000030?ooo`\
030000003oool0oooo00800000103o\n\
ool00`000000oooo0?ooo`080?ooo`030000003oool0000000<0oooo00D000000?ooo`\
3oool0oooo\n\
000000030?ooo`030000003oool0oooo0500oooo001U0?ooo`\
030000003oool0oooo0080oooo0P00\n\
0000103oool000000000003oool5000000<0oooo1@0000060?ooo`\
040000003oool0oooo000000<0\n\
oooo0`0000030?ooo`8000000`3oool4000000P0oooo0P0000000`3oool00000000000020?ooo`\
<0\n00000P3oool2000000040?ooo`00000000000?ooo`@00000203oool00`\
000000oooo000000040?oo\n\
o`<00000103oool00`000000oooo0?ooo`1@0?ooo`00I03oool3000001/0oooo0P0000020?ooo`\
80\n00003P3oool00`000000oooo0?ooo`070?ooo`8000000`3oool2000000d0oooo00<000000?\
ooo`3o\nool01`3oool2000000030?ooo`000000000000X0oooo00<000000?ooo`\
3oool0D03oool00940oooo\n\
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01@\
0oooo\n0`00001B0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`\
3ooolQ0?ooo`00\n\\\n\\>\"],\n  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> \
{-1.38583, -23.7996,\n  0.0544153, 5.28935}}]\n}, Open  ]]\n},\n\
FrontEndVersion->\"Macintosh 3.0\",\nScreenRectangle->{{0, 832}, {0, 604}},\n\
WindowSize->{653, 590},\nWindowMargins->{{68, Automatic}, {Automatic, 9}},\n\
MacintoshSystemPageSetup->\"\\<\\\n\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001\n\
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000\n\
00000000000000000000000000000000\\>\"\n]\n\n\n\
(***********************************************************************\n\
Cached data follows.  If you edit this Notebook file directly, not using\n\
Mathematica, you must remove the line containing CacheID at the top of\nthe \
file.  The cache data will then be recreated when you save this file\nfrom \
within Mathematica.\n\
***********************************************************************)\n\n\
(*CellTagsOutline\nCellTagsIndex->{}\n*)\n\n(*CellTagsIndex\n\
CellTagsIndex->{}\n*)\n\n(*NotebookFileOutline\nNotebook[{\n\n\
Cell[CellGroupData[{\nCell[1731, 51, 3070, 54, 1019, \"Input\"],\nCell[4804, \
107, 59, 1, 26, \"Output\"],\nCell[4866, 110, 189, 3, 41, \"Output\"],\n\
Cell[5058, 115, 235, 3, 56, \"Output\"],\nCell[5296, 120, 67, 1, 26, \"Output\
\"],\nCell[5366, 123, 67, 1, 26, \"Output\"]\n}, Open  ]],\n\n\
Cell[CellGroupData[{\nCell[5470, 129, 226, 6, 43, \"Input\"],\nCell[5699, \
137, 102, 2, 26, \"Output\"],\nCell[5804, 141, 555, 14, 22, \"Print\"],\n\
Cell[6362, 157, 20989, 833, 85, 9863, 691, \"GraphicsData\",\n\"PostScript\", \
\"Graphics\"],\nCell[27354, 992, 135, 3, 26, \"Output\"]\n}, Open  ]],\n\
Cell[27504, 998, 335, 7, 203, \"Input\"],\n\nCell[CellGroupData[{\n\
Cell[27864, 1009, 1123, 18, 219, \"Input\"],\nCell[28990, 1029, 420, 6, 71, \
\"Output\"],\nCell[29413, 1037, 3286, 81, 71, \"Output\"],\nCell[32702, 1120, \
177, 3, 37, \"Message\"],\nCell[32882, 1125, 290, 4, 56, \"Output\"]\n}, \
Closed]],\n\nCell[CellGroupData[{\nCell[33209, 1134, 151, 2, 56, \"Input\"],\n\
Cell[33363, 1138, 20510, 456, 186, 4231, 250, \"GraphicsData\",\n\"PostScript\
\", \"Graphics\"]\n}, Open  ]]\n}\n]\n*)\n\n\n\n\n\
(***********************************************************************\nEnd \
of Mathematica Notebook file.\n\
***********************************************************************)\n\n\n\
\n\n--============_-1352851531==_============--\n\n\n\n\n"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{12, Automatic}, {Automatic, 16}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 60442, 945, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
