(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4485,         92]*)
(*NotebookOutlinePosition[      5595,        129]*)
(*  CellTagsIndexPosition[      5551,        125]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`ContSamp`\"]\n\nRSContinuousDistribution::usage = \"\n\
RSContinuousDistribution[functionf,a,b,n] returns a sample of size n\nfor the \
distribution with density functionf on the interval [a,b].\"\n\n\n\
RSIndependent2D::usage = \"\n\
RSIndependent2D[functionf1,a1,b1,functionf2,a2,b2,n] returns a sample of \n\
size n {{x1,y1},...,{xn,yn}} of a two-dimensional random vector (X,Y) , \n\
where X and Y are independent, X has density functionf1 on the interval \n\
[a1,b1], Y has density functionf2 on the interval [a2,b2].\"\n\n\n\
RSNormal2D::usage = \"\nRSNormal2D[Sigma1,Sigma2,rho,n] returns a sample of \
size n for the \ntwo-dimensional Gaussian vector (X,Y). The means of X and Y \
are null, \ntheir standard deviations are sigma1 and sigma2. Their \
correlation \ncoefficient is rho.\"\n\n\nRSUnitBall::usage = \"\n\
RSUnitBall[dim,nb] returns a sample of size n of vectors uniformly \n\
distributed in the unit ball of the space of dimension dim.\"\n\n\n\n\
Begin[\"`Private`\"]\n\n\nRSContinuousDistribution[density_ , a_ , b_ , \
n_Integer]:=\n\n      Block[ {nbint,delta,abscissas,ordinates,cdf,inv},\n\n\t \
  nbint=100;\n\t   delta=N[(b-a)/nbint];\n\t   nbint=nbint+1;\n\t   \
abscissas=N[Range[a,b,delta]];\n\t   ordinates=Table[ density[abscissas[[i]]] \
,{i,nbint}];\n\n\t   cdf = Drop[ordinates,-1]+Drop[ordinates,1];\n\t   delta \
= delta/2;\n\t   cdf = cdf*delta;\n\t   cdf = FoldList[Plus,0.,cdf];\n\t   \
cdf = cdf/Last[cdf];\n\t  \n\t   cdf = Transpose[{cdf,abscissas}];\n\t   inv \
= Interpolation[cdf, InterpolationOrder->1];\n\n\t   Return[Table[ \
inv[Random[] ] , {n} ] ];\n       \n\t   ];\n\n\n\
RSIndependent2D[density1_,inf1_,sup1_,density2_,inf2_,sup2_,n_Integer]:=\n\
If[N[inf1]<=N[sup1] && N[inf2]<=N[sup2],\n   Return[\n\t  Transpose[\n\t\t    \
{RSContinuousDistribution[density1,N[inf1],N[sup1],n],\n\t\t     \
RSContinuousDistribution[density2,N[inf2],N[sup2],n]}\n\t\t   ]\n\t ]\n  ];\n\
\n\n\n\nRSNormal2D[sigma1_,sigma2_,rho_,n_Integer]:=\n\n\
Block[{matra={{sigma1,sigma2*rho},{0,sigma2*Sqrt[1-rho*rho]}},res={},\n\t     \
 u={},s},\n     Do[(\n\t u = {Random[Real,{-1,1}],Random[Real,{-1,1}]};\n\t s \
= u . u;\n\t While[s>1,\n\t       u = \
{Random[Real,{-1,1}],Random[Real,{-1,1}]};\n\t       s = u . u;\n\t      ]; \n\
\t res = Append[res,u*Sqrt[-2Log[s]/s]]     \n\t ),{n}];\n       \
res=res.matra;\n       Return[res];\n\n     ];\n\n\n\n\
RSUnitBall[dim_Integer,n_Integer]:=\n\nBlock[{res={},coord={}},\n      Do[(\n\
\t  coord=Table[Random[Real,{-1,1}],{dim}]; \n\t  While[coord.coord>1,\n\t\t\
coord=Table[Random[Real,{-1,1}],{dim}]\n\t       ];\n\t  \
res=Append[res,coord]\n\t  ),{n}];\n       Return[res];\n\n     ];\n\nEnd[]\n\
\nEndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{228, Automatic}, {30, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 2771, 40, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
