(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7750,        138]*)
(*NotebookOutlinePosition[      8860,        175]*)
(*  CellTagsIndexPosition[      8816,        171]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`DataRep`\"]\n\n\nHistogram::usage = \"\n\
Histogram[listofdata,listofbounds] represents the histogram of the data \n\
contained in listofdata. The bounds of the classes are read in \n\
listofbounds.\"\n\n\nRegularHisto::usage = \"\n\
RegularHisto[listofdata,xmin,xmax,nx] represents the histogram of the data \n\
contained in list of data. There are nx regular classes between xmin \nand \
xmax.\"\n\n\nSamplePlot2D::usage = \"\nSamplePlot2D[listof2Ddata] plots in \
the plane the points whose coordinates \nare read in listof2Ddata.\"\n\n\n\
Histogram2D::usage = \"\nHistogram2D[listof2Ddata,xmin,xmax,nx,ymin,ymax,ny] \
represents a histogram \nin 3 dimensions for the two dimensional data \
contained in listof2Ddata. \nThe classes are regular. There are nx classes in \
abscissa between xmin \nand xmax, and ny classes in ordinate between ymin and \
ymax.\"\n\n\nLargeNumbers::usage = \"\nLargeNumbers[listofdata] plots the \
partial means of the data contained in \nlistofdata.\"\n\n\n\
CentralLimit::usage = \"\nCentralLimit[listofdata, mu, sigma, n] takes \
consecutive groups of n data in \nlistofdata. The sum of each group is \
centered by n*mu then divided \nby Sqrt[n]*sigma. The results are represented \
on a regular histogram \nwith 20 classes.\"\n\n\n\nBegin[\"`Private`\"]\n\n\n\
Histogram[listofdata_List,listofbounds_List,opts___]:=\n\n    \
Block[{list,nbclasses,cardinal,i,ordinates,abscissas,g},\n\n       list = \
Cases[listofdata,\n\t\t\tx_/;First[listofbounds]<x<Last[listofbounds]];\n     \
  nbclasses = Length[listofbounds]-1;\n\n       cardinal = \
Table[Length[Select[list,\n\t\t\t\tlistofbounds[[i]]<#<=listofbounds[[i+1]] \
&]],\n\t\t\t  {i,1,nbclasses}];\n\n       cardinal = cardinal / \
(Drop[listofbounds,1]\n\t\t\t\t  - Drop[listofbounds,-1]);\n       cardinal = \
cardinal / Length[list];\n\n       ordinates = \
Flatten[Transpose[{cardinal,cardinal,\n\t\t\t\t      Table[0,{nbclasses}]}]];\
\n       \n       \n       abscissas = \
Flatten[Transpose[{Drop[listofbounds,-1],\n\t\t\t\t\t  Drop[listofbounds,1],\n\
\t\t\t\t\t      Drop[listofbounds,1]}]];\n       \n       g = \
Transpose[{abscissas,ordinates}];\n       g = \
Prepend[g,{First[listofbounds],0}];\n\n       ListPlot[g,\n\t\t opts,\n\t\t \
PlotRange  -> All,\n\t\t PlotJoined -> True]\n    ]\n\n\n\n\
RegularHisto[listofdata_List,xmin_,xmax_,nx_,opts___]:=\n\n  \
Block[{cardinal,list,step,i,abscissas,ordinates,g},\n\n\tstep  = \
N[(xmax-xmin)/nx];\n\n\tlist = Cases[listofdata,x_/;xmin<x<xmax];\n\tlist = \
list - xmin;\n\tlist = list/step;\n\tlist = Ceiling[list];\n\n\t\
cardinal=Table[Count[list,i],{i,1,nx}];\n\tcardinal=cardinal / \
(step*Length[list]);\n\n\tordinates = \
Flatten[Transpose[{cardinal,cardinal,Table[0,{nx}]}]];\n\tabscissas = \
Flatten[Transpose[{Range[xmin,xmax-step,step],\n\t\t\t\t\t    \
Range[xmin+step,xmax,step],\n\t\t\t\t\t    Range[xmin+step,xmax,step]}]]; \n\t\
\t\t\t\t\t \n\tg = Transpose[{abscissas,ordinates}];                          \
               \n\tg = Prepend[g,{xmin,0}];\n     \n\n\tListPlot[g, \n\t\t    \
opts,\n\t\t    PlotJoined -> True,\n\t\t    PlotRange  -> All ]\n\n\t]\n\n\n\n\
\nHistogram2D[list2Dofdata_List,xmin_,xmax_,nx_,ymin_,ymax_,ny_,opts___]:=\n\n\
Block[{cardinal,xmesh,ymesh,list,stepx,stepy,g,i,j},\n\n      stepx   = \
N[(xmax-xmin)/nx];\n      stepy   = N[(ymax-ymin)/ny];\n\n      list   = \
Cases[list2Dofdata,x_List/;\n\t\t      xmin<First[x]<xmax && \
ymin<Last[x]<ymax];\n      list   = Transpose[ {(Transpose[list][[1]] - \
xmin)/stepx ,\n\t\t\t   (Transpose[list][[2]] - ymin)/stepy } ]; \n      list \
  = Ceiling[list];\n\n      cardinal = \
Table[Count[list,{i,j}],{i,1,nx},{j,1,ny}];\n      cardinal = cardinal \
(Max[N[xmax-xmin],N[ymax-ymin]]/Max[cardinal]);\n      xmesh    = \
Range[xmin,xmax,stepx];\n      ymesh    = Range[ymin,ymax,stepy];\n   \n\t\
g=Table[{Polygon[{\n\t\t {xmesh[[i]]    , ymesh[[j]]   ,0},\n\t\t {xmesh[[i]] \
   , ymesh[[j]]   ,cardinal[[i,j]]},\n\t\t {xmesh[[i+1]]  , ymesh[[j]]   \
,cardinal[[i,j]]},\n\t\t {xmesh[[i+1]]  , ymesh[[j]]   ,0}}],\n\t\t Polygon[{\
\n\t\t {xmesh[[i]]    , ymesh[[j]]   ,cardinal[[i,j]]},\n\t\t {xmesh[[i+1]]  \
, ymesh[[j]]   ,cardinal[[i,j]]},\n\t\t {xmesh[[i+1]]  , ymesh[[j+1]] \
,cardinal[[i,j]]},\n\t\t {xmesh[[i]]    , ymesh[[j+1]] ,cardinal[[i,j]]}}],\n\
\t\t Polygon[{\n\t\t {xmesh[[i+1]]  , ymesh[[j]]   ,0},\n\t\t {xmesh[[i+1]]  \
, ymesh[[j]]   ,cardinal[[i,j]]},\n\t\t {xmesh[[i+1]]  , ymesh[[j+1]] \
,cardinal[[i,j]]},\n\t\t {xmesh[[i+1]]  , ymesh[[j+1]] ,0}}]\n\t\t \
},{i,1,nx},{j,1,ny}];\n\n\t Show[Graphics3D[g],\n\t     opts,\n\t     \
PlotRange -> All,\n\t     AspectRatio -> Automatic,\n\t     Boxed -> True,\n\t\
     Axes -> Automatic,\n\t     Ticks ->Automatic,\n\t     AxesLabel \
->{\"x\",\"y\",\"f[x,y]\"}\n\t     ]\n       ]\n\n\n\n\
SamplePlot2D[listof2Ddata_,opts___]:=\n\n\t     ListPlot[listof2Ddata,\n\t\t  \
    opts,\n\t\t      PlotRange -> All,\n\t\t      AxesLabel -> \
{\"x\",\"y\"}];\n\n\n\n\nLargeNumbers[listofdata_List,opts___] :=\n  Block[\n \
   {listofmeans,len},\n\n    listofmeans = \
Rest[FoldList[Plus,0.,listofdata]];\n    len=Length[listofdata];\n    \
listofmeans = listofmeans / Range[len];\n\n    ListPlot[listofmeans , \n\n\t  \
   PlotRange -> All,\n\t     Prolog    -> PointSize[0.001],\n\t     opts\n\t  \
  ]\n       ]\n\n\nCentralLimit[ listofdata_List,mu_,sigma_,n_,opts___] :=\n  \
Block[\n    {listpart, max,min,g1,g2},\n    \n\n    listpart = \
Transpose[Partition[listofdata,n]];\n    listpart = Apply[Plus,listpart];\n   \
 listpart = listpart - (N[n] mu);\n    listpart = listpart/(Sqrt[N[n]] \
sigma);\n    \n    min = Min[listpart];\n    max = Max[listpart];\n   \n    \
g1 := RegularHisto[listpart,min,max,20,\n\t\t   DisplayFunction -> Identity];\
\n\n    g2 := Plot[Exp[-(x^2)/2] / Sqrt[2 Pi], {x,min,max},\n\t\t   \
DisplayFunction -> Identity];\n\n\t      \n    \
Show[g1,g2,DisplayFunction->$DisplayFunction]\n\n\n    ]\n\nEnd[]\n\n\
EndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{212, Automatic}, {Automatic, 16}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 6036, 86, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
