(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4466,         92]*)
(*NotebookOutlinePosition[      5576,        129]*)
(*  CellTagsIndexPosition[      5532,        125]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`DiscSamp`\"]\n\n\
Distribution::usage=\"Distribution[listofdata] returns a list of pairs. \nThe \
first element of each pair is a value appearing in listofdata, \nthe second \
one is the frequency of that value in listofdata.\"  \n\t\t\t       \n\
RSPermutation::usage=\"RSPermutation[list,n] returns a list of n random \n\
permutations of list.\" \n\nRSExtract::usage=\"RSExtract[list,k,n] returns a \
list of n lists of length k, \nextracted at random from list.\"\n\n\
RSDiscreteDistribution::usage=\"RSDiscreteDistribution[dist,n] returns a\n\
random sample of size n of the distribution dist, given under the form of\na \
list of nonnegative reals. The list dist is first divided by \nits sum then \
interpreted as a probability distribution on the set \n\
{1,...,Length[dist]}.\"\n\t\t\t      \n\t\t\t       \n\nBegin[\"`Private`\"]\n\
\nDistribution[list_List]:=\n\n\t Block[{red,len,shortlen,i},\n\n\t      red \
= Union[list];\n\t      len = Length[list];\n\t      shortlen = Length[red];\n\
\t      Return[Table[{red[[i]],\n\t\t\t   N[Count[ list,red[[i]] ]/len]},\n\t\
\t\t   {i,shortlen}]\n\t\t    ];\n\t      ];\n\n\n\
RSPermutation[list_List,n_Integer]:=\n\n\t    \
Block[{len,i,r,swap,perm,result={}},\n\t\t len=Length[list];\n\t\t Do[\n\t\t  \
 perm=list;\n\t\t   For[i=1,i<len,i++,\n\t\t\tr=Random[Integer,{i,len}];\n\t\t\
\tswap=perm[[i]];\n\t\t\tperm[[i]]=perm[[r]];\n\t\t\tperm[[r]]=swap;\n\t\t    \
   ];\n\t\t    result=Append[result,perm],\n\t\t   {n}];\n\t\t \
Return[result];\n\n\t\t ];\n\n       \n\n\
RSExtract[list_List,k_Integer,n_Integer]:=\n\n\t    \
Block[{r,listbool={},samp={},extr={},len},\n\n\t\t len=Length[list];\n\t\t \
Do[\n\t\t   (\n\t\t   listbool=Transpose[{list,Table[False,\n\t\t\t\t\t\t  \
{len}]}];\n\t\t   extr={};\n\t\t    \n\t\t   Do[\n\t\t     (\n\t\t     \
r=Random[Integer,{1,len}];\n\t\t     While[listbool[[r,2]],\n\t\t\t   \
r=Random[Integer,{1,len}]\n\t\t\t  ];\n\t\t     \
extr=Append[extr,listbool[[r,1]]];\n\t\t     listbool[[r,2]]=True\n\t\t     )\
\n\t\t     ,{k}];\n\t\t   extr = Sort[extr];\n\t\t   samp = Append[samp,extr]\
\n\t\t   )\n\t\t   ,{n}];\n\t\t   Return[samp];\n\n\t\t       ];\n\n\n \n\
RSDiscreteDistribution[dist_List,n_Integer]:=\n\n\t    \
Block[{cumul={},j,choice,res={}},\n\n\t\t If[VectorQ[dist],\n\t\t\t (\n\t\t   \
  cumul = N[dist];\n\t\t     cumul = cumul/Apply[Plus,cumul];\n\t\t     cumul \
= Rest[FoldList[Plus,0,cumul]];\n\t\t     Do[\n\t\t\t (\n\t\t\t \
choice=Random[];\n\t\t\t j=1;\n\t\t\t While[choice>cumul[[j]],\n\t\t\t       \
j=j+1];\n\t\t\t res=Append[res,j]\n\t\t\t )\n\t\t     ,{n}];\n\t\t     \
Return[res];\n\t\t\t) \n\t\t    \n\t\t    ];\n\t\t ];\n\nEnd[]\n\n\
EndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{196, Automatic}, {15, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 2752, 40, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
