(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5287,        105]*)
(*NotebookOutlinePosition[      6397,        142]*)
(*  CellTagsIndexPosition[      6353,        138]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`DynSyst`\"]\n\nMean::usage= \"Mean[list] returns the \
arithmetic mean of list.\"\n\nVariance::usage= \"Variance[list] returns the \
maximum likelyhood\nestimate of the variance of list.\" \n\n\
TentFunction::usage= \"TentFunction[a,x] returns 1-a*Abs[x-1+1/a].\" \n\n\
LogisticFunction::usage= \"LogisticFunction[a,x] returns ax(1-x).\"\n\n\
IterateAPhi::usage=\"\nIterateAPhi[matrixA,functionPhi,vectorX0,n] computes \
and returns in a list \nthe images by the function Phi of the vector X0 and \
its products by the \nsuccessive powers of the matrix A. The coordinates of \
these vectors are \nreduced to their decimal parts.\"\n\n\
CovarianceFunction::usage= \"\nCovarianceFunction[list,N] returns in a list \
the values cov(i) for i \nranging from 0 to N . The value cov(i) is the \
covariance of list with \nits i-th shift.\"\n\nAsymptoticVariance::usage= \
\"AsymptoticVariance[list,N] returns the sum of \nthe values cov(i) for i \
ranging from 0 to N . The value cov(i) is the \ncovariance of list with its \
i_th shift.\"\n\nCorrelationDimension::usage= \"\n\
CorrelationDimension[list,step,ntep] computes the values of C(r) , r \nbeing \
an integer multiple of step, up to nstep values. Then the values \nLog[C(r)] \
as a function of r are plotted, and the linear regression \ncoefficients are \
computed. The slope of the regression line and the \ncorrelation coefficient \
are printed.\"\n\n\nBegin[\"`Private`\"]\n\n\n\n\
Mean[list_]:=N[Apply[Plus,list]/Length[list]];\n\n\
Variance[list_]:=(list.list)/Length[list]-(Mean[list]^2);\n\n\
LogisticFunction[a_,x_]:=N[a*x*(1-x)];\n\nTentFunction[a_,x_]:= 1 - \
a*Abs[x-1+1./a];\n\n\nIterateAPhi[a_,phi_,x0_,n_]:=\n\n      \
Block[{f,x,res,i},\n\n\t     f[x_]:= Mod[a.x,1.];\n\t     res   = \
NestList[f,Mod[x0,1.],n];\n\t     res   = Table[Mod[phi[ \
res[[i,1]],res[[i,2]] ],1.], {i,n}];\n\t     Return[res];\n\t   ];\n\n\n\
CovarianceFunction[listofdata_List,n_]:=\n     Block[{lcent,k,len,covar},\n\n\
\t   lcent = listofdata-Mean[listofdata];\n\t   len   = Length[listofdata];\n\
\t   covar = Table[(Drop[lcent,-k].\n\t\t\t  Drop[lcent, \
k])/(len-k),{k,0,n}];\n\t   Return[covar];\n\t  ];                  \n\n\n\
AsymptoticVariance[listofdata_List,n_]:=\n\t\t   Apply[Plus, \
CovarianceFunction[listofdata,n]];\n\n\n\
CorrelationDimension[listofdata_List,step_,nstep_]:=\n   \
Block[{n,twoover,list,sum,i,elem, work,\n\t\t     abscissas, \
ordinates,mx,my,vx,vy,cova,corr,a,b},\n\t \n\t n       = \
Length[listofdata]-1;\n\t twoover = 2./(n*(n-1));\n\t list = listofdata;\n\t \
sum = Table[0,{nstep}];\n\t \n\t Do  [\n\t     (\n\t     elem=First[list];\n\t\
     list=Drop[list,1];\n\t     work=Ceiling[Abs[(list-elem)/step]];\n\t     \
sum=sum+Table[Count[work,i],{i,nstep}];\n\t     ),{n}\n\t     ]; \n\t     \n\t\
 abscissas = Range[step,nstep*step,step];\n\t ordinates = Log[sum*twoover];\n\
\n\t mx = Mean[abscissas];\n\t my = Mean[ordinates];\n\t vx = \
Variance[abscissas];\n\t vy = Variance[ordinates];\n\t cova = \
(abscissas.ordinates)/nstep - (mx*my);\n\t corr = cova/Sqrt[vx*vy];\n\t a  = \
cova/vx;\n\t b  = -a*mx + my;\n\t \n\t Print[\"         \"];\n\t \
Print[\"Slope = \",a];\n\t Print[\"         \"];\n\t Print[\"Linear \
Correlation = \",corr];\n\t \n\t g1 := \
ListPlot[Transpose[{abscissas,ordinates}],\n\t\t\t\t\
DisplayFunction->Identity];\n\t g2 := Plot[a*x+b,{x,0,Last[abscissas]},\n\t\t\
\t\tDisplayFunction->Identity];\n\t \
Show[g1,g2,DisplayFunction->$DisplayFunction]\n\t \n\t];\n\nEnd[]\n\n\
EndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{180, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 3573, 53, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
