(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9615,        165]*)
(*NotebookOutlinePosition[     10724,        202]*)
(*  CellTagsIndexPosition[     10680,        198]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`Fractals`\"]\n\n(*--------------------- Examples of basic \
patterns -----------------------*)\n\nTriangle::usage=\"\nTriangle returns an \
equilateral triangle as a list of three segments in \nthe plane.\"\n\n\
Star::usage=\"\nReturns a star as a list of six segments in the plane.\"\n\n\
Island::usage=\"\nReturns a notch and a triangle as a list of eight segments \
in the plane.\"\n\nBattlement::usage=\"\nReturns a battlement as a list of \
eight segments in the plane.\"\n\nHat::usage=\"\nHat[sharpness] returns a \
list of four segments in the plane. \" \n\nWy::usage=\"\n\
Wy[angle1,length1,angle2,length2] returns a Y-shaped list of four segments \n\
in the plane. angle1,length1,angle2 and length2 are the parameters of the \n\
two branches.\" \n\nRSWy::usage=\"\nRSWy[n] returns a random sample of size n \
of outputs of the function Wy.\"\n\nRSTruncs::usage=\"\nRSTruncs[n] returns a \
random sample of vertical segments in the plane.\"\n\n\n(*--------- Functions \
for the replacement of segments by patterns --------*)\n\n\
TransformSegment::usage=\"\nTransformSegment[segment,pattern] returns a list \
of segments obtained from \npattern by moving it in the plane so as to make \
its ends fit with \nthose of the initial segment.\"\n\nIteratePattern::usage=\
\"\nIteratePattern[listofsegments,pattern,n] applies TransformSegment to each \
\nof the segments in listofsegments. Iterates n times.\"\n\n\
IterateRandomPatterns::usage=\"\n\
IterateRandomPattern[listofsegments,patterns,probas,n] iterates\nn times the \
following operation : for each of the segments in listofsegments\none of the \
patterns in patterns is chosen randomly according to a \nprobability read in \
probas, and the segment is transformed accordingly\nby TransformSegment.\" \n\
\n(*----------------------- Graphical representation \
-----------------------*)\n\nDrawSegments::usage=\"\n\
DrawSegments[listofsegments] plots the elements of listofsegments in the\n\
plane.\"\n\n\
(*------------------------------------------------------------------------*)\n\
\nBegin[\"`Private`\"]\n\n(*--------------------- Examples of basic patterns \
-----------------------*)\n\nTriangle   = { { {1.,0.},{0.,0.} },\n\t       { \
{0.,0.},{0.5,N[Sqrt[3]/2]} }, \n\t       { {0.5,N[Sqrt[3]/2]},{1.,0.} } };\n\n\
Island     = { { {0.,0.},{1.,0.} },\n\t       { {1.,0.},{2.,-N[Sqrt[3]/2]} }, \
\n\t       { {2.,-N[Sqrt[3]/2]},{3.,-N[Sqrt[3]/2]} }, \n\t       { \
{2.,0.},{2.5,N[Sqrt[3]/2]} },\n\t       { {2.5,N[Sqrt[3]/2]},{3.,0.} },\n\t   \
    { {3.,0.},{2.,0.} },\n\t       { {3.,-N[Sqrt[3]/2]},{4.,0.} },\n\t       \
{ {4.,0.},{5.,0.} } };\n\nStar       = { { {0.,0.},{1.,0.} },\n\t       { \
{0.,0.},{0.5,N[Sqrt[3]/2]} },  \n\t       { {0.,0.},{-0.5,N[Sqrt[3]/2]} },\n\t\
       { {0.,0.},{-1.,0.} },\n\t       { {0.,0.},{-0.5,-N[Sqrt[3]/2]} },  \n\t\
       { {0.,0.},{0.5,-N[Sqrt[3]/2]} } };\n\nBattlement = { { {0.,0.},{1.,0.} \
},\n\t       { {1.,0.},{1.,1.} },  \n\t       { {1.,1.},{2.,1.} },\n\t       \
{ {2.,1.},{2.,0.} },\n\t       { {2.,0.},{2.,-1.} },  \n\t       { \
{2.,-1.},{3.,-1.} }, \n\t       { {3.,-1.},{3.,0.} },\n\t       { \
{3.,0.},{4.,0.} } };  \n\nHat[sharpness_]:= \n\t     { { {0.,0.},{1.,0.} },\n\
\t       { {1.,0.},{1.5,N[sharpness]} },\n\t       { \
{1.5,N[sharpness]},{2.,0.} }, \n\t       { {2.,0.},{3.,0.} } };\n\n\
Wy[angle1_,length1_,angle2_,length2_]:=\n\t     { { {0.,0.},{0.,1.} },\n\t    \
   { {0.,1.},{N[length1*Sin[angle1]],\n\t\t\t   1.+N[length1*Cos[angle1]]} },\
\n\t       { {0.,1.},{-N[length2*Sin[angle2]],\n\t\t\t   \
1.+N[length2*Cos[angle2]]} },\n\t       { {0.,1.3},{0.,2.} } };\n\n\
RSWy[n_Integer]:=Table[Wy[N[Pi/2]*Random[],Random[],\n\t\t\t  \
N[Pi/2]*Random[],Random[]],{n}];\n\nRSTruncs[n_Integer] := \n    \
Block[{abs,ord,height,truncs},\n\n\t  truncs={};\n\t  Do[(\n\t     abs     = \
Random[Real,10.]; \n\t     ord     = Random[Real,3.];\n\t     height  = \
Random[Real,{4.,7.}];\n\t     truncs  = \
Append[truncs,{{abs,ord},{abs,ord+height}}];\n\t     ),{n}];\n\n\t  \
Return[truncs];\n\t ];\n\n(*--------- Functions for the replacement of \
segments by patterns --------*)\n\n\
TransformSegment[segment_List,pattern_List]:=\n\n    \
Block[{i,firstofpat,lastofpat,normofpat,\n\t     \
firstofseg,lastofseg,normofseg,\n\t     sinangle,cosangle,\n\t     point, \
transpat},\n\n\t      (* First and last point met in pattern and their \
distance --*)\n\n\t  firstofpat = First[Flatten[pattern,1]];\n\t  lastofpat  \
= Last[Flatten[pattern,1]];\n\t  normofpat  = N[Sqrt[ (lastofpat-firstofpat).\
\n\t\t\t       (lastofpat-firstofpat) ]];\n\t\t\t      \n\t      (* End \
points and length of segment ------------------------*)\n\n\t  firstofseg = \
segment[[1]];\n\t  lastofseg  = segment[[2]];\n\t  normofseg  = N[Sqrt[ \
(lastofseg-firstofseg).\n\t\t\t       (lastofseg-firstofseg)]];\n\n\t      (* \
Sine and Cosine of the angle between segment and pattern *)\n\n\t  cosangle   \
= ((lastofseg-firstofseg).(lastofpat-firstofpat))\n\t\t\t      \
/(normofseg*normofpat);\n\t  sinangle   = \
(({{0.,-1.},{1.,0.}}.(lastofseg-firstofseg))\n\t\t       \
.(lastofpat-firstofpat))\n\t\t\t      /(normofseg*normofpat);\n\t       \n\t  \
    (* Transformations that map the end points of pattern ------*)\n\t      \
(* onto those of segment -----------------------------------*)\n\n\t  \
translation[point_List]:=point-(firstofpat-firstofseg);\n\n\t  \
rotation[point_List]:=({{cosangle,sinangle},\n\t\t\t\t  {-sinangle,cosangle}}\
\n\t\t\t\t .(point-firstofseg)) \n\t\t\t\t + firstofseg;\n\t\t\t\t  \n\t  \
homothety[point_List]:=(point-firstofseg)\n\t\t\t\t   *normofseg/normofpat + \
firstofseg;\n\n\t      (* Transformation of pattern point by point \
---------------*)\n\t  transpat=Flatten[pattern,1];\n\t  \
transpat=Table[homothety[rotation[translation[transpat[[j]] ]]],\n\t\t\t \
{j,1,Length[transpat]}];\n\t  transpat=Partition[transpat,2];\n\t \n\t  \
Return[transpat];\n\t ];   (* End of function TransformSegment \
-----------------------*)\n\n\n\
IteratePattern[listofsegments_List,pattern_List,n_Integer]:=\n\n    \
Block[{i,jagged},\n\n\t  jagged = listofsegments;\n\n\t  Do[(\n\t      (* \
Replace all segments in jagged by a transformed pattern -*)\n\n\t      jagged \
= Table[TransformSegment[jagged[[i]],pattern],\n\t\t\t     \
{i,1,Length[jagged]}];\n\t      jagged = Flatten[jagged,1];\n\t     ),{n}];\n\
\n\t  Return[jagged];\n\t ];   (* End of function \
IteratePattern---------------------------*)\n\n\n\
IterateRandomPatterns[listofsegments_List,patterns_List,\n\t\t\t\t\t  \
probas_List,n_Integer]:=\n\n    Block[{i,j,cumul,jagged},\n\n\t      (* \
Distribution function of probas -------------------------*)\n\t  cumul = \
N[probas];\n\t  cumul = cumul/Apply[Plus,cumul];\n\t  cumul = \
Rest[FoldList[Plus,0,cumul]];\n\t  \n\t      (* Definition of random choice \
according to probas ---------*)\n\t  choice := \n\t    Block[{j,ran},\n\n\t\t \
  ran=Random[];\n\t\t   j=1;\n\t\t   While[ ran>cumul[[j]] , j=j+1];\n\t\t   \
Return[j];\n\t\t ];\n\t\t \n\t  jagged = listofsegments;\n\n\t  Do[(\n\t      \
(* Replace all segments in jagged by a transformed pattern -*)\n\n\t     \
jagged = Table[TransformSegment[jagged[[i]],\n\t\t\t\t\t     \
patterns[[choice]]\n\t\t\t\t\t    ],\n\t\t\t    {i,1,Length[jagged]}];\n\t    \
 jagged = Flatten[jagged,1];\n\t     ),{n}];\n\n\t  Return[jagged];\n\t ];   \
(* End of function IteratePattern --------------------------*)\n\n\n\
(*----------------------- Graphical representation -----------------------*)\n\
\nDrawSegments[listofsegments_List,opts___]:=\n    Block[{i},\n\n\t  \
Show[Graphics[Table[Line[listofsegments[[i]]],\n\t\t\t\
{i,1,Length[listofsegments]}]], opts,\n\t       Frame->True, \
FrameTicks->None]\n\t ]    (* End of function \
DrawSegments-------------------------------*)\n\nEnd[]        \n\n\
EndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{164, Automatic}, {Automatic, 1}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 7901, 113, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
