(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8774,        150]*)
(*NotebookOutlinePosition[      9884,        187]*)
(*  CellTagsIndexPosition[      9840,        183]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`Interact`\"]\n\n(*----------------- Examples of basic \
configurations ---------------------*)\n(* All configurations are \
two-dimensional arrays of 0's and 1's. The      *)\n(* element config[[x,y]] \
is interpreted as the state of site (x,y).       *) \n\
(*------------------------------------------------------------------------*)\n\
\nCheckerboard::usage=\"\nCheckerboard returns a 40-by-40 configuration of \
0's and 1's arranged in\n10 by 10 squares.\"\n\nDiagonals::usage=\"\n\
Diagonals returns a 40-by-40 configuration of 0's and 1's arranged in \n\
diagonal stripes.\"\n\nRConfig::usage=\"\nRConfig[p,width,height] returns a \
width-by-height array of independent \nrandom 0's and 1's, 1 being chosen \
with probability p.\"\n\n(*------------------------ Examples of rates \
-----------------------------*)\n(* All lists of rates are returned as a \
2-by-5 list of reals. in such a   *)\n(* list, rate[[i,j]] represents the \
rate at which the configuration will  *)\n(* change at a site in state i (0 \
or 1) having j (from 0 to 4) neighbors  *)\n(* in state 1.                    \
                                        *)\n\
(*------------------------------------------------------------------------*)\n\
\nUniform::usage=\"\nUniform[lambda,mu] are the rates corresponding to the \
case where the        \nconfiguration changes from 0 to 1 at rate lambda and \
from 1 to 0 at rate \nmu, independently from the number of neighbors in state \
1.\"\n\nIsing::usage=\"\nIsing[Alpha,Beta] returns the rates corresponding to \
the symmetric\nStochastic Ising Model, admitting a Gibbs measure as a \
reversible state.\nAlpha is the potential of a site alone, Beta is the \
potential of a pair \nof neighboring sites.\"\n\nContact::usage=\"\n\
Contact[lambda] returns the rates of the contact process. The transition\n\
rates from 1 to 0 (curing) is constant. The rate of transition from\n0 to 1 \
is proportional to the number of neighbors at 1 (infecting).\"\n\n\
Voter::usage=\"\nVoter returns the rates of the Voter Model, where the \
transition rate from \n0 to 1 is proportional to the number of neighbors in \
state 1 and \nvice versa.\"\n\n(*------------------- Treatment of a \
configuration -----------------------*)\n\nCyclic::usage=\"\nCyclic[n,bound] \
returns bound if n is 0, 1 if n is bound+1 , n in any other \ncase. (Periodic \
boundary conditions are assumed for all configurations.)\"\n\n\
RepartConfig::usage=\"\nRepartConfig[config] returns a 2-by-5 list of \
integers. Its element\n[[i,j]] is the number of sites in state i (0 or 1) \
having j (from 0 to 4) \nneighbors in state 1.\"\n\nEvolution::usage=\"\n\
Evolution[initialconfig,rates,niter] simulates the evolution of a \n\
configuration according to the spin system corresponding to rates. niter\n\
iteration are performed. One iteration consists of picking up a site at\n\
random and decide to flip its state or not.\"\n\n(*-------------------- \
Graphical representation --------------------------*)\n\nDrawConfig::usage=\"\
\nDrawConfig[config,opts] plots config as a rectangular array of back and \n\
white squares.\"\n\n\
(*------------------------------------------------------------------------*)\n\
(*------------------------------------------------------------------------*)\n\
\nBegin[\"`Private`\"]\n\n(*----------------- Examples of basic \
configurations ---------------------*)\n\nCheckerboard :=\n    Block[{i,j},\n\
\t  Return[Table[If[ Xor[ Mod[Quotient[i,5],2]==0,\n\t\t\t\t\
Mod[Quotient[j,5],2]==0 ]\n\t\t\t ,1,0],\n\t\t       {i,0,39},{j,0,39}]\n\t\t\
];\n\t ];\n\nDiagonals :=\n    Block[{i,j},\n\t  Return[Table[If[ \
Mod[i+j,10]<5  \n\t\t\t ,1,0],\n\t\t       {i,0,39},{j,0,39}]\n\t\t];\n\t ];\n\
\nRConfig[p_Real,height_Integer,width_Integer] :=\n    \
Table[If[Random[]<p,1,0],{height},{width}];\n\n\n(*------------------------ \
Examples of rates -----------------------------*)\n\nUniform[lambda_,mu_]:=\n \
   Transpose[Table[{N[lambda],N[mu]},{5}]];\n\nIsing[alpha_,beta_]:=\n    \
Block[{i},\n\t  Return[Transpose[\n\t\t   Table[{N[Exp[alpha+(2*i-4)*beta]],\n\
\t\t\t  N[Exp[-alpha+(4-2*i)*beta]]}\n\t\t\t ,{i,0,4}]\n\t\t\t  ]\n\t\t];\n\t \
];\n\nContact[lambda_]:=\n    Block[{i},\n\t  \
Return[Transpose[Table[{N[lambda*i] , 1.} , {i,0,4}]]];\n\t ];\n\nVoter :=\n  \
  Block[{i},\n\t  Return[Transpose[Table[{N[i] , N[4-i]} , {i,0,4}]]];\n\t ];\
\n\n(*------------------- Treatment of a configuration \
-----------------------*)\n\nCyclic[n_Integer,bound_Integer]:= \n    \
Switch[n,0,bound,bound+1,1,_,n];\n\nRepartConfig[config_List]:=\n    \
Block[{w,h,x,y,state,nei,dist},\n\t\t\t\t       (* Dimensions of the grid \
---------*)\n\t  w    = Length[Transpose[config]];\n\t  h    = \
Length[config];\n\n\t  dist = Table[0,{2},{5}];\n\n\t  Do[(                   \
      (* For all sites ------------------*)\n\t\t\t\t       (* State of site \
(x,y) ------------*)\n\t      state = config[[x,y]];\n\t\t\t\t       (* Count \
its neighbors at 1 -------*)\n\t      nei = 1;\n\t      nei = nei + config[[ \
Cyclic[(x-1),h],y]];\n\t      nei = nei + config[[ Cyclic[(x+1),h],y]];\n\t   \
   nei = nei + config[[x,Cyclic[(y-1),w] ]];\n\t      nei = nei + \
config[[x,Cyclic[(y+1),w] ]];\n\t      state = state+1;\n\t\t\t\t       (* \
Increment dist[[state]][[nei]] -*)\n\t      dist[[state,nei]] = \
dist[[state,nei]]+1;\n\t\t\t\t\t    \n\t     ),{x,1,h},{y,1,w}];\n\n\t  \
Return[dist];\n\t ];\n\n\n\n\
Evolution[initialconfig_List,rates_List,niter_Integer]:=\n\n    \
Block[{w,h,config,proba,x,y,nei},\n\t\t   (* INITIALIZATIONS *)\n\t\t\t\t     \
  (* Dimensions of the grid ---------*)\n\t  w      = \
Length[Transpose[initialconfig]];\n\t  h      = Length[initialconfig];\n\t\t\t\
\t       (* The curent configuration -------*)\n\t  config = initialconfig;\n\
\t\t\t\t       (* Probabilities to flip a site in *)\n\t\t\t\t       (* a \
given state with n neighbors -*)\n\t  proba = rates/Max[rates];\n\n\t\t      \
(* MAIN LOOP *)\n\n\t  Do[\n\t     (                         (* Choose a site \
at random --------*)\n\t      x = Random[Integer,{1,h}];\n\t      y = \
Random[Integer,{1,w}];\n\t\t\t\t       (* Count its neighbors at 1 -------*)\n\
\t      nei = 1;\n\t      nei = nei + config[[ Cyclic[x-1,h],y]];\n\t      \
nei = nei + config[[ Cyclic[x+1,h],y]];\n\t      nei = nei + \
config[[x,Cyclic[y-1,w] ]];\n\t      nei = nei + config[[x,Cyclic[y+1,w] ]];\n\
\t\t\t\t       (* Decide to flip it or not -------*)\n\t      \
If[Random[]<proba[[ 1+config[[x,y]],nei ]],\n\t\t\t\t       (* Flip it \
------------------------*)\n\t\t  config[[x,y]] = 1-config[[x,y]] \n\t\t];\n\t\
     ),{niter}];\n\n\t     Return[config];\n\t ];\n\n(*-------------------- \
Graphical representation --------------------------*)\n\
DrawConfig[config_List,opts___]:=\n    Show[Graphics[Raster[config]], opts\n\t\
\t      Frame->True,\n\t\t      FrameTicks->None,\n\t\t      AspectRatio->\n\t\
\t\tN[Length[config]/Length[Transpose[config]]]\n\t]\n\nEnd[]       \n\n\
EndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{148, Automatic}, {30, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 7060, 98, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
