(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20748,        506]*)
(*NotebookOutlinePosition[     21853,        541]*)
(*  CellTagsIndexPosition[     21809,        537]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\

 
letterfreq={{sp,0.206},{E,0.091},{T,0.077},{A,0.068},
{O,0.067},{N,0.054},{I,0.050},{R,0.050},
             {H,0.047},{S,0.047},{D,0.029},{L,0.027},
             {C,0.023},{M,0.023},{U,0.023},
              {F,0.016} ,{P,0.016},{ Y,0.016} , 
              {B,0.012}, {G,0.012}, {W,0.012},
               {V,0.008}, {J,0.006},{K,0.006},{X,0.006}
               ,{Q,0.004},{Z,0.004}}

freq={0.206, 0.091, 0.077, 0.068, 0.067, 0.054, 0.05, 0.05, 
 
  0.047, 0.047, 0.029, 0.027, 0.023, 0.023, 0.023, 0.016, 
 
  0.016, 0.016, 0.012, 0.012, 0.012, 0.008, 0.006, 0.006, 
 
  0.006, 0.004, 0.004}

letters={sp, E, T, A, O, N, I, R, H, S, D, L, C, M, U, F, P, Y, B, 
 
  G, W, V, J, K, X, Q, Z}
  
  
  
  sp  stands for space
  
  
  =======================================
  
  
  Below, we provide    frequency tables  collected by Scott Leyh, a CWRU \
senior, for   samples from the german and English languages. Both samples \
were of similar length and contained a mixture of general, business, \
humanities and technical/medical texts \
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    RowBox[{\(SINGLE\ LETTERS\), "\n"}], 
    RowBox[{\(English\ text\), "\n"}], 
    RowBox[{
      StyleBox["  ",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox[\(Total\ number\ of\ \(characters : \ 3936\)\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n", "\n"}], 
    RowBox[{
      StyleBox["    ",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox[
        \(sp\ a\ \ \ b\ \ c\ \ \ d\ \ \ e\ \ \ f\ \ g\ \ h\ \ \ i\ \ \ j\ \ k
          \ \ I\ \ \ m\ \ \ n\ \ o\ \ p\ \ q\ r\ \ \ s\ t\ \ \ \ u\ v\ w\ \ x
          \ \ \ y\ \ z\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n", "\n"}], 
    StyleBox[
      \(661\ \ 295\ \ 31\ \ 111\ \ 107\ \ 401\ \ 75\ \ 66\ \ 115\ \ 243\ \ \ 3
        \ \ 28\ \ 145\ \ \ 98\ \ \ 274\ 257\ \ 56\ \ 4\ \ 201\ \ 210\ \ 298
        \ \ 97\ 46\ \ 41\ \ 13\ \ 59\ \ 1\),
      FontFamily->"Geneva",
      FontWeight->"Plain"]}], "Input"],

Cell[BoxData[
    \(German\ text\)], "Input"],

Cell[BoxData[
    RowBox[{"\n", "\n", 
      StyleBox["       ",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox[\(Total\ number\ of\ \(characters : \ 4428\)\n\n\n\ \n\n
        sp, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, 
        w, x, y, z, \[ADoubleDot], \[EDoubleDot], \[IDoubleDot], 
        \[ODoubleDot], \[UDoubleDot], \[SZ]\n
        604, 183, 99, 138, 172, 686, 47, 95, 182, 342, 5, 57, 111, 93, 425, 
        71, 34, 1, 242, 243, 235, 162, 20, 47, 9, 0, 63, 15, 0, 0, 5, 36, 6, 
        \),
        FontFamily->"Geneva",
        FontWeight->"Plain"]}]], "Input"],

Cell[BoxData[
    \(\(\n\n\nPAIRS\ OF\ LETTERS\)\)], "Input"],

Cell[BoxData[{
    RowBox[{"\n", 
      \(English\ text\ 
        \((rows\ and\ columns\ indexed\ by\ 27\ characters\ in\ the\ \ listed
            \ above\ order)\)\), "\n", "\n"}], 
    StyleBox[
      \(11\ \ \ \ 32\ \ 0\ \ \ 2\ \ \ \ 48\ \ 116\ \ 17\ \ 17\ \ \ 13\ \ 14
        \ \ \ 06\ \ \ \ \ 30\ 13\ 59\ 27\ 4\ \ \ 0\ 31\ \ 73\ \ 79\ 13\ 0
        \ \ \ 5\ \ 1\ \ \ 30\ 0\n\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[
      \(102\ \ \ 0\ \ \ 2\ \ \ 20\ \ \ 3\ \ \ 20\ \ \ 5\ \ \ 0\ \ \ \ 24\ \ 7
        \ \ \ \ \ \ 0\ \ 0\ \ \ \ \ 27\ \ \ 21\ \ \ 7\ \ \ 0\ \ 4\ \ 0\ \ 25
        \ \ \ 5\ \ \ 11\ \ \ \ 6\ \ 1\ \ 3\ \ \ \ \ 1\ \ 1\ \ 0\n\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[
      \(17\ \ \ \ 7\ \ \ 0\ \ \ 0\ \ \ \ 1\ \ \ 0\ \ \ \ 0\ \ \ 0\ \ \ \ 0
        \ \ \ l\ \ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ 4\ \ 0\ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0
        \ \ 0\ \ 0\ \ 1\ \ 0\n\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[
      \(39\ \ \ \ 7\ \ \ 0\ \ \ 1\ \ \ \ 0\ \ \ 17\ \ \ 0\ \ \ I\ \ \ \ 0
        \ \ \ 23\ \ \ \ \ 0\ \ 0\ \ \ \ \ \ 1\ 0\ \ 7\ \ 4\ \ 0\ \ 0\ 2\ \ 1
        \ \ 1\ \ 7\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\n\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    RowBox[{
      StyleBox[
        \(15\ \ \ \ 4\ \ \ 0\ \ \ 0\ \ \ \ 1\ \ \ 23\ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 7\ \ \ \ \ \ \ \ \ \ \ 0\ 0\ \ 8\ \ \ 0\ \ 37\ \ 6\ \ 0\ \ 0
          \ \ 6\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(12\ \ \ \ 0\ \ \ 9\ \ \ 15\ \ \ 11\ \ 12\ \ \ 11\ \ 21\ \ \ 46\ \ 10
          \ \ \ \ \ 0\ \ 8\ \ \ \ \ \ \ 20\ \ 38\ \ 20\ \ \ 2\ \ \ \ 21\ \ \ 0
          \ \ 43\ \ 27\ \ 33\ \ \ \ 0\ \ \ 32\ \ \ 6\ \ \ 1\ \ 2\ \ 1\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(34\ \ \ \ 1\ \ \ 0\ \ 0\ \ \ \ \ \ \ 0\ \ \ 2\ \ \ \ 7\ \ \ 0
          \ \ \ \ 0\ \ \ 7\ \ \ \ 0\ \ 0\ \ \ \ \ 2\ \ 0\ \ \ \ 2\ \ \ 18
          \ \ \ 0\ \ 0\ \ 1\ \ 0\ \ 0\ \ 1\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(18\ \ \ \ 4\ \ \ 0\ \ \ 0\ \ \ \ 2\ \ \ 2\ \ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 7\ \ \ \ 0\ \ 1\ \ \ \ \ 0\ \ 0\ \ \ \ \ \ \ 26\ \ 1\ \ 0\ \ 0
          \ \ 1\ \ 0\ \ 0\ \ 3\ \ 0\ \ 0\ \ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(21\ \ \ \ 0\ \ \ 0\ \ \ 21\ \ \ O\ \ \ 0\ \ \ \ O\ \ \ 6\ \ \ \ 0
          \ \ \ 0\ \ \ \ 0\ \ 0\ \ \ \ \ 0\ \ \ \ 0\ \ \ \ 1\ \ 0\ \ 0\ \ 0
          \ \ 0\ \ \ 6\ \ 52\ \ 0\ \ 0\ \ 8\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox[" ",
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(60\ \ \ \ 4\ \ \ 1\ \ \ 5\ \ \ \ 13\ \ \ 3\ \ \ \ 13\ \ 5\ \ \ \ 6
          \ \ \ 0\ \ \ \ 0\ \ 8\ \ \ \ \ 18\ \ \ \ 3\ \ \ \ 16\ \ \ 0\ \ \ 1
          \ \ 0\ \ 11\ \ 16\ \ 39\ \ 2\ \ 11\ \ 8\ \ 0\ \ 0\ \ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(2\ \ \ \ \ 0\ \ \ 0\ \ \ 0\ \ \ \ \ \ 0\ \ \ 0\ \ \ \ 0\ \ \ 0
          \ \ \ \ 0\ \ \ 0\ \ \ \ \ \ \ \ \ \ \ 0\ \ 0\ \ \ 0\ \ 0\ \ \ \ 1
          \ \ 0\ \ 0\ \ 0\ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(4\ \ \ \ \ 4\ \ \ 0\ \ \ 5\ \ \ \ 0\ \ \ I\ \ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 4\ \ \ \ 0\ \ 0\ \ \ \ \ 0\ \ \ 0\ \ \ \ 1\ \ \ 3\ \ \ 0\ \ 0
          \ \ \ 4\ \ 2\ \ 0\ \ \ 0\ \ \ \ \ \ \ \ \ \ 0\ \ \ 0\ \ \ \ \ 0
          \ \ \ 0\ \ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    StyleBox[
      \(25\ \ \ \ 39\ \ 3\ \ \ 3\ \ \ \ 0\ \ \ 16\ \ \ 1\ \ \ 2\ \ \ \ 1\ \ \ 
        6\ \ \ \ 0\ \ \ 0\ \ \ \ \ 14\ \ \ \ 0\ \ 1\ \ \ 2\ \ \ 5\ \ 0\ \ \ 1
        \ \ \ 17\ \ 2\ \ 5\ \ 0\ \ \ 2\ \ \ \ \ 0\ \ \ 0\ \ \ 0\n\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    RowBox[{
      StyleBox[
        \(25\ \ \ \ 6\ \ \ 0\ \ \ 0\ \ \ \ 0\ \ \ 3\ \ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 10\ \ \ 0\ \ 0\ \ \ \ \ 5\ \ 2\ \ \ \ 4\ \ \ 21\ \ \ 0\ \ \ \ 
          0\ \ \ 11\ 4\ \ \ \ 0\ \ 7\ \ 0\ \ \ 0\ \ \ \ \ 0\ \ \ 0\ \ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(16\ \ \ \ \ 87\ \ \ 0\ \ \ \ 0\ \ \ \ 0\ \ \ 41\ \ \ 0\ \ \ 4
          \ \ \ \ 7\ \ \ 60\ \ \ 0\ \ \ 4\ \ \ \ \ 0\ \ \ 0\ \ \ \ 3\ \ \ 45
          \ \ \ \ \ 0\ \ 0\ \ \ 2\ \ 0\ \ \ 0\ \ \ 5\ \ \ \ \ \ \ 0\ \ 0
          \ \ \ \ \ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(33\ \ \ \ 0\ \ \ 6\ \ \ 24\ \ \ 10\ \ 3\ \ \ \ 14\ \ \ 3\ \ \ \ 9
          \ \ \ 24\ \ \ 2\ \ \ 1\ \ \ \ \ 5\ \ \ \ 7\ \ \ \ 15\ \ \ \ 8
          \ \ \ \ 5\ \ \ \ 0\ \ \ 13\ \ 13\ \ 28\ \ \ 0\ \ 2\ \ \ 9\ \ \ \ \ 0
          \ \ \ 23\ \ \ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(21\ \ \ \ 2\ \ \ 0\ \ \ 0\ \ \ \ 0\ \ \ 1\ \ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 1\ \ \ \ 0\ \ \ 0\ \ \ \ \ \ \ \ \ \ \ 1\ \ \ 6\ \ \ \ 0\ \ \ 
          6\ \ \ 2\ \ \ 0\ \ \ \ 1\ \ 8\ \ \ 0\ \ 5\ \ \ \ \ \ \ \ \ 0\ \ 0
          \ \ \ \ \ 2\ \ 0\ \ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(3\ \ \ \ \ 0\ \ \ 0\ \ 0\ \ \ \ 0\ \ \ 1\ \ \ \ 0\ \ 0\ \ 0\ \ 0\ \ 
          0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0
          \ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(9\ \ \ \ \ 23\ \ 1\ \ \ 2\ \ \ \ 0\ \ \ 67\ \ \ 5\ \ \ 3\ \ \ \ 2
          \ \ \ 1\ \ \ \ \ \ \ \ \ \ \ 0\ \ 0\ \ \ \ 0\ \ \ 0\ \ 0\ \ 38
          \ \ \ \ 8\ \ \ 0\ \ 0\ \ \ 0\ \ \ 25\ 17\ \ \ 0\ \ \ 0\ \ 0\ \ 0\ \ 
          0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(40\ \ \ \ 11\ \ \ 2\ \ \ 0\ \ \ \ 9\ \ \ 30\ \ \ 0\ \ \ 2\ \ \ \ 0
          \ \ \ 21\ \ \ 0\ \ \ 0\ \ \ \ \ 7\ \ \ 1\ \ \ \ 35\ \ \ \ 8\ \ \ 0
          \ \ 0\ \ 10\ 10\ \ \ 10\ 12\ \ \ 0\ \ \ 0\ 0\ \ \ 2\ \ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(97\ \ \ \ 46\ \ 0\ \ \ 8\ \ \ \ 4\ \ \ 15\ \ \ 2\ \ \ 0\ \ \ \ 2
          \ \ \ 28\ \ \ 0\ \ \ 0\ \ \ \ \ 2\ \ \ \ 0\ \ \ \ 27\ \ \ 12\ \ \ \ 
          2\ \ \ \ 0\ \ \ 6\ \ \ 20\ \ \ \ \ 5\ \ \ 14\ \ \ \ 0\ \ 0\ \ 8\ \ 0
          \ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(5\ \ \ \ \ 2\ \ \ 6\ \ \ 5\ \ \ \ 2\ \ \ 0\ \ \ \ O\ \ \ 2\ \ \ \ 5
          \ \ \ 0\ \ \ \ 1\ 0\ \ \ \ \ 0\ \ \ \ 0\ \ \ \ 2\ \ \ 44\ \ \ \ 3
          \ \ \ \ \ 4\ \ \ 3\ \ 8\ \ 5\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(2\ \ \ \ \ 12\ \ \ \ 0\ \ \ 0\ \ \ \ 1\ \ \ 11\ \ \ 0\ \ \ 0\ \ \ \ 
          0\ \ \ 10\ \ \ 0\ \ 0\ \ \ \ \ \ 0\ \ 0\ \ 2\ \ \ 1\ \ 0\ \ 0\ \ 7
          \ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(26\ \ \ \ l\ \ \ \ 0\ \ \ 0\ \ \ \ 0\ \ \ 4\ \ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 0\ \ \ \ 0\ \ \ 0\ \ \ \ \ 0\ \ \ 0\ \ \ 0\ \ \ 7\ \ \ 0\ \ 0
          \ \ 0\ \ 0\ \ 3\ \ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(0\ \ \ \ \ 0\ \ \ 0\ \ \ 0\ \ \ \ 0\ \ \ 12\ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 1\ \ \ \ 0\ \ 0\ \ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0
          \ \ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(24\ \ \ \ 3\ \ \ 1\ \ \ 0\ \ \ \ 1\ \ \ l\ \ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 0\ \ \ \ 0\ \ \ 0\ \ \ \ \ 5\ \ 7\ \ \ 8\ \ \ 0\ \ 1\ \ \ 0
          \ \ \ 3\ \ 0\ \ 5\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox[" ",
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n"}], 
    RowBox[{
      StyleBox[
        \(0\ \ \ \ \ 0\ \ \ 0\ \ \ 0\ \ \ \ 0\ \ \ 0\ \ \ \ 0\ \ \ 0\ \ \ \ 0
          \ \ \ 1\ \ \ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0
          \ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\ \ 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["  ",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"], "\n", "\n"}], 
    RowBox[{\(German\ Letters\), "\n", "\n", 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"]}], 
    RowBox[{
      StyleBox[" ",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox[\(sp, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, 
        t, u, v, w, x, y, z, \[ADoubleDot], \[EDoubleDot], \[IDoubleDot], 
        \[ODoubleDot], \[UDoubleDot], \[SZ]\n' sp, \n10, 6, 6, 0, 29, 103, 2, 
        16, 36, 1, 0, 3, 10, 11, 169, 0, 0, 0, 71, 41, 77, 9, 0, 1, 0, 0, 1, 
        0, 0, 0, 0, 0, 2\),
        FontFamily->"Geneva",
        FontWeight->"Plain"]}], 
    StyleBox[\(a, 48, 0, 1, 1, 15, 1, 6, 2, 18, 3, 2, 9, 6, 15, 3, 0, 2, 0, 
      19, 11, 10, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(b, 23, 11, 0, 0, 1, 10, 0, 0, 0, 4, 0, 0, 3, 0, 3, 5, 0, 0, 
      14, 2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 22, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(c, 2, 13, 0, 0, 0, 9, 0, 0, 0, 52, 0, 0, 1, 0, 6, 4, 0, 0, 1, 
      36, 0, 7, 0, 0, 0, 0, 0, 2, 0, 0, 0, 5, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(d, 62, 2, 0, 0, 0, 14, 0, 1, 0, 6, 0, 0, 2, 0, 54, 13, 0, 0, 
      12, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(e, 50, 0, 63, 1, 66, 0, 9, 42, 51, 69, 3, 9, 33, 37, 54, 1, 5, 
      0, 34, 39, 69, 6, 11, 18, 0, 0, 14, 0, 0, 0, 0, 0, 2\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(f, 12, 1, 0, 0, 0, 6, 2, 0, 0, 1, 0, 0, 1, 0, 3, 4, 1, 0, 3, 
      1, 1, 8, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(g, 23, 6, 0, 0, 1, 4, 1, 1, 1, 13, 0, 0, 1, 1, 35, 1, 0, 0, 1, 
      2, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(h, 14, 2, 0, 129, 0, 15, 0, 0, 0, 7, 0, 0, 0, 0, 4, 1, 0, 0, 
      1, 4, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(i, 38, 2, 14, 0, 37, 104, 4, 2, 6, 0, 0, 0, 24, 9, 24, 0, 3, 
      0, 9, 28, 14, 0, 1, 13, 0, 0, 9, 0, 0, 0, 0, 0, 1\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(j, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(k, 27, 2, 1, 5, 0, 0, 0, 0, 0, 4, 0, 0, 3, 1, 4, 2, 0, 0, 4, 
      1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(l, 16, 22, 1, 0, 1, 10, 1, 10, 6, 11, 0, 5, 14, 0, 2, 4, 0, 0, 
      0, 0, 6, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(m, 28, 8, 0, 0, 2, 11, 1, 0, 7, 4, 0, 0, 0, 10, 1, 6, 0, 0, 4, 
      2, 1, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(n, 22, 38, 0, 0, 0, 170, 0, 0, 14, 82, 0, 0, 0, 0, 16, 11, 0, 
      0, 5, 1, 1, 62, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(o, 12, 0, 0, 2, 7, 1, 2, 0, 1, 4, 0, 8, 1, 1, 1, 0, 1, 0, 10, 
      3, 4, 0, 8, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(p, 13, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 1, 
      14, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(q, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(r, 7, 16, 6, 0, 2, 132, 3, 2, 17, 5, 0, 1, 0, 0, 0, 11, 17, 0, 
      1, 0, 4, 11, 0, 0, 0, 0, 0, 2, 0, 0, 0, 5, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(s, 54, 13, 0, 0, 1, 41, 0, 9, 2, 38, 0, 3, 5, 1, 11, 3, 0, 0, 
      24, 9, 5, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(t, 19, 11, 1, 0, 1, 29, 7, 4, 19, 30, 0, 8, 7, 2, 16, 2, 2, 0, 
      13, 35, 1, 12, 0, 0, 9, 0, 3, 2, 0, 0, 1, 0, 1\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(u, 33, 28, 4, 0, 7, 8, 1, 6, 0, 1, 0, 8, 0, 0, 9, 2, 3, 1, 2, 
      3, 13, 0, 0, 0, 0, 0, 31, 2, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(v, 12, 0, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 0, 2, 
      0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(w, 34, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 
      2, 2, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(x, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(y, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(z, 24, 0, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 0, 3, 1, 0, 0, 2, 
      2, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(\[ADoubleDot], 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1, 0, 1, 2, 0, 
      0, 0, 2, 1, 3, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(\[EDoubleDot], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(\[IDoubleDot], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(\[ODoubleDot], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 1, 0, 
      0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    StyleBox[\(\[UDoubleDot], 14, 0, 1, 0, 0, 3, 7, 0, 1, 0, 0, 0, 0, 1, 1, 
      0, 0, 0, 6, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
      FontFamily->"Geneva",
      FontWeight->"Plain"], 
    RowBox[{
      StyleBox[\(\[SZ], 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\),
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"], 
      StyleBox["\n",
        FontFamily->"Geneva",
        FontWeight->"Plain"]}]}], "Input"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1089, 37, 627, "Input"],
Cell[2801, 88, 980, 25, 187, "Input"],
Cell[3784, 115, 45, 1, 26, "Input"],
Cell[3832, 118, 627, 13, 162, "Input"],
Cell[4462, 133, 61, 1, 71, "Input"],
Cell[4526, 136, 16218, 368, 1830, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

