(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3144,         72]*)
(*NotebookOutlinePosition[      4254,        109]*)
(*  CellTagsIndexPosition[      4210,        105]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`Lorenz`\"]\n\nLorenz::usage=\"\nLorenz[s,r,b] computes \
and plots an approximate solution of the \nLorenz equations with parameters \
(s,r,b), by a Runge-Kutta method.\"\n\n\nLorenzArray::usage=\"\n\
LorenzArray[matrix] plots an array of solutions of the Lorenz equations \nfor \
the values of the parameters contained in matrix.\"\n\n\nBegin[\"`Private`\"]\
\n\n\nLorenz[s_,r_,b_,opts___]:=\n      Block[{listofpoints},\n\t   \
RKuttable[f_List, y_List, y0_List, {t1_,dt_}]:=\n\t\t    \
Block[{k1,k2,k3,k4,yp0 = N[y0]},\n\t\t\t Table[ k1 = dt N[f /. Thread[y -> \
yp0]];\n\t\t\t\tk2 = dt N[f /. Thread[y -> yp0 + k1/2]];\n\t\t\t\tk3 = dt N[f \
/. Thread[y -> yp0 + k2/2]];\n\t\t\t\tk4 = dt N[f /. Thread[y -> yp0 + k3]];\n\
\t\t\t\typ0 = yp0 + (k1 + 2k2 + 2k3 + k4)/6,  \n\t\t\t\t{Round[N[t1/dt]]}]]/;\
\n\t\t\t\tLength[f]==Length[y]==Length[y0];\n\n\t   listofpoints= \
RKuttable[{- s (x-y), - x z + r x - y,x y - b z},\n\t      {x,y,z}, \
{0,1,0},{20.,0.025}];\n\n\t   Show[ Graphics3D[ {Line[listofpoints]} ], \
PlotRange->All, opts ]\n\t   ]\n\n\nLorenzArray[matrix_List]:=\n\n       \
Show[ GraphicsArray[\n\t     Table[ Lorenz[\n\t\t    \
matrix[[i,j,1]],matrix[[i,j,2]],matrix[[i,j,3]],\n\t\t    DisplayFunction -> \
Identity\n\t\t\t   ], \n\t\t    {i,Length[matrix]},       \n\t\t    \
{j,Length[First[matrix]]}\n\t\t  ]]]\n\nEnd[]\n\nEndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{132, Automatic}, {Automatic, 16}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 1430, 20, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
