(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    116849,       2070]*)
(*NotebookOutlinePosition[    117955,       2105]*)
(*  CellTagsIndexPosition[    117911,       2101]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\nNothing\ is\ random, \ only\ uncertain.\ \(-\ Gail\)\ Gasram\n\n\), 
    \(The\ \ Marsaglia\ Random\ Number\ CDROM, \ 
    produced\ by\ George\ Marsaglia\ of\ the\ \ Florida\ State\ University, 
    \ \ contains\ 4.8\ billion\ random\ bits\ 
      \((and\ also\ the\ DIEHARD\ battery\ of\ tests\ of\ randomness)\).\ They
        \ were\ produced\ by\ a\ combination\ of\ several\ ofthe\ best\ 
      deterministic\ random\ number\ generators, \ 
    together\ with\ three\ sources\ of\ white\ noise, \ 
    as\ well\ as\ black\ noise.\n\t\tBelow, \ 
    we\ produce\ a\ list\ of\ unsigned\ 8000\ long\ integers\ by\ reading\ 
      first\ 1000\ \ \ blocks\ of\ Marsaglia' s\ catalog, \ 
    each\ 64\ bytes\ long, \ 
    and\ converted\ each\ block\ to\ 8\ numbers\ between\ 0\ and\ 
        2^\((64)\) - 1.\), 
    \(Peter\ Kernan\ of\ the\ CWRU\ Physics\ and\ Statistics\ Departments\), 
    \(helped\ to\ carry\ out\ this\ 
      project.\n\n\n\n\n\n\n\n\n\n\n\n\n1058915452\ \ 806597142\ \ 771555612\ 
      1668878431\ \ \), 
    \(\t335022025\ 3441894902\ 2024793893\ 3222734186\), 
    \(\ 217988416\ 2576826438\ 1363766847\ 2538000462\ 1335376495\ 4100853813
      \ 3066022444\ \ \ 23504845\), 
    \(2094455625\ 2665865642\ 3261069821\ \ 414873592\ 4264493334\ 1695662434
      \ \ 379539154\ \ \ 70373598\), 
    \(1466059248\ \ 235606729\ 1506510656\ \ 874167970\ 3501980348\ \ 
      889312704\ 1340590525\ 2057349822\), 
    \(\ 468407224\ 1159809346\ 3909144504\ \ 837890669\ 1839053066\ \ 
      253472500\ 3373732724\ 1633572908\), 
    \(2617384685\ \ 728436453\ \ 383533025\ \ 148074654\ 2833021860\ 
      4045958393\ 2690952902\ 3747939824\), 
    \(2493131104\ 4279225552\ \ 243771305\ 3429996826\ 3030458897\ \ 640788428
      \ 3488935192\ 1535636546\), 
    \(4269835025\ 3658781902\ 2858215945\ 3009863355\ \ \ 97349188\ 2402586360
      \ 3988810933\ 1508957191\), 
    \(\ 515919363\ 1305990628\ 2595363836\ 3435511398\ \ 124843225\ 2477373139
      \ \ 411985060\ 3423774150\), 
    \(1558662947\ 3650721421\ 2342571274\ 2722582644\ 3077931979\ 2325755490\ 
      4068128898\ \ 540396707\), 
    \(\ 283057300\ \ 207973646\ 2919085679\ 2914935791\ 2760552095\ \ 
      429946166\ 2714777638\ 3006017331\), 
    \(2475937929\ 2417577209\ 2998092220\ 3219404659\ 2932443593\ 1541271704\ 
      2123470899\ 2205288477\), 
    \(1040412368\ 2867719856\ \ 151244494\ 2397300910\ 1550655733\ 3797759239
      \ 2095968109\ \ 817490030\), 
    \(3290851904\ \ 406948901\ 3065060058\ 2417142636\ 2777948472\ 1558705670
      \ 3200498601\ 3015159090\), 
    \(1762768242\ 2627409680\ \ 573294676\ \ \ 72019493\ 1368011379\ 
      2174984970\ 4057755678\ 3526338036\), 
    \(1253446981\ 3830153308\ \ 402816700\ 3663575957\ 2421517949\ 4170227448
      \ 2633648465\ 2471215866\), 
    \(2909133146\ \ 996817441\ 3022631759\ 4185968322\ 1630820817\ 2781528373
      \ 3801121674\ \ 754910281\), 
    \(1006624885\ 3485816816\ 4140567603\ 4005839764\ 1607621419\ 2246410579
      \ \ 499047972\ 2553450103\), 
    \(2373705715\ 3100637044\ 4140417500\ 3570222247\ 2689151199\ 2133026819
      \ \ 768400540\ \ 508828834\), 
    \(1517519970\ 4230136566\ 3391557338\ 2946437149\ \ 377002115\ 2599036177
      \ 1562587491\ 4156679466\), 
    \(2575314883\ 2648523563\ 1958683074\ \ \ 97145276\ 1613195085\ \ 
      425117084\ 3488304007\ 2630009412\), 
    \(1908701145\ 1735981221\ 1537683772\ 2001360523\ 4161821484\ 3210218404
      \ \ 787769475\ 2707722076\), 
    \(\ 113083624\ \ 389955931\ 1763119556\ 1561693924\ 4284896099\ \ 
      214217983\ \ 966317543\ 3564374713\), 
    \(3035162178\ 3128512758\ \ 667595272\ 2594895318\ \ 732147727\ 4250412356
      \ 2603421925\ \ 731187690\), 
    \(3597229480\ 2264360718\ 2085490978\ 1803097649\ 4234397134\ 4116241192\ 
      1985873412\ \ \ 65174351\), 
    \(2812202558\ 1148424545\ 2918021561\ 3506774280\ 2896633454\ \ 598801915
      \ 3345807625\ 3967903047\), 
    \(2255247655\ 2468455492\ 2286437990\ 3518637887\ 1659768095\ 3371540175\ 
      1734211715\ 2160412337\), 
    \(3839286473\ 4252230536\ 1579977145\ \ 548717815\ \ 340063934\ 3396643124
      \ 4223231101\ 4121587459\), 
    \(1703058545\ 3189905050\ 4076677243\ 2622083420\ 3405933488\ 2138482144
      \ \ 229482659\ 4199451891\), 
    \(\ 555420912\ 3350709420\ 3395011997\ 2192791991\ 3679798279\ 3908735778
      \ 3455580628\ 3064080858\), 
    \(4064977707\ \ 431368422\ 1083739170\ 2441540694\ 2943534936\ 1725216123
      \ 1283446026\ 4270756314\), 
    \(2679619849\ 3125561674\ 1498105388\ \ 955648901\ 3129030724\ 4276688001
      \ \ 764215913\ 3895932071\), 
    \(1841988818\ 1983495430\ \ 261915572\ 2175355581\ 3772824746\ 1820761137
      \ 1215935824\ 2697532649\), 
    \(3689608113\ 2412989571\ 2393850472\ 1722011576\ 3249987589\ \ 901022986
      \ \ 415248464\ 1979212421\), 
    \(3906581079\ 3455920891\ 2349544156\ \ 261425325\ \ \ 78462089\ 
      1088215276\ \ 977646851\ 2182665920\), 
    \(2982624994\ 3011030444\ 3990105986\ \ 931401830\ \ 289436456\ 4135515529
      \ 2738600922\ 4286041254\), 
    \(3067831985\ 1643841903\ 2103648361\ 2494908008\ 4019882802\ 1244295013\ 
      3458185449\ \ 111072671\), 
    \(2756794515\ 3265313675\ 3536788881\ 1027345227\ 2103401032\ 2780650071
      \ \ 646859639\ \ 161400345\), 
    \(\ 838373897\ 1037415342\ 3921526658\ 3288487758\ \ 613141266\ 2846392425
      \ 4020045593\ \ 862112653\), 
    \(\ 131223133\ 2983435018\ 2248931332\ \ 738273790\ 2957492107\ \ \ 
      20244701\ 2291332775\ 1703911580\), 
    \(4284523228\ 1103763594\ 2412745745\ 2415117546\ \ 902687092\ \ 539503828
      \ 2843636345\ 2556556073\), 
    \(2691546634\ 1139211010\ 2468354526\ 2690675448\ 2756277329\ \ 819768958
      \ 1755581603\ 3977486698\), 
    \(2615950689\ 3673562645\ 1280727884\ 1456196421\ 1761923374\ \ 408715853
      \ \ 811184902\ 3356233055\), 
    \(3391628510\ \ 270576705\ \ 358799098\ 3627147412\ 3384163639\ 1711504661
      \ \ 228509532\ 2861343600\), 
    \(3427761560\ \ \ \ \ \ 39273\ 1392359375\ \ 707084212\ 1650448008\ 
      3227852373\ 2546679342\ \ 510245696\), 
    \(\ 504507715\ 2516470568\ 1571224034\ \ 436795242\ 3476372137\ 3577085944
      \ 3530240379\ 2523473328\), 
    \(4279113517\ 3683996123\ 3584486195\ 3168606491\ 3039398774\ 1245629784\ 
      3632081388\ 1382028342\), 
    \(3518240858\ \ 154414451\ 3564241587\ 4177731850\ 1118462198\ 4206463322
      \ 1840153963\ \ 282358190\), 
    \(2146349579\ 3871621961\ 2479473512\ \ 751124725\ \ 983150776\ 2558916897
      \ 1297174338\ 3722192912\), 
    \(4116247609\ 2230128867\ 4162192586\ \ 384355672\ 2539145384\ \ 335469311
      \ 2970808054\ 2036206792\), 
    \(3498112442\ 3768689219\ \ 808114054\ 3981859477\ \ 262430805\ \ 
      431498339\ \ 648216307\ \ \ 88169553\), 
    \(2673124684\ \ 699988509\ \ 646864545\ 1987260462\ \ 983632960\ 
      2051209550\ 1025896020\ 3988041772\), 
    \(1917323253\ \ 872969288\ 2452741978\ 3778966626\ 3080279255\ 3285558838
      \ 3917584651\ 2061801079\), 
    \(1161239387\ 2944033857\ \ 106285030\ 3145842509\ \ 685461173\ \ 
      561878877\ \ 390622058\ 3095749172\), 
    \(3384985218\ 4078162428\ 4115759579\ 3292663406\ \ \ 59309501\ \ \ 
      17098453\ \ \ 82787555\ 2357329229\), 
    \(2872373025\ 1952836959\ 2418903679\ 1598580280\ 4029011015\ \ \ 20220996
      \ 1223379028\ 2377563700\), 
    \(1640526998\ 2557324030\ 1856651179\ 1835298060\ \ 433374875\ 1885836594
      \ 1531831458\ \ 995169947\), 
    \(3514585110\ 1589566030\ 2153874266\ 2573143259\ 2001684943\ 2750888315
      \ \ 302452627\ 1705422498\), 
    \(3350810322\ \ 833222964\ 1853474240\ 3293144617\ 2599108490\ 3975970085
      \ 1006963251\ 1615579507\), 
    \(1002789516\ 4040986415\ 3287467689\ 1240203086\ 1143622133\ 2890894843
      \ \ 367210937\ 3739936188\), 
    \(1951562973\ \ 257162619\ \ 718866991\ 1882793700\ \ 275472256\ 
      2523234915\ \ 424218567\ 3919468942\), 
    \(2559928916\ 2803584559\ 4230448387\ 2042934285\ 1558534843\ \ 693004107
      \ \ 233139942\ 1387971540\), 
    \(1384059791\ 1835906269\ 1336838928\ 1222374583\ \ 244600543\ 2283874213
      \ 2239405904\ 1805490157\), 
    \(3840123742\ \ 362464129\ 3916166493\ \ 449099736\ \ 279143023\ \ 
      279551532\ 2508476504\ 3493445496\), 
    \(1966484569\ 2319962008\ \ 755162559\ 3126446755\ \ 952513717\ \ 
      110410660\ 1494914622\ 3833009688\), 
    \(\ 718199109\ 1934726717\ \ 445709143\ \ 177544765\ 3691509994\ 
      1979992262\ 2776738076\ \ \ 94568309\), 
    \(4099822366\ \ 695794802\ 3861925689\ 1421992391\ 1838677737\ 1940673305
      \ 3571034961\ \ 199539848\), 
    \(3863618216\ \ 718707980\ 2386891255\ 1526490170\ 1934968694\ 3385868856
      \ 1904396034\ 2631140878\), 
    \(1777181289\ 1310601444\ 2644876777\ 2766363918\ 3024469035\ 1047352863
      \ \ 237296513\ 3847354807\), 
    \(\ 395009415\ 1047595096\ 1841710547\ 3014216508\ 1761604172\ 1323714739
      \ 1435763691\ 3212095145\), 
    \(4094695184\ 2077305016\ 1441771659\ 3772590252\ 3407129882\ 1417327099\ 
      4063383056\ 1217434583\), 
    \(4096467928\ 3201698192\ 1972059272\ 1477272747\ 2512123291\ 2828948364\ 
      3752727879\ 4117059588\), 
    \(2377631476\ 1157016782\ 3820062899\ 3020731757\ \ 893615798\ \ 335394584
      \ 1646062425\ \ 352679143\), 
    \(1714030116\ 1330035068\ 4093079015\ 4028097918\ \ 312760119\ \ 781420149
      \ \ 114725645\ 1441338819\), 
    \(1443795965\ 1482764157\ 3166483127\ \ 442754245\ 3997173058\ 1864389971
      \ 3994293803\ 1788521690\), 
    \(1129707919\ \ 536716485\ 2919106457\ \ 189351614\ 3716774306\ 3205789230
      \ 2377868926\ 2932661426\), 
    \(2930994869\ 3451408675\ 1205178992\ \ 858367002\ 3983469205\ 2720245953
      \ \ 410313117\ 3074824577\), 
    \(\ 518234723\ 3828137187\ 2687479023\ 1047694734\ \ \ 49310401\ 
      4020836505\ 2939294052\ \ 960308499\), 
    \(3658142154\ 1695570443\ 2938223498\ 3509791151\ \ 766215608\ \ 148783692
      \ 3644622621\ 2056954281\), 
    \(\ \ 84077385\ \ 119292737\ 2461545589\ 3141583262\ \ 802155427\ \ 
      760670403\ 1430967557\ 3940524562\), 
    \(2016078519\ 2684918133\ 1255653344\ \ 791969981\ 1725056666\ 2681529625
      \ 2256041981\ 4201262169\), 
    \(2383290764\ \ 721881043\ 1368473409\ 2082014840\ 3697788042\ 2748146193
      \ \ 653009490\ \ 400995209\), 
    \(2485341797\ \ 931422759\ 2910339606\ 3173202450\ 3352667269\ 3169852059
      \ 1316007089\ 1390351745\), 
    \(\ 340941820\ 1176346705\ 1684029951\ \ 118944352\ 2784859706\ 2314643350
      \ 2077390273\ 1895761865\), 
    \(\ 431385436\ \ 941253086\ 4290456777\ 3192831563\ 3047660840\ 2330700644
      \ 2200468917\ 1042909173\), 
    \(1265848718\ 2452174079\ 3591142105\ 4125363369\ 4288821250\ \ 385426539
      \ 3593358566\ 2074519510\), 
    \(1584317716\ 1258429921\ 1767781179\ 2797314964\ 2930170543\ 2671086397\ 
      2637209790\ 2313345577\), 
    \(1702050627\ 2722225429\ 2632114830\ \ 169690307\ 1075547263\ \ 993457428
      \ \ 350932049\ 1386817046\), 
    \(2928138538\ \ 569999575\ 2027908906\ 4050189587\ 2635590034\ \ 687566040
      \ 3060263614\ 2942707346\), 
    \(3904088696\ 3210516768\ 1611970401\ 3858516249\ 1137533877\ 1025767352\ 
      2248360793\ \ 880308792\), 
    \(2377969863\ 4283106326\ 2026053691\ \ 790761171\ 2736864142\ 3712420290
      \ 1202917366\ 2280954457\), 
    \(3807333127\ \ 516414267\ 1235298836\ 2318384472\ 3474212641\ 2376728376
      \ 4206432085\ \ \ 55339364\), 
    \(2729086655\ 3364838097\ 3326857223\ 2882896548\ 1692642659\ 2904918362\ 
      1899966115\ 3805659156\), 
    \(3468871277\ \ 911609625\ 2309069356\ 2986496075\ 1010353960\ 3585956789
      \ 3943457531\ 3075802773\), 
    \(3642454502\ \ 192028383\ 2300991402\ \ 894474102\ 3666740280\ 3971841826
      \ 1647254839\ 2114514603\), 
    \(3179014849\ 2195515812\ 2478466183\ 1454808286\ \ 420985718\ 1960220827
      \ 3696643675\ 3172479207\), 
    \(2660888306\ 1756032191\ 3841289738\ 1541406387\ 3317203275\ 1224350057\ 
      2118472816\ 1874153754\), 
    \(3487913374\ 3399356031\ 1118105200\ 2620079874\ 2796160875\ \ \ 76887997
      \ \ 569396415\ \ 457685533\), 
    \(1043546216\ \ 114941247\ \ 336358748\ 4113052579\ \ 377851611\ \ 
      992501190\ \ 403967911\ 2219335558\), 
    \(3639240618\ 3784874181\ \ \ 97079775\ 4248597585\ 1895269795\ \ 
      588542732\ 3054989090\ \ 731759583\), 
    \(1506262866\ \ 116403689\ 2813125470\ 4244415353\ 1988427811\ 1702149443
      \ 2224472612\ 2547521382\), 
    \(2897666344\ 2600388870\ 2207820548\ 4209511602\ \ 562790472\ 2020321325
      \ \ 230126323\ 2815025143\), 
    \(3447508081\ \ 230446878\ 3871339771\ 1534488766\ \ \ 54915487\ 
      4266130343\ 1386546876\ 1772446983\), 
    \(4205418525\ 2012304023\ 2311068617\ 4095565514\ \ 169031146\ 1300336047
      \ 2143407966\ \ 632837289\), 
    \(1292907657\ 3182414134\ 3928785945\ \ 886753649\ \ 429921717\ \ 
      748733613\ 3262591235\ 3322122826\), 
    \(3315666508\ 2485345236\ 2594207001\ 1523548129\ 1695070257\ 3702826373\ 
      2389671326\ 3768255259\), 
    \(\ 891482854\ 4141484988\ \ 135269251\ 3586685913\ 3907864483\ 3768234696
      \ 2656494480\ 2087899443\), 
    \(2023587671\ 2729314199\ 2584036844\ 3287214699\ 3291607309\ 1927553374\ 
      1906768556\ 1936768190\), 
    \(4146181616\ 3380855352\ \ 688884370\ \ \ 95337060\ 3917874761\ 
      2318734859\ 1345667610\ \ 796437555\), 
    \(1247315379\ \ 358496015\ 3340975508\ 3079628346\ 2439052450\ 2804103473
      \ 1402689657\ 3950719621\), 
    \(3778226110\ 2284790730\ 1635411214\ 3319288985\ 2895025179\ 2565195217\ 
      3701614029\ 2693114219\), 
    \(2673998887\ 2694952702\ 1486908141\ 2127049356\ \ 667255043\ 2051301246
      \ 1645308825\ 4293351659\), 
    \(3427102644\ 2687861884\ 2722799709\ 3408401609\ 1139718024\ 2486024111\ 
      2332391152\ 4236595829\), 
    \(3130702814\ 3349899704\ 1230243172\ 3179994629\ 3072471264\ 3695436114
      \ \ 990335974\ 3164013567\), 
    \(\ \ 83089164\ 1515521012\ 2363163940\ 1655346963\ 2410629278\ 3491191109
      \ \ 437050559\ 1735474835\), 
    \(1179541073\ 1696252280\ 4106971056\ \ 914054275\ 3138492130\ \ 459949160
      \ 1086929979\ 3097203500\), 
    \(1952069427\ 3079189030\ \ 445927337\ 3310765370\ \ 748022981\ 2229842531
      \ 3528149570\ 1483587690\), 
    \(3267473839\ 1808176484\ 1510347851\ 1218073105\ 1148159572\ 2715889967\ 
      2896344595\ 1483822145\), 
    \(\ 124982475\ 3650565324\ 4107363741\ 2531262659\ 1224672678\ \ \ 
      62249156\ 2116840100\ \ 890227293\), 
    \(2243808491\ \ 716806616\ \ 915260679\ 3009131013\ 3510706407\ 1381114140
      \ 4213478325\ 3511717061\), 
    \(1317402386\ 1460908192\ \ \ 80217475\ 3039593161\ 3119687957\ \ 
      222284120\ 3593381335\ \ 670945902\), 
    \(\ 348497028\ 1275470586\ \ \ 55688530\ \ 486728631\ 3853765511\ 
      1040265733\ 1462373348\ 3343929483\), 
    \(4061574385\ \ 210440148\ 3044519140\ 1021301876\ 2648580474\ 1061136668
      \ 1290065871\ 2867447142\), 
    \(3641371067\ 3004393254\ 2511570586\ 2106831679\ 4248970514\ 2326134632\ 
      3067187750\ \ 836663968\), 
    \(1991729153\ \ 330423384\ 1612514939\ 4195127423\ \ 223998184\ \ 
      186153374\ 3080338029\ 3860692511\), 
    \(\ 143342894\ \ 899824990\ 1884803485\ 3959718367\ 2151593218\ \ 
      198427267\ 2883984733\ 1562861397\), 
    \(2508243269\ \ 878937730\ \ 713396806\ 1187898456\ 3223767803\ 1014967438
      \ 2181762220\ \ 785008707\), 
    \(1709817842\ 1651464869\ 2929588045\ 3613254832\ \ 739016546\ 2412487089
      \ 3042791166\ 2005795408\), 
    \(\ 188383699\ \ 126096130\ 3898482001\ \ 560590534\ 3247578900\ 
      2106682167\ 2880772498\ 3895262102\), 
    \(\ \ 13283039\ 2679639883\ 3691415501\ 1413608313\ 3376003646\ 3638738669
      \ 2194305046\ \ 187372684\), 
    \(1888455336\ 2715079143\ \ \ 23739631\ \ 509516726\ 4138132041\ \ 
      525006314\ \ 968443576\ 2788829013\), 
    \(1241375419\ 1731834189\ \ 689050428\ \ 348277815\ 3006276543\ 1448042322
      \ 1721869063\ \ 711914320\), 
    \(3798935306\ \ 846750025\ 2481111739\ 3811026636\ \ 237595021\ 1211496466
      \ \ 938038699\ \ 891800601\), 
    \(3075259587\ 3320558653\ 3721267597\ 3603154494\ 3542693798\ 2609932494\ 
      1989422342\ 2206541974\), 
    \(1489836563\ 2689112403\ 1676647146\ 1210201086\ 3606538150\ \ \ 52488320
      \ 1997350283\ 3341601044\), 
    \(2836138716\ 1132377142\ 3785573258\ 1817182459\ \ 186507758\ 3486628962
      \ \ 168414781\ 2106629862\), 
    \(3222239008\ 2217964547\ \ 779321904\ 4262026549\ 3190356619\ \ 410104128
      \ \ 302373108\ 3756274013\), 
    \(3432315529\ 4234743503\ 3693270133\ 2579484654\ 4002841676\ 2142094054\ 
      3326322606\ 2455601523\), 
    \(2695561648\ 1095183322\ 1718384736\ 3868450189\ 3792343687\ 3559002942\ 
      2154706773\ \ 987641720\), 
    \(2300281178\ 3096175159\ 3691253548\ 2931016151\ \ 121051084\ 2930413300
      \ 2864303986\ 1677221343\), 
    \(2804335501\ \ \ 20474009\ 3407434554\ \ 607665623\ 3533695997\ 
      1078566279\ 3681861830\ 2226905024\), 
    \(3963537347\ 1172634384\ 1410916299\ \ 461454599\ 1819889790\ 2015116999
      \ 3144933756\ 4039365208\), 
    \(3897275774\ 3658112718\ 1028356484\ 4193958706\ 1816899025\ \ \ 86313754
      \ 3070045274\ \ 294833398\), 
    \(1642789331\ 1969389151\ 3492890496\ \ 953479704\ 4006547317\ 3703992427
      \ 3037088384\ 2193064845\), 
    \(3213756509\ \ 234834470\ 2976072370\ 1753977881\ 3064094675\ 2617985164
      \ \ 134841792\ 3190302686\), 
    \(4225889265\ 2159096235\ 2303171033\ 3438761926\ 4152335039\ 4258247811\ 
      2212886103\ 3758829979\), 
    \(1488123995\ 1261987505\ 3474058995\ 1849173173\ \ 557760611\ 3062071834
      \ 2036237578\ 3579227934\), 
    \(\ 304260815\ 3960154479\ 1553535132\ 2375993644\ 3263606832\ \ 232506922
      \ 1328074851\ 3156508909\), 
    \(4055531530\ 2557249246\ 2761417693\ 3391016759\ 3815920428\ 3707750392\ 
      2934321465\ 2968985568\), 
    \(2803508549\ 3543322295\ 4252983146\ \ 318397060\ 2495438658\ 3345533892
      \ 1771990648\ \ 433196957\), 
    \(2966592049\ \ 363057951\ 3103927953\ 3294647772\ \ 462391138\ \ 
      871826484\ 1079148067\ \ 240868414\), 
    \(2889420866\ 1309446509\ 2485094338\ 2019708960\ \ 492281258\ 1894690216
      \ 4036113965\ 3226876924\), 
    \(\ 222638887\ 3805020819\ 3857275302\ 4074523700\ 2101300105\ 1661532895
      \ 1892855109\ 3742148773\), 
    \(2222488154\ 2187435334\ 2543915568\ 3364404968\ \ 841875069\ 1884671588
      \ 1632749329\ 1319226468\), 
    \(2879688014\ 2882351292\ 4077425499\ \ 530002339\ 3573417520\ \ 681364388
      \ 1706770141\ \ 895406220\), 
    \(\ 415981440\ 3957577906\ 2874865613\ 3046129793\ 4268360393\ 2677980692
      \ 3275410002\ 2567799888\), 
    \(1543434739\ 3452619498\ 2657557210\ 2327451613\ 1257708728\ 3830498782
      \ \ 617240111\ 3112754741\), 
    \(3868875907\ 1722800092\ \ \ 54029274\ 2189107233\ 3692691899\ 3481592366
      \ \ 141024366\ 1775599199\), 
    \(\ 557642114\ 3508106450\ 1246586157\ \ 689279830\ 2193769222\ 2731574925
      \ 1328942336\ 3081892025\), 
    \(3142031993\ 2547437522\ 2979824282\ 4284586183\ 1369556817\ 2341324096
      \ \ 153418620\ 4245636213\), 
    \(3301452233\ 1735284308\ 1033606644\ 2257868830\ \ 418969619\ 3606288949
      \ 1325141740\ \ 371155856\), 
    \(3384824593\ 3713363651\ \ 957044160\ \ 459788723\ \ 370881531\ \ 
      982517538\ 3192067101\ 1737527118\), 
    \(3934768924\ 1784547386\ 2602316106\ 2248300995\ \ \ 55830159\ 2194522463
      \ 2648795160\ 1492052923\), 
    \(4092392417\ 3962157774\ 2328065294\ 2960903499\ 2811245593\ 1611832107\ 
      3142384959\ 3532632609\), 
    \(2220407050\ 1905671261\ 1416056085\ \ 276085524\ 2091667426\ 2055158012
      \ 1757696585\ 3898851156\), 
    \(\ 212879934\ 1268604577\ 3569957943\ 1833759443\ 1840530338\ 3469563709
      \ 1468515201\ 3305325332\), 
    \(2013650159\ \ 813317335\ \ 104912744\ 1348308800\ 3574879677\ 3072045932
      \ 2554681689\ 2568751631\), 
    \(2769894360\ \ \ 22463259\ 1322610113\ \ 986597564\ 3094039030\ \ 
      691202851\ 4246960600\ 3973933223\), 
    \(1562291520\ \ 596779275\ 3429390221\ \ 176650135\ 1491834464\ \ 
      877316179\ 2767557874\ 1315790518\), 
    \(1127737716\ 3377648789\ 3358749348\ 2772763112\ 1442213800\ 4094364010\ 
      1850591198\ 3475128013\), 
    \(4157179608\ 2547218677\ 3355781324\ 3580786379\ 2062046711\ 3964196349\ 
      2452106375\ 4104520254\), 
    \(\ 943060777\ \ 208073714\ 3177870155\ 2084336059\ 3274123939\ 2558457157
      \ \ 525749649\ 2940407455\), 
    \(4155518326\ 1351451951\ 3750234735\ 3376672386\ \ 723524381\ 3342933657
      \ \ 314709311\ 4079630772\), 
    \(3924078458\ \ 470729655\ 1303649422\ 2785208383\ \ \ 89498821\ 
      1494756231\ 3127900305\ 2176576507\), 
    \(2080349178\ 2042034462\ \ 224706841\ \ 621830515\ 2962999694\ 2833580205
      \ \ \ \ 6460488\ 3941380017\), 
    \(2318169889\ \ 988112968\ \ 413827137\ 3942378567\ 1544465033\ 2877721752
      \ 1675878333\ 2943278218\), 
    \(\ 754285055\ 1836512821\ 2420604616\ 3253842774\ \ 845279431\ 4288639099
      \ 3054914745\ 1778321876\), 
    \(2191731492\ 1997844595\ \ \ 70912368\ 1983429177\ 1109995498\ \ 
      933175720\ 2102759142\ 1825799260\), 
    \(4165386725\ 3084364052\ \ \ 77465461\ 2343783982\ 3320063677\ 1323185292
      \ 3664108262\ 3324641450\), 
    \(3755224791\ 4230933647\ 3913130850\ 2324144906\ \ 354747834\ 3314077185
      \ 2548996582\ 1803105229\), 
    \(1383668487\ 1798737390\ 2933505311\ 2298016046\ 2784243025\ \ 462791228
      \ \ 787744087\ \ 788778484\), 
    \(\ 329635595\ 3748872876\ 1109706246\ 3721471749\ 3933632144\ \ 835110803
      \ 1111563707\ 1038859420\), 
    \(4242802926\ 3602875410\ 3369947504\ 1279427925\ \ 593584549\ 1142410655
      \ 2341940900\ \ 327147803\), 
    \(3002648171\ \ 554531845\ \ \ 95455898\ \ 972162700\ 3526711310\ 
      4032200433\ 1118462163\ 2855592085\), 
    \(\ 467046209\ 3830102848\ \ 856328302\ \ 536072449\ 4233019061\ 
      4167988134\ 1197936499\ \ 648483848\), 
    \(3901597638\ \ 323255947\ \ \ 96172979\ 1634558007\ \ 964367491\ \ 
      182542648\ 1116923105\ 3985116031\), 
    \(\ 473383575\ \ 508374114\ \ 772754419\ 4101575837\ 4201193820\ 
      4240706754\ 3252618285\ 2263049680\), 
    \(3862570118\ 4041557024\ 3002977637\ \ 871388080\ 3213402174\ 2812408133
      \ \ 564962898\ 2147421899\), 
    \(1260376023\ 4037974605\ \ 972503937\ 3804856755\ \ 221509723\ 1940720655
      \ 2209574963\ 2283712028\), 
    \(4244161389\ 4112046062\ 4124942999\ 3043583498\ 1761347667\ 2307644824\ 
      4196727740\ 3710781802\), 
    \(3387634359\ 1030951825\ 2753307208\ 3066113860\ 3643496093\ 3641092168\ 
      3942369960\ 2240177618\), 
    \(1288984688\ 4207892116\ \ 924681473\ \ 337537463\ \ 890243007\ 
      3360182836\ 2102767700\ 1012582346\), 
    \(3265512789\ 4209372123\ 3184162893\ \ 503592215\ 3632521554\ 1323083817
      \ 3950327194\ 2066763039\), 
    \(1387356829\ \ 765576376\ 3735440527\ 1925858876\ 3077483915\ 3929672017
      \ \ 245360987\ 2980144943\), 
    \(3368121631\ \ 129533580\ 2738902455\ 3640027604\ \ 963421687\ \ 
      480575344\ 3516476932\ 1148118222\), 
    \(1683463652\ 3082130499\ 1059067053\ 2465502337\ 2297332556\ 2550486049
      \ \ 585510561\ 1012283796\), 
    \(1960182781\ 2849230611\ 1178137861\ 1619053564\ 2222567406\ 3049743144\ 
      3610055552\ 2686324509\), 
    \(1294674151\ 2176249561\ 2797916848\ \ 789615489\ \ 354383162\ 1580737150
      \ 2392388844\ 1427484255\), 
    \(1113808514\ 1665690921\ 2336133987\ 3755907774\ 3023107214\ 3765092397\ 
      3362889648\ 1860172186\), 
    \(2491825186\ 1667460117\ 1316173539\ 1628102209\ 4146433385\ \ 880171151
      \ 3984078254\ 2949160585\), 
    \(1007942551\ 3275908746\ 2639142932\ 2352554422\ 2962378027\ 2161130606
      \ \ 153608660\ 3963728540\), 
    \(1204374265\ 2284190417\ 4127635974\ 3103965650\ \ 481893767\ 1041171649
      \ 1389540252\ \ 205911454\), 
    \(2867431755\ 3614823922\ 1820299876\ \ 722756127\ 3296770048\ 3614601128
      \ 4277497333\ 2258740118\), 
    \(1373733626\ 1003893104\ 2390494163\ 2276776958\ 1396521416\ 2447802181\ 
      3377042332\ 2127414693\), 
    \(3022639434\ 2250921587\ 1671746437\ \ \ 16341152\ \ 862508050\ 
      2375764348\ 1513802472\ \ 529261710\), 
    \(3068208302\ 2200670682\ 1465697323\ 3296989973\ 3014071076\ 1609232281\ 
      3273029179\ \ 220470141\), 
    \(1290496424\ 3875290642\ \ 907190226\ 2672964531\ 2435053397\ 2101884679
      \ 2834657003\ 2310458239\), 
    \(2355711612\ \ 953838170\ 4216010065\ 1656917259\ 1586836854\ \ 638356361
      \ \ 406525944\ 2186515740\), 
    \(1798631676\ \ 942710183\ 4194517101\ 1645178232\ \ 338330165\ \ \ 
      53283877\ \ 952074978\ 2615954500\), 
    \(1263403566\ 2938849568\ 3039836122\ 2114670891\ 1904131898\ \ 331681102
      \ 3268913669\ 2575338003\), 
    \(1303343202\ 3414777817\ 3258008709\ 1709689455\ 3221008023\ \ 639113567
      \ \ 164389265\ 3098115124\), 
    \(1545368743\ 2626195139\ 3724579179\ 3557388515\ 2220419920\ \ 653264936
      \ 2433181739\ 1544884482\), 
    \(2917909709\ \ \ 48242407\ \ 657364659\ 4165594455\ 1259302265\ 
      4014142274\ 2631626490\ 1231408423\), 
    \(\ 592526012\ 3396529661\ 3773193956\ 3302158851\ \ 890308489\ 1061346859
      \ 1794722107\ 2936341963\), 
    \(3770813830\ 3970762383\ 1836029633\ 2089267017\ \ 833570778\ 4028185828
      \ 3387268643\ \ 857534877\), 
    \(3041288769\ 2730688851\ 3160998452\ 1982339074\ 2624956104\ 3553966696\ 
      1801517642\ 2292745786\), 
    \(2249557529\ 2210146205\ \ 507206733\ 1965461468\ 2235145036\ 2677684012
      \ \ 141185084\ 3478048711\), 
    \(2351949951\ 1278234245\ 3564842551\ 4149357798\ 3333427131\ \ \ 22919671
      \ 1231914397\ 2220980753\), 
    \(3508976253\ 2161458449\ 1803841486\ 2882312031\ \ 374932899\ 4044993853
      \ \ 664656307\ 2364376735\), 
    \(2903511002\ 4235084295\ 2425114911\ 1231202074\ \ 655781218\ 3012229095
      \ 4147825131\ 1764489721\), 
    \(3105811089\ 3288695572\ 3665357491\ 4143599455\ 1053366641\ 3927907409\ 
      1842484865\ 3954652712\), 
    \(\ 673518840\ 1886445451\ \ 629391180\ 3694568812\ \ 989819488\ 
      4197164247\ 2288100469\ 1739446493\), 
    \(1999306136\ 3513262637\ 3983546076\ 3985135692\ 4217037235\ 3860510287
      \ \ 818015552\ 1520901988\), 
    \(2079826420\ 1682885514\ 2007660990\ \ 687113249\ 3589358313\ 3849907302
      \ \ 863664320\ 3910416849\), 
    \(1074589194\ 2135232004\ 1474724906\ \ \ 86024039\ \ 171143430\ 
      1893988710\ 4294665475\ 3673086801\), 
    \(\ 512997324\ 4016369956\ \ 171315763\ \ 664812489\ 3311716696\ \ 
      180978645\ 2067613647\ 1401885943\), 
    \(\ 272342761\ \ \ 24247019\ 3352088896\ 2127749744\ 4085783883\ 
      1185709135\ \ 995752926\ \ 674041852\), 
    \(1878702377\ 1374714447\ \ 362545298\ \ 765083673\ 3074275701\ 3075031530
      \ \ 125969369\ \ 331176418\), 
    \(3309864029\ 4151394888\ 4007521599\ 2854762069\ 1709413283\ 3438781392\ 
      3506618600\ 2828326997\), 
    \(\ 174149563\ 3068264696\ 3231275965\ 1375030694\ 2213402260\ \ 540072173
      \ 1400397469\ 3880988246\), 
    \(3969175863\ 1111838200\ \ 370628232\ \ 857276403\ 3911382756\ 3352524628
      \ 3442251035\ 1513230135\), 
    \(3536384132\ \ 136520541\ 3231211064\ 2098055468\ \ 697540690\ 2963866413
      \ 3164124062\ \ \ \ 1893422\), 
    \(2648387714\ 3752918077\ \ 506571953\ 2566080329\ 2135210812\ 3574244521
      \ 4003974198\ 3454902094\), 
    \(3558266730\ 3276008463\ 2146020342\ 1948371494\ 3866237345\ \ 433020687
      \ 1433504372\ 1478802988\), 
    \(1310957216\ 1462175340\ 3189943221\ 3827228102\ 1612603785\ 2675172548\ 
      3232986745\ 2623255340\), 
    \(3787415041\ 3347578968\ \ 220474040\ \ 719456495\ 3718208992\ \ \ 
      34775324\ 1423361013\ 1616082650\), 
    \(2946510053\ \ 646553931\ 1658519023\ 3028789008\ 3914250172\ 2177656216
      \ 3382877807\ \ 368093743\), 
    \(\ 314147024\ \ 945788870\ 4008312256\ \ 598557705\ 1843536854\ 
      2505981638\ 2468659263\ 1075863621\), 
    \(\ \ 55394920\ 3913329819\ 1411600381\ \ \ 10335366\ 1286194428\ 
      2322957658\ 3711721840\ 3510280515\), 
    \(\ 656365203\ \ 354103385\ 3390388718\ 3408061007\ 4222893796\ \ 
      984313496\ 4035631859\ \ 562428620\), 
    \(3699588280\ \ 874196680\ 4291032855\ 2864765500\ 3744095682\ 4113732358
      \ 2490621023\ 1045326039\), 
    \(2530918551\ 1437634512\ 2391510035\ 2769932462\ 1357720069\ \ 535633983
      \ 3592271209\ 1108616692\), 
    \(2664340287\ \ 539839765\ 3025779244\ 1278656839\ 3588943593\ 2459682425
      \ 4200014510\ 4189804246\), 
    \(2405497650\ 1428714606\ \ 518790190\ 2094759744\ \ 387419526\ 1101981360
      \ 3854497728\ \ 147839957\), 
    \(\ 605778018\ \ 903271333\ 2926957900\ 3066302170\ 3620345791\ 1492057394
      \ 1105783011\ 3933497240\), 
    \(1829797646\ 3432985073\ 3626013258\ \ 549528956\ 3543618567\ 1150208695
      \ \ 691542219\ 2846474252\), 
    \(1035399809\ 2591167695\ 4138382894\ \ 502915628\ 2700568892\ 1263267295
      \ 2514787019\ 1421698566\), 
    \(3374634046\ 2011314995\ 1438351119\ 2235516012\ 2654173944\ \ 786598374
      \ \ 708501544\ 3474658652\), 
    \(3611799795\ 2852717829\ \ 675083453\ \ 502672882\ 1818980688\ 3451119490
      \ 4057572119\ 2676353724\), 
    \(2059465635\ 1351489577\ \ 251445755\ 3481530988\ 3415268517\ \ 191880236
      \ 3566468645\ \ 895736854\), 
    \(1428143554\ 3931163405\ 1344746334\ 3068742198\ 2837133362\ 3808461322\ 
      3363780836\ \ 829814106\), 
    \(1429283764\ 4100455824\ 3944014192\ 1385743762\ 3363778424\ 1653474965
      \ \ \ \ 9700715\ 3578615152\), 
    \(2150326088\ 2342459443\ 3405112227\ 2829955604\ 2530140574\ 2162941931\ 
      4162293280\ 2877986278\), 
    \(1121416477\ 1127403786\ 1009999677\ \ 404501756\ 2584557364\ 2197032738
      \ 1524583513\ 2642695684\), 
    \(2289283902\ 1801584486\ 3273407673\ 2849522864\ 2493577342\ 2477480227\ 
      4265115344\ \ 806404376\), 
    \(\ \ 28194446\ 2496900006\ 2184339690\ \ 643237494\ \ 875764070\ \ \ 
      19262157\ 3587826599\ 1832041355\), 
    \(1975868548\ 2593760156\ 3271481138\ 2230815633\ 3311107230\ 2827681864
      \ \ \ 45068026\ 3346433069\), 
    \(3861806813\ 2575470281\ 3527588652\ 1065626790\ 2637264803\ 3979005146\ 
      3981149944\ 3024394352\), 
    \(\ 806150675\ \ 941423250\ \ 126889512\ 1293722795\ 1817634035\ \ 
      206996039\ 2238685371\ 2544165490\), 
    \(\ 573043902\ 1815219584\ 1566745363\ 1442741874\ 2661879408\ 1427796909
      \ \ 760169407\ 1580626483\), 
    \(2776637326\ 2268878279\ 3132293964\ 1446530829\ 3579653382\ 1335082440\ 
      4114125958\ 2335694601\), 
    \(\ \ 73137186\ 1562628234\ 1819985515\ 3122280126\ 3405487117\ 2916120059
      \ 1654440427\ 1049900475\), 
    \(2613148622\ \ 522587983\ 3035007918\ 2043740441\ 3725653771\ 1114070451
      \ \ 416252634\ 3709243211\), 
    \(1239451047\ 3864225430\ 3124981524\ \ 291443085\ \ 738352559\ 1296004394
      \ 1624122761\ 3588568659\), 
    \(1720325378\ \ 728555285\ 1245360877\ 2453290198\ 3404088354\ 1772906122
      \ \ 656517671\ \ 120830616\), 
    \(1914864584\ \ 532970838\ 4187456701\ 2616584089\ \ 968612052\ 2848732915
      \ 3504703000\ 1127849680\), 
    \(2556958671\ \ 893649978\ 3432231882\ 3401956808\ 3497453390\ \ 539627778
      \ 3818461135\ 1121486614\), 
    \(\ 860699093\ 1548350860\ 1068166521\ 3360947389\ 4140631683\ \ 526344905
      \ 3439349041\ 2836908111\), 
    \(3679510171\ \ 207632770\ \ 349854764\ 1229400479\ \ 935802987\ 
      3083059798\ 2688433197\ 2201389402\), 
    \(\ 847080143\ \ 779678526\ 1855446795\ 3660586409\ 1523322917\ 2254282438
      \ 1856316961\ 3538390015\), 
    \(2416792934\ \ 647009934\ \ 968857882\ \ 592454505\ \ 109632501\ 
      1511338153\ 1973629039\ 4232087821\), 
    \(3752137266\ 1549755507\ 3999578314\ 1681107223\ 1280590146\ 4043687825\ 
      3968978787\ \ 337308328\), 
    \(3120498269\ 3749167003\ 3174230374\ 2418482047\ 2200506765\ 1573500195\ 
      3904070556\ \ 814604479\), 
    \(3407510037\ 2251247300\ 3479717877\ 3261391558\ 2434220432\ \ 965800455
      \ 3722253526\ 1318344034\), 
    \(1769957732\ 4196436387\ 2437380769\ 3183128723\ 2637557449\ 2557348379
      \ \ 613176126\ 2425420778\), 
    \(1542299963\ 4031979953\ 1099659287\ 3558688205\ 1015246635\ 2538443525
      \ \ 999705120\ \ 187974134\), 
    \(3143934126\ 4201679281\ \ 944988073\ \ 743240456\ 1151815578\ \ \ 
      54801939\ 2103004673\ 2152637725\), 
    \(2743056283\ 3853852362\ 2840207896\ 1337569151\ 2797682077\ 4087966037\ 
      2359497567\ \ 764331549\), 
    \(\ 822359345\ 1329478701\ 2386005939\ 1763001242\ 3664766256\ \ 359926876
      \ 2383676234\ \ 384936607\), 
    \(\ 824618817\ 2042766739\ 2049571869\ 2572866536\ \ 355510368\ 3745201815
      \ 4275106645\ \ 627585308\), 
    \(4037301137\ 1389210997\ 1887713527\ 1403093186\ \ 625602746\ \ \ 
      24712189\ 3662370233\ \ 568461672\), 
    \(\ 647089865\ 2454780844\ 3492089303\ 2869590724\ 4077234142\ 2635670046
      \ 1215556891\ 4103680763\), 
    \(3121114821\ 3109928297\ \ 413366066\ 3590221767\ \ 994166564\ 4235892454
      \ \ 153630484\ 1782208605\), 
    \(\ 929115688\ 1343050379\ 3438552336\ \ 750762214\ 1717562974\ 2936030090
      \ 2521827272\ 1517441572\), 
    \(2154919393\ 3784818622\ 4276445783\ \ 504439638\ 3464625830\ 3457788765
      \ 1080895353\ 4111616603\), 
    \(2082719548\ 2016625137\ 4087530812\ 2042369007\ 1822809595\ 3336201473\ 
      2997828101\ 4132731244\), 
    \(2175141201\ 3362337177\ 3031586563\ 2907184461\ 1595949777\ 2479265069\ 
      2071487311\ 1891158184\), 
    \(3344232312\ \ 517789819\ \ 828847532\ 3636275902\ 4185168732\ \ 
      692031624\ 3819059353\ 1106721370\), 
    \(3938342888\ 1312886774\ \ 394864800\ 4176273872\ \ 808747548\ 3083309194
      \ 1910313260\ 2326598186\), 
    \(\ 576850503\ 2696419193\ \ 505168560\ 3312836570\ 4082057672\ 2406501451
      \ 4056755778\ 3313896149\), 
    \(\ 243073625\ \ 315122618\ 2816546125\ 3771202318\ 3519678397\ 1188156697
      \ 4101925534\ 1988664151\), 
    \(1421718238\ 2439752897\ 3905894166\ \ 752442557\ 2398971670\ 2738322578
      \ 3724643557\ 2281364385\), 
    \(2677722915\ 1964769483\ 2280372836\ 1937617623\ 2703452568\ 2495539127\ 
      2736243993\ \ 205775176\), 
    \(\ 368525832\ 1867389792\ 1971507815\ 2030554651\ \ 677156029\ 2848434375
      \ 1536543947\ 4172276012\), 
    \(\ 875637028\ 3213325201\ 2457027698\ 3224514531\ \ 506132317\ 1968024005
      \ \ 944570015\ 1453199661\), 
    \(1165444622\ 3702712691\ 3611940154\ 3442942795\ 1622061928\ \ 847016083
      \ 2930666469\ 2162320972\), 
    \(1808319725\ \ \ 51170012\ \ 403444929\ 3361596794\ 4202005786\ 
      3032425071\ \ 276818674\ 1170679723\), 
    \(2772072231\ 1590431716\ \ 940291761\ \ 346917922\ 3358701911\ 2717715651
      \ \ 676642999\ 1340354672\), 
    \(\ 207832995\ \ 527039516\ 1715426036\ 3830802159\ 2348252323\ 2971353378
      \ 1469347067\ \ 695060699\), 
    \(3999734105\ 2462974660\ 3714844236\ 3967571101\ 4218193205\ 2302657375
      \ \ \ 78395223\ 2387511681\), 
    \(2954741108\ 2475717483\ 3324238734\ \ 979478476\ 2027652426\ 3339146510
      \ 1960239259\ 1517946844\), 
    \(\ 247156947\ \ 611447121\ 1704553815\ 1221362165\ 1627983412\ 1515286923
      \ 1183848441\ 1471733602\), 
    \(\ 822001826\ 3211090506\ 1684107232\ \ 826860288\ 4287494946\ 2587304775
      \ 1973698369\ 2661448142\), 
    \(3273593767\ \ 434346588\ 2430846408\ \ 839476158\ 2162226841\ \ 
      242713675\ \ 287968385\ 3435685030\), 
    \(2277729094\ 1977520643\ \ 258808402\ \ 286198505\ 1054813884\ 1300778749
      \ 1380391695\ 3305843242\), 
    \(4146790841\ 1831202723\ 1973417180\ 1118783839\ 3220478268\ \ 131439207
      \ 1032786939\ 1435060697\), 
    \(3387608754\ 3637254733\ 2067925435\ \ \ 43167846\ 3085949699\ 2888322325
      \ 2639457248\ 2942271638\), 
    \(2928208619\ 1741304869\ \ 575072396\ 2553013017\ 2834952882\ 2976727693
      \ \ 704422963\ 2377144042\), 
    \(4096703883\ 1286628805\ 3462218376\ 2652345343\ \ 210987538\ 2258133863
      \ 2384617867\ 1201007877\), 
    \(3700045439\ \ \ 14132968\ 2383963429\ 3241193156\ 3026078638\ 3727795936
      \ \ 958169636\ 2206851982\), 
    \(\ 426724023\ 2758116511\ 3090119814\ 2338351103\ 1716071508\ 3440018032
      \ \ 196640889\ 4101820031\), 
    \(1513118236\ 3283931141\ 1265951204\ 1204805370\ 3571617187\ 3539415436\ 
      1495413267\ \ 753376531\), 
    \(\ 985924178\ 1337418517\ 3662788186\ \ 124408835\ 2688688206\ \ 
      753167933\ 3390506347\ 1890265045\), 
    \(\ 745690159\ 2464024647\ 2137309820\ 2703215649\ 4059692249\ 1446654949
      \ 2128041222\ 2386989196\), 
    \(\ 490260118\ 1911228264\ 3501652211\ 3008114170\ 3610875197\ 1878696456
      \ 2851147012\ 1795989434\), 
    \(\ \ 45182628\ 1073041158\ 4277204979\ 3883706938\ 3781890469\ 3122961295
      \ 1900602271\ 3767611229\), 
    \(1047814029\ 1108765788\ 1295075135\ 2876104587\ \ 453769977\ 1363637132
      \ \ 340490706\ \ 380054271\), 
    \(4063325099\ 2193139762\ 1948555715\ 1944060000\ 4068418602\ \ \ 77274101
      \ 4276957578\ 2054732388\), 
    \(1277557057\ 4216960884\ \ 695175945\ 3638917829\ 2240466789\ 1838405917
      \ 3612395172\ \ 613255218\), 
    \(1647658164\ 1486771452\ 3065839806\ 2768255337\ 1656655967\ 2293407272
      \ \ 758179798\ 2792477244\), 
    \(3169735750\ 3681560005\ 1326532690\ 1237346516\ 3694237120\ 1036892299
      \ \ \ 99742212\ \ 497676500\), 
    \(1306079136\ \ \ \ 6513339\ \ 297860936\ 3805490563\ 2824950789\ 
      2563106315\ 1362763169\ 1045649759\), 
    \(3856138297\ 3745208743\ 3698562812\ 1002302674\ 3178277846\ \ 967525250
      \ 2844128187\ \ 872127609\), 
    \(3984448520\ 4196642108\ 3722031350\ 2631797233\ 3222228509\ 2740514802\ 
      2220991426\ 4051105029\), 
    \(4292553639\ 3341285490\ 1033771435\ \ 526992905\ 3675503562\ 1632563342
      \ 3723610068\ 2060493568\), 
    \(1439128823\ 1789169452\ \ \ 54046209\ 2503951698\ 3304351176\ 2307682227
      \ 3771996299\ 3716987299\), 
    \(3625720393\ 1028282853\ 1404405135\ \ 933683436\ \ 444588264\ 3872466849
      \ 1219960042\ \ 983965914\), 
    \(\ 768882467\ 3181660676\ \ 941133605\ \ 596575383\ 2433616257\ 
      3410208433\ \ 496462955\ 1313399224\), 
    \(3057060473\ \ 829185453\ 2762148580\ 3007987830\ 3807261003\ 2017393325
      \ 1539589517\ \ \ 19548711\), 
    \(1300321227\ 3265236701\ 2412824041\ 3901753098\ 1243084831\ 1686076024\ 
      2038238891\ 2395437321\), 
    \(1625845935\ \ 262771999\ \ 636342803\ 1933454126\ 2265592282\ \ 
      338339818\ \ 678161365\ \ 192057651\), 
    \(1646512226\ \ 820386433\ 1472672037\ 4263255603\ 1415483372\ \ 119623975
      \ \ 691499043\ 1563140801\), 
    \(3672367167\ 1843141456\ 2026099178\ 1536376846\ 3652799702\ 2396710131
      \ \ \ \ 6574339\ 2124996685\), 
    \(2204720897\ \ 200111273\ 3734849202\ 4280308885\ 2257429794\ 2566722075
      \ 2196791476\ \ \ 49565484\), 
    \(3181445502\ 1435105177\ 4103065164\ \ 785919068\ \ 238322702\ \ 
      313138214\ 1425731385\ 4025428261\), 
    \(3640864588\ 2976818303\ \ 754576393\ 4140219817\ 1618045758\ 3585332246
      \ 2418021551\ \ 498625034\), 
    \(2283860369\ \ 345016500\ 1454567168\ \ 917550983\ 4228306690\ 2829849655
      \ 1917756024\ \ 684022947\), 
    \(1822289597\ 2976729879\ 1047453884\ 2736883230\ 2706095638\ 2588321259\ 
      1507829508\ 2161933318\), 
    \(\ 642846687\ \ 778348924\ \ 260137047\ 1171565719\ 3838094400\ 
      3727686183\ 4254844015\ 1290595570\), 
    \(\ 168743141\ 3388301447\ 2704131573\ 3751785268\ 3527484008\ 2146602704
      \ 3303495063\ 2987546000\), 
    \(3486649742\ 1266575722\ 3610166723\ 2095458690\ 2223011419\ 1885775160\ 
      3961341503\ 2200758638\), 
    \(2163937180\ 1652220293\ \ 308244034\ 4089676301\ 3900734069\ 2417928915
      \ 4142178415\ 1171108451\), 
    \(2183768376\ 1835838557\ 2373674828\ 4252814212\ 3681240628\ 2780111640
      \ \ \ 97826767\ 2806762755\), 
    \(1821649856\ \ 922673152\ 1633547920\ \ 136018660\ \ 454924577\ 
      2085437405\ \ 651386109\ 3987197430\), 
    \(4142471079\ \ \ 82913023\ \ 193739614\ 3274424597\ \ 903926982\ 
      1865522971\ 1068465001\ \ 625984166\), 
    \(2944528309\ 4012857359\ \ 423674166\ \ 434683518\ 3172431870\ \ 
      627889360\ 1250356937\ 4192810410\), 
    \(1459784551\ \ 915147718\ 3329426603\ 2141418066\ 1957714481\ 4276364720
      \ 3296031870\ \ 584308081\), 
    \(\ 443010456\ 4232071220\ 1040697004\ \ 765966571\ \ 902249266\ \ 
      828768051\ 2536743444\ \ 421656039\), 
    \(1112949775\ 3103598987\ 2148939973\ \ 640814673\ 3995188925\ 2307960395
      \ \ 225535034\ 3111985250\), 
    \(2719499858\ 3445763085\ \ 790219713\ \ 836159748\ 3164631548\ \ 
      416385156\ 2965785905\ 3502394082\), 
    \(1857133332\ 4041907448\ 2599536927\ \ 645734976\ \ 668913412\ 2499706824
      \ \ 633398922\ \ \ 34915412\), 
    \(1625379774\ 1172036309\ 3803564923\ 1965242177\ 2854486649\ 2051020153\ 
      1945866329\ 3442415527\), 
    \(4093282853\ 3687729234\ 4161176959\ 1084173645\ 2763502340\ 2350460680
      \ \ 569399339\ 3397632404\), 
    \(2730556623\ \ 809981810\ 4105953691\ 2998657900\ 2355217121\ 3890155020
      \ \ \ 23187433\ 1890937032\), 
    \(3906271592\ 1262651152\ 3033799024\ 1006017878\ 1772238667\ 3519816054\ 
      4093547383\ 1270015709\), 
    \(\ 330254616\ 3223757387\ 3571740105\ 2418254491\ 4255831045\ \ 508454395
      \ \ 739159139\ 3772231242\), 
    \(2493863929\ 2889911935\ 1993246817\ 3975845605\ 2843238431\ 1995138702\ 
      2683960391\ \ 377207802\), 
    \(1059212611\ 3206459317\ \ 758624094\ 3505802726\ \ \ 12254066\ \ 
      172970475\ \ 354779956\ \ 832116287\), 
    \(\ 296487497\ 4010971811\ \ 303903575\ 2805208543\ 3392319383\ 3459933922
      \ \ 793014865\ 2095027131\), 
    \(1497219924\ 3779371445\ \ 740433874\ \ 406889291\ \ 894055457\ \ 
      826760802\ \ 905175004\ 2345651676\), 
    \(2310772333\ 2914720710\ 2688080778\ 3998581179\ 2549676067\ 3018652396\ 
      1675404836\ \ 572363224\), 
    \(\ 313127938\ 3770121663\ 1365283105\ \ \ 89731463\ \ 297690098\ 
      2778732575\ 1814674003\ 2156989035\), 
    \(1786576889\ \ 560512542\ \ 787860054\ 4117049010\ 3542846902\ 3230463589
      \ 1023338042\ \ 825319162\), 
    \(2774921118\ 1440267207\ 3537311622\ \ 916937931\ 4033713089\ 2350811462
      \ \ 924108726\ \ \ 18051749\), 
    \(\ \ 30703652\ 3290617348\ 2870475397\ 2842436464\ 3163208986\ 2476520997
      \ 1809275602\ 2524719521\), 
    \(2891960492\ 2498618398\ 1392077105\ 2964598501\ 2997731908\ \ 738188742
      \ 1948973227\ 2503392060\), 
    \(3030278857\ 3357591575\ 2791917270\ 4092563845\ \ 274709756\ 4043862238
      \ 3118065188\ \ 185579925\), 
    \(3471507164\ 1284685629\ \ 444316646\ \ 788793404\ 1514919371\ \ 
      286133848\ \ 433280089\ 2709226759\), 
    \(3628954644\ 1318635655\ 4293746048\ 3317978368\ 2618332866\ \ 534456019
      \ 3305888767\ 4203193954\), 
    \(1303419846\ 4264547942\ 2739457213\ 2197167739\ \ 740109233\ \ 635358103
      \ 1994346178\ 3558913681\), 
    \(2542050735\ 3972876441\ 2358291528\ 3102736983\ 1978179005\ \ 859556724
      \ \ 432989198\ 3867768606\), 
    \(\ 750743169\ 2370798860\ 3213687308\ \ \ 29462305\ 2393153845\ \ 
      544295128\ 3230286705\ 3857978989\), 
    \(3049359442\ 2004280520\ 2887556817\ \ 829725978\ 1699766469\ 1476966712
      \ 1263332849\ 3723395224\), 
    \(4118456830\ 3596947307\ 3704187726\ 2746693854\ 1415194852\ \ 586462490
      \ 1160208855\ \ 291944657\), 
    \(\ 866926396\ 1689648433\ 3719077339\ 1775370314\ 1318669139\ 1895018465
      \ 2368669723\ 1217319811\), 
    \(3590364002\ 1876736036\ 2823517310\ 1693591510\ \ 104916918\ \ \ 
      72887927\ 3446534178\ 3916718786\), 
    \(3087765889\ 1176745556\ \ 150947686\ \ 107646470\ 3312712669\ \ 
      530026737\ 1317031538\ 1123042565\), 
    \(1507513870\ 4188790614\ 3003778816\ 3465724284\ 3336450151\ 2091310641\ 
      2427169910\ 1811378243\), 
    \(3106855466\ 2450772608\ \ 358486176\ 2575296662\ 2480450680\ 2592269982
      \ 2555094492\ 3826839762\), 
    \(1405191188\ 2056710151\ \ 596608727\ 4129531244\ 3734520485\ 2800463618
      \ \ 350081694\ 3535364259\), 
    \(\ 585575984\ 2703609831\ \ 676053809\ 3863184487\ 3694848443\ \ 
      886309880\ \ 741264271\ \ 391299439\), 
    \(1399551005\ 1700021468\ 3884496034\ 2006994777\ 3607209664\ 2244784923\ 
      1179506686\ 1379316830\), 
    \(1335526231\ 3251273241\ 3699909076\ \ 844696623\ 3607413394\ \ 839015803
      \ 2549847180\ \ 945307551\), 
    \(1949205071\ \ 753609704\ \ 337658748\ 1732594641\ 4103559050\ 1111706209
      \ 3607130091\ 1202832679\), 
    \(1588961749\ 1512225824\ \ \ 87363961\ \ 271979520\ 3276963734\ 
      3527902170\ \ 607488388\ 3237412448\), 
    \(1117332605\ \ 379972084\ 3552696078\ 1836558954\ 2172609096\ 3416488373
      \ \ 209513209\ 3739947440\), 
    \(1088627428\ \ 990418257\ \ 349922189\ 1470459396\ 3260805093\ 2526915661
      \ \ 959248190\ \ 148269468\), 
    \(1029950311\ 3442143079\ 4248511256\ 4234479007\ \ \ 58818195\ 1955730979
      \ 2918247781\ 4074618969\), 
    \(\ 266625151\ 2774146885\ 4205839259\ \ 943357178\ 3378886609\ 2320988072
      \ 1272826731\ 2952021034\), 
    \(1993091044\ \ 599909970\ 2886444237\ \ \ 73507418\ 1234380290\ \ 
      760537341\ \ \ \ \ 847630\ 3347895397\), 
    \(1766835522\ \ 485885685\ 3903045578\ 3448931772\ 4177909559\ 2410298629
      \ \ \ \ 4599050\ 1513113312\), 
    \(4221587942\ 1689145531\ 1747405833\ \ \ 53705262\ \ 620624894\ 
      3035364437\ 1330137287\ \ 656662897\), 
    \(1411110593\ \ 631390004\ \ \ 17354082\ 3884018231\ 1959967403\ 
      1750830183\ 3286178106\ \ 820341765\), 
    \(3806854902\ 3031428097\ 3533447586\ 2368056863\ \ 532161597\ 4104652679
      \ 3629495832\ 3941272058\), 
    \(1910829139\ \ 189519243\ \ 970590999\ 1890378675\ 2545450181\ 2205987164
      \ 2789241863\ \ 984471970\), 
    \(\ 905071884\ \ 996799447\ 1289959550\ 3107633788\ 2698868808\ 2612346482
      \ 4232736363\ 2497525935\), 
    \(2681202266\ 3014917203\ \ 220343424\ 4148024794\ 2385013160\ 1708570394
      \ 2122330514\ 3350009284\), 
    \(\ 976953008\ 1521834488\ 2004044075\ 2286668414\ 2861470200\ 3809127151
      \ \ 281916183\ 1510164700\), 
    \(3268275011\ 2474158455\ \ \ 99577235\ 4080592662\ 1384467200\ 2804654750
      \ \ 457841683\ \ 228063750\), 
    \(3120167730\ 1818948892\ \ 239800424\ 3417607741\ 3786704207\ \ 747593566
      \ 3457221868\ \ 627581766\), 
    \(2204490561\ 1654518495\ \ 966360572\ 2853319497\ 2455128566\ 3517985118
      \ 3593599918\ 1086222004\), 
    \(3074099922\ 3856007742\ 2762533028\ 3484086227\ 2720715068\ 1423900534\ 
      1891275068\ 2633704518\), 
    \(1320447861\ 2344157810\ 2899633030\ 1855082034\ 3212524906\ 3268146012\ 
      1735762383\ 1994104674\), 
    \(1355943577\ \ 318595675\ 3454515872\ 1392698237\ 2119655878\ 2508434134
      \ 3854276905\ 3349455206\), 
    \(2233118550\ 3092215179\ 3323951031\ 1958680398\ 3878835161\ 2012979824\ 
      2351117969\ \ 780670701\), 
    \(3158763318\ 1073832881\ 3665238293\ 3787037806\ \ 691146148\ 2216607216
      \ 3819658820\ 4143691593\), 
    \(3445113413\ 2686012841\ 2279132543\ 3095798926\ \ 517117470\ \ 634398440
      \ 1587111125\ 2517135584\), 
    \(3866153684\ 1246306840\ 3848113902\ 2941742896\ 1251311272\ 3303454732\ 
      3471973631\ 1866567016\), 
    \(2505311199\ 4174254673\ 3489462558\ \ \ 65367815\ 2225693439\ 3990751312
      \ 3844328985\ \ 644205753\), 
    \(\ 740045798\ \ 188141672\ 1286832987\ 3557622121\ \ 541377473\ 
      1608091225\ 3763774448\ 1352913814\), 
    \(\ 682469086\ 1234421535\ \ 826313464\ 1543057347\ 2591277616\ \ 
      586168222\ 3317093908\ 2027648159\), 
    \(3351098940\ 3484979617\ 1433486920\ \ \ 94887888\ 1039347367\ 2699721387
      \ \ 125668326\ 3878127446\), 
    \(\ 420030633\ 3162259755\ 4045872984\ 2373308424\ 2813497109\ 3610418419
      \ \ 789327611\ 3396208164\), 
    \(\ 191490764\ 2020588718\ 1684785703\ 1874959416\ 2859259193\ \ 228846577
      \ 4294893654\ \ 752333763\), 
    \(\ \ 82145776\ \ 245232121\ 2858492379\ \ 235226011\ \ 212736994\ 
      1791541608\ 3075260034\ 1027589779\), 
    \(1768428135\ 1476711478\ \ 807264634\ 1313384963\ \ 593677689\ 3546529704
      \ 2222253162\ 2972143421\), 
    \(\ \ 37511113\ 1745788345\ 4227623691\ 2747548306\ 2094052287\ 2043366178
      \ 3881152626\ 1658133163\), 
    \(\ 599042739\ 3351903285\ \ \ \ 2005121\ 2679773248\ 3172990851\ 
      1280309242\ 1847530073\ \ 190334083\), 
    \(3750559064\ 3328869973\ 3372216332\ 2336176749\ 1753730790\ 3915210687\ 
      3214682656\ 2036163190\), 
    \(2523178202\ \ 284734049\ 1633230712\ 3257262522\ \ 338862965\ 3426099860
      \ 3741797550\ \ 455041246\), 
    \(3811903278\ 1107645022\ 1849592035\ 3058625089\ 1369453369\ 2666801360
      \ \ 667793454\ 3410228514\), 
    \(2663806823\ 3662880959\ \ \ 35238938\ 2467754234\ \ 300243799\ 
      1735364601\ 2755142313\ 2576072174\), 
    \(1220393348\ 1626276624\ \ 300473732\ 3075218758\ 3210855134\ 2002063512
      \ \ 401485554\ 3879146350\), 
    \(1695276591\ 3792782491\ 1298274552\ 2993666128\ 2714389533\ 3775019336\ 
      3730740288\ 3835960123\), 
    \(4083394823\ 2193096880\ \ 852994860\ 2492648230\ \ 490076625\ 4175816389
      \ 2581713452\ 1592670400\), 
    \(3619544440\ \ \ 90685280\ \ 975539641\ 4072060450\ 1546669408\ \ 
      411245662\ 1986268792\ 4153784958\), 
    \(\ 209404652\ 1027425057\ 1486079244\ 3634268120\ 1932956885\ \ 630161225
      \ 2132474245\ \ 314962319\), 
    \(\ 966958332\ 3692275544\ 2658670556\ 2202369153\ 3359046993\ 2861050896
      \ \ 893544953\ 1140287277\), 
    \(\ 369282465\ 1825529437\ \ 333262285\ 1034258249\ 2768061767\ 3883374682
      \ \ \ 26256632\ \ 939449915\), 
    \(1907043798\ 3071493311\ 1624010112\ 2465328792\ \ 106234312\ \ 650034415
      \ 2948043496\ 3610554287\), 
    \(\ 406947634\ 3766442270\ \ 701357388\ \ 665226690\ 4252139828\ 
      3813848635\ 1418309240\ 2237834930\), 
    \(3622983277\ \ 746211972\ \ 370526154\ 1993297255\ 2811305867\ 4161432428
      \ 3628801435\ \ 563533208\), 
    \(3222391547\ 2480087214\ 2786427859\ 4005980421\ 1069487715\ \ 656038424
      \ 1319570133\ 1383803119\), 
    \(1428788589\ \ 381480032\ 2586325375\ \ \ 30559722\ 2002386556\ 
      1409584452\ 3138187723\ 1703445596\), 
    \(4102523094\ 2807412791\ \ 589852012\ 1769252329\ 3897921907\ 1498392139
      \ 1794431406\ 4086207398\), 
    \(2003644282\ 3334054626\ 3618386473\ 1823686994\ 4246204671\ 3572369470\ 
      1594140701\ 2272712483\), 
    \(4131360882\ 2392979147\ 2063727660\ 3053175055\ 3297493727\ 2460585260
      \ \ 180885532\ 4082548811\), 
    \(1616051277\ \ 794939498\ 1853316870\ 1742857702\ \ 835619509\ 1502910882
      \ 3850170336\ 3018390104\), 
    \(3178723855\ 4161178917\ 1019464921\ 3033215971\ \ 385568368\ 2771693857
      \ 1947544271\ 3685546760\), 
    \(3313735804\ 3469518565\ 1341243561\ 1661509128\ 4256377965\ 1018175690\ 
      1616294731\ 2639537073\), 
    \(\ 817696001\ \ \ \ 1725530\ 2201290870\ 3706773748\ 1415287977\ \ 
      221785150\ 3905287173\ 1897254652\), 
    \(3909510745\ 4157244920\ 1332703682\ 4087264634\ 1723196897\ 3360051415\ 
      3237694272\ 1529223353\), 
    \(2752092507\ \ 846502131\ 2802772158\ 1154286484\ 3510190744\ 3004931899
      \ 3176277967\ \ \ 84766659\), 
    \(3322229343\ 2676415568\ 1038035192\ 2506427422\ 3432632619\ 3168189925\ 
      1897817991\ 1132802451\), 
    \(1291156643\ 2835510427\ 3852219905\ 1368363742\ 3273166816\ 4162123264\ 
      1361540934\ 3065797031\), 
    \(2614708851\ 2849892050\ \ 589461856\ 1465336896\ 2155783540\ \ 236885535
      \ 3412543391\ 3425884605\), 
    \(\ 946992608\ 1708908220\ 1309773264\ 1738592212\ 1321457405\ \ 978009097
      \ \ 329620658\ 3545263181\), 
    \(3950604513\ 3831435306\ 4119274234\ 4275688850\ 3103174948\ 1207869326\ 
      1363655984\ 1877615619\), 
    \(4047716551\ \ \ 57672020\ \ 176652536\ 2951052473\ 2765828007\ 
      2667346558\ 2091201180\ 3120276762\), 
    \(2688155494\ \ 840282508\ 4047506951\ 3435240986\ 2724578280\ 3688379744
      \ 2989181925\ 3693293110\), 
    \(2950295334\ 3893711895\ \ \ 64501173\ 2384600675\ 1227267012\ \ 
      639786252\ 3932114302\ 3366730737\), 
    \(3364150689\ 3076865454\ 1481743839\ 4269552611\ 1690319522\ 1472876739\ 
      1415660921\ 3656509071\), 
    \(3486756365\ 4114553017\ 3342481560\ 2202344826\ 1239512328\ 2627058336\ 
      4149497236\ 1716819743\), 
    \(1275702621\ \ 868781292\ \ 723757197\ \ 563539089\ \ 247981038\ 
      1664626427\ \ 513057776\ 1699081318\), 
    \(3479405647\ 2909491349\ 3148719547\ 3968262104\ 3807979773\ 2288514487\ 
      1867986809\ \ 431323634\), 
    \(2379773506\ \ 904841574\ 1708306992\ \ 116091421\ 2361856990\ \ 
      234677952\ 1232479616\ 4217034537\), 
    \(1715394977\ \ 317342102\ \ 232996278\ 2824190993\ 2107068226\ 1944032421
      \ 3891031163\ 4155927495\), 
    \(1067754117\ \ 217954096\ 1282789290\ 2115182050\ 2893425772\ 3342657913
      \ 1942586273\ 1836559512\), 
    \(\ 683297230\ \ \ 37338296\ 2728017363\ 2268251185\ 2227754618\ 
      1791884963\ 2771214162\ \ 372558769\), 
    \(1850625856\ 4173697632\ 2364949268\ \ 245058127\ \ 567108172\ 1498338907
      \ 1441580436\ 4161171095\), 
    \(2774783097\ 1679459622\ \ 722685855\ 1423164997\ \ 621836029\ 1385523131
      \ \ 850328664\ 2994107480\), 
    \(1603380245\ 1501086005\ 3815760463\ \ 774154464\ \ 156172958\ 4238721953
      \ 3020489116\ 3856072108\), 
    \(2838353438\ 4083999053\ \ 735796702\ 2028221193\ 3159583944\ \ 313958415
      \ \ 269070808\ \ \ 12355621\), 
    \(3154924792\ \ \ 94021856\ 3991690705\ \ 102216448\ 2422504060\ 
      2367803112\ \ 472898317\ 3924108382\), 
    \(\ 247393388\ 1067939877\ \ 455571758\ 1058582856\ 2699654124\ 1939285159
      \ 2443983126\ 1380332484\), 
    \(1801890779\ \ 375271328\ 1110464914\ 3742188448\ 2103588451\ 3064823872
      \ 1072093149\ 1446855494\), 
    \(\ 423730436\ 3304496190\ 2251842779\ \ \ 35041433\ 1531411956\ 
      2359525107\ 1515120158\ 3147755790\), 
    \(2761786675\ \ 446764251\ 2926448516\ 4183493303\ \ 488812989\ \ \ 
      90472896\ 1282507323\ 4090457868\), 
    \(\ 825012887\ 3509836685\ 4183762175\ 3974323208\ 2383917494\ 2173509941
      \ \ 607585820\ 2025618205\), 
    \(\ 864830499\ 1077022181\ 2816694638\ \ 182179442\ 3815114102\ \ \ 
      86418649\ 3326327084\ 1637739939\), 
    \(4028493455\ \ 478552824\ 2233905636\ 1217886107\ 1393262837\ \ \ 
      30816333\ 1753336884\ \ 684631768\), 
    \(\ 703716602\ 2094408433\ 2633256746\ 1653038156\ 2485720031\ \ 779849000
      \ \ 977620064\ 4181706736\), 
    \(4270470706\ 1244000472\ 1322125910\ 2145082910\ 2983414994\ 2080107170\ 
      3070989570\ 1818354068\), 
    \(3904069946\ \ 514167481\ 3430110867\ 1047027825\ 2548578233\ 4213427958
      \ 1841954672\ 2856104067\), 
    \(2399865782\ \ \ \ 3136366\ \ 530596605\ 1575054524\ 2046614710\ 
      2342832656\ 1987608686\ \ 634988374\), 
    \(2268808979\ 1086077310\ 1770094983\ 1839536626\ \ 833475129\ \ 368786729
      \ 3502587767\ 3333587135\), 
    \(3374756798\ 2012096171\ 1233473970\ 1109095246\ 4121551260\ 2995715363\ 
      3715041991\ 3398171845\), 
    \(2901279204\ \ 977277449\ \ 477207405\ 4153125914\ 4113260728\ \ 
      245673221\ 3385415756\ 4040508404\), 
    \(1515720066\ 2533511173\ 2711200223\ 1311257048\ 2818794465\ 2542755994
      \ \ 751160206\ 3528909876\), 
    \(\ 695643428\ 4163880058\ 2810186341\ 2642902765\ 3833808315\ 1764063008
      \ 2391032208\ 2395890731\), 
    \(3207888584\ \ 328929871\ 3889715597\ 1332467838\ 1196268773\ \ \ 
      32332284\ \ 302914611\ \ 237244259\), 
    \(\ 784702212\ \ 692722976\ 2416485354\ 2453145929\ 1980564752\ 2598027856
      \ 3054172739\ 4256824281\), 
    \(\ 477951384\ 3669309620\ \ 745024217\ 4073470290\ 1319647929\ 2177969438
      \ \ 206662655\ 3629479999\), 
    \(2500469414\ 2805800654\ 2125732944\ 2677630256\ \ 503559500\ 3798185864
      \ 2769764644\ 1273857370\), 
    \(2877383254\ 2559555968\ 3290815038\ 1379250344\ 1359510758\ 1030832379\ 
      1861590982\ 3800234263\), 
    \(2081863381\ 2625869243\ \ 548743802\ 3562586344\ 1954555632\ 3969352290
      \ 3071592204\ 2775303016\), 
    \(\ 941896010\ 2847165586\ 4149330847\ 3123737580\ \ 173500290\ 1649778230
      \ \ 608763566\ 3936953174\), 
    \(2896613449\ 3414015747\ 4268898926\ 3891456016\ 1914366173\ 3232322875\ 
      2423196107\ 1959315929\), 
    \(2141139767\ 4232325930\ \ 887066965\ 4036938725\ 2117325551\ 2147543466
      \ \ 474568736\ 1107186066\), 
    \(3804329195\ \ 927272829\ 2061750569\ 2499824115\ \ 131129242\ \ 
      501080253\ \ 523410363\ \ 962102757\), 
    \(4081416447\ 2973634041\ \ 893004834\ 3711762405\ 4177016841\ \ 978142352
      \ 2164525795\ 3581085542\), 
    \(\ 381700346\ \ 882319548\ 2186804317\ 1113802303\ 2812259990\ 4036910973
      \ \ \ 80522227\ 1323040858\), 
    \(1402193618\ \ 345918372\ \ 351907731\ 3789332966\ 2160053864\ \ 
      889110874\ 1361199411\ \ 695650755\), 
    \(2045364587\ 2180836903\ 3357262904\ 1803117201\ \ 706157658\ 2125976733
      \ 2081483617\ \ 411009850\), 
    \(\ 898276012\ 4031162129\ 3830845910\ 2503824830\ 4047627386\ \ 447592803
      \ 3051978501\ 4073598084\), 
    \(3081963613\ \ 856227030\ 3175060270\ 2906494364\ 2459890843\ 3510652295
      \ 1999308187\ 2146225314\), 
    \(\ 472294803\ 1270815584\ 3734894109\ 3808863309\ \ 347429218\ 4199558126
      \ \ 755983770\ 2926311247\), 
    \(2362068395\ 1484771152\ 1024715856\ \ 844535265\ 1529197484\ 4090614327
      \ 1687166305\ \ 173323982\), 
    \(3748344179\ 2139442393\ 2384376080\ \ 626080868\ 2062130534\ 1650949362
      \ 2811766495\ 3804886342\), 
    \(\ \ 46897614\ \ 321809509\ 3508495020\ 3359004496\ 3200478418\ 
      2656680199\ 2279876073\ \ 350427398\), 
    \(1148550369\ \ 610205500\ \ 991955760\ 2144821693\ \ 836268104\ \ 
      541320294\ 3724893297\ 1380166097\), 
    \(4000141520\ 1242706649\ 3478153668\ 1345263329\ 2118340857\ 1126093950
      \ \ 815650377\ 3853413403\), 
    \(\ 333736379\ 2930073676\ 4175525730\ 3451134118\ 3402607387\ 1001122393
      \ \ 726631636\ 3286587919\), 
    \(1513573399\ 2406415314\ 3897827647\ 4205662947\ \ 134624747\ 2294770644
      \ 2953982798\ 3315757670\), 
    \(\ 135955386\ 1045784342\ 4170507085\ 1925635416\ 3547827509\ 1704982126
      \ \ 342731567\ \ 867037077\), 
    \(3350895173\ 3576211005\ 3019487652\ \ 247594499\ 1940869416\ \ 546855813
      \ 2959479809\ 3363393133\), 
    \(\ 586682653\ 3514732564\ 3747175745\ 4010985550\ \ 886203835\ \ 
      777576826\ \ 379889206\ 1590260691\), 
    \(\ 407647019\ \ 219484566\ 3179603220\ 4008057555\ 3720587698\ \ 
      115231396\ \ 258822379\ \ 872029841\), 
    \(1629760670\ 4023419204\ \ 113899469\ 1047825003\ 1183873372\ \ \ 
      22726940\ 3730110467\ 1004382880\), 
    \(3628033420\ 2213897519\ \ 986200126\ 2053514165\ \ 864564022\ 1991935550
      \ 1034520289\ 2009897772\), 
    \(3728561559\ \ 370485282\ 1165938769\ 4178071857\ \ 953651433\ 1534198948
      \ 4178087906\ 1298335936\), 
    \(\ 537237555\ 2105483327\ 3439794093\ 3780202075\ 1020323080\ 1984589362
      \ 2482354469\ \ 110961535\), 
    \(\ 940160771\ 1558396533\ 1525799444\ \ 393522457\ 1616820386\ 1100762641
      \ 2491956607\ 4119920195\), 
    \(1193998565\ 3002655224\ \ 907564056\ 2716119436\ 3919747116\ 2342564360
      \ 4174441927\ \ 945995282\), 
    \(2609258469\ 3505525437\ 2885261225\ 2676755504\ 3960761023\ 3251013372\ 
      4119918992\ \ \ 90006986\), 
    \(2647164180\ \ 983505884\ 3266092551\ \ \ 83001342\ 2579790131\ 
      3684242412\ \ 132582375\ 2643921388\), 
    \(3640490969\ 1356492768\ 4265189261\ \ \ 33014428\ 4056992018\ 1672563053
      \ \ 769432238\ 1456894737\), 
    \(\ 215721261\ 2098132357\ 2975102855\ 3288836514\ 2522520076\ 1049518012
      \ 4091844758\ 2939729084\), 
    \(\ 992584400\ 4201767091\ 2532283079\ 4271904831\ 1248822142\ 1187013292
      \ \ 634293158\ 2404594554\), 
    \(\ 701262102\ 2115084280\ 1051957074\ \ 559592792\ \ 148572414\ 
      2050767660\ 3305343892\ \ 618751122\), 
    \(2095357784\ \ 547826896\ 1948814124\ 2802928257\ 1253534323\ 3119333571
      \ 3355625977\ 3528866467\), 
    \(\ 533139088\ 1763341858\ 2748150042\ 2238483435\ 1496761330\ 4237539139
      \ 1024445184\ 1700376433\), 
    \(2625695944\ 1804860120\ 4272473285\ 2874951580\ 3479302046\ 3849689715\ 
      4001416474\ 1816450618\), 
    \(2893981664\ 3862550062\ 2900747782\ 1087471288\ 1855301067\ 1932053063\ 
      3472511186\ 3617602935\), 
    \(1179805132\ \ 554314280\ 1053501677\ 2236886959\ 2180794642\ \ 162790453
      \ \ 560136004\ 1306874207\), 
    \(2023226057\ 2999166777\ \ 268917335\ 3481172407\ 1028840116\ 2477469379
      \ \ 605732267\ \ 500650016\), 
    \(1677599712\ 2902022137\ 4205404557\ 4110791566\ \ 762684274\ 2282575754
      \ 3383944323\ 3591739676\), 
    \(1832879599\ \ 415504428\ 1027147236\ 3280223437\ 3705978071\ \ 362751846
      \ 1423371363\ 3110552732\), 
    \(2110527374\ \ 202906824\ 2716482100\ 2410441610\ 2615790797\ \ \ 
      64009392\ \ 220484573\ \ 593155917\), 
    \(1769285813\ 3085217044\ 2895479099\ 2525189856\ 2024736530\ 3364551957
      \ \ 722751274\ 2932547868\), 
    \(2759531139\ 4047260661\ 1667007710\ 3475436212\ 3564976713\ 1417747644
      \ \ 495613401\ 3038337369\), 
    \(\ 679384910\ 2947181640\ 1418548795\ 2472006726\ \ \ 55200007\ 
      3699956450\ 3476935712\ 3310573844\), 
    \(\ 894570262\ \ 441089411\ \ 518718577\ \ 604032452\ \ 198967660\ 
      2499059220\ \ 412604190\ 4159298309\), 
    \(3434494553\ 3989655078\ 2685059962\ \ 136962773\ 3585418555\ \ 926249942
      \ 1271759417\ 2558174469\), 
    \(4175105097\ \ 645518354\ 1701590073\ \ 164023953\ \ 983819411\ 
      2825605232\ 2416189490\ 3064793344\), 
    \(4271786466\ \ 895531279\ \ 593304853\ 2744169700\ 3578359053\ 1648206885
      \ \ 542677883\ \ \ 68398600\), 
    \(3736168493\ 2009930579\ \ 428596554\ 1283912589\ 2340988083\ \ 773349531
      \ 1636351077\ \ 835690930\), 
    \(1961294260\ 1714309353\ 2122738981\ 4221879377\ \ 981808086\ 2995773386
      \ 2806737253\ 1221803543\), 
    \(1872390176\ 1657395299\ \ 716594031\ 1481821814\ 2369014015\ 1288999878
      \ 2729202538\ 3733227495\), 
    \(\ 362745206\ 4195323112\ 4257171445\ 4187341459\ 1146750073\ 4151035098
      \ 2806221610\ 2892497077\), 
    \(2681845580\ 4165837871\ 1032003806\ 4012479773\ 3456359782\ 1707327920\ 
      2876518664\ 3080392901\), 
    \(3179841604\ \ 975808252\ \ 119960494\ 3699886978\ \ 388175526\ 
      3382617274\ 2806270216\ 1624469558\), 
    \(3077797282\ 4273081398\ 2245065925\ \ 145343766\ 1787879685\ 2817595594
      \ 2143658781\ 4016783953\), 
    \(1507874547\ 2152657567\ 3509044426\ 3766086584\ 2592037217\ 1338552336\ 
      4025852128\ \ 188383123\), 
    \(2838659047\ \ 349864534\ 4256584599\ 3661962139\ 3862425527\ 2557571470
      \ \ 418968527\ \ 484379645\), 
    \(3677594542\ 1077391979\ 4272197300\ 2492737687\ 4112408363\ 2028961188\ 
      3845201049\ 3600870761\), 
    \(1070761423\ \ 248642545\ 1237317602\ \ 493991427\ 2785122146\ 3186720941
      \ \ \ 11061197\ 4179588145\), 
    \(\ 369737402\ 2830915326\ \ 842451474\ 1384611753\ \ 766887187\ 
      3324217830\ \ 212265295\ 1410761111\), 
    \(2478558834\ \ 457370668\ 1936134962\ \ 940371742\ 2599745366\ \ 
      538783629\ 3167125856\ 3115610520\), 
    \(\ 131118614\ \ 272014093\ \ 246578456\ 4110036266\ 1917026017\ 
      2046895960\ 1278805900\ 2740838957\), 
    \(\ 918145152\ 1316961352\ 2207033419\ 4250289288\ 1323250873\ 1020197828
      \ 1400842361\ 2409380643\), 
    \(\ 796398137\ 1978018497\ 1339582870\ 2112607339\ 1284324322\ 1798811386
      \ 3078816372\ 3746065119\), 
    \(2830519416\ \ 798826909\ 4290739425\ \ 727023617\ 4160130074\ \ 
      408755943\ 3787833284\ 2219352093\), 
    \(2876699154\ 4009971594\ 3387671311\ \ 192007765\ 2345016001\ 2380417337
      \ 2820981468\ 1951814436\), 
    \(1413604076\ 1232595622\ 2966995056\ 3821263990\ \ 358071865\ 4233943187
      \ 3339307403\ \ 902081817\), 
    \(2377308911\ 3855643046\ 3160468326\ 3751770128\ \ 742125100\ 3285130445
      \ 1019857991\ \ 416284075\), 
    \(1066753364\ 1880989236\ 1100442063\ \ 100903552\ 3728297630\ 3747106733
      \ \ \ 72143880\ 3055674431\), 
    \(1751148716\ 2941407582\ 2362256162\ 2217759581\ 1361563818\ 1283317841\ 
      1716909011\ 2825450847\), 
    \(1890688650\ 3389038238\ \ 197731180\ \ 914548631\ 3683718392\ 3239394193
      \ 3598887537\ 1500604867\), 
    \(1937442473\ \ 422608215\ 2290399243\ 2792829760\ 2725942426\ 2342202519
      \ 2747436874\ 3420872851\), 
    \(3480307605\ 2214889367\ 3893851885\ \ 789130289\ 2562485897\ 1799886575
      \ 3142984470\ 1726859592\), 
    \(1821902158\ 3848479085\ 3776577158\ 1895711624\ \ 156057577\ \ 522744934
      \ 1347249382\ 4273048323\), 
    \(3886740609\ \ 601571367\ 1596715953\ \ 695231145\ 4291075262\ 3013011504
      \ 2219642884\ 1989237758\), 
    \(3595999221\ 3702447111\ 1769246204\ 3310026123\ 3553726937\ 2448869988\ 
      3572683168\ \ 431652129\), 
    \(\ \ 77784438\ \ 496994647\ 1385828117\ 3964742247\ \ 363499050\ 
      1341029956\ \ 191903845\ 2067628126\), 
    \(3122493209\ 1820198076\ 4048257273\ 4289034449\ 3051744273\ 1114872680\ 
      3801036175\ 3510515749\), 
    \(3553010776\ 1064895376\ \ 259560818\ \ 589140905\ 1820397699\ \ 
      531631205\ 1093069523\ 1974726713\), 
    \(1050829490\ 3902702383\ 2995631830\ 2386826042\ \ 340630346\ \ 479928335
      \ 1483706886\ 2214544903\), 
    \(2663164920\ 2709325138\ \ 310902457\ 3749211137\ 3388351516\ 3460033394
      \ \ 954804625\ 2434176126\), 
    \(3875381567\ \ 386170669\ \ 943093629\ 2010857701\ 2771337613\ 3863827019
      \ 2687718342\ 3843254318\), 
    \(2000606181\ \ 318965264\ 2123267120\ 3749389414\ 3599690143\ \ 719796697
      \ 2631505553\ 2950788325\), 
    \(4100115192\ 3706897577\ 4035453538\ 2950036412\ \ \ 62994574\ 3163834842
      \ 2386601044\ 3776194418\), 
    \(3160875066\ 2080382309\ 3046628501\ \ 527002302\ 2691072649\ 1591740602
      \ 3426222703\ 3019722340\), 
    \(3361040131\ \ 584500153\ 3018203276\ 2423580532\ 2110240510\ 1537574465
      \ 3239011561\ 2140124735\), 
    \(\ 494353745\ 2085536655\ 3356218820\ 3115706377\ 3043317355\ 3857135781
      \ \ 130905107\ \ 671967260\), 
    \(1405860499\ 3896911497\ 1472186839\ \ 564229526\ 3249130326\ \ 178096264
      \ 3332362851\ 1907787779\), 
    \(2079054782\ 2100597102\ 1183639812\ \ 416597887\ \ 223225388\ 3231543265
      \ 2175718670\ 3446165712\), 
    \(1675167561\ 4147440493\ 3043612272\ 3849196724\ 1311293920\ 2883056285\ 
      3760414223\ 1308513455\), 
    \(\ 421031876\ 1510585767\ 3558603935\ 1528841760\ \ 859689048\ 1458735297
      \ 3793591640\ 2823645076\), 
    \(3829877831\ 2726089266\ \ 703323960\ 2453767075\ 1021574326\ \ 966321052
      \ 1707346610\ 1340553891\), 
    \(1978567163\ 3503105589\ 1610302695\ 4149844213\ 1088602057\ \ 134925473
      \ 2266286610\ 2308059114\), 
    \(1285149812\ \ 954813761\ 1956000020\ 1553228177\ 3844048756\ 1730556900
      \ \ 741728219\ 3465405279\), 
    \(1852222925\ 2340635626\ 3092072906\ \ 314679298\ 2160748263\ 1580997288
      \ 4186538317\ 1491509481\), 
    \(2209518325\ \ 958479147\ 2594476504\ \ 133972115\ 2661304534\ 3993301391
      \ 2256335451\ \ 372553478\), 
    \(4242040355\ 1681290385\ 2026622067\ 2322323293\ 2184351338\ \ 319294631
      \ 1437222894\ 3289213598\), 
    \(\ 593941515\ 1848755588\ 3960404589\ \ 599590353\ 2334481317\ 3922775635
      \ \ 943111039\ \ \ \ 8475151\), 
    \(2343755961\ 2639807439\ 4266689513\ 1348319504\ \ 780449840\ 1343441442
      \ 2015543431\ 3285464146\), 
    \(\ 371341348\ 1200017570\ 3824141038\ 2900792601\ \ \ 25785609\ 
      3748405320\ 3913439060\ 1365495550\), 
    \(2007338695\ 1792517324\ 3013567425\ 3380021604\ 2601889820\ 2379635221
      \ \ 138652967\ 1596423739\), 
    \(3374670104\ 1460290651\ 4258423331\ 3882023401\ 1597617542\ \ 855106927
      \ 2974117136\ 2598283418\), 
    \(2819432820\ 3343045741\ 1690075929\ 4024600028\ 2865264449\ \ 617374612
      \ 2166091472\ 2548667843\), 
    \(4062897360\ 2582182398\ 4121770303\ 2664863204\ 2576363425\ 3291103969\ 
      2873105549\ 2253256104\), 
    \(3917731342\ \ 649438839\ 3386405420\ \ \ 83334287\ 3301122949\ \ 
      900542248\ \ 222596851\ 1810546670\), 
    \(3720190956\ 3816712989\ \ 196550250\ \ 852521959\ 4237345408\ 3887597992
      \ 2251712014\ \ 562464713\), 
    \(1929042501\ 1033947813\ \ 439462645\ 1337266578\ 2759887745\ 1520008151
      \ 3145028002\ 2334471329\), 
    \(2308869629\ 2111491017\ \ 557525336\ 1250079489\ \ 528211377\ \ 
      437883882\ \ 930520667\ 1456313197\), 
    \(3586199934\ 3887884009\ \ 802112843\ 2643196138\ \ 109184865\ 3769837348
      \ 2365470934\ 4207279951\), 
    \(3106354993\ 3019588003\ \ 655870393\ 1924444854\ \ 392834771\ 1871435273
      \ \ 737749041\ 1203046249\), 
    \(2173508935\ 2673135268\ 4026295782\ 2848635636\ 4159189139\ 4089718577\ 
      1140918826\ 2700778028\), 
    \(3450637911\ 4159192811\ 2054552550\ 1096128718\ 1384365774\ 1062470190\ 
      2354023514\ 3110116192\), 
    \(\ 815459818\ \ 677774333\ 2078072895\ \ 287637217\ 1627741818\ 
      4145712519\ \ 499028587\ 1922399932\), 
    \(2339149591\ 2021023846\ 1201742738\ 2275871763\ 4179865960\ 1859507642
      \ \ 315396768\ 3637949591\), 
    \(3083298811\ 1041169806\ \ 146228786\ 4096871311\ 1351116504\ \ 385198817
      \ 1540417724\ 3845149292\), 
    \(2749011817\ 3139527691\ 2645045861\ \ 558115467\ 3681286823\ \ 570252876
      \ \ 910023587\ 3725642749\), 
    \(3690627955\ 4292126382\ 1432482732\ 3716597717\ 2287498909\ 2520392981\ 
      3294887556\ \ 809541313\), 
    \(1054672759\ 1496435400\ 1287905892\ 3256917544\ 1197674515\ 2585585733
      \ \ \ 53968273\ 4084633868\), 
    \(\ 470608700\ 1512309144\ 3102819087\ 1878656735\ 2035909841\ 1116850668
      \ 1292964844\ 1694758982\), 
    \(1188956261\ 3245765963\ 2706722361\ \ 474435470\ \ 428418512\ 2254464029
      \ 3468070736\ 1493698003\), 
    \(2042085404\ 3835536913\ 2856057155\ \ 471763241\ 2727567948\ \ 125257123
      \ 1998473205\ 3816054761\), 
    \(\ 738359027\ 3781540247\ 4191095208\ 4222007862\ 2677092920\ 2414337651
      \ \ 661853546\ 2974113512\), 
    \(\ 988665168\ 1216642945\ 2526546174\ 3886816782\ 2041886726\ 1397338053
      \ 2982132075\ 3904745552\), 
    \(1462152275\ 4114446531\ 2142965081\ 3824214930\ 2981211573\ 1218617639\ 
      3621327311\ 2864031438\), 
    \(2997313887\ \ 280698755\ 1941549721\ 1091051644\ 1714019248\ 1679574243
      \ 4113704489\ 3834259882\), 
    \(\ 659407595\ 2566275583\ 1933228989\ 2519008366\ \ 144401442\ 3539123793
      \ 1733977398\ \ 655768966\), 
    \(3509556525\ 2606157405\ 3266440712\ 2825348859\ \ 271663378\ 3329366611
      \ \ 364866034\ 2971398599\), 
    \(\ 333704786\ 1555269792\ \ \ 39509787\ 2973346833\ 2654220670\ 
      3406557475\ 3592622878\ \ 316829776\), 
    \(1920597918\ 1254145563\ 1992823676\ 1721035080\ 3307927801\ 3298475312
      \ \ 997408768\ 3894732925\), 
    \(3140498174\ 2728990924\ 1493678979\ \ 782139786\ 3132097376\ 2345420077
      \ 3085223201\ 1975573604\), 
    \(2567110847\ 4113982180\ \ 523749096\ 1338479055\ 1735030786\ 1766730452
      \ 1066080372\ 2650983301\), 
    \(2989451471\ \ 550962429\ \ 574468272\ 1912845433\ \ 197084981\ 
      3915324899\ 1576796068\ 3018451336\), 
    \(2797067074\ 2940174488\ \ 817257229\ 1804699098\ 1173180277\ 3538064298
      \ 1788067987\ 2127875081\), 
    \(3699938742\ 3208089660\ 1414129897\ \ 609592073\ 2862582019\ 1277244169
      \ 3455998053\ 1477364660\), 
    \(3313173494\ \ 928606852\ 1286035515\ 4266697702\ \ \ 88383757\ 
      3961019676\ \ 480116545\ 1761773034\), 
    \(2582266431\ 3980117433\ 1563505331\ 1606928577\ 2996830377\ 1147258726\ 
      1267701800\ 3298446707\), 
    \(\ 211791931\ 4217998199\ 1032809080\ \ 270816068\ 1939502819\ 1489478611
      \ 3754962085\ 3261737200\), 
    \(1351890143\ 3100080385\ 1907070635\ 3272330901\ \ 799533386\ 3486323504
      \ 4245744132\ 1513428671\), 
    \(\ 712212664\ \ 774685418\ 3167499102\ 1558647987\ \ 153704214\ 
      3124585434\ 2571006771\ 1363459663\), 
    \(4222529726\ 2562650559\ 2039134769\ \ \ 75364594\ 1587157984\ \ 
      667831660\ 1667619242\ 2640230008\), 
    \(2563546355\ \ 740776234\ 3884760377\ \ 730217970\ 4125465365\ 3324078454
      \ 3426625427\ 3611079278\), 
    \(\ 660824547\ \ 881887318\ \ 826476343\ 1612259189\ 1779507492\ \ 
      664498816\ 3503011916\ 3348252399\), 
    \(3848000395\ 2191570586\ 2571583585\ 3717485035\ \ 889088830\ 3368924667
      \ 3722708266\ \ 573327094\), 
    \(3722485961\ 2882436105\ 2709073650\ 2344585927\ 2933651062\ 2964178846\ 
      2775578950\ \ 243495770\), 
    \(4044268187\ 2605963071\ \ 559665373\ 2560935919\ 1901124231\ \ 213615877
      \ 2688675651\ 3175220021\), 
    \(3448280377\ 2660556998\ 2268000381\ 1723599786\ 1635170102\ 4125645511
      \ \ 226330445\ 3549993625\), 
    \(1098684826\ \ 557361230\ 2959168886\ 1504105451\ 2481867356\ 4244439924
      \ \ 735129501\ \ 926210057\), 
    \(2857071892\ 2072366105\ 1936419289\ 2178617310\ 1525665144\ \ 254382403
      \ 3380486276\ \ 612278793\), 
    \(\ 222331584\ 3999733197\ \ \ 54831851\ 4030368632\ 3277978498\ 
      3015713988\ 1766459377\ 2841335157\), 
    \(2310733700\ 3819903034\ 4164580818\ 1943307706\ 1932066358\ \ 850569518
      \ 1716977186\ 3450680613\), 
    \(1011009013\ 3847023465\ 3328096161\ 4181327698\ 1185866741\ 2948770919\ 
      1809461205\ 1296298078\), 
    \(2939362195\ 2183996242\ 3698558494\ 1549585272\ \ 399482572\ 2741765854
      \ 3771589071\ \ 770513317\), 
    \(3620507999\ 3856412538\ \ 572665554\ \ 904834317\ \ 392011710\ 
      1915927641\ 3203111969\ 1489959192\), 
    \(3972727963\ 3734929516\ 2397034577\ \ 279554309\ 3887893592\ \ \ 
      26589594\ 1260467623\ 2261525339\), 
    \(1213945442\ \ 958497898\ 3576122874\ 1959882528\ \ 930297212\ 2773875538
      \ 3551857457\ 1108483287\), 
    \(\ 515543714\ 3115618815\ 3051349796\ \ 101918799\ 1736380504\ 2870538081
      \ 1935981584\ 2376593533\), 
    \(\ 927627880\ 1261684208\ \ 589995140\ 2984514288\ 2669650272\ \ 
      209746241\ 3617438018\ \ 871607634\), 
    \(2507194396\ 2606606018\ 1793506070\ 1792133133\ \ 162002787\ 3954708730
      \ 1700224262\ \ 117579662\), 
    \(3464902735\ 3108394320\ 2442628226\ 4158220507\ 3828788918\ 1595638547
      \ \ 598513858\ 2701775245\), 
    \(1596669520\ \ 309783526\ 1099143919\ 3721884321\ \ 210067759\ 3905242651
      \ 1701208388\ 1630585129\), 
    \(3962655688\ \ 160416896\ 4064295766\ 2142028708\ 2837051608\ \ 926805673
      \ \ \ 13934414\ 1658721036\), 
    \(1853736079\ 2133833187\ \ 904020032\ 1345950899\ 3759460999\ 3566819771
      \ 3509031133\ 4039939647\), 
    \(2600525138\ \ 534416298\ 2598542100\ 1048860060\ 3810600760\ \ 842344693
      \ \ \ 40085439\ 3828936354\), 
    \(1181740581\ \ 125407151\ 2719966845\ 3589223721\ 1197717145\ 2172805437
      \ 2682247449\ 3444221242\), 
    \(2281407594\ 1343619356\ 2224440516\ \ 201584785\ 1545683055\ 2677087570
      \ 3530132002\ 1067573577\), 
    \(2807399777\ 3556825166\ 1142904686\ 2562103274\ 1330570795\ 2871749411
      \ \ \ 34570269\ 3916017434\), 
    \(3052708997\ 2883416933\ 2933704874\ \ 315799154\ 1027443069\ 4033957436
      \ \ 880258199\ \ 568227694\), 
    \(2355798869\ 1793209129\ 3917122472\ 1595976684\ 4231553972\ \ \ 28511460
      \ 3933805391\ 2501719766\), 
    \(1614366462\ 1156914706\ 3698656157\ \ 535043075\ 1672161288\ \ 789610443
      \ \ 786776029\ 4057676248\), 
    \(1417864970\ 3846045323\ 3873230254\ 2396324242\ 1361289066\ \ 225121304
      \ \ 264628931\ 3540464130\), 
    \(1166983396\ 1599420443\ 3178923039\ 3789787768\ \ 644159692\ \ 733068198
      \ 1412301237\ 4234889998\), 
    \(2079578057\ \ 911366091\ \ 814331772\ 2366994562\ \ 211823581\ \ 
      201534345\ 2866366848\ 1676412257\), 
    \(3099342614\ 1055907821\ \ 319123145\ 2494379061\ 1327459986\ 3958526322
      \ 3381516861\ 2200483281\), 
    \(\ 729922003\ 2950299184\ 1023900943\ \ 654169998\ 4150287796\ 3149386851
      \ 3049355036\ \ 367343390\), 
    \(1824430037\ 2221384079\ \ 933456146\ 4203579577\ 2599712246\ 1015172126
      \ \ 718959661\ 3595710050\), 
    \(\ 867007085\ 3983634311\ 1219852944\ 1182156390\ 2765278525\ 3723986796
      \ 2053968915\ 2313317812\), 
    \(\ 250361817\ 4109994961\ 1796949436\ \ 138206312\ 1866049822\ 1243241863
      \ 4194923697\ 3863022465\), 
    \(3017973995\ 1408606923\ 2501703403\ 2372728099\ 2661679307\ 3201961440
      \ \ 428747734\ 2276676566\), 
    \(3055911614\ 1503288881\ 2064007417\ \ 721533393\ \ 439219776\ 1950732825
      \ 3583168532\ 1487752832\), 
    \(1769157649\ 2209861135\ 2868744326\ 3272895179\ 3262546188\ 2619257928\ 
      1295850644\ 1817056976\), 
    \(2336736353\ 1279802613\ 2340121560\ 3669448667\ 3050472056\ \ 524246831
      \ 2337818815\ 4124168532\), 
    \(\ 779788513\ 3365480581\ 1138309793\ \ 310053721\ 2256703538\ \ 
      201925869\ 3659068242\ 1408528330\), 
    \(2396954431\ 1249808209\ \ \ 55071209\ 1565009202\ 1247191359\ \ 
      503244882\ 4280833533\ 2639835568\), 
    \(3048567678\ 3680079483\ \ 113641520\ 3458082644\ 2260836805\ \ 232106254
      \ \ \ 95508666\ 3336277353\), 
    \(3151938082\ \ 388700691\ 3479756731\ \ 475413623\ 3330997832\ 2065457519
      \ 2758398914\ 2267657370\), 
    \(\ 323694109\ 2431975389\ 4084482952\ \ 140308961\ 3649199377\ 2448034162
      \ 1877438350\ 1639910114\), 
    \(3419835622\ 3497915359\ 2035765699\ 2530435298\ 2249410443\ 2917595469\ 
      3932284830\ 1067859416\), 
    \(\ \ 23694158\ 3002922157\ 2799430300\ 3062245297\ 3633314337\ 3207540778
      \ 3938865363\ 2660064977\), 
    \(2483694215\ 3658820453\ 2359500958\ 2556197812\ 2698693483\ 4099012527\ 
      3549104086\ 1746276419\), 
    \(4278399179\ 3688266508\ 1369599618\ 3545200962\ \ 774937072\ 3175759183
      \ 3863184043\ \ 976001621\), 
    \(2162297121\ 1024116319\ \ 877466824\ \ 955684309\ 3599148869\ 3303916108
      \ 2252081888\ 4047305364\), 
    \(1950212177\ 3213241790\ \ \ 66918334\ \ 420139392\ 1259440418\ 
      2918219103\ 4052013223\ 1220343377\), 
    \(1553285491\ 3901958360\ 1671351169\ \ 120286127\ 3549181986\ 1071381903
      \ \ 462430529\ 1077458138\), 
    \(\ \ 91902157\ 3379361469\ 3412288387\ 2915490990\ 1197211426\ 2389362316
      \ 2414012316\ \ 590220451\), 
    \(3864233469\ 3474538900\ \ 354865714\ 1019328830\ 1931718533\ 2816038522
      \ \ 690266275\ \ 338817461\), 
    \(1628150172\ 2444487159\ 3493515226\ 3693287446\ 3668486821\ 1834907108\ 
      2271184199\ 3348394904\), 
    \(\ 856308536\ 4021705718\ 3865618555\ 2484367229\ 3051600799\ 3853962052
      \ 4179395121\ \ 681697714\), 
    \(4032957842\ 1138701471\ 2626136604\ 2035727226\ 1574812974\ 2007711182\ 
      2833188345\ 1477537311\), 
    \(\ 946444211\ 2418424233\ 1165833466\ 2402606925\ 3387544052\ 3292351438
      \ 1207412549\ 1592418139\), 
    \(3010286947\ 3215020908\ 1857700044\ 1678883746\ 2720112938\ 2393213253
      \ \ 617306328\ 3042616699\), 
    \(\ \ 85479372\ \ 843568231\ 2995225330\ 3857034356\ \ 733436776\ \ 
      741318993\ 1972580316\ 1545311539\), 
    \(\ 520826579\ \ 130329576\ \ 457433568\ 3901775946\ 3844876294\ 
      3413512698\ \ 913849860\ 2421897631\), 
    \(\ 897144523\ 3829144332\ 1914455053\ \ 649423998\ 3991032391\ \ 
      688976535\ \ 597425244\ 2125150662\), 
    \(\ \ 74495659\ 1554103943\ 3577337931\ 3900074302\ 1182010730\ \ 
      690508442\ \ 680678847\ 2882873224\), 
    \(2226152338\ 1241956649\ 3180139650\ 2677542794\ 1933401916\ 1732998043
      \ \ 710029196\ 2234773624\), 
    \(3991365873\ 3408860609\ \ 797494233\ \ 593700100\ 3224167809\ \ 
      582123067\ 3064839168\ 1641913682\), 
    \(2826295167\ 2356192531\ 3360957751\ 1502512007\ 4005063020\ 3198900900\ 
      3999258041\ 1471678105\), 
    \(1516125451\ 2816104460\ 3207787600\ 3189594186\ 3037067586\ 3462872947\ 
      1109084555\ 4005155641\), 
    \(4019309221\ 1884750857\ 1405476835\ 3316990580\ 2924761081\ 3745846133\ 
      2133126930\ \ 318511773\), 
    \(\ 874304510\ 2096646476\ 2036293746\ 1580137754\ \ 896583016\ 3590776957
      \ 1602773524\ \ 356336048\), 
    \(3005683392\ 3906593644\ 3876240072\ 1233590400\ 1519907004\ 2675788505\ 
      3874262425\ 3832822470\), 
    \(2170110499\ 3090012998\ \ \ 64902196\ \ 483344658\ 1661563449\ \ 
      454895088\ \ 537474429\ 2920702493\), 
    \(3150940096\ 3770403262\ \ 449388027\ 2738518304\ 2289944536\ 3302689725
      \ 1101215316\ 3587809753\), 
    \(1520394723\ 3153256791\ \ 194416906\ 2481380978\ 2218889677\ 2028510402
      \ 2378905514\ \ 822283507\), 
    \(3554246132\ 2015728841\ 2235386354\ 2382564023\ \ \ 33057896\ 3826229225
      \ 2983520840\ 2460694121\), 
    \(4228130251\ \ 298056530\ 1383900018\ 3415415930\ 1575626398\ 1055239567
      \ 2641729325\ 2658022656\), 
    \(1108909346\ 1334791938\ 1163328903\ 1901055996\ 2962461782\ \ 512127299
      \ \ 175174271\ 2882018163\), 
    \(1446778763\ 1388538942\ 3641634867\ 1026808234\ 1924919279\ 2275892208\ 
      1818265015\ 4260543679\), 
    \(2857537584\ 2907057874\ 2587054506\ 3685525049\ \ 355417226\ 3048465825
      \ 2984319734\ 2890097915\), 
    \(3266936049\ 1755567632\ 1645108391\ 3858128112\ 3391628298\ 4242087636
      \ \ 600202643\ 3451630743\), 
    \(3646357720\ 1964643115\ 2800930853\ 4203218476\ 2364399270\ 3436896838
      \ \ 327751621\ 2652544987\), 
    \(3435875555\ 2499885005\ 1662875818\ \ 448589885\ 3481806811\ 1812990241
      \ 3992747818\ \ 505972593\), 
    \(2306142345\ 3717781723\ 2134192189\ 3056583540\ \ \ 54580205\ 1913287139
      \ 2210585966\ 1996639682\), 
    \(3736107832\ 3352286403\ 2228062699\ \ 679052833\ 2071888728\ 1352540044
      \ \ \ 86884160\ 1081407020\), 
    \(1817033975\ 1492228630\ 4030354147\ \ 625415671\ 2033078400\ 2640495920
      \ \ \ 18553970\ 1136481837\), 
    \(2748329155\ \ 692195559\ 2303183601\ 1169104090\ \ 218641870\ \ 
      794778185\ 4088345707\ \ \ 95816594\), 
    \(1555180433\ 3837873926\ 2951034182\ 2145082152\ 3779237388\ 2892293148\ 
      3118772025\ 3818619066\), 
    \(2759820550\ 2566975988\ \ 402952157\ \ 304442283\ \ 217295448\ 
      2426546584\ \ 708008134\ 1320818513\), 
    \(1189118926\ \ 695014015\ \ 980258804\ \ 118327745\ 2016937917\ \ 
      316603826\ 2035710621\ \ 983311095\), 
    \(3814026789\ \ 334809195\ \ \ 95920315\ 4019127228\ 2508362264\ 
      1785537550\ 3027395582\ \ 250499278\), 
    \(2632967628\ 3145187786\ 3375582150\ 1995018226\ 1915273502\ \ 479625314
      \ 3266440710\ 4115312188\), 
    \(3605947892\ 2274260642\ 1653215889\ 1161508480\ 3635155674\ \ 752693354
      \ 1353721546\ \ 108576883\), 
    \(\ 979401481\ 1028529280\ \ 380430382\ \ 697805245\ \ 771529608\ 
      2812007218\ 1603093888\ 3054536393\), 
    \(1632279998\ 3822467820\ 1759029899\ \ 181865736\ 3533834206\ \ 842945009
      \ 3121407844\ \ 558302144\), 
    \(3593817028\ 1817836981\ 3917218939\ 4051650719\ \ 996511195\ 4047780352
      \ 2777959571\ \ 805764703\), 
    \(3901704678\ 4191703431\ 1971776113\ \ 831009455\ 3451150382\ 3665403810
      \ 2281572009\ 1473586841\), 
    \(\ 875878932\ \ 686642991\ 1646445886\ 1436879892\ 3260079078\ 1771745582
      \ \ 256083357\ 2846422910\), 
    \(\ \ \ 
    7392137\ 1321272773\ 3176799296\ 2762080883\ 4241020025\ 2504613741\ 
      3416483084\ 2802747723\), 
    \(1059645923\ 3535249274\ \ \ 47259946\ 2770580497\ 3119075323\ 2741697501
      \ 1042173588\ \ 823575628\), 
    \(\ 211100407\ 3642354261\ \ 988187171\ 1631291649\ \ 348006774\ 
      4047829579\ 2093201647\ \ 632950323\), 
    \(2035741316\ 3973512280\ 1590029608\ \ 234262489\ 1199794335\ \ 347972971
      \ 1152870383\ 3991321051\), 
    \(\ 233320363\ 1325568083\ 3429441709\ 2148822222\ 1343971245\ \ 946991501
      \ 1564815383\ 1430738443\), 
    \(2751048931\ 2397196833\ 3749950087\ \ 661952534\ 2794957195\ 1710776745
      \ 1961907094\ 3778659981\), 
    \(\ \ 14743368\ 1903930823\ 1573604765\ 2375064827\ 3016752662\ 1716813784
      \ 3152588151\ 3968635504\), 
    \(\ 593505948\ \ 285132566\ \ 567978379\ \ 312700522\ 3601513275\ \ \ 
      80886376\ 2704758835\ 4110982544\), 
    \(3483200731\ 2030828384\ 1201768242\ 1438637708\ 2740516237\ 1338741589\ 
      3414427890\ 2481321854\), 
    \(\ 970858749\ \ 509156168\ 3072175627\ 3629283308\ 2874204841\ 3353124451
      \ 1927678231\ 1493566292\), 
    \(4285433249\ 2109785283\ 1637580810\ \ 532115396\ 1153825317\ \ 692238544
      \ 2964606218\ 2570333222\), 
    \(\ 130035313\ 3248882687\ 1987057535\ 3195139807\ \ 549722028\ 3516323576
      \ 2827544740\ 1986701349\), 
    \(\ 691978647\ 2860862225\ 3474760865\ 3088967066\ \ 260463377\ \ 
      809289337\ \ 399411727\ \ 725626538\), 
    \(\ 581998427\ 3518676944\ 2796838523\ \ 585297128\ 1772817271\ 2839958346
      \ 3428553980\ 2621657576\), 
    \(2510824834\ \ 499243785\ 3078159751\ 3707590488\ 1506055538\ 3494017459
      \ 2330494670\ \ 349207825\), 
    \(\ 505909373\ 2103973917\ \ 428753399\ \ 316165025\ 4118103598\ 
      1690299460\ 4037802943\ 1343743125\), 
    \(3103685083\ 2357785702\ 1865883178\ 3192476401\ 3074218058\ 2550193072\ 
      3425882880\ 3603021735\), 
    \(1617257032\ \ 188393217\ 3703863791\ \ 485826128\ \ 443213474\ \ 
      685592546\ \ 830261562\ 2790694107\), 
    \(2675561262\ \ 852190466\ 2091945112\ 1048990434\ \ 256274435\ 3826585517
      \ 1973778214\ 3560989731\), 
    \(3215403706\ 2159016645\ 2805078948\ 3655323087\ 3283988016\ 1265145647\ 
      3629345830\ 1271193073\), 
    \(\ 878452143\ 2255577562\ 1022943389\ 2869087266\ \ 745502919\ 4245582345
      \ 2267154835\ 3764542987\), 
    \(4227632501\ 2901913891\ 4260411369\ 3356804897\ \ 836288604\ 3489583218
      \ \ \ \ 2662280\ 4048712586\), 
    \(3227955968\ 1977935749\ 2109862194\ 3148087458\ 2774378150\ 4276551350
      \ \ \ 49145691\ 3470028419\), 
    \(3736748378\ 1000093869\ 1579714679\ 2712102430\ \ 808424628\ 2974539445
      \ 3177974086\ 3362188214\), 
    \(2920670323\ 1673239835\ 2387557632\ 1353883181\ \ 235564492\ 2338243054
      \ 3982760250\ \ 574720343\), 
    \(\ 457830298\ 2496509279\ \ \ 61399623\ 1116612228\ 2335016912\ \ 
      259000644\ 1254943189\ 4088170060\), 
    \(2000286128\ 1993022046\ 1969291927\ \ 485679459\ 1332942425\ 2699832067
      \ 3753546425\ 3365974086\), 
    \(1557535481\ 1597222018\ 3634125623\ \ 797000517\ 3655194874\ 2901690503
      \ 3592893638\ 2124332393\), 
    \(1224331937\ 1272407201\ \ \ 90876870\ \ 822994915\ \ 851986061\ 
      3842663847\ 2303514421\ 3167883683\), 
    \(\ 863759583\ 2378584987\ \ 309053928\ 2243754042\ \ 386664236\ 
      1813410484\ 1188937477\ 1411015099\), 
    \(3960992424\ 2720825367\ 4033969118\ 1557145551\ \ \ 38184751\ 1805235333
      \ 3691192313\ 2064934927\), 
    \(4234903588\ 1917683630\ 1189271359\ 4085127137\ 1242456242\ 2310252447\ 
      2453127468\ 1797483449\), 
    \(\ 885379780\ 2680790943\ \ \ 71616565\ \ 863263710\ 2009832086\ 
      2356288438\ 1752262743\ 1456745192\), 
    \(2387199035\ 2162976638\ 2582992503\ 3881750662\ 2747857216\ 4088637843\ 
      3054851092\ 1893328762\), 
    \(3868065475\ \ 665736204\ \ 122650419\ 2873832230\ 2218544722\ 4020487849
      \ \ 773521247\ 3788931319\), 
    \(\ 583348978\ 3495248593\ 4110518073\ 1351818308\ 3251497560\ \ 826438558
      \ 2448592662\ 4019345549\), 
    \(3659808335\ 3803975430\ 3301615245\ 2409318045\ 2064746607\ 3125905420\ 
      4174131541\ 4258361220\), 
    \(2678395935\ 1414348512\ 2782650473\ \ 140670015\ 1767397821\ \ 944702309
      \ \ 336565450\ \ \ 16578585\), 
    \(1435586945\ 3281162165\ 1253146683\ 1201003763\ 1987659110\ 2489345477\ 
      3185086714\ \ 462784692\), 
    \(\ 177827704\ \ 233005239\ \ 416053967\ 2953337626\ 2546099979\ 
      3026282724\ 1633165376\ 4026878941\), 
    \(1670168362\ 2718111199\ \ 100915423\ 2386251057\ 3775247146\ 1971409329
      \ 3128955070\ \ 332008559\), 
    \(2758005085\ 1537119985\ 1323241608\ 1909553524\ \ 938651705\ \ 929852783
      \ 3651509736\ 3220229789\), 
    \(2415863155\ 2360842736\ 1344586714\ 1328346356\ \ 958069489\ \ 340930078
      \ 1787176863\ 3018056733\), 
    \(2971810429\ 1250695733\ 1383346883\ 3392424170\ 4040945164\ 2983946669\ 
      2784376102\ \ 421197597\), 
    \(\ \ 43595925\ 3272952695\ \ 935232950\ 1779258481\ 1421409700\ 
      2608947146\ 3815674484\ \ 104812394\), 
    \(\ 473932583\ 3304986293\ 1843619103\ \ 299500925\ 1815471427\ 3763327526
      \ 3420652033\ 4244186371\), 
    \(3523925378\ 1418778211\ 2757280629\ \ 650725411\ 3170748360\ 3609119929
      \ 1866182423\ \ 378485139\), 
    \(\ 878183347\ 1520838317\ 2934115256\ \ 579085192\ 3352838361\ \ 
      386598905\ 1248630629\ 3332971275\), 
    \(\ 517456107\ 2309387103\ 1525794389\ 3880307939\ 1021042588\ 4102417339
      \ 4229989127\ \ 439707614\), 
    \(3172518653\ 2436117961\ \ 392002587\ 1112822214\ \ 582468462\ 2045969672
      \ \ 949227500\ 3512780990\), 
    \(2010203318\ 3589671408\ \ 570072833\ 3445670773\ 3386781173\ 3710763847
      \ 4239021146\ 1085023372\), 
    \(\ 965510550\ 3748698336\ 1946148916\ 3922390829\ 2488981029\ 1530855203
      \ 3968930083\ \ 673324997\), 
    \(3021910559\ 2021520759\ 2709661063\ \ 288986154\ 2253980863\ 3194279078
      \ 1301275294\ 2724994496\), 
    \(1005588763\ 2431310547\ 1816950532\ 2483362434\ \ 880350267\ \ \ 
      10937109\ 3550086966\ 3984653178\), 
    \(2458743732\ 2597361740\ 3545142133\ 4140824262\ \ 433291790\ 3489963753
      \ 1549610978\ 3380880051\), 
    \(1535336951\ 2188758564\ 1869705089\ 1744773229\ \ 151237050\ 1067091869
      \ \ 378792426\ 3865022142\), 
    \(1423208623\ 2698999609\ 4232859746\ 2616147436\ 3694444822\ 4237421960\ 
      3789193349\ \ 264938270\), 
    \(2542042420\ 3811462821\ \ 934506737\ 3923849261\ 3129800086\ 2935106683
      \ 2876970146\ 3084460261\), 
    \(4288528738\ \ 573982257\ 2536280769\ \ 164684574\ 3609193209\ 2034210351
      \ 1418828926\ 2367177073\), 
    \(4198350415\ 2672299050\ 2450929243\ 2277488088\ 1262108384\ 1300592556\ 
      2246280643\ 1463077270\), 
    \(\ \ 24283669\ 2814256484\ 2920428572\ \ 732185295\ 3449236148\ 
      1785697238\ 2895573792\ 3412059153\), 
    \(\ 130317547\ 2399010748\ 2402680747\ 3446112668\ 4141494682\ 2979945319
      \ \ 699134504\ \ 423743893\), 
    \(1989020686\ 2892756180\ 2757804347\ 2958469521\ \ 302686846\ 2821216526
      \ 3906087555\ 3439892137\), 
    \(1270515938\ 2595176811\ 3358998573\ 2609500190\ 1321973023\ 2918102480
      \ \ 557191655\ 4286897776\), 
    \(2432393051\ 3061076275\ 4217975357\ 1449903310\ \ 212671482\ 2225780503
      \ 2802763968\ 4103827866\), 
    \(\ 527599029\ 1780796863\ 2724761943\ 3276943711\ 4269559468\ 3584562687
      \ 3755339122\ 1961843736\), 
    \(2889553859\ 4262450468\ 2866870940\ 1506764626\ \ \ 87325502\ 1851218811
      \ \ 104902807\ 2433146474\), 
    \(1405973740\ \ 712106204\ 3501882793\ 1668628196\ \ 367053759\ 2439104364
      \ 2345633601\ 4261976274\), 
    \(2389511231\ \ 670971233\ 3512818519\ \ 291931354\ 1010117639\ 3121226912
      \ \ 216794089\ 2381605253\), 
    \(1234429988\ \ 890040290\ 3407272923\ 4036460531\ 4248230025\ 2322331360
      \ \ 857627108\ 3431122373\), 
    \(3920556260\ 3620184925\ 1822004436\ 2089483249\ 1457150695\ 1058512461\ 
      2323826196\ 1467927598\), 
    \(1829542728\ 3597941153\ 1195056903\ 4213136448\ 2692934715\ \ 350230171
      \ 1338676178\ 2212454885\), 
    \(4221578785\ 3340788217\ 4254994570\ 1401889037\ 1458588220\ \ 406498190
      \ 3353840100\ 1333584504\), 
    \(1067831467\ 2303446962\ \ 832673291\ 2803834274\ 2058955135\ \ 439115463
      \ 4237189348\ 4177624984\), 
    \(\ 434368896\ \ \ 65745811\ 1674343216\ \ 682007505\ \ 881307904\ 
      2115865947\ 2818376323\ 2597893492\), 
    \(3388193995\ \ 648220176\ \ 965789948\ 3648545894\ 2559346465\ 1186935538
      \ 2849249634\ 1435152096\), 
    \(2099779097\ 2236433707\ 2056857718\ 3622427106\ 2807966002\ 2805696251\ 
      3791999283\ 2906605789\), 
    \(1579920301\ \ 495498283\ 3585279899\ 1790131525\ 2507064090\ 3550219133
      \ 2045966513\ 2143932053\), 
    \(2093239437\ 2931918748\ \ 132834540\ 2043527559\ 2857101065\ 2266094582
      \ 2032134499\ 4162861582\), 
    \(1604703548\ \ 993549793\ 3893087712\ \ 594670956\ 2206702188\ 1307337017
      \ 2544944972\ \ 173168926\), 
    \(2687435672\ \ 603162056\ 3850750600\ \ 652237570\ 2228623290\ \ 
      908508311\ 2575673992\ \ 451869805\), 
    \(1218328223\ 1240023337\ 3363817602\ 1510325986\ \ \ 84889544\ 1497259115
      \ 3569064714\ 2307779873\), 
    \(3269949104\ \ 196335899\ 3317064378\ 3662913307\ 3123975713\ 3371942183
      \ 1294604224\ 2754472443\), 
    \(3272171988\ 1860343264\ 1219371781\ 1152918699\ \ 589391294\ 1640980420
      \ 3468579151\ 1680360152\), 
    \(1859807416\ \ 176066368\ \ 170161385\ 3933343378\ 3249718721\ \ 
      556595142\ 2233739461\ \ \ \ 9864098\), 
    \(3554193492\ 2678498973\ 1839040553\ 1319589657\ 2784480313\ \ \ 91572997
      \ 3504987363\ 1330333369\), 
    \(4258957162\ 2307616336\ 2459189958\ 1556640224\ \ 184831671\ \ \ 
      97452767\ 2123501187\ \ 589872371\), 
    \(\ 150231019\ 1610202207\ 3829241503\ \ 561523044\ 2475099748\ 1537414965
      \ \ 777410677\ \ 750925909\), 
    \(\ 376520949\ 2246395494\ \ 477200035\ \ 721677295\ \ 586782788\ 
      4248269418\ 2079058630\ 1841543344\), 
    \(1798938565\ \ 579237886\ 1156909308\ 3795849213\ 3360397125\ 2751178118
      \ 1241311672\ \ 784067534\), 
    \(1218595403\ 3279181635\ 1697121234\ \ 499432327\ 3273437891\ 1954695406
      \ 3602303438\ 1432689590\), 
    \(1092492595\ 1693348613\ 2140023804\ 3280301139\ 1400843261\ 1221016476\ 
      4284665248\ 1644434125\), 
    \(1485592922\ 1543989666\ 2696601906\ 3628838970\ 2791619497\ 4273412614\ 
      3856677594\ \ 148260534\), 
    \(2325117186\ 2031881146\ 1464829168\ 1317723753\ 3541379644\ 3971222234\ 
      2482870646\ 1632643873\), 
    \(3593477543\ 3148908700\ 1148199485\ 1601239651\ \ 565984844\ 3518119430
      \ 1295987389\ 3952746779\), 
    \(\ \ 53970847\ 3347385628\ 1246325209\ 1935966700\ 3913428939\ 3934987583
      \ \ \ 31505956\ 3763896993\), 
    \(2846901715\ \ 112930545\ \ 682101170\ 2710765160\ 3823412034\ 2178636147
      \ \ 833176151\ 1980890013\), 
    \(\ 904137391\ \ 476756128\ 4092970068\ \ 956990362\ 3791853381\ 
      1243355800\ \ \ 91762894\ 1832932671\), 
    \(3021936135\ 2755794335\ 2443199185\ 2300173769\ 4019213268\ 4089671557\ 
      1406147190\ \ 651927999\), 
    \(3815162042\ 2935102486\ 2752301727\ \ 479595150\ 3330411850\ 2203595139
      \ 2623652570\ \ 794852846\), 
    \(1657728150\ \ 185409986\ 3230474879\ \ 206273867\ 1935262861\ 3152821789
      \ 3736812077\ 4045585219\), 
    \(\ 119683170\ 2091212766\ \ 314608403\ 1428284689\ \ 519575066\ 
      2886873598\ 1308363508\ 1521346412\), 
    \(4089106095\ 2256293793\ \ 393692371\ \ 949385236\ 3304715658\ \ 
      617001934\ \ 781143168\ \ 581874173\), 
    \(2362271291\ 2945070122\ 3586712457\ 3719794863\ 2902990799\ 2619652520\ 
      2831554934\ 2236808970\), 
    \(2872841965\ \ \ 82679725\ 2711279140\ \ 504180029\ 3129887481\ \ 
      926289273\ 3944557459\ \ 839965950\), 
    \(4204877220\ 1290383674\ 3999249077\ \ 903314022\ 2404682504\ \ 788694991
      \ \ 297554183\ 1751378569\), 
    \(\ 163906496\ 1405547293\ 2031521022\ 2906777514\ 2205474023\ 2573744904
      \ 2096905188\ 2160698520\), 
    \(2519033162\ 3595245487\ 3167271611\ 3423221854\ 4110298186\ 3516244093
      \ \ 338460071\ 1662021266\), 
    \(3300200318\ 2163016681\ 4002825932\ \ 871334726\ 3977898718\ \ 419629989
      \ 3436519635\ \ 592257277\), 
    \(\ 912665897\ \ 666535099\ 2572590773\ \ \ 77274931\ \ \ \ 6109335\ 
      4173404358\ 2598298542\ 1346554609\), 
    \(2021586543\ 1092582049\ 3331344646\ 3071068385\ 2279186743\ 1145538682
      \ \ 759629660\ 3986980488\), 
    \(3779509572\ 3202409358\ 3006016147\ 4192132351\ 3532066718\ \ 426976533
      \ 3233496528\ 1145694005\), 
    \(\ 765624510\ \ 940363647\ 2383606835\ \ 964915647\ 1592062234\ 
      4238812025\ 3638612493\ 2796792973\), 
    \(4118725121\ 2402350472\ \ 442899207\ 2987267085\ 4260092726\ 1475398477
      \ 1759730192\ 2455227780\), 
    \(4088809793\ 3971286814\ 3643465766\ 3686692330\ 2062898871\ 1653416242\ 
      3884655817\ 1057603667\), 
    \(3831471335\ \ 429163316\ 3819689928\ 1154485038\ 3837904593\ 1164771389
      \ 3630077160\ 3769082562\), 
    \(\ \ \ 
    1693630\ \ 664843864\ 2444945553\ 2535101076\ 1878816006\ 3290601565\ 
      2363979618\ 3490914130\), 
    \(2583504946\ 2165244998\ 3778994735\ 3191036481\ \ 864027724\ 1195525028
      \ 3843350733\ 1425115345\), 
    \(2901724451\ \ \ 80417703\ 2762458755\ 3124876600\ 2132642003\ \ 
      857833840\ 4260031479\ 3642620821\), 
    \(3316424721\ 1129661820\ 1067496184\ 3992724464\ 2215037596\ 3293587235\ 
      2264652636\ 1455837048\), 
    \(2966202245\ 3856459925\ \ 843441253\ 2165791865\ 1784096582\ 3250904560
      \ \ 638620762\ 1452012175\), 
    \(2989933565\ \ 567119600\ 2061017059\ 1130928899\ 3219989444\ \ 498196214
      \ 3070443236\ 3849110839\), 
    \(2908450871\ 3765293483\ 4093279040\ 1714796787\ 2609717535\ 1850220024\ 
      2140774347\ 2069134639\), 
    \(\ 178995835\ 4159957337\ \ 585442800\ 3950381346\ 2285321836\ 3003739699
      \ 3703767172\ 4025922938\), 
    \(\ 691640479\ 1366753219\ 1682283223\ 2963128769\ 3627273162\ 1230027144
      \ 3043982268\ \ 814948925\), 
    \(4280814273\ 4237120618\ 1724062590\ 1080700372\ 1973681345\ 1341128461
      \ \ 877687716\ 1353904600\), 
    \(1608054216\ \ 665751835\ 2789336533\ 1921027273\ 2895949746\ 3234357019
      \ \ 237030094\ \ 707986913\), 
    \(\ 789756092\ 1075955211\ 2347868972\ \ 630590265\ 1012946959\ 1014350873
      \ \ 507441018\ 3572116730\), 
    \(3344878835\ \ 271994070\ 1966914258\ 3143762306\ 4043571584\ 2447924608
      \ 3443506144\ 3507925154\), 
    \(\ 942099851\ \ 860792568\ 3105845673\ 2397880888\ \ 131897164\ \ \ 
      79683041\ 3449364073\ \ 601737448\), 
    \(1033401112\ 3641638089\ 1515327293\ 4139804574\ \ 601303454\ 1141128347
      \ \ 890933032\ 3051993699\), 
    \(2728242744\ 2289505106\ 1831519542\ 3816031113\ 3671422116\ 2673035031
      \ \ 158347909\ 3459496851\), 
    \(3012972960\ 2426398235\ 2347431685\ 4245957794\ 1392864703\ \ 309592454
      \ 3289269241\ 3406525666\), 
    \(2575584962\ 1295351242\ 3306104233\ 4003080977\ 3461655421\ 3349959782\ 
      1562076428\ 4105202938\), 
    \(2206603425\ 2782829320\ 4008213168\ 2469148415\ \ \ 84641434\ 4060089453
      \ 1248189859\ 1240763608\), 
    \(\ \ 84887210\ 1384866065\ 1254968398\ 1345533674\ 3046096700\ 2476571276
      \ \ 728630200\ 1486410594\), 
    \(3688692632\ \ 684126521\ 1360710476\ 3290659927\ 3404002781\ 2630822458
      \ \ 780458984\ 1742103233\), 
    \(\ \ 32458419\ 3224946830\ 3160620903\ 1370037231\ 3383245789\ 1954486844
      \ 3139708526\ \ 511306777\), 
    \(3871697635\ 3456901046\ 3069848492\ \ 437221400\ \ 640653820\ 1577841821
      \ \ 287550708\ 4236118742\), 
    \(1051449947\ 1235678535\ 3020114064\ 2043912980\ 1362055293\ \ 602754508
      \ 2476475653\ 2362252216\), 
    \(4274250950\ 3555430402\ 2230386555\ 2946365306\ \ \ 12417200\ 2471662922
      \ 2650083042\ 1114486994\), 
    \(3953329767\ 1649905490\ 3803329521\ 4056927668\ 1034538122\ \ \ 30576004
      \ 3892795508\ 3338658630\), 
    \(2102527906\ 1092194665\ 2760999594\ 2099906492\ 2249868529\ 1799190974\ 
      2685897361\ 1800205709\), 
    \(3711490105\ 1044826125\ \ 942238112\ 2771601279\ 2862630790\ 2823623273
      \ 2965836627\ 3069194291\), 
    \(2490493218\ \ 474597347\ 4206179142\ \ 616363127\ \ 862727161\ \ 
      401022377\ \ 665950749\ \ 254628103\), 
    \(2894903167\ 2673537665\ 2322806961\ 1232154137\ 1659237620\ 2196487540\ 
      2142016635\ \ 412713410\), 
    \(2059207844\ 1385208142\ \ 528311361\ 4196431850\ 4105369863\ 2339656420
      \ 1204151851\ 1725372588\), 
    \(\ 176435431\ 3831371885\ 2279786913\ 4283594829\ 2517082663\ 4002282105
      \ \ \ 71943199\ \ 670473968\), 
    \(2723652450\ 2816623899\ 2501215425\ 1022368585\ 1170864140\ 1759298415
      \ \ 228612976\ 3793685226\), 
    \(4125402985\ 2050383867\ 2702923405\ 2530646061\ 1841219964\ 3634498154
      \ \ 133547435\ \ 236529113\), 
    \(1880488285\ \ 671135318\ 1005890222\ 2123556919\ 1364722303\ 2238619742
      \ 3025098954\ 2759092404\), 
    \(3511624694\ 2959351362\ 2573819461\ \ 703775071\ \ \ \ 7085318\ \ 
      192514329\ 4169908003\ 3143503722\), 
    \(\ 283074040\ 1931165439\ \ 519282108\ 4037756511\ 1760898757\ \ 
      701850081\ 3412605298\ 4216915908\), 
    \(3558781295\ 4159837526\ 3403083671\ 1556737804\ \ 723639417\ 2730827619
      \ \ 908262398\ 2351756180\), 
    \(3274117832\ 3774360100\ 1547931724\ 3679586399\ 1135970976\ 3544798573\ 
      1181208103\ 2894021537\), 
    \(2055727992\ \ 899154433\ 2632572537\ 1034423810\ 3308672789\ 3483129289
      \ 1857653534\ \ 777440859\), 
    \(1175153627\ 3367076282\ 4135089772\ 2566620639\ 1792799155\ 2940675386\ 
      2753216397\ 1227410719\), 
    \(3687684610\ 3241603246\ \ 505579970\ 1664138986\ 3448484939\ \ 649962991
      \ 1551163899\ \ 450745746\), 
    \(3708692666\ \ 385248656\ 1932959030\ \ 223070251\ 1912838509\ 2116367223
      \ \ 662548685\ 3216483939\), 
    \(1508069519\ \ 766826131\ 1788083416\ 2781653837\ 3192230299\ 3708945173
      \ \ 117376161\ \ \ 99591745\), 
    \(3765925136\ 2236073299\ 1206978023\ 3089063954\ 3161971362\ 1728941486
      \ \ 236602271\ 4037626692\), 
    \(4116614060\ \ 854138957\ 2042903490\ 3855233146\ \ 991601524\ 3014286704
      \ 4251399929\ 4020400502\), 
    \(\ 861514885\ \ 847109801\ \ 726079254\ 2288863052\ 2773281491\ 
      1281483177\ \ 441824988\ 1934646206\), 
    \(\ \ 72293983\ \ 227648937\ 1800243123\ 1646765736\ 3399767375\ 
      1811938738\ 2112242318\ 2293272410\), 
    \(2371417521\ 2020058355\ \ 786092202\ 3141967809\ 2378143338\ 3907320930
      \ 1775221776\ \ 308309164\), 
    \(4161348686\ 2056326725\ 2789824257\ 2466751035\ \ \ 79585454\ 3548028921
      \ 1744908788\ 3892484242\), 
    \(2940021597\ 3818472801\ 2386846389\ 3877762081\ 1667434277\ 2872725452\ 
      4255173237\ \ 622791848\), 
    \(3484198380\ \ 884062902\ 2450570224\ 1138707573\ 2888329327\ 1458048089
      \ 2127130238\ 3369686292\), 
    \(2098229249\ \ \ 40868883\ \ 981128484\ \ \ 96614743\ 1594288838\ 
      3105035312\ 1757436286\ 3007682450\), 
    \(2820814320\ 1335442794\ \ 205759431\ 1745142805\ 3176726063\ 1964942082
      \ 3238939856\ 4113185846\), 
    \(\ 156957510\ \ 580050979\ 1800044658\ \ 963356375\ \ 228963303\ 
      2660690414\ \ 747755411\ 2119312735\), 
    \(\ \ 23207706\ \ 788859407\ 3742742171\ \ 703428215\ 1038496548\ 
      3051102714\ \ 788383018\ 3416446126\), 
    \(1393794887\ 2157870150\ 1800693175\ \ 256918600\ 3515346694\ 2757585793
      \ 2678783851\ 3262607651\), 
    \(2724548393\ \ \ 21084200\ 3024189351\ 1005075187\ 1502651897\ \ 
      659576508\ 1448059638\ 4099889047\), 
    \(3808419119\ 1975223231\ 2342632084\ \ 507928157\ \ 809928134\ 3972968787
      \ \ 131467654\ 3849463694\), 
    \(3930016425\ \ 828609713\ 3936345711\ 2050755844\ 2048170047\ 2288325261
      \ \ 585856686\ 1329485191\), 
    \(\ 158684773\ 2890335993\ 1324825188\ 2612429199\ 4275915193\ \ 769475787
      \ 1966706313\ 3346317033\), 
    \(1284482456\ 3819217871\ 3498600485\ \ 419709076\ 1404162972\ \ 574278557
      \ 1516168407\ 1886888463\), 
    \(1303060044\ 2415024107\ 3533273866\ \ 376331886\ 1828547608\ 2968210867
      \ 4076606573\ 3495522317\), 
    \(\ 639085562\ 3946244177\ \ 584695600\ 1825645803\ 3284309735\ \ 
      897858717\ \ \ 67629177\ 3599708313\), 
    \(3236615906\ \ \ \ 8526085\ 2925280306\ 2084337885\ 2338891637\ \ 
      817764643\ \ 762904671\ 2710851038\), 
    \(3254246250\ 1598487309\ 3405540279\ 2247029823\ 2031523688\ \ 543783084
      \ 3156647698\ 2465657008\), 
    \(3757979758\ 3734688185\ 2996835116\ 4290603810\ \ 806761501\ 1724266702
      \ 2153958468\ 2398365801\), 
    \(3570779598\ 1625563176\ 2663394807\ 1732337714\ \ 341483624\ 1968731516
      \ \ 716901216\ \ 497863403\), 
    \(3630991925\ 3677885354\ 3481104698\ 2038906833\ 2784670319\ 1082401619\ 
      2489136364\ 1984652405\), 
    \(\ 897755828\ 2449915510\ 3330061388\ 1768989554\ 2701445799\ 3078115314
      \ 1774869265\ 1003459027\), 
    \(4001248516\ 1327546321\ 2278186329\ 3662123417\ 3019323794\ 1304938062
      \ \ 135701303\ 1578227104\), 
    \(\ 917680041\ 4286468096\ 2519862702\ \ 335709301\ 3546900210\ 3990057428
      \ 2949839752\ 3957644590\), 
    \(1114706168\ 1932864923\ 1330452784\ 1068111376\ 4042526585\ \ 786469670
      \ 3777068953\ 1144973551\), 
    \(3954473670\ \ 248974002\ 2400227244\ 3673761110\ 1243765098\ 1483759267
      \ 3993288170\ 3319225635\), 
    \(1229186005\ 1240403815\ 3497972229\ 1466206868\ \ 451313864\ 1554009058
      \ 1826391088\ 3287780649\), 
    \(3193405301\ 1145947137\ 1184856824\ 3278276661\ 1090712870\ 2360205041
      \ \ 424181213\ 3786515138\), 
    \(3243803700\ 2568742265\ 2627500106\ \ 424988539\ 3502455751\ 2658710569
      \ 2000682105\ \ 779361841\), 
    \(3937939912\ 1254173607\ 4054929342\ 3257813892\ 1286901842\ 3707638820\ 
      1500727909\ 4039315649\), 
    \(\ 385062622\ 4139426629\ 2073542473\ 3611441365\ \ 805538035\ \ 
      858081990\ \ 215794149\ \ 778509672\), 
    \(1335553996\ 1402887084\ 2344281757\ \ 535808535\ \ \ 23345221\ 
      3188467507\ 3573364281\ 1139188787\), 
    \(\ 251472575\ 1610340950\ \ 242273198\ 2272793072\ 4264622977\ 1233819868
      \ \ 877114430\ 1063710998\), 
    \(3573713567\ 3209429055\ 1263284708\ \ 922953294\ 4055968914\ 2984215782
      \ 2561623242\ 4077488054\), 
    \(\ 207143835\ 2259472391\ 4098275727\ 2878428004\ 1829107321\ 3301448594
      \ 1478620539\ 1344722529\), 
    \(1733809920\ 3911292508\ 1595606464\ 1774538216\ \ 212843905\ 3078969049
      \ 2338657288\ 3146183140\), 
    \(\ \ 66073503\ 3113158348\ 3942713700\ \ 891295097\ 1323355471\ 
      3333032790\ 3887538247\ 3516622130\), 
    \(\ 876378254\ 1371297246\ 2761882236\ 3741711973\ 1095332850\ 1831717914
      \ 4233261312\ 2124970622\), 
    \(\ 918320638\ 3368889387\ \ 442310450\ 2009791552\ \ 764452069\ 
      3590367874\ 2978475917\ 2709164693\), 
    \(1911690225\ 3519123445\ 4128383870\ 2702006432\ 3074387729\ 1678397006\ 
      3366116213\ 2822467776\), 
    \(3171413266\ 1402848657\ \ 275332201\ 4235303289\ 1464116250\ \ \ 
      20982622\ \ 983790578\ \ 776483049\), 
    \(2179440371\ 3163780794\ 1837171161\ 3499897626\ 1773928262\ 1365142338\ 
      1274825974\ \ 979674129\), 
    \(\ 417595340\ 3200198117\ 3616759559\ 2892287884\ 3734056536\ 1535204090
      \ 3514013258\ 3803000270\), 
    \(\ 595664280\ 4146813623\ \ 561479100\ 4246243778\ 2347226145\ \ 
      570569950\ 1868393776\ 1826405894\), 
    \(1826801258\ \ 155257841\ 2472243498\ \ 826514820\ \ 321910203\ 
      1313644034\ \ 334390067\ 2369113699\), 
    \(\ 764994273\ 2583329232\ \ \ 80310165\ 1849450413\ 3483845143\ 
      2738983997\ \ 446832915\ 3336784384\), 
    \(1724539715\ 2591062565\ 3267328553\ 2018894927\ 1921631638\ 3318768654\ 
      3901675570\ 3601262969\), 
    \(3371462909\ 1192646625\ 4229330104\ \ 215276137\ \ 316821887\ \ 
      668256922\ 1873950328\ \ 479752694\), 
    \(3348643101\ 3203901238\ 2620248030\ 2007115846\ 2871392171\ \ 913693999
      \ 1425593292\ 4244671770\), 
    \(\ 561957334\ \ \ 14069772\ 4110554222\ 1642818688\ 1230209322\ \ 
      133693171\ 3748954167\ 2763691475\), 
    \(1942968507\ \ 603914975\ \ 459065238\ 3338031138\ 1655403729\ 2694960840
      \ 2167990983\ 1139643294\), 
    \(\ 687805405\ 1257296043\ 3794628885\ 3896490227\ 1795329833\ 2319583548
      \ 1021982539\ 3714995648\), 
    \(3678110925\ 2394772814\ 1788122509\ \ 937813186\ 3529953144\ 2291509455
      \ \ 225884226\ \ 357322924\), 
    \(1749018254\ 1310702152\ 3125853802\ 1772757809\ 4116197190\ 2346417810\ 
      4092191682\ 2405126594\), 
    \(2043548788\ 2099756770\ 1925915862\ 3119561195\ \ 978483496\ 1703723068
      \ 3948622155\ \ 874087535\), 
    \(3155967752\ 3326079664\ 4269436162\ 3552119451\ 2517403459\ 3955726866\ 
      4111902119\ \ 118112224\), 
    \(\ 415926961\ 4237474322\ 4094483323\ 1235545797\ 3947345696\ 1329301755
      \ 3136731357\ 3577798096\), 
    \(1595679848\ \ 690573188\ 2834579295\ 1555785967\ 1005245151\ 3468107589
      \ 2244845308\ 4091906949\), 
    \(\ 741279801\ \ 347723715\ 2283799767\ \ 716381209\ \ 404686902\ 
      3996416033\ 3654040968\ 1854458183\), 
    \(2409295455\ \ \ 93845460\ 2336317317\ 4057905218\ 4214098916\ 1158088284
      \ 3948782848\ 2608502273\), 
    \(2011409651\ 2771814231\ \ 883844932\ \ 433207991\ \ 963855510\ 
      1824884918\ 2804925100\ 1902891355\), 
    \(3373748709\ 3342718039\ \ \ 57649642\ \ 324671581\ 2698310460\ 
      4157081259\ \ 964641806\ \ 807818511\), 
    \(3057694341\ 3588572045\ 1327694249\ 3715680613\ 2748132454\ 2221877501
      \ \ 114376799\ 3363940934\), 
    \(2018364268\ 1156129440\ 1636951875\ 1565318663\ 3164502536\ \ 226038799
      \ \ 851849947\ 1285382043\), 
    \(1288503002\ 1443658616\ 2133986465\ 4293865352\ \ 479636266\ 3875759222
      \ 4235017207\ 1093970677\), 
    \(\ 958121655\ 2850296054\ \ 445688933\ 3996130537\ 1737501720\ 1762899942
      \ 2167565152\ 3172868057\), 
    \(1034158551\ 2797392172\ 1901916934\ 3454603584\ 2181647153\ 2326636761\ 
      3340958174\ 1601370911\), 
    \(2894566609\ 4056415220\ 2198335137\ 4084674352\ 1061199609\ 4237119284\ 
      1719703183\ 3960905876\), 
    \(1767043654\ 2104359293\ 3718470747\ 4238524999\ 3068340155\ 3571578811\ 
      2046015375\ 3057248405\), 
    \(1710422295\ 1186310646\ 2740383926\ 4133011900\ 4034790903\ 3505945991\ 
      3307717031\ 4257318434\), 
    \(\ 134069520\ 2856175556\ 2091725449\ 2785099126\ 4078688338\ 2059725367
      \ 3058569414\ 3595621833\), 
    \(1108488156\ \ 889955247\ \ 773845806\ \ 549446562\ 1292952934\ 
      1699977118\ 2331032725\ 2525705694\), 
    \(2190201774\ \ 185375630\ \ 649060337\ 1437510220\ 3143739241\ 1927402423
      \ 3072597792\ 3259173902\), 
    \(3919211993\ \ 897246662\ 2833452447\ 1977275564\ 4253808397\ 1443168052
      \ \ 471136414\ 3671427586\), 
    \(2313038812\ \ 643663090\ 4124613044\ 3098733213\ \ 182121856\ 2593759630
      \ \ 830021105\ \ \ 40679803\), 
    \(1166897270\ \ 863404896\ 2132434177\ \ 797336662\ 3040184172\ 2930103949
      \ 2135316727\ 1240780147\), 
    \(2842788688\ 2112878360\ 2409204373\ 2285233108\ \ 615627557\ \ 439505065
      \ \ \ 17583580\ \ 448720273\), 
    \(\ 323364735\ 4113421053\ 3892015826\ \ 179521539\ 3096909937\ \ \ 
      42506835\ \ 958278857\ 3815601510\), 
    \(3161222859\ 1393225004\ 2777927773\ \ 886538818\ \ 355798311\ 2611898454
      \ \ 390686194\ 3652151112\), 
    \(1059696215\ \ 282683156\ 4033366895\ 2183987379\ 2993914555\ 1682566739
      \ 2890327632\ 2560868485\), 
    \(1830832932\ 3045559105\ 1132721978\ \ 669262677\ \ 372230619\ 3063826659
      \ \ 940287879\ 3416367727\), 
    \(1820102376\ 1112491751\ 3674647202\ \ 210100128\ \ 823116088\ 2816005154
      \ 1375022464\ 1998656290\), 
    \(3535639104\ 2713579167\ 4260063265\ \ 249834868\ 1059272795\ \ 804708169
      \ 1799685698\ 1465877982\), 
    \(2737783395\ 1382592952\ 3315370543\ 3489900683\ 2715784450\ 4027570990\ 
      3468927663\ 3687020827\), 
    \(\ 669831964\ \ 286608506\ 4269286041\ 3783244322\ 3736933193\ \ 
      434545758\ 3022796439\ 3716165211\), 
    \(1381590063\ 2238164367\ 3280920573\ 2477212394\ 2914038844\ \ 567546477
      \ 1814177486\ 3590847687\), 
    \(3948037548\ 2617840913\ 2370303193\ 3843957038\ 3259941939\ 1936473685\ 
      2426921600\ 1142006938\), 
    \(\ \ 38005592\ 2362725809\ 1096226176\ 2844715437\ 2209838127\ 1323554041
      \ 3623490170\ 2546619143\), 
    \(4257383984\ 2276226445\ 3233041698\ 4074397676\ 4288600917\ 3671885141
      \ \ \ 52824465\ 2906391781\), 
    \(\ 295087682\ 1792485623\ 2870090883\ 2030226888\ \ 239367961\ \ 
      675963807\ 3704159159\ \ 971607281\), 
    \(3575928713\ 4194261988\ 2436849566\ 1045049869\ 3503389371\ \ 982351182
      \ \ 416047581\ 1873750952\), 
    \(2888412915\ 2206168732\ 2238017818\ 3422969883\ \ 839421013\ 2180719366
      \ 1649338280\ 3216209067\), 
    \(3766214242\ 4155080031\ 2070776915\ \ 250154173\ 1666876983\ \ 142078024
      \ 3270206516\ 2125895390\), 
    \(\ 574744847\ 4238033396\ \ 520775955\ 3418298669\ 4076085046\ 2537176347
      \ 3089378684\ 3671616704\), 
    \(1652247606\ 1639818696\ 4265932128\ 3674896177\ 1561612015\ 3258093310\ 
      3306651063\ 1714142090\), 
    \(2442352766\ \ 853922986\ \ 690390507\ \ 721108701\ 1980875371\ \ 
      753286881\ 1144180827\ 1206649754\), 
    \(3843665569\ 1621206586\ 2170527696\ 2116642310\ \ 380487321\ \ 953803026
      \ 1089048841\ 3245000889\), 
    \(3148173832\ 3920367629\ \ \ 70966932\ 2784824839\ 3632142199\ 1504145043
      \ 3689642675\ 3062401264\), 
    \(\ 683013401\ 2691901304\ 4183334566\ \ 863611766\ 1804541873\ 2751886324
      \ 3619965889\ \ 166865796\), 
    \(2782106620\ 4263973087\ 4267134650\ \ 868767684\ 1862803139\ \ 804447356
      \ \ 104446606\ 2119003044\), 
    \(4071127740\ 3406602439\ \ 449528393\ 1952315523\ 3966849471\ \ 915336797
      \ 3117194883\ 1027771343\), 
    \(3905363365\ 3466124578\ \ \ 33192127\ \ 455545235\ 1146653717\ 
      4230576262\ 3377112782\ \ \ 79506065\), 
    \(1414943059\ 3395059811\ 3204323425\ 1109479610\ 3947740839\ 2111424978\ 
      1967274605\ 3005383438\), 
    \(4076636385\ 3617234202\ 3445834990\ \ 792827529\ 3927089032\ 1449443714
      \ 4284903558\ \ 908658421\), 
    \(4279527574\ \ 746272739\ 2326638557\ 1066120208\ 2621939974\ 1749815977
      \ 1330332057\ 3816468971\), 
    \(4211389169\ 2503746391\ 3556616986\ 1828866465\ 4141826223\ 3614827077\ 
      1889165723\ 2856456083\), 
    \(3334691428\ 3641996254\ 1351274729\ \ 171617890\ \ 917237352\ 2709808943
      \ 4132831726\ 2657636267\), 
    \(\ 908946333\ \ 427420008\ 3763596541\ 1744333754\ 4119504287\ \ 
      372026259\ 2555431032\ 2272649823\), 
    \(2468201435\ 2019892815\ \ 134752524\ 2411630429\ 3020568832\ 3086157779
      \ 1514104616\ 3231846750\), 
    \(1421435901\ 3156756201\ 2212443327\ 3257588357\ 1902815516\ 1837040572
      \ \ \ 50150213\ 3642652720\), 
    \(1267225763\ 3683234456\ 3349368427\ 1646844092\ 4035953991\ \ \ 22323085
      \ 1317008310\ 3788204271\n\)}], "Input"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 485},
WindowMargins->{{60, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 115136, 2019, 30476, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

