(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4379,         90]*)
(*NotebookOutlinePosition[      5489,        127]*)
(*  CellTagsIndexPosition[      5445,        123]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`PseuGene`\"]\n\nCongruGenerator::usage = \"\n\
CongruGenerator[seed,a,c,m,n] returns a list of the n first iterates of the \n\
congruential generator\n\t\t  x(n+1) = a x(n) + c  Modulo m .\nseed is the \
first element x(0). If seed is an integer, the result will \nbe a list of \
integers between 0 and m . If seed is real, all the results\nwill be divided \
by m to return a list of reals between 0 and 1 .\"\n\n\n\
MidsquareGenerator::usage = \" \nMidsquareGenerator[seed,n] returns a list of \
the first iterates of the \nmidsquare generator, starting with seed (four \
digits integer).\"\n\n\nCongruentialLoop::usage = \" \n\
CongruentialLoop[seed,a,c,m] returns in a list the loop of the congruential \n\
generator\n\t\t x(n+1) = a x(n) + c  Modulo m ,\nstarting with x(0)=seed .\"\n\
\n\nMidsquareLoop::usage =\" \nMidsquareLoop[seed] returns in a list the loop \
of the midsquare generator, \nstarting with seed.\"\n\n\n\n\n\
Begin[\"`Private`\"]\n\n\nCongruGenerator[seed_,a_,c_,m_,n_]:= \n\n   Block[ \
{f, y, res},\n\n\t f[y_]:= Mod[ a y + c, m ];\n\t \n\t If[ IntegerQ[seed],\n\t\
     res = NestList[ f, seed, n-1 ] ,\n\t     res = NestList[ f, \
m*(seed-Floor[seed]) , n-1 ] /m  \n\t   ];\n\n\t Return[res];\n       ];\n\n\n\
\nMidsquareGenerator[seed_,n_]:= \n\n   Block[ {mids,x},\n\n\t\
mids[x_]:=Block[{res},\n\t\t     res = Floor[x*x/100];\n\t\t     res = res - \
(10000*Floor[res/10000]);\n\t\t     Return[res];\n\t\t       ];\n\tReturn[ \
NestList[ mids , seed , n-1 ] ];  \n\t\n\t];\n \n\n\n\
CongruentialLoop[seed_,a_,c_,m_]:= \n\n   Block[ {f, y , pos , element , \
loop={} },\n\n\n\t  f[y_]:= Mod[ a y + c, m ];\n\n\t  loop = \
Append[loop,seed];\n\t  element= f[ seed ];\n\n\t  While[ \
!MemberQ[loop,element],\n\t\t (\n\t\t loop  = Append[loop,element];\n\t\t \
element = f[element]\n\t\t )\n\t       ];\n\n\t  pos    = \
First[Flatten[Position[loop,element]]]; \n\t  loop = Drop[ loop, pos-1 ];\n\t \
 loop = Append[loop,element];\n\t  Return[loop];\n  \n\t];\n\n \n\
MidsquareLoop[seed_]:= \n\n   Block[ {f, x , pos , element , loop={} },\n\n\t \
 f[x_]:=Block[{res},\n\t\t     res = Floor[x*x/100];\n\t\t     res = res - \
(10000*Floor[res/10000]);\n\t\t     Return[res];\n\t\t      ];\n\t  loop  = \
Append[loop,seed];\n\t  element = f[ seed ];\n\n\t  While[ \
!MemberQ[loop,element],\n\t\t (\n\t\t loop  = Append[loop,element];\n\t\t \
element = f[element]\n\t\t )\n\t       ];\n\n\t  pos    = \
First[Flatten[Position[loop,element]]]; \n\t  loop = Drop[ loop, pos-1 ];\n\t \
 loop = Append[loop,element];\n\t  Return[loop];\n\n\t];  \n\nEnd[]\n\n\
EndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{116, Automatic}, {15, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 2665, 38, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
