(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5621,        108]*)
(*NotebookOutlinePosition[      6731,        145]*)
(*  CellTagsIndexPosition[      6687,        141]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`RandWalk`\"]\n\nRandomWalk::usage= \"\n\
RandomWalk[ListofVelocities,Deltat] represents the trajectory of a point \nin \
a square. ListofVelocities is a list of two-dimensional vectors, \n\
interpreted as consecutive speeds for the point. The point starts from \nthe \
center with the first speed vector of the list. It changes its speed \nvector \
for the next one in the list at each integer multiple of deltat.\"\n\n\n\n\
VectorField::usage= \"\nVectorField[arrayof2Dvelocities] represents \
graphically by segments on a \ngrid the values of a discrete vector field. \
Arrayof2Dvelocities is a list \nwith three levels. The first two correspond \
to the coordinates (i,j) of a \npoint on the grid. The last level corresponds \
to the two coordinates of the \nvector attached to point (i,j) : Vx(i,j) , \
Vy(i,j) . The function represents \nthe grid and the vector attached to each \
point.\"\n\n\n\nVectorFieldTrajectory::usage= \"\n\
VectorFieldTrajectory[arrayof2Dvelocities, deltat, tmax] represents first a \n\
vector field on a grid by calling VectorField[arrayof2Dvelocities]. Then \nit \
draws the trajectory of a point starting at the center of the grid. At \neach \
integer multiple of deltat, the velocity vector of the point is changed \nfor \
that of the vector field at the closest point on the grid. \nThe trajectory \
is followed up to time tmax. The boundary conditions are \nperiodic.\"\n\n\t  \
 \nBegin[\"`Private`\"]\n\n\
RandomWalk[listofvelocities_List,deltat_,opts___]:=\n\n      Block[{points},\n\
\n\t   points = listofvelocities deltat;\n\t   points = \
FoldList[Plus,{1.,1.},points];\n\t   points = Mod[points,2.] - \
Table[{1.,1.},{Length[points]}];\n\t   \n\t   ListPlot[points,\n\t\t  opts,\n\
\t\t  Prolog     -> PointSize[0.001],\n\t\t  PlotRange  -> {{-1,1},{-1,1}},\n\
\t\t  Axes       -> False,\n\t\t  Frame      -> True,\n\t\t  FrameTicks -> \
None]\n\t\t       \n\t   ]\n\t\t\t\t       \n\n\n\
VectorField[arrayofvelocities_List,opts___]:=\n\n      \
Block[{nx,ny,vect,graph,i,j},\n\t   \n\t   nx   = Length[arrayofvelocities];\n\
\t   ny   = Length[First[arrayofvelocities]];\n\t   vect = \
N[arrayofvelocities]; \n\t   vect = vect/ (2 Max[Abs[vect]]);\n\t   \n\t   \
graph = Table[Line[{{i,j},{i,j}+vect[[i,j]]}],{i,nx},{j,ny}];\n\n\t   \
Show[Graphics[graph],\n\t\t\t      opts,\n\t\t\t      Prolog  -> \
Thickness[0.001],\n\t\t\t      PlotRange  -> {{0,nx+1},{0,ny+1}},\n\t\t\t     \
 Axes       -> False,\n\t\t\t      Frame      -> True,\n\t\t\t      \
FrameTicks -> None]\n\t   ]\n\n\n\
VectorFieldTrajectory[arrayofvelocities_List,deltat_,tmax_]:=\n\n      \
Block[{nx,ny,maxx,maxy,nstep,vect,x,y,point,traj,i,j,gvect,gtraj},\n\n\t   nx \
   = Length[arrayofvelocities];\n\t   maxx  = nx - 1.;\n\t   ny    = \
Length[First[arrayofvelocities]];\n\t   maxy  = ny - 1.;\n\t   nstep = \
Floor[tmax/deltat];\n\t   x = nx/2.;\n\t   y = ny/2.;\n\t   point={x,y};\n\t  \
 traj = {point};\n\t   vect = N[arrayofvelocities];\n\n\t   Do [\n\t      (\n\
\t       point = point + deltat*vect[[ Round[x]+1,Round[y]+1 ]];  \n\t       \
x = Mod[First[point],maxx];                                              \n\t \
      y = Mod[Last[point],maxy];\n\t       point = {x,y};\n\t       traj = \
Append[traj,point]\n\t      ),\n\t      {nstep}\n\t      ];\n\n     \n\t   \
traj=traj+Table[{0.5,0.5},{Length[traj]}];\n\t   \n\t   vect  = vect /(2 \
Max[Abs[vect]]);\n\n\t   gvect = \
Table[Line[{{i,j},{i,j}+vect[[i,j]]}],{i,nx},{j,ny}];\n\n\n\t   gtraj = \
Table[Point[traj[[i]]],{i,Length[traj]}]; \n\n\t   \
Show[Graphics[gvect],Graphics[gtraj],\n\t\t\t  \n\t\t\t      Prolog  -> \
Thickness[0.001],\n\t\t\t      PlotRange  -> {{0,nx+1},{0,ny+1}},\n\t\t\t     \
 Axes       -> False,\n\t\t\t      Frame      -> True,\n\t\t\t      \
FrameTicks -> None]        \n\t   \n\t   ];\n\nEnd[]\n\nEndPackage[]"], 
  "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{100, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 3907, 56, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
