(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3206,         74]*)
(*NotebookOutlinePosition[      4314,        111]*)
(*  CellTagsIndexPosition[      4270,        107]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`StoGho`\"]\n\nStogho::usage=\"\nStogho[c] portraits the \
gha(us)stly ghost known by the name of Stogho \nin some old castles of \
Europe. His mood depends heavily on the sine of \nthe real c .\"\n\n\
GalleryOfPortraits::usage=\"\nGalleryOfPortraits[matrix] draws an array of \
portraits of your favorite \nstar.\"\n\n\nBegin[\"`Private`\"]\n\n\n\
Stogho[c_,opts___]:=\n\n    Block[{h, body, eyes, mouth, pupils},\n    \n\t \
h=Sin[N[c]]+3;\n\n\n     body = ParametricPlot[{t,Exp[(-t^2)/h]},{t,-10,10},\n\
\t\tDisplayFunction->Identity,PlotStyle->Thickness[0.009]];\n\n\n     eyes = \
ParametricPlot[{{1/3Sin[t]-0.6,1/(h 20)Cos[t]+0.6},\n\t\t{1/3Sin[t]+0.6,1/(h \
20)Cos[t]+0.6}},{t,-Pi,Pi},\n\t\t\
DisplayFunction->Identity,PlotStyle->Thickness[0.002]];\n\n\n     mouth = \
ParametricPlot[{t,(1/10 h)(t^2)Sin[c]+0.2},{t,-0.75,0.75},\n\t\t\
DisplayFunction->Identity,PlotStyle->Thickness[0.007]];\n\n\n     pupils = \
Graphics[{PointSize[0.02],\n\t\t\tPoint[{0.6+(h/22)(-1)^Round[h],0.6}],\n\t\t\
\tPoint[{-0.6+(h/22)(-1)^Round[h],0.6}]\n\t\t\t}];\n\n     \
Show[body,eyes,mouth,pupils, \n\t       \
Axes->False,opts,DisplayFunction->$DisplayFunction]\n\t       \n\t ]\n\n\n\
GalleryOfPortraits[matrixA_List]:=\n\n    \
Show[GraphicsArray[Table[Stogho[matrixA[[i,j]],\n\t\t\t       \
DisplayFunction->Identity],\n\t\t\t       {i,Length[matrixA]},\n\t\t\t       \
{j,Length[First[matrixA]]}]]]\n\n\nEnd[]\n\nEndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{84, Automatic}, {Automatic, 1}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 1492, 22, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
