(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4458,         94]*)
(*NotebookOutlinePosition[      5567,        131]*)
(*  CellTagsIndexPosition[      5523,        127]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`TimeRep`\"]\n\nQueue::usage= \
\"Queue[interarrivals,services] represents on a graphics as a \nfunction of \
time, the evolution of the number of customers in a queue \nwith one \
server.The times between consecutive arrivals are read\nin the first list, \
the service times in the second one.\"\n \nCumulatedTimes::usage= \
\"CumulatedTimes[listoftimes] represents on a graphics\nthe function of time \
defined as follows. Starting from 0, it is  \nincremented by one at dates \
separated by the times read in listoftimes.\"\n\t\nGeiger::usage= \
\"Geiger[listoftimes] plots on a line the dates separated by\nthe durations \
read in listoftimes.\"\n\n\nBegin[\"`Private`\"]\n\n\
Queue[interarrivals_List,services_List] :=\n\n     Block[{m, arr={}, dep={}, \
abs={}, ord={}, events={}},\n\t\n\n\t  \
m=Min[Length[interarrivals],Length[services]];\n\n\t  \
arr=Rest[FoldList[Plus,0,N[interarrivals]]];\n\t  \
dep=Append[dep,First[arr]+First[services]];\n\n\n\t  For[k=1, k<m, k++,\n\t\t \
  If [(dep[[k]]<arr[[k+1]]),\n\t\t\tdep = Append[ dep, \
arr[[k+1]]+services[[k+1]] ],\n\t\t\tdep = Append[ dep, \
dep[[k]]+services[[k+1]] ]\n\t\t      ]\n\t     ]; \n   \n\t  arr    = \
Transpose[{arr,Table[1.,{Length[arr]}]}];\n\t  dep    = \
Transpose[{dep,Table[-1.,{m}]}];\n\t  events = \
Transpose[Sort[Join[arr,dep]]];\n\t  abs    = events[[1]];\n\t  ord    = \
FoldList[Plus,0,events[[2]]];\n\t  abs    = Flatten[Transpose[{abs,abs}]];\n\t\
  ord    = Flatten[Transpose[{Drop[ord,-1],Drop[ord,1]}]];\n\t  events = \
Transpose[{abs,ord}];  \n\t  events = Prepend[events,{0.,0.}];\n\n\t  \
ListPlot [events, PlotJoined -> True,\n\t  AxesLabel -> {\"t\",\"N(t)\"}]\n   \
   ]\n\n\n\n\nCumulatedTimes[listoftimes_List] :=\n\n      \
Block[{cumul={},ordinates={},g},\n       \n\t cumul = \
FoldList[Plus,0,N[listoftimes]]; \n\t ordinates = \
Range[0.,N[Length[listoftimes]-1]];\n\t g = Transpose[ { \
Transpose[{Drop[cumul,-1],ordinates}] , \n\t\t\t       \
Transpose[{Drop[cumul,1],ordinates}] } ];\n\n\t g = \
Table[Line[g[[i]]],{i,1,Length[g]}];\n     \n\t Show[ Graphics [g] , \n\t\t   \
 Prolog    -> Thickness[0.003],\n\t\t    Axes      -> True, \n\t\t    \
AxesLabel -> {\"t\",\"N(t)\"}]\n      ]\n\n\n\nGeiger[listoftimes_List]:=\n\n\
\tBlock[{cumul,max,g},\n\t    \n\t     cumul = \
Rest[FoldList[Plus,0,N[listoftimes]]];\n\t     max   = Max[cumul];\n\n\t     \
g = Table[Line[{{cumul[[i]],0.},{cumul[[i]],0.01}}],\n\t\t       \
{i,Length[cumul]}]; \n\t     \n\t     Show[ Graphics [g], \n\t\t\tProlog    \
-> Thickness[0.003],\n\t\t\tPlotRange -> {{0.,max},{0.,1.}},\n\t\t\tAxes \
->{True,False},\n\t\t\tAxesLabel ->{\"t\",\"t\"}]\n\t     ]\n\t\nEnd[]\n\n\
EndPackage[]"], "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{60, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 2744, 42, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
