(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5841,        110]*)
(*NotebookOutlinePosition[      6949,        147]*)
(*  CellTagsIndexPosition[      6905,        143]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData[
"BeginPackage[\"UVW`ZeroOne`\",{\"Graphics`Animation`\"}]\n\n\
RSZeroOne::usage= \"\nRSZeroOne[p,n] returns a random sample of n zeros and \
ones. One is chosen \nwith probability p.\"\n\nPlotZeroOne::usage= \"\n\
PlotZeroOne[listofzeroones] represents graphically a list of zeros and \nones \
as black and white squares on a grey background.\"\n\nAnimateShift::usage= \"\
\nAnimateShift[listofzeroones] forms a list of zeros and ones three times \n\
as long as the initial list, by adding first a list of same length of \n\
random digits, then copying the initial list at the end. Then the successive \
\nshifts are animated as arrays of black and white squares.\"\n\n\
Binary::usage= \"\nBinary[functionf,listofzeroones] computes the real in \
[0,1] the binary \ndecomposition of which is that of the list. Then the image \
by functionf \n(from [0,1] into R) is computed. The decimal part of it is \
returned under \nbinary form as a new list of zeroones.\"\n\n\
ActualLength::usage= \"\nActualLength[listofzeroones] returns the length of \
the list obtained when \nall zeros before the first one are droppped in \
listofzeroones.\"\n       \nWeight::usage= \"\nWeight[listofzeroones] returns \
the number of ones in the list.\"\n\t \nWeightedAlphabeticalOrder::usage= \"\n\
WeightedAlphabeticalOrder[listofzeroones] computes the rank of the given \n\
list of zeros and ones among lists of same actual length, when they are \n\
ranked according to increasing weights and alphabetical order for lists \nof \
same weight. That rank is returned in base 2 as another list of zeros \nand \
ones.\"\n\t  \nBinaryNumbers::usage= \"\nBinaryNumbers[n] returns a list of \
all the 2^n lists of binary digits with\nlength n.\"\n\nEntropy::usage= \"\n\
Entropy[t] returns -tLog[2,t]-(1-t)Log[2,1-t]\"\n\n\nBegin[\"`Private`\"]\n\n\
RSZeroOne[p_,n_]:= Table[If[Random[]<p,1,0],{n}];\n\n\n\
PlotZeroOne[listofzeroones_List,opts___]:=\n\n      Block[{complete,dim}, \n  \
    \n\t   dim      = Ceiling[Sqrt[N[Length[listofzeroones]]]];\n\t   \
complete = Partition[listofzeroones,dim];\n      \n\t   \
Show[Graphics[Raster[complete]],\n\t\t\t\t  opts,\n\t\t\t\t  \
AspectRatio->0.9,\n\t\t\t\t  Background->GrayLevel[0.5]]\n\n\t   ]      \n\t  \
 \n\nAnimateShift[listofzeroones_List]:=\n\n      \
Block[{dim,dim2,complete,nbshift,walt,disney,i},\n\t \n\t   dim      = \
Length[listofzeroones];\n\t   dim2     = \
Ceiling[Sqrt[N[Length[listofzeroones]]]];\n\t  \n\t   complete = \
Join[listofzeroones,RSZeroOne[0.5,dim],listofzeroones];\n\t   nbshift  = \
2*dim+1;\n\t   walt     = Table[Partition[\n\t\t\t\
Take[complete,{i,i+dim-1}],dim2],{i,1,nbshift}];\n\n\t   disney   = \
Table[Graphics[Raster[walt[[i]]]],{i,1,nbshift}];\n\t   ShowAnimation[disney]\
\n\n\t ]\n\nBinary[f_,listofzeroones_List]:=\n\n      Block[{x,y},\n\n\t   x \
= listofzeroones.Table[0.5^i, {i,1,Length[listofzeroones]}];\n\t   y = f[x];\n\
\t   y = Mod[y,1.];\n\t   Return[ Drop[ Flatten[ RealDigits[y,2] ] ,-1] ];\n \
\n\t   ]\n\nActualLength[listofzeroones_List]:=\n\n      Block[{j=1},\n\t   \
While[listofzeroones[[j]]==0,\n\t\t j=j+1];\n\t   \
Return[Length[listofzeroones]-j+1];\n\t   ];\n\n\n\
Weight[listofzeroones_List]:=Apply[Plus,listofzeroones];\n\n\n\n\
WeightedAlphabeticalOrder[listofzeroones_List]:=\n\n  Block[{r,p,u,l,i},\n\n  \
     p = Weight[listofzeroones];\n       l = Length[listofzeroones];\n       \
r =  0;\n\n\t u=0;\n\t i=0;\n\t While[u<p,\n\t      (\n\t      i=i+1;\n\t     \
 If[listofzeroones[[i]]==1, \n\t\t      (r=r+Binomial[l,u]+Binomial[l-i,p-u] \
; u=u+1)\n\t\t]\n\t      )\n\t      ];\n      \n       \
Return[IntegerDigits[r,2]];\n       ];\n  \nBinaryNumbers[n_Integer]:=\n\n  \
Block[{m,l,i,number},\n    \n       m = 2^n-1;\n       l = {Table[O,{n}]};\n  \
     i = 0;\n       Do[(\n\t   i=i+1;\n\t   number=IntegerDigits[i,2];\n\t   \
If[Length[number]<n,\n\t\tnumber = Join[Table[0,{n-Length[number]}],number]];\
\n\t   l = Append[l,number]\n\t  ),{m}];\n\n       Return[l];\n       ];\n    \
\n\nEntropy[t_]:=-t Log[2,t] -(1-t) Log[2,t]; \n\nEnd[]\n\nEndPackage[]"], 
  "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 653},
WindowMargins->{{44, Automatic}, {Automatic, 1}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 4127, 58, 70, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
