
function compare(p,q,nametag)

% function compare(p,q,nametag)
%
% Compare two sampled signals in
% time and frequency domains
%
% creates a figure with a 3x2 grid of plots:
%
%   ____________________
%  |                    |
%  |   p        phat    |
%  |                    |
%  |   q        qhat    |
%  |                    |
%  |  p-q     phat-qhat |
%   ____________________
%

% arg process

  if nargin<3, nametag='Compare'; end
  
% init

  clf
%  uiDisp([nametag '  '],'close')
%  uiDisp('Ready')

  phat = fft(p);
  qhat = fft(q);
  

  setplot set

  setplot([3 2 1 1])
    plot(p)
    scale_axis(10,'y')
    ylim = get(gca,'ylim');
    AxisButton(gca,'Snd','FMSoundProc(GetUserData(''p''))')
    
    large_ylabel('ORIGINAL');
    
  setplot right
    plot(phat)
    ylimhat = get(gca,'ylim');
    
  setplot([3 2 2 1])
    plot(q)
    set(gca,'ylim',ylim)
    AxisButton(gca,'Snd','FMSoundProc(GetUserData(''q''))')
    
    large_ylabel('RECONSTRUCTION');
    
  setplot right
    plot(qhat)
    set(gca,'ylim',ylimhat)

  setplot([3 2 3 1])
    plot(p-q)
    set(gca,'ylim',ylim)
    
    large_ylabel('ERROR');
        
  setplot right
    plot(phat-qhat)
    set(gca,'ylim',ylimhat)

  setplot end

  SetUserData('p',p)
  SetUserData('q',q)

  
function large_ylabel(str)

  ylabel(str)
  
  h=get(gca,'ylabel');
  set(h,'color','y','fontsize',12)