
function [t0,t1,g0,g1,TF]=TFeps(g,epsilon)

% Compute filter epsilon support in time and frequency
% or simple filter Time-BW product
%
% With one output argument the filter epsilon TBW is computed
%
% g is assumed to be in time domain

% compute time/freq supports

   ghat = fft(g);

   [rows,cols]=size(g.sig);
   neps = length(epsilon);
   
   t0 = zeros(neps,cols);
   t1 = zeros(neps,cols);
   g0 = zeros(neps,cols);
   g1 = zeros(neps,cols);
   
   for ii=1:neps
     [t0(ii,:),t1(ii,:)] = support(g,   epsilon(ii));
     [g0(ii,:),g1(ii,:)] = support(ghat,epsilon(ii));
   end
   
% compute and output filter Time-BW product?
 
   TF = (t1-t0).*(g1-g0);
   if nargout==1
     t0=TF;
   end
   
   


