
function [p,noise] = add_noise(p,SNRs,analytic)

% function [pnoisy,noise] = add_noise(p,SNRs,analytic)
%
% <sampled_signal> = add_noise(<sampled_signal>,<double>,<scalar boolean>)
%
% Add White noise, w, to a signal, p, such that the resulting
% signal, p+w,  has a signal to noise ratio of SNR dB, i.e.,
%
%     SNRdB = 20 log10( norm(p)/norm(w) ).
%
%
% analytic =1 (default) creates analytic noise (no negative freq. content)
%
% SNRs may be a vector in which case each SNR is applied
% to p and returned in a concatenated sampled_signal
% 
% See Also: powerdB.m


   if nargin<2, error('No SNRs specified.'), end
   if nargin<3, analytic=1; end

% matrix case

   for ii=1:length(p(:))
     for jj=1:length(SNRs)
       [r(ii,jj),n(ii,jj)] = scalar(p(ii),SNRs(jj),analytic);
     end
     pname = p(ii).name;
     p(ii) = join(r(ii,:));
     
     if all(SNRs==SNRs(1))
       if SNRs(1)~=inf
	 p(ii).name = sprintf('Noisy_{%sdB}%s',num2str(SNRs(1)),pname);
       end
     end
     noise(ii) = join(n(ii,:));
     noise(ii).name = 'Noise';
   end
   
   noise = reshape(noise,size(p));


% scalar case

function [p,noise]=scalar(p,SNRdB,analytic)

   if SNRdB==inf % anything to do?
     noise=sampled_signal(zeros(size(p.sig)),p.d);
     return
   end 

   L2signal= sqrt( sum(real(p.sig).^2  + imag(p.sig).^2)  );  
   
   if L2signal==0
     disp('Warning: no noise added; SNR undefined for zero signal!')
     return
   end
   
   SNR = 10^(SNRdB/20);  % convert from dB
   
   noise = randn(size(p.sig));
   
   if any(imag(p.sig(:)))>0
     if analytic
       noise = Hilbert(noise);
     else
       noise = noise + j*randn(size(p.sig));
     end
   end
   
   L2noise = sqrt( sum(real(noise ).^2 + imag(noise ).^2) );
   
   actSNR = (L2signal./L2noise);
   
   [rows,cols] = size(noise);
   
   noise =  actSNR(ones(rows,1),:) .* noise/SNR;

   p.orig = p; % store copy of uncorrupted version
   
   p.sig  = p.sig + noise;
   
 %  p.SNR = SNR;

   noise = sampled_signal(noise,p.d);
   noise.name = 'Noise';
   
   if strcmp(p.nametrack,'on')
     if ~strncmp(p.name,'Noisy',5)
       dB = sprintf('%s ',num2str(SNRdB));
       p.name = sprintf('Noisy_{%sdB} %s',dB,p.name);
     end
   end


