
function [p,dx]=align(p,x0,how)

% function p=align(p,x0,how)
%
%   Align signals in p to the value x0
%
%   how = 
%         'lead'  % leading edge      % sets how=0.25
%         'max'   % maximums          % sets how=0.99
%
%         double  % delta percentage  % defaults to 0.25
%
% See Also: time_align.m


   if nargin<3, how='lead'; end

   if strcmp(how,'lead')
     delta=0.25;
   elseif strcmp(how,'max')
     delta=0.99;
   elseif isa(how,'double')
     delta=how;
   else
     error(sprintf('Unknown method ''%s''',how))
   end
   
% matrix case

   dx = cell(size(p));
   for ii=1:length(p(:))
     [p(ii),dx{ii}]=scalar(p(ii),x0,delta);
   end
   
   if length(p)==1, dx=dx{1}; end

% scalar case

function [p,dx]=scalar(p,x0,delta)

   [a,b] = support_interval(p);
   
   if ~isbetween(x0,a,b)
     disp('Resampling!')
     nn = ceil(abs(x0)/b);
     p=resample(p,[0 nn*(b-a)/2]);
   end

   
   xdel = support(p,delta); % delta power point
   dx   = x0-xdel;
   
   p=split(p);
   
   for ii=1:length(p(:))
     p(ii) = translate(p(ii),dx(ii));
   end
   
   p=join(p);
   