
function p=bandpass(p,BW,CF,transition_factor)

% function p=bandpass(p,BW,CF);
%
% Bell shaped band pass filter with specified 
% bandwidth BW and center frequency CF

% arg process

   if nargin<3, CF=0;                  end % lowpass
   if nargin<4, transition_factor=0.1; end
   
   if  ~isbetween(transition_factor,0,0.5,'[]')
     error('transition_factor out of range (0,0.5)');
   end
   

% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),BW,CF,transition_factor);
   end
   
   
% scalar case   
   
function p=scalar(p,BW,CF,transition_factor)
   
   pname  = p.name;
   
   dw     = BW/2+[-1 1]*transition_factor*BW; % 2x1 interval
   winhat = sampled_signal('bell',1./(2*p.d([2 1])),CF-fliplr(dw),CF+dw);

   winhat.sig = repmat(winhat.sig,1,size(p.sig,2));

   p = ifft( fft(p) .* winhat );

   if strcmp(p.nametrack,'on')
     p.name = sprintf('BP_{bw=%s,cf=%s}(%s)',num2str(BW),num2str(CF),pname);
   end
   


