
function q = coherence(p,delta)

% function Cohp = coherence(p,delta)
%
%   Computes the coherence of p as a function of threshold delta
%
%         Coh_\delta(p) = norm(F_\delta p)^2./norm(p).^2

   if nargin<2, delta=[]; end

   for ii=1:length(p)
     q(ii) = scalar(p(ii),delta);
   end
      
%
%
%

function pcoh=scalar(p,delta)

   if isempty(delta)
     ndeltas=16;
     
     MM = max(abs(p.sig(:)));
     delta = MM*(0:1/(ndeltas-1):1);
   
     pcoh = sampled_signal(zeros(ndeltas,1),MM*[1/ndeltas 1/2]);
     pcoh.d0 = 1;
   else
     ndeltas=length(delta);
     
     if ndeltas==1
       pcoh.sig = 0;
     else
       pcoh = sampled_signal(zeros(ndeltas,1));
       pcoh.d = delta;
     end
   end
   
   pcoh.xlabel = 'Threshold \delta';
   pcoh.name = sprintf('Coh(%s)',name(p));   
   
   ss=sum(abs(p.sig(:)).^2);
   for ii=1:ndeltas
     jj = find(abs(p.sig(:))>delta(ii));
     pcoh.sig(ii) = sum(abs(p.sig(jj)).^2)/ss;
   end

   if ndeltas==1, pcoh=pcoh.sig; end